/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.obeonetwork.m2doc.services.configurator.IServicesConfigurator;
import org.obeonetwork.m2doc.services.configurator.IServicesConfiguratorDescriptor;
import org.obeonetwork.m2doc.services.configurator.ServicesConfiguratorDescriptor;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class M2DocUtilsTests {
    private static final ServicesConfiguratorDescriptor CONFIGURATOR = new ServicesConfiguratorDescriptor((IServicesConfigurator)new TestServiceConfigurator());

    @BeforeClass
    public static void beforeClass() {
        M2DocUtils.registerServicesConfigurator((IServicesConfiguratorDescriptor)CONFIGURATOR);
    }

    @AfterClass
    public static void afterClass() {
        M2DocUtils.unregisterServicesConfigurator((IServicesConfiguratorDescriptor)CONFIGURATOR);
    }

    @Test
    public void getInitializedOptions() {
        LinkedHashMap options = new LinkedHashMap();
        Map initializedOptions = M2DocUtils.getInitializedOptions(options);
        Assert.assertEquals((long)3L, (long)initializedOptions.size());
        Assert.assertEquals((Object)"false", initializedOptions.get("UpdateFields"));
        Assert.assertEquals((Object)"false", initializedOptions.get("IgnoreVersionCheck"));
        Assert.assertEquals((Object)"value", initializedOptions.get("option"));
    }

    @Test
    public void createResourceSetForModels() {
        ArrayList exceptions = new ArrayList();
        ResourceSet rs = M2DocUtils.createResourceSetForModels(exceptions, (Object)Query.newEnvironment(), null, new HashMap());
        Assert.assertEquals((Object)TestServiceConfigurator.RESOURCE_SET, (Object)rs);
    }

    @Test
    public void versionTest() throws IOException {
        String manifest = new String(Files.readAllBytes(Paths.get("META-INF/MANIFEST.MF", new String[0])));
        String version = manifest.substring(manifest.indexOf("Bundle-Version: ") + 16, manifest.indexOf(".qualifier"));
        Assert.assertEquals((Object)version, (Object)"3.3.5");
    }

    public static final class TestServiceConfigurator
    implements IServicesConfigurator {
        public static final String OPTION = "option";
        public static final String VALUE = "value";
        public static final ResourceSet RESOURCE_SET = new ResourceSetImpl();

        public List<String> getOptions() {
            ArrayList<String> res = new ArrayList<String>();
            res.add(OPTION);
            return res;
        }

        public Map<String, String> getInitializedOptions(Map<String, String> options) {
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
            res.put(OPTION, VALUE);
            return res;
        }

        public Map<String, String> getInitializedOptions(Map<String, String> options, EObject eObj) {
            return Collections.emptyMap();
        }

        public Map<String, List<Diagnostic>> validate(IReadOnlyQueryEnvironment queryEnvironment, Map<String, String> options) {
            LinkedHashMap<String, List<Diagnostic>> res = new LinkedHashMap<String, List<Diagnostic>>();
            if (options.containsKey(OPTION) && !VALUE.equals(options.get(OPTION))) {
                ArrayList<BasicDiagnostic> diagnostic = new ArrayList<BasicDiagnostic>();
                diagnostic.add(new BasicDiagnostic());
            }
            return res;
        }

        public Set<IService> getServices(IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels, Map<String, String> options) {
            return Collections.emptySet();
        }

        public void startGeneration(IReadOnlyQueryEnvironment queryEnvironment, XWPFDocument destinationDocument) {
        }

        public void cleanServices(IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels) {
        }

        public ResourceSet createResourceSetForModels(Object context, Map<String, String> options) {
            return RESOURCE_SET;
        }

        public void cleanResourceSetForModels(Object context) {
        }
    }
}

