/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests.generator;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;
import org.obeonetwork.m2doc.generator.M2DocValidator;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.Cell;
import org.obeonetwork.m2doc.template.Conditional;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.Query;
import org.obeonetwork.m2doc.template.Row;
import org.obeonetwork.m2doc.template.Table;
import org.obeonetwork.m2doc.template.TemplatePackage;
import org.obeonetwork.m2doc.tests.M2DocTestUtils;

public class M2DocValidatorTests {
    public void conditionalInferedTypeInElse() throws IOException {
        IQueryEnvironment queryEnvironment = org.eclipse.acceleo.query.runtime.Query.newEnvironmentWithDefaultServices(null);
        IQueryBuilderEngine engine = QueryParsing.newBuilder((IQueryEnvironment)queryEnvironment);
        Conditional conditional = TemplatePackage.eINSTANCE.getTemplateFactory().createConditional();
        conditional.setCondition(engine.build("self.oclIsKindOf(ecore::EClassifier)"));
        Block thenCompound = TemplatePackage.eINSTANCE.getTemplateFactory().createBlock();
        conditional.setThen(thenCompound);
        Conditional alternative = TemplatePackage.eINSTANCE.getTemplateFactory().createConditional();
        alternative.setCondition(engine.build("self.oclIsKindOf(ecore::EPackage)"));
        Block alternativeThenCompound = TemplatePackage.eINSTANCE.getTemplateFactory().createBlock();
        alternative.setThen(alternativeThenCompound);
        Block elseCompound = TemplatePackage.eINSTANCE.getTemplateFactory().createBlock();
        elseCompound.getStatements().add((Object)alternative);
        conditional.setElse(elseCompound);
        Block body = TemplatePackage.eINSTANCE.getTemplateFactory().createBlock();
        body.getStatements().add((Object)conditional);
        Throwable throwable = null;
        Object var10_11 = null;
        try (DocumentTemplate documentTemplate = M2DocTestUtils.createDocumentTemplate(body);){
            M2DocValidator validator = new M2DocValidator();
            HashMap types = new HashMap();
            LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
            types.put("self", selfTypes);
            selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClassifier()));
            selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
            validator.validate(documentTemplate, (IReadOnlyQueryEnvironment)queryEnvironment, false, (Monitor)new BasicMonitor());
            Assert.assertEquals((long)0L, (long)conditional.getValidationMessages().size());
            Assert.assertEquals((long)1L, (long)alternative.getValidationMessages().size());
            M2DocTestUtils.assertTemplateValidationMessage((TemplateValidationMessage)alternative.getValidationMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when self (EClassifier=EPackage) is not kind of EClassifierLiteral=EPackage", (XWPFRun)alternative.getRuns().get(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void tableRowCellTemplate() {
        IQueryEnvironment queryEnvironment = org.eclipse.acceleo.query.runtime.Query.newEnvironmentWithDefaultServices(null);
        IQueryBuilderEngine engine = QueryParsing.newBuilder((IQueryEnvironment)queryEnvironment);
        Query query = TemplatePackage.eINSTANCE.getTemplateFactory().createQuery();
        query.setQuery(engine.build("self"));
        Block body = TemplatePackage.eINSTANCE.getTemplateFactory().createBlock();
        Table table = TemplatePackage.eINSTANCE.getTemplateFactory().createTable();
        body.getStatements().add((Object)table);
        Row row = TemplatePackage.eINSTANCE.getTemplateFactory().createRow();
        table.getRows().add((Object)row);
        Cell cell = TemplatePackage.eINSTANCE.getTemplateFactory().createCell();
        row.getCells().add((Object)cell);
        Block cellBody = TemplatePackage.eINSTANCE.getTemplateFactory().createBlock();
        cellBody.getStatements().add((Object)query);
        cell.setBody(cellBody);
        DocumentTemplate documentTemplate = M2DocTestUtils.createDocumentTemplate(body);
        M2DocValidator validator = new M2DocValidator();
        validator.validate(documentTemplate, (IReadOnlyQueryEnvironment)queryEnvironment, false, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)1L, (long)query.getValidationMessages().size());
        M2DocTestUtils.assertTemplateValidationMessage((TemplateValidationMessage)query.getValidationMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'self' variable", query.getStyleRun());
    }
}

