/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests.properties;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.junit.Assert;
import org.junit.Test;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;

public class TemplateCustomPropertiesTests {
    @Test
    public void parseVariable() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/properties-template.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            Map variables = properties.getVariables();
            Assert.assertEquals((long)3L, (long)variables.size());
            Assert.assertEquals((Object)"ecore::EPackage", variables.get("variable1"));
            Assert.assertEquals((Object)"ecore::EClass", variables.get("variable2"));
            Assert.assertEquals(null, variables.get("variable3"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void parseVariableAndGetITypes() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/properties-template.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            Map variables = properties.getVariables();
            Assert.assertEquals((long)3L, (long)variables.size());
            Assert.assertEquals((Object)"ecore::EPackage", variables.get("variable1"));
            Assert.assertEquals((Object)"ecore::EClass", variables.get("variable2"));
            Assert.assertEquals(null, variables.get("variable3"));
            IQueryEnvironment env = Query.newEnvironmentWithDefaultServices(null);
            Map types = properties.getVariableTypes(new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)env)), (IReadOnlyQueryEnvironment)env);
            Set var1Types = (Set)types.get("variable1");
            Assert.assertEquals((long)1L, (long)var1Types.size());
            Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)((IType)var1Types.iterator().next()).getType());
            Set var2Types = (Set)types.get("variable2");
            Assert.assertEquals((long)1L, (long)var2Types.size());
            Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((IType)var2Types.iterator().next()).getType());
            Set var3Types = (Set)types.get("variable3");
            Assert.assertTrue((boolean)(var3Types.iterator().next() instanceof NothingType));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void parseImport() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/properties-template.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            ArrayList serviceClasses = new ArrayList(properties.getServiceClasses().keySet());
            Assert.assertEquals((long)2L, (long)serviceClasses.size());
            Assert.assertEquals((Object)"org.obeonetwork.m2doc.services.test.ServicePackage1", serviceClasses.get(0));
            Assert.assertEquals((Object)"org.obeonetwork.m2doc.services.test.ServicePackage2", serviceClasses.get(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void parseInvalidVariables() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/emptyVar.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            Map variables = properties.getVariables();
            Assert.assertTrue((boolean)variables.isEmpty());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testReadBlankMMUri() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/noUri.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            List uris = properties.getPackagesURIs();
            Assert.assertTrue((boolean)uris.isEmpty());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void addProperties() throws IOException {
        TemplateCustomProperties properties;
        XWPFDocument document;
        File tempFile = File.createTempFile("properties", "-add.docx");
        URI tempFileURI = URI.createURI((String)tempFile.toURI().toString(), (boolean)false);
        tempFile.deleteOnExit();
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/noProperties.docx"));
            try {
                properties = new TemplateCustomProperties(document);
                Assert.assertTrue((boolean)properties.getPackagesURIs().isEmpty());
                properties.getPackagesURIs().add("http://www.eclipse.org/meta100");
                properties.getPackagesURIs().add("http://www.eclipse.org/meta200");
                Assert.assertTrue((boolean)properties.getServiceClasses().isEmpty());
                properties.getServiceClasses().put("org.obeonetwork.m2doc.services.test.ServicePackage100", "");
                properties.getServiceClasses().put("org.obeonetwork.m2doc.services.test.ServicePackage200", "");
                Assert.assertTrue((boolean)properties.getVariables().isEmpty());
                properties.getVariables().put("var100", "String");
                properties.getVariables().put("var200", "Integer");
                properties.save();
                POIServices.getInstance().saveFile(URIConverter.INSTANCE, document, tempFileURI);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, tempFileURI);
            try {
                properties = new TemplateCustomProperties(document);
                Assert.assertEquals((long)2L, (long)properties.getPackagesURIs().size());
                Assert.assertEquals((Object)"http://www.eclipse.org/meta100", properties.getPackagesURIs().get(0));
                Assert.assertEquals((Object)"http://www.eclipse.org/meta200", properties.getPackagesURIs().get(1));
                ArrayList serviceClasses = new ArrayList(properties.getServiceClasses().keySet());
                Assert.assertEquals((long)2L, (long)serviceClasses.size());
                Assert.assertEquals((Object)"org.obeonetwork.m2doc.services.test.ServicePackage100", serviceClasses.get(0));
                Assert.assertEquals((Object)"org.obeonetwork.m2doc.services.test.ServicePackage200", serviceClasses.get(1));
                Assert.assertEquals((long)2L, (long)properties.getVariables().size());
                Assert.assertEquals((Object)"String", properties.getVariables().get("var100"));
                Assert.assertEquals((Object)"Integer", properties.getVariables().get("var200"));
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void deleteProperties() throws IOException {
        XWPFDocument document;
        File tempFile = File.createTempFile("properties", "-add.docx");
        URI tempFileURI = URI.createURI((String)tempFile.toURI().toString(), (boolean)false);
        tempFile.deleteOnExit();
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/properties-template.docx"));
            try {
                TemplateCustomProperties properties = new TemplateCustomProperties(document);
                Assert.assertEquals((long)2L, (long)properties.getPackagesURIs().size());
                properties.getPackagesURIs().clear();
                Assert.assertEquals((long)2L, (long)properties.getServiceClasses().size());
                properties.getServiceClasses().clear();
                Assert.assertEquals((long)3L, (long)properties.getVariables().size());
                properties.getVariables().clear();
                properties.save();
                POIServices.getInstance().saveFile(URIConverter.INSTANCE, document, tempFileURI);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, tempFileURI);
            try {
                TemplateCustomProperties info = new TemplateCustomProperties(document);
                Assert.assertEquals((long)0L, (long)info.getPackagesURIs().size());
                Assert.assertEquals((long)0L, (long)info.getServiceClasses().size());
                Assert.assertEquals((long)0L, (long)info.getVariables().size());
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void updateProperties() throws IOException {
        TemplateCustomProperties properties;
        XWPFDocument document;
        File tempFile = File.createTempFile("properties", "-add.docx");
        URI tempFileURI = URI.createURI((String)tempFile.toURI().toString(), (boolean)false);
        tempFile.deleteOnExit();
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/properties-template.docx"));
            try {
                properties = new TemplateCustomProperties(document);
                Assert.assertEquals((long)2L, (long)properties.getPackagesURIs().size());
                properties.getPackagesURIs().add("http://www.eclipse.org/meta100");
                properties.getPackagesURIs().add("http://www.eclipse.org/meta200");
                Assert.assertEquals((long)2L, (long)properties.getServiceClasses().size());
                properties.getServiceClasses().put("org.obeonetwork.m2doc.services.test.ServicePackage100", "");
                properties.getServiceClasses().put("org.obeonetwork.m2doc.services.test.ServicePackage200", "");
                Assert.assertEquals((long)3L, (long)properties.getVariables().size());
                properties.getVariables().put("var100", "String");
                properties.getVariables().put("var200", "Integer");
                properties.save();
                POIServices.getInstance().saveFile(URIConverter.INSTANCE, document, tempFileURI);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, tempFileURI);
            try {
                properties = new TemplateCustomProperties(document);
                Assert.assertEquals((long)4L, (long)properties.getPackagesURIs().size());
                Assert.assertEquals((Object)"http://www.eclipse.org/meta1", properties.getPackagesURIs().get(0));
                Assert.assertEquals((Object)"http://www.eclipse.org/meta2", properties.getPackagesURIs().get(1));
                Assert.assertEquals((Object)"http://www.eclipse.org/meta100", properties.getPackagesURIs().get(2));
                Assert.assertEquals((Object)"http://www.eclipse.org/meta200", properties.getPackagesURIs().get(3));
                ArrayList serviceClasses = new ArrayList(properties.getServiceClasses().keySet());
                Assert.assertEquals((long)4L, (long)serviceClasses.size());
                Assert.assertEquals((Object)"org.obeonetwork.m2doc.services.test.ServicePackage1", serviceClasses.get(0));
                Assert.assertEquals((Object)"org.obeonetwork.m2doc.services.test.ServicePackage2", serviceClasses.get(1));
                Assert.assertEquals((Object)"org.obeonetwork.m2doc.services.test.ServicePackage100", serviceClasses.get(2));
                Assert.assertEquals((Object)"org.obeonetwork.m2doc.services.test.ServicePackage200", serviceClasses.get(3));
                Assert.assertEquals((long)4L, (long)properties.getVariables().size());
                Assert.assertEquals((Object)"ecore::EPackage", properties.getVariables().get("variable1"));
                Assert.assertEquals((Object)"ecore::EClass", properties.getVariables().get("variable2"));
                Assert.assertEquals(null, properties.getVariables().get("variable3"));
                Assert.assertEquals((Object)"String", properties.getVariables().get("var100"));
                Assert.assertEquals((Object)"Integer", properties.getVariables().get("var200"));
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testIsValidVariableName() {
        Assert.assertTrue((boolean)TemplateCustomProperties.isValidVariableName((String)"v"));
        Assert.assertTrue((boolean)TemplateCustomProperties.isValidVariableName((String)"_valid"));
        Assert.assertTrue((boolean)TemplateCustomProperties.isValidVariableName((String)"valid_"));
        Assert.assertTrue((boolean)TemplateCustomProperties.isValidVariableName((String)"valid_123"));
        Assert.assertTrue((boolean)TemplateCustomProperties.isValidVariableName((String)"_VALID_1354"));
        Assert.assertFalse((boolean)TemplateCustomProperties.isValidVariableName(null));
        Assert.assertFalse((boolean)TemplateCustomProperties.isValidVariableName((String)""));
        Assert.assertFalse((boolean)TemplateCustomProperties.isValidVariableName((String)"not valid"));
        Assert.assertFalse((boolean)TemplateCustomProperties.isValidVariableName((String)"\u00e9"));
        Assert.assertFalse((boolean)TemplateCustomProperties.isValidVariableName((String)"3invalid"));
        Assert.assertFalse((boolean)TemplateCustomProperties.isValidVariableName((String)"-inv"));
        Assert.assertFalse((boolean)TemplateCustomProperties.isValidVariableName((String)"not-valid"));
        Assert.assertFalse((boolean)TemplateCustomProperties.isValidVariableName((String)"dfg$fsd"));
    }

    @Test
    public void getMissingVariables() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/missingVariables.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            List missingVariables = properties.getMissingVariables();
            if (missingVariables.size() == 16) {
                Assert.assertEquals((Object)"linkNamelinkText", missingVariables.get(0));
                Assert.assertEquals((Object)"bookmarkName", missingVariables.get(1));
                Assert.assertEquals((Object)"queryInBookmark", missingVariables.get(2));
                Assert.assertEquals((Object)"ifCondition", missingVariables.get(3));
                Assert.assertEquals((Object)"queryInIf", missingVariables.get(4));
                Assert.assertEquals((Object)"elseIfCondition", missingVariables.get(5));
                Assert.assertEquals((Object)"queryInElseIf", missingVariables.get(6));
                Assert.assertEquals((Object)"queryInElse", missingVariables.get(7));
                Assert.assertEquals((Object)"letExpression", missingVariables.get(8));
                Assert.assertEquals((Object)"queryInLet", missingVariables.get(9));
                Assert.assertEquals((Object)"forExpression", missingVariables.get(10));
                Assert.assertEquals((Object)"queryInFor", missingVariables.get(11));
                Assert.assertEquals((Object)"queryExpression", missingVariables.get(12));
                Assert.assertEquals((Object)"aqlInSelect", missingVariables.get(13));
                Assert.assertEquals((Object)"aqlLetExpression", missingVariables.get(14));
                Assert.assertEquals((Object)"aqlLetBody", missingVariables.get(15));
            } else {
                Assert.assertEquals((long)17L, (long)missingVariables.size());
                Assert.assertEquals((Object)"linkName", missingVariables.get(0));
                Assert.assertEquals((Object)"linkText", missingVariables.get(1));
                Assert.assertEquals((Object)"bookmarkName", missingVariables.get(2));
                Assert.assertEquals((Object)"queryInBookmark", missingVariables.get(3));
                Assert.assertEquals((Object)"ifCondition", missingVariables.get(4));
                Assert.assertEquals((Object)"queryInIf", missingVariables.get(5));
                Assert.assertEquals((Object)"elseIfCondition", missingVariables.get(6));
                Assert.assertEquals((Object)"queryInElseIf", missingVariables.get(7));
                Assert.assertEquals((Object)"queryInElse", missingVariables.get(8));
                Assert.assertEquals((Object)"letExpression", missingVariables.get(9));
                Assert.assertEquals((Object)"queryInLet", missingVariables.get(10));
                Assert.assertEquals((Object)"forExpression", missingVariables.get(11));
                Assert.assertEquals((Object)"queryInFor", missingVariables.get(12));
                Assert.assertEquals((Object)"queryExpression", missingVariables.get(13));
                Assert.assertEquals((Object)"aqlInSelect", missingVariables.get(14));
                Assert.assertEquals((Object)"aqlLetExpression", missingVariables.get(15));
                Assert.assertEquals((Object)"aqlLetBody", missingVariables.get(16));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getMissingVariablesInHeader() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/missingVariablesInHeader.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            List missingVariables = properties.getMissingVariables();
            if (missingVariables.size() == 16) {
                Assert.assertEquals((Object)"linkNamelinkText", missingVariables.get(0));
                Assert.assertEquals((Object)"bookmarkName", missingVariables.get(1));
                Assert.assertEquals((Object)"queryInBookmark", missingVariables.get(2));
                Assert.assertEquals((Object)"ifCondition", missingVariables.get(3));
                Assert.assertEquals((Object)"queryInIf", missingVariables.get(4));
                Assert.assertEquals((Object)"elseIfCondition", missingVariables.get(5));
                Assert.assertEquals((Object)"queryInElseIf", missingVariables.get(6));
                Assert.assertEquals((Object)"queryInElse", missingVariables.get(7));
                Assert.assertEquals((Object)"letExpression", missingVariables.get(8));
                Assert.assertEquals((Object)"queryInLet", missingVariables.get(9));
                Assert.assertEquals((Object)"forExpression", missingVariables.get(10));
                Assert.assertEquals((Object)"queryInFor", missingVariables.get(11));
                Assert.assertEquals((Object)"queryExpression", missingVariables.get(12));
                Assert.assertEquals((Object)"aqlInSelect", missingVariables.get(13));
                Assert.assertEquals((Object)"aqlLetExpression", missingVariables.get(14));
                Assert.assertEquals((Object)"aqlLetBody", missingVariables.get(15));
            } else {
                Assert.assertEquals((long)17L, (long)missingVariables.size());
                Assert.assertEquals((Object)"linkName", missingVariables.get(0));
                Assert.assertEquals((Object)"linkText", missingVariables.get(1));
                Assert.assertEquals((Object)"bookmarkName", missingVariables.get(2));
                Assert.assertEquals((Object)"queryInBookmark", missingVariables.get(3));
                Assert.assertEquals((Object)"ifCondition", missingVariables.get(4));
                Assert.assertEquals((Object)"queryInIf", missingVariables.get(5));
                Assert.assertEquals((Object)"elseIfCondition", missingVariables.get(6));
                Assert.assertEquals((Object)"queryInElseIf", missingVariables.get(7));
                Assert.assertEquals((Object)"queryInElse", missingVariables.get(8));
                Assert.assertEquals((Object)"letExpression", missingVariables.get(9));
                Assert.assertEquals((Object)"queryInLet", missingVariables.get(10));
                Assert.assertEquals((Object)"forExpression", missingVariables.get(11));
                Assert.assertEquals((Object)"queryInFor", missingVariables.get(12));
                Assert.assertEquals((Object)"queryExpression", missingVariables.get(13));
                Assert.assertEquals((Object)"aqlInSelect", missingVariables.get(14));
                Assert.assertEquals((Object)"aqlLetExpression", missingVariables.get(15));
                Assert.assertEquals((Object)"aqlLetBody", missingVariables.get(16));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getMissingVariablesInFooter() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/missingVariablesInFooter.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            List missingVariables = properties.getMissingVariables();
            if (missingVariables.size() == 16) {
                Assert.assertEquals((Object)"linkNamelinkText", missingVariables.get(0));
                Assert.assertEquals((Object)"bookmarkName", missingVariables.get(1));
                Assert.assertEquals((Object)"queryInBookmark", missingVariables.get(2));
                Assert.assertEquals((Object)"ifCondition", missingVariables.get(3));
                Assert.assertEquals((Object)"queryInIf", missingVariables.get(4));
                Assert.assertEquals((Object)"elseIfCondition", missingVariables.get(5));
                Assert.assertEquals((Object)"queryInElseIf", missingVariables.get(6));
                Assert.assertEquals((Object)"queryInElse", missingVariables.get(7));
                Assert.assertEquals((Object)"letExpression", missingVariables.get(8));
                Assert.assertEquals((Object)"queryInLet", missingVariables.get(9));
                Assert.assertEquals((Object)"forExpression", missingVariables.get(10));
                Assert.assertEquals((Object)"queryInFor", missingVariables.get(11));
                Assert.assertEquals((Object)"queryExpression", missingVariables.get(12));
                Assert.assertEquals((Object)"aqlInSelect", missingVariables.get(13));
                Assert.assertEquals((Object)"aqlLetExpression", missingVariables.get(14));
                Assert.assertEquals((Object)"aqlLetBody", missingVariables.get(15));
            } else {
                Assert.assertEquals((long)17L, (long)missingVariables.size());
                Assert.assertEquals((Object)"linkName", missingVariables.get(0));
                Assert.assertEquals((Object)"linkText", missingVariables.get(1));
                Assert.assertEquals((Object)"bookmarkName", missingVariables.get(2));
                Assert.assertEquals((Object)"queryInBookmark", missingVariables.get(3));
                Assert.assertEquals((Object)"ifCondition", missingVariables.get(4));
                Assert.assertEquals((Object)"queryInIf", missingVariables.get(5));
                Assert.assertEquals((Object)"elseIfCondition", missingVariables.get(6));
                Assert.assertEquals((Object)"queryInElseIf", missingVariables.get(7));
                Assert.assertEquals((Object)"queryInElse", missingVariables.get(8));
                Assert.assertEquals((Object)"letExpression", missingVariables.get(9));
                Assert.assertEquals((Object)"queryInLet", missingVariables.get(10));
                Assert.assertEquals((Object)"forExpression", missingVariables.get(11));
                Assert.assertEquals((Object)"queryInFor", missingVariables.get(12));
                Assert.assertEquals((Object)"queryExpression", missingVariables.get(13));
                Assert.assertEquals((Object)"aqlInSelect", missingVariables.get(14));
                Assert.assertEquals((Object)"aqlLetExpression", missingVariables.get(15));
                Assert.assertEquals((Object)"aqlLetBody", missingVariables.get(16));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getUnusedVariables() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/unusedVariables.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            List unusedVariables = properties.getUnusedDeclarations();
            if (unusedVariables.size() == 1) {
                Assert.assertEquals((Object)"unusedVariable", unusedVariables.get(0));
            } else {
                Assert.assertEquals((long)2L, (long)unusedVariables.size());
                Assert.assertEquals((Object)"linkNamelinkText", unusedVariables.get(0));
                Assert.assertEquals((Object)"unusedVariable", unusedVariables.get(1));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getUnusedVariablesInHeader() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/unusedVariablesInHeader.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            List unusedVariables = properties.getUnusedDeclarations();
            if (unusedVariables.size() == 1) {
                Assert.assertEquals((Object)"unusedVariable", unusedVariables.get(0));
            } else {
                Assert.assertEquals((long)2L, (long)unusedVariables.size());
                Assert.assertEquals((Object)"linkNamelinkText", unusedVariables.get(0));
                Assert.assertEquals((Object)"unusedVariable", unusedVariables.get(1));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getUnusedVariablesInFooter() throws IOException, InvalidFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/unusedVariablesInFooter.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            List unusedVariables = properties.getUnusedDeclarations();
            if (unusedVariables.size() == 1) {
                Assert.assertEquals((Object)"unusedVariable", unusedVariables.get(0));
            } else {
                Assert.assertEquals((long)2L, (long)unusedVariables.size());
                Assert.assertEquals((Object)"linkNamelinkText", unusedVariables.get(0));
                Assert.assertEquals((Object)"unusedVariable", unusedVariables.get(1));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getM2DocVersion() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/properties-template-m2docVersion.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            Assert.assertEquals((Object)"2.0.0", (Object)properties.getM2DocVersion());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void setM2DocVersion() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/properties-template-m2docVersion.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            Assert.assertEquals((Object)"2.0.0", (Object)properties.getM2DocVersion());
            properties.setM2DocVersion("3.0.0");
            Assert.assertEquals((Object)"3.0.0", (Object)properties.getM2DocVersion());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getVariableTypes() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, URI.createFileURI((String)"resources/document/properties/properties-template-m2docVersion.docx"));){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
            AstValidator validator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)queryEnvironment));
            Set possibleTypes = properties.getVariableTypes(validator, (IReadOnlyQueryEnvironment)queryEnvironment, "ecore::EClass");
            Iterator it = possibleTypes.iterator();
            IType possibleType = (IType)it.next();
            Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
            Assert.assertFalse((boolean)(possibleType instanceof EClassifierLiteralType));
            Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
            possibleTypes = properties.getVariableTypes(validator, (IReadOnlyQueryEnvironment)queryEnvironment, "Sequence(ecore::EClass)");
            it = possibleTypes.iterator();
            possibleType = (IType)it.next();
            Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
            IType collectionType = ((SequenceType)possibleType).getCollectionType();
            Assert.assertTrue((boolean)(collectionType instanceof EClassifierType));
            Assert.assertFalse((boolean)(collectionType instanceof EClassifierLiteralType));
            Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)collectionType).getType());
            possibleTypes = properties.getVariableTypes(validator, (IReadOnlyQueryEnvironment)queryEnvironment, "OrderedSet(ecore::EClass)");
            it = possibleTypes.iterator();
            possibleType = (IType)it.next();
            Assert.assertTrue((boolean)(possibleType instanceof SetType));
            collectionType = ((SetType)possibleType).getCollectionType();
            Assert.assertTrue((boolean)(collectionType instanceof EClassifierType));
            Assert.assertFalse((boolean)(collectionType instanceof EClassifierLiteralType));
            Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)collectionType).getType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

