/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests.services;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MElementContainer;
import org.obeonetwork.m2doc.element.MPagination;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.impl.MStyleImpl;
import org.obeonetwork.m2doc.element.impl.MTableImpl;
import org.obeonetwork.m2doc.element.impl.MTextImpl;

public class MTableTestServices {
    public MTable emptyTable(String label) {
        MTableImpl table = new MTableImpl();
        table.setLabel(label);
        return table;
    }

    public MTable tableEmptyCell(String label) {
        MTableImpl table = new MTableImpl();
        table.setLabel(label);
        MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
        MTableImpl.MCellImpl cell = new MTableImpl.MCellImpl(null, Color.BLACK);
        row.getCells().add(cell);
        table.getRows().add(row);
        return table;
    }

    public MTable tableNullCell(String label) {
        MTableImpl table = new MTableImpl();
        table.setLabel(label);
        MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
        row.getCells().add(null);
        table.getRows().add(row);
        return table;
    }

    public MTable sampleTable(String label) {
        MTableImpl table = new MTableImpl();
        table.setLabel(label);
        int[] nArray = new int[3];
        nArray[1] = 127;
        nArray[2] = 255;
        int[] colors = nArray;
        int index = 0;
        MTableImpl.MRowImpl headerRow = new MTableImpl.MRowImpl();
        table.getRows().add(headerRow);
        headerRow.getCells().add(new MTableImpl.MCellImpl(null, null));
        int xStyle = 0;
        while (xStyle < 4) {
            MTextImpl headerText = new MTextImpl(this.getLabelStyle(xStyle), this.getStyle(1 << xStyle, 10, null, null));
            MTableImpl.MCellImpl headerCell = new MTableImpl.MCellImpl((MElement)headerText, null);
            headerRow.getCells().add(headerCell);
            ++xStyle;
        }
        int yStyle = 0;
        while (yStyle < 4) {
            MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
            table.getRows().add(row);
            MTextImpl headerText = new MTextImpl(this.getLabelStyle(yStyle), this.getStyle(1 << yStyle, 10, null, null));
            MTableImpl.MCellImpl headerCell = new MTableImpl.MCellImpl((MElement)headerText, null);
            row.getCells().add(headerCell);
            int xStyle2 = 0;
            while (xStyle2 < 4) {
                String text = Integer.toString(index++);
                Color foregroundColor = new Color(colors[(index + 1) % 3], colors[(index + 2) % 3], colors[(index + 3) % 3]);
                Color backgroundColor = new Color(colors[(index + 2) % 3], colors[(index + 3) % 3], colors[(index + 1) % 3]);
                MTextImpl mText = new MTextImpl(text, this.getStyle(1 << xStyle2 | 1 << yStyle, index + 4, foregroundColor, null));
                MTableImpl.MCellImpl cell = new MTableImpl.MCellImpl((MElement)mText, backgroundColor);
                row.getCells().add(cell);
                ++xStyle2;
            }
            ++yStyle;
        }
        return table;
    }

    private MStyle getStyle(int modifiers, int fontSize, Color foregroundColor, Color backgroundColor) {
        return new MStyleImpl(null, fontSize, foregroundColor, backgroundColor, modifiers);
    }

    private String getLabelStyle(int index) {
        String res;
        switch (index) {
            case 0: {
                res = "Bold";
                break;
            }
            case 1: {
                res = "Italic";
                break;
            }
            case 2: {
                res = "Underline";
                break;
            }
            case 3: {
                res = "Strike through";
                break;
            }
            default: {
                res = "";
            }
        }
        return res;
    }

    public List<MElement> alignmentTables(String label) {
        ArrayList<MElement> res = new ArrayList<MElement>();
        MElementContainer.HAlignment[] hAlignmentArray = MElementContainer.HAlignment.values();
        int n = hAlignmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            MElementContainer.HAlignment hAlign = hAlignmentArray[n2];
            MTableImpl table = new MTableImpl();
            res.add((MElement)table);
            res.add((MElement)MPagination.newParagraph);
            MTableImpl.MRowImpl titleRow = new MTableImpl.MRowImpl();
            table.getRows().add(titleRow);
            titleRow.getCells().add(new MTableImpl.MCellImpl(null, null));
            titleRow.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl(hAlign.name(), null), null));
            titleRow.getCells().add(new MTableImpl.MCellImpl(null, null));
            MTable.MCell.VAlignment[] vAlignmentArray = MTable.MCell.VAlignment.values();
            int n3 = vAlignmentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                MTable.MCell.VAlignment vAlign = vAlignmentArray[n4];
                MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
                table.getRows().add(row);
                row.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl(vAlign.name(), null), null));
                MTableImpl.MCellImpl cell = new MTableImpl.MCellImpl((MElement)new MTextImpl("Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit...", null), null);
                cell.setVAlignment(vAlign);
                cell.setHAlignment(hAlign);
                row.getCells().add(cell);
                row.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl("\n\n\n\n\n\n", null), null));
                ++n4;
            }
            ++n2;
        }
        return res;
    }

    public MTable simpleTable(String label) {
        MTableImpl res = new MTableImpl();
        int i = 0;
        while (i < 5) {
            MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
            res.getRows().add(row);
            int j = 0;
            while (j < 5) {
                row.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl("Text " + i + " " + j, null), null));
                ++j;
            }
            ++i;
        }
        return res;
    }

    public MTable verticalMergeAll(String label) {
        MTable res = this.sampleTable(label);
        MTable.MCell.Merge merge = MTable.MCell.Merge.RESTART;
        for (MTable.MRow row : res.getRows()) {
            for (MTable.MCell cell : row.getCells()) {
                cell.setVMerge(merge);
            }
            merge = MTable.MCell.Merge.CONTINUE;
        }
        return res;
    }

    public MTable verticalMerge(String label) {
        MTable res = this.sampleTable(label);
        MTable.MCell cell = this.getCell(res, 2, 2);
        cell.setVMerge(MTable.MCell.Merge.RESTART);
        cell = this.getCell(res, 2, 3);
        cell.setVMerge(MTable.MCell.Merge.RESTART);
        cell = this.getCell(res, 3, 2);
        cell.setVMerge(MTable.MCell.Merge.CONTINUE);
        cell = this.getCell(res, 3, 3);
        cell.setVMerge(MTable.MCell.Merge.CONTINUE);
        return res;
    }

    public MTable horizontalMergeAll(String label) {
        MTable res = this.sampleTable(label);
        for (MTable.MRow row : res.getRows()) {
            MTable.MCell.Merge merge = MTable.MCell.Merge.RESTART;
            for (MTable.MCell cell : row.getCells()) {
                cell.setHMerge(merge);
                merge = MTable.MCell.Merge.CONTINUE;
            }
        }
        return res;
    }

    public MTable bothMergeAll(String label) {
        MTable res = this.sampleTable(label);
        MTable.MCell.Merge vMerge = MTable.MCell.Merge.RESTART;
        for (MTable.MRow row : res.getRows()) {
            MTable.MCell.Merge hMerge = MTable.MCell.Merge.RESTART;
            for (MTable.MCell cell : row.getCells()) {
                cell.setVMerge(vMerge);
                cell.setHMerge(hMerge);
                hMerge = MTable.MCell.Merge.CONTINUE;
            }
            vMerge = MTable.MCell.Merge.CONTINUE;
        }
        return res;
    }

    public MTable horizontalMerge(String label) {
        MTable res = this.sampleTable(label);
        MTable.MCell cell = this.getCell(res, 2, 2);
        cell.setHMerge(MTable.MCell.Merge.RESTART);
        cell = this.getCell(res, 2, 3);
        cell.setHMerge(MTable.MCell.Merge.CONTINUE);
        cell = this.getCell(res, 3, 2);
        cell.setHMerge(MTable.MCell.Merge.RESTART);
        cell = this.getCell(res, 3, 3);
        cell.setHMerge(MTable.MCell.Merge.CONTINUE);
        return res;
    }

    public MTable bothMerge(String label) {
        MTable res = this.sampleTable(label);
        MTable.MCell cell = this.getCell(res, 2, 2);
        cell.setVMerge(MTable.MCell.Merge.RESTART);
        cell.setHMerge(MTable.MCell.Merge.RESTART);
        cell = this.getCell(res, 2, 3);
        cell.setVMerge(MTable.MCell.Merge.RESTART);
        cell.setHMerge(MTable.MCell.Merge.CONTINUE);
        cell = this.getCell(res, 3, 2);
        cell.setVMerge(MTable.MCell.Merge.CONTINUE);
        cell.setHMerge(MTable.MCell.Merge.RESTART);
        cell = this.getCell(res, 3, 3);
        cell.setVMerge(MTable.MCell.Merge.CONTINUE);
        cell.setHMerge(MTable.MCell.Merge.CONTINUE);
        return res;
    }

    private MTable.MCell getCell(MTable mTable, int row, int column) {
        MTable.MCell res;
        if (row > -1 && row < mTable.getRows().size()) {
            MTable.MRow mRow = (MTable.MRow)mTable.getRows().get(row);
            res = column > -1 && column < mRow.getCells().size() ? (MTable.MCell)mRow.getCells().get(column) : null;
        } else {
            res = null;
        }
        return res;
    }
}

