/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.sirius.tests.tables;

import java.awt.Color;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DCellStyle;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MList;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.MText;
import org.obeonetwork.m2doc.sirius.util.DTable2MTableConverter;

public class DMTableTest {
    private static final int BROWN = 0x804000;
    private static final int WHITE = 0xFFFFFF;
    private static final int GRAY = 0x404040;
    private static final int BLACK = 0;
    private DTable dtable;
    private DTableElementStyle styleRow;
    private DTableElementStyle styleCol;
    private DCellStyle styleCell;
    private MTable tableWithHeader;
    private MTable tableWithoutHeader;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    private final DTable2MTableConverter tableConverter = new DTable2MTableConverter(this.adapterFactoryLabelProvider);

    @Test
    public void testWithHeader() {
        Assert.assertEquals((long)3L, (long)this.tableWithHeader.getColumnsCount());
        Assert.assertEquals((long)3L, (long)this.tableWithHeader.getRows().size());
        Iterator rowIt = this.tableWithHeader.getRows().iterator();
        MTable.MRow row = (MTable.MRow)rowIt.next();
        MTable.MCell cell0 = (MTable.MCell)row.getCells().get(0);
        Assert.assertNull((Object)cell0.getContents());
        Assert.assertNull((Object)cell0.getBackgroundColor());
        MTable.MCell cell1 = (MTable.MCell)row.getCells().get(1);
        Assert.assertEquals((Object)"Col One", (Object)((MText)cell1.getContents()).getText());
        Assert.assertEquals((Object)DTable2MTableConverter.HEADER_BACKGROUND_COLOR, (Object)cell1.getBackgroundColor());
        this.assertStyleEqualsTo(DTable2MTableConverter.HEADER_STYLE, ((MText)cell1.getContents()).getStyle());
        MTable.MCell cell2 = (MTable.MCell)row.getCells().get(2);
        Assert.assertEquals((Object)"Col Two", (Object)((MText)cell2.getContents()).getText());
        Assert.assertEquals((Object)DTable2MTableConverter.HEADER_BACKGROUND_COLOR, (Object)cell2.getBackgroundColor());
        this.assertStyleEqualsTo(DTable2MTableConverter.HEADER_STYLE, ((MText)cell2.getContents()).getStyle());
        row = (MTable.MRow)rowIt.next();
        Assert.assertEquals((long)3L, (long)row.getCells().size());
        MTable.MCell cell10 = (MTable.MCell)row.getCells().get(0);
        Assert.assertTrue((boolean)(((MList)cell10.getContents()).get(0) instanceof MImage));
        Assert.assertEquals((Object)"Row One", (Object)((MText)((MList)cell10.getContents()).get(1)).getText());
        this.assertStyleEqualsTo(DTable2MTableConverter.HEADER_STYLE, ((MText)((MList)cell10.getContents()).get(1)).getStyle());
        MTable.MCell cell11 = (MTable.MCell)row.getCells().get(1);
        MStyle style = ((MText)cell11.getContents()).getStyle();
        Assert.assertEquals((Object)"Cell One One", (Object)((MText)cell11.getContents()).getText());
        Assert.assertEquals((long)6L, (long)style.getFontSize());
        Assert.assertEquals((Object)new Color(0x404040), (Object)cell11.getBackgroundColor());
        Assert.assertEquals((Object)new Color(0), (Object)style.getForegroundColor());
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 4));
        MTable.MCell cell12 = (MTable.MCell)row.getCells().get(2);
        Assert.assertNull((Object)cell12.getContents());
        Assert.assertNull((Object)cell12.getBackgroundColor());
        row = (MTable.MRow)rowIt.next();
        Assert.assertEquals((long)3L, (long)row.getCells().size());
        MTable.MCell cell20 = (MTable.MCell)row.getCells().get(0);
        Assert.assertTrue((boolean)(((MList)cell20.getContents()).get(0) instanceof MImage));
        Assert.assertEquals((Object)"Row Two", (Object)((MText)((MList)cell20.getContents()).get(1)).getText());
        Assert.assertEquals((Object)DTable2MTableConverter.HEADER_BACKGROUND_COLOR, (Object)cell20.getBackgroundColor());
        this.assertStyleEqualsTo(DTable2MTableConverter.HEADER_STYLE, ((MText)((MList)cell20.getContents()).get(1)).getStyle());
        MTable.MCell cell21 = (MTable.MCell)row.getCells().get(1);
        Assert.assertNull((Object)cell21.getContents());
        Assert.assertEquals((Object)new Color(0xFFFFFF), (Object)cell21.getBackgroundColor());
        MTable.MCell cell22 = (MTable.MCell)row.getCells().get(2);
        Assert.assertEquals((Object)"Cell Two Two", (Object)((MText)cell22.getContents()).getText());
        style = ((MText)cell22.getContents()).getStyle();
        Assert.assertEquals((long)9L, (long)style.getFontSize());
        Assert.assertEquals((Object)new Color(0xFFFFFF), (Object)cell22.getBackgroundColor());
        Assert.assertEquals((Object)new Color(0x804000), (Object)style.getForegroundColor());
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 4));
    }

    @Test
    public void testWithoutHeader() {
        Assert.assertEquals((long)3L, (long)this.tableWithoutHeader.getColumnsCount());
        Assert.assertEquals((long)3L, (long)this.tableWithoutHeader.getRows().size());
        Iterator rowIt = this.tableWithoutHeader.getRows().iterator();
        MTable.MRow row = (MTable.MRow)rowIt.next();
        MTable.MCell cell0 = (MTable.MCell)row.getCells().get(0);
        Assert.assertNull((Object)cell0.getContents());
        Assert.assertNull((Object)cell0.getBackgroundColor());
        MTable.MCell cell1 = (MTable.MCell)row.getCells().get(1);
        Assert.assertEquals((Object)"Col One", (Object)((MText)cell1.getContents()).getText());
        Assert.assertEquals(null, (Object)cell1.getBackgroundColor());
        this.assertStyleEqualsTo(null, ((MText)cell1.getContents()).getStyle());
        MTable.MCell cell2 = (MTable.MCell)row.getCells().get(2);
        Assert.assertEquals((Object)"Col Two", (Object)((MText)cell2.getContents()).getText());
        Assert.assertEquals(null, (Object)cell2.getBackgroundColor());
        this.assertStyleEqualsTo(null, ((MText)cell2.getContents()).getStyle());
        row = (MTable.MRow)rowIt.next();
        Assert.assertEquals((long)3L, (long)row.getCells().size());
        MTable.MCell cell10 = (MTable.MCell)row.getCells().get(0);
        Assert.assertTrue((boolean)(((MList)cell10.getContents()).get(0) instanceof MImage));
        Assert.assertEquals((Object)"Row One", (Object)((MText)((MList)cell10.getContents()).get(1)).getText());
        this.assertStyleEqualsTo(null, ((MText)((MList)cell10.getContents()).get(1)).getStyle());
        MTable.MCell cell11 = (MTable.MCell)row.getCells().get(1);
        MStyle style = ((MText)cell11.getContents()).getStyle();
        Assert.assertEquals((Object)"Cell One One", (Object)((MText)cell11.getContents()).getText());
        Assert.assertEquals((long)6L, (long)style.getFontSize());
        Assert.assertEquals((Object)new Color(0x404040), (Object)cell11.getBackgroundColor());
        Assert.assertEquals((Object)new Color(0), (Object)style.getForegroundColor());
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 4));
        MTable.MCell cell12 = (MTable.MCell)row.getCells().get(2);
        Assert.assertNull((Object)cell12.getContents());
        Assert.assertNull((Object)cell12.getBackgroundColor());
        row = (MTable.MRow)rowIt.next();
        Assert.assertEquals((long)3L, (long)row.getCells().size());
        MTable.MCell cell20 = (MTable.MCell)row.getCells().get(0);
        Assert.assertTrue((boolean)(((MList)cell20.getContents()).get(0) instanceof MImage));
        Assert.assertEquals((Object)"Row Two", (Object)((MText)((MList)cell20.getContents()).get(1)).getText());
        Assert.assertEquals(null, (Object)cell20.getBackgroundColor());
        this.assertStyleEqualsTo(null, ((MText)((MList)cell20.getContents()).get(1)).getStyle());
        MTable.MCell cell21 = (MTable.MCell)row.getCells().get(1);
        Assert.assertNull((Object)cell21.getContents());
        Assert.assertEquals((Object)new Color(0xFFFFFF), (Object)cell21.getBackgroundColor());
        MTable.MCell cell22 = (MTable.MCell)row.getCells().get(2);
        Assert.assertEquals((Object)"Cell Two Two", (Object)((MText)cell22.getContents()).getText());
        style = ((MText)cell22.getContents()).getStyle();
        Assert.assertEquals((long)9L, (long)style.getFontSize());
        Assert.assertEquals((Object)new Color(0xFFFFFF), (Object)cell22.getBackgroundColor());
        Assert.assertEquals((Object)new Color(0x804000), (Object)style.getForegroundColor());
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 4));
    }

    private void assertStyleEqualsTo(MStyle left, MStyle right) {
        if (left == null) {
            Assert.assertNull((Object)right);
        } else {
            Assert.assertEquals((Object)left.getForegroundColor(), (Object)right.getForegroundColor());
            Assert.assertEquals((long)left.getFontModifiers(), (long)right.getFontModifiers());
            Assert.assertEquals((long)left.getFontSize(), (long)right.getFontSize());
        }
    }

    @Before
    public void setUp() {
        this.dtable = TableFactory.eINSTANCE.createDTable();
        this.styleRow = TableFactory.eINSTANCE.createDTableElementStyle();
        this.styleRow.setLabelSize(3);
        this.styleCol = TableFactory.eINSTANCE.createDTableElementStyle();
        this.styleCol.setLabelSize(6);
        this.styleCol.setBackgroundColor(RGBValues.create((int)64, (int)64, (int)64));
        this.styleCol.getLabelFormat().add((Object)FontFormat.ITALIC_LITERAL);
        this.styleCell = TableFactory.eINSTANCE.createDCellStyle();
        this.styleCell.setLabelSize(9);
        this.styleCell.setForegroundColor(RGBValues.create((int)128, (int)64, (int)0));
        this.styleCell.getLabelFormat().add((Object)FontFormat.BOLD_LITERAL);
        DFeatureColumn col1 = TableFactory.eINSTANCE.createDFeatureColumn();
        col1.setLabel("Col One");
        col1.setCurrentStyle(this.styleCol);
        col1.setVisible(true);
        col1.setTable(this.dtable);
        DTargetColumn col2 = TableFactory.eINSTANCE.createDTargetColumn();
        col2.setLabel("Col Two");
        col2.setVisible(true);
        col2.setTable(this.dtable);
        DLine line1 = TableFactory.eINSTANCE.createDLine();
        line1.setLabel("Row One");
        line1.setVisible(true);
        this.dtable.getLines().add((Object)line1);
        DCell cell11 = TableFactory.eINSTANCE.createDCell();
        cell11.setLabel("Cell One One");
        cell11.setColumn((DColumn)col1);
        line1.getCells().add((Object)cell11);
        DLine line2 = TableFactory.eINSTANCE.createDLine();
        line2.setLabel("Row Two");
        line2.setCurrentStyle(this.styleRow);
        this.dtable.getLines().add((Object)line2);
        DCell cell22 = TableFactory.eINSTANCE.createDCell();
        cell22.setLabel("Cell Two Two");
        cell22.setColumn((DColumn)col2);
        cell22.setCurrentStyle(this.styleCell);
        line2.getCells().add((Object)cell22);
        this.tableWithHeader = this.tableConverter.convertTable(this.dtable, true);
        this.tableWithoutHeader = this.tableConverter.convertTable(this.dtable, false);
    }
}

