/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.sirius.services;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.image.ImageManagerProvider;
import org.eclipse.sirius.business.api.query.DRepresentationDescriptorQuery;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.impl.MImageImpl;
import org.obeonetwork.m2doc.element.impl.MTableImpl;
import org.obeonetwork.m2doc.element.impl.MTextImpl;
import org.obeonetwork.m2doc.sirius.services.CleaningAIRDJob;
import org.obeonetwork.m2doc.sirius.services.SiriusRepresentationUtils;
import org.obeonetwork.m2doc.sirius.util.DTable2MTableConverter;

@ServiceProvider(value="Services available for Sirius. You will have to set the \"SiriusSession\" option in the generation configuration. It must contains the .aird file URI. See [document examples](https://github.com/ObeoNetwork/M2Doc/tree/master/tests/org.obeonetwork.m2doc.sirius.tests/resources/m2DocSiriusServices). In addition, you can force the refresh of all representation with option \"SiriusForceRefresh\" set to \"true\". Note this option might have an impact on memory usage, calls to services with the refresh parameter should be prefered. You can also use the two following options to define the size of the exported images from Sirius diagrams: \"SiriusScalingPolicy\" that can be one of: WORKSPACE_DEFAULT, AUTO_SCALING, NO_SCALING, AUTO_SCALING_IF_LARGER and \"SiriusScaleLevel\" and integer.")
public class M2DocSiriusServices {
    private static final String JPG = "JPG";
    private static final Set<String> VALID_IMAGE_FORMATS = M2DocSiriusServices.initializeValidImageFormats();
    private final Session session;
    private final URIConverter uriConverter;
    private final boolean forceRefresh;
    private final ExportFormat.ScalingPolicy scalingPolicy;
    private final Integer scaleLevel;
    private final CleaningJobRegistry registry = new CleaningJobRegistry();
    private final Set<File> tmpFiles = new LinkedHashSet<File>();
    private final boolean shouldCloseSession;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    private final DTable2MTableConverter tableConverter = new DTable2MTableConverter(this.adapterFactoryLabelProvider);

    public M2DocSiriusServices(Session session, boolean forceRefresh) {
        this(session, forceRefresh, ExportFormat.ScalingPolicy.WORKSPACE_DEFAULT, null);
    }

    public M2DocSiriusServices(Session session, boolean forceRefresh, ExportFormat.ScalingPolicy scalingPolicy, Integer scaleLevel) {
        this.session = session;
        this.uriConverter = session.getTransactionalEditingDomain().getResourceSet().getURIConverter();
        this.forceRefresh = forceRefresh;
        if (!session.isOpen()) {
            session.open((IProgressMonitor)new NullProgressMonitor());
            this.shouldCloseSession = true;
        } else {
            this.shouldCloseSession = false;
        }
        this.scalingPolicy = scalingPolicy;
        this.scaleLevel = scaleLevel;
    }

    private static Set<String> initializeValidImageFormats() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        res.add(ImageFileFormat.BMP.getName());
        res.add(ImageFileFormat.GIF.getName());
        res.add(ImageFileFormat.JPG.getName());
        res.add(ImageFileFormat.JPEG.getName());
        res.add(ImageFileFormat.PNG.getName());
        res.add(ImageFileFormat.SVG.getName());
        return res;
    }

    @Documentation(value="Returns <code>true</code> if the arguments are not null, the eObject is in a session and there's a representation description with the specified name in it that is associated to the specified eObject. Returns <code>false</code> otherwise.", params={@Param(name="eObject", value="Any eObject that is in the session where to search"), @Param(name="representationDescriptionName", value="the name of the searched representation description")}, result="<code>true</code> if there's a representation description with the specified name in the eObject's associated session", examples={@Example(expression="ePackage.isRepresentationDescriptionName('class diagram')", result="True")})
    public boolean isRepresentationDescriptionName(EObject eObject, String representationDescriptionName) {
        boolean result = representationDescriptionName != null ? this.getAssociatedRepresentationByDescriptionAndName(eObject, representationDescriptionName).size() > 0 : false;
        return result;
    }

    protected List<DRepresentationDescriptor> getAssociatedRepresentationByDescriptionAndName(EObject targetRootObject, String representationId) {
        return this.getAssociatedRepresentationByDescriptionAndName(targetRootObject, representationId, false);
    }

    protected List<DRepresentationDescriptor> getAssociatedRepresentationByDescriptionAndName(EObject targetRootObject, String representationId, boolean createIfAbsent) {
        ArrayList<Object> result = new ArrayList<DRepresentationDescriptor>();
        if (representationId != null && targetRootObject != null && this.session != null) {
            Collection representations = DialectManager.INSTANCE.getRepresentationDescriptors(targetRootObject, this.session);
            Collection selectedViewpoints = this.session.getSelectedViewpoints(false);
            for (DRepresentationDescriptor representation : representations) {
                Viewpoint vp;
                boolean isDangling = new DRepresentationDescriptorQuery(representation).isDangling();
                if (isDangling || !representationId.equals(representation.getDescription().getName()) || !(representation.getDescription().eContainer() instanceof Viewpoint) || !selectedViewpoints.contains(vp = (Viewpoint)representation.getDescription().eContainer())) continue;
                result.add(representation);
            }
        }
        if (result.isEmpty() && createIfAbsent) {
            RepresentationDescription description = SiriusRepresentationUtils.findDescription(this.session, representationId);
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new CreateRepresentationCommand(this.session, description, targetRootObject, representationId, (IProgressMonitor)new NullProgressMonitor()));
            for (DRepresentationDescriptor representation : DialectManager.INSTANCE.getRepresentationDescriptors(targetRootObject, this.session)) {
                if (representation == null || representation.getDescription() != description) continue;
                this.registry.registerJob(new CleaningAIRDJob(targetRootObject, this.session, representation));
                result = new ArrayList();
                result.add(representation);
            }
        }
        return result;
    }

    @Documentation(value="Returns <code>true</code> if the arguments are not null, there's a representation with the specified name in the Sirius session. Returns <code>false</code> otherwise.", params={@Param(name="representationName", value="the name of the searched representation")}, result="<code>true</code> if there's a representation with the specified name in the Sirius session", examples={@Example(expression="'MyEPackage class diagram'.isRepresentationName()", result="True")})
    public boolean isRepresentationName(String representationName) {
        boolean result = representationName != null ? SiriusRepresentationUtils.getAssociatedRepresentationByName(representationName, this.session) != null : false;
        return result;
    }

    @Documentation(value="Insert the image of the given representation if it's a diagram.", params={@Param(name="representation", value="the DRepresentation"), @Param(name="refresh", value="true to refresh the representation"), @Param(name="layerNames", value="the OrderedSet of layer names to activate")}, result="insert the image of the given representation if it's a diagram.", examples={@Example(expression="dRepresentation.asImage(true, OrderedSet{'Layer 1', 'Layer 2'})", result="insert the image of the given representation if it's a diagram")})
    public MImage asImage(DRepresentation representation, boolean refresh, Set<String> layerNames) throws SizeTooLargeException, IOException {
        return this.asImage(representation, JPG, refresh, layerNames);
    }

    @Documentation(value="Insert the image of the given representation if it's a diagram.", params={@Param(name="representation", value="the DRepresentation"), @Param(name="format", value="the image format: BMP, GIF, JPG, JPEG, PNG, SVG"), @Param(name="refresh", value="true to refresh the representation"), @Param(name="layerNames", value="the OrderedSet of layer names to activate")}, result="insert the image of the given representation if it's a diagram.", examples={@Example(expression="dRepresentation.asImage('JPG', true, OrderedSet{'Layer 1', 'Layer 2'})", result="insert the image of the given representation if it's a diagram")})
    public MImage asImage(DRepresentation representation, String format, boolean refresh, Set<String> layerNames) throws SizeTooLargeException, IOException {
        MImage res;
        if (representation instanceof DDiagram) {
            DDiagram diagram = (DDiagram)representation;
            ArrayList<Layer> layers = new ArrayList<Layer>();
            for (Layer layer : SiriusRepresentationUtils.getAllLayer(diagram.getDescription())) {
                if (!layerNames.contains(layer.getName())) continue;
                layers.add(layer);
            }
            boolean isSessionDirtyBeforeExport = SessionStatus.DIRTY.equals((Object)this.session.getStatus());
            DDiagram diagramToExport = SiriusRepresentationUtils.getDDiagramToExport(diagram, refresh, layers, this.session, SiriusRepresentationUtils.getEditor(this.session, (DRepresentation)diagram) != null);
            res = this.internalAsImage((DRepresentation)diagramToExport, format);
            if (!diagramToExport.equals(diagram)) {
                this.session.getTransactionalEditingDomain().getCommandStack().undo();
            }
            if (!isSessionDirtyBeforeExport) {
                this.session.save((IProgressMonitor)new NullProgressMonitor());
            }
        } else {
            res = MImage.EMPTY;
        }
        return res;
    }

    @Documentation(value="Insert the image of the given representation if it's a diagram.", params={@Param(name="representation", value="the DRepresentation"), @Param(name="format", value="the image format: BMP, GIF, JPG, JPEG, PNG, SVG")}, result="insert the image of the given representation if it's a diagram.", examples={@Example(expression="dRepresentation.asImage()", result="insert the image of the given representation if it's a diagram")})
    public MImage asImage(DRepresentation representation, String format) throws SizeTooLargeException, IOException {
        return this.asImage(representation, format, false);
    }

    @Documentation(value="Insert the image of the given representation if it's a diagram.", params={@Param(name="representation", value="the DRepresentation")}, result="insert the image of the given representation if it's a diagram.", examples={@Example(expression="dRepresentation.asImage()", result="insert the image of the given representation if it's a diagram")})
    public MImage asImage(DRepresentation representation) throws SizeTooLargeException, IOException {
        return this.asImage(representation, false);
    }

    @Documentation(value="Insert the image of the given representation if it's a diagram.", params={@Param(name="representation", value="the DRepresentation"), @Param(name="refresh", value="true to refresh the representation")}, result="insert the image of the given representation if it's a diagram.", examples={@Example(expression="dRepresentation.asImage(true)", result="insert the image of the given representation after refreshing it if it's a diagram")})
    public MImage asImage(DRepresentation representation, boolean refresh) throws SizeTooLargeException, IOException {
        return this.asImage(representation, JPG, refresh);
    }

    @Documentation(value="Insert the image of the given representation if it's a diagram.", params={@Param(name="representation", value="the DRepresentation"), @Param(name="format", value="the image format: BMP, GIF, JPG, JPEG, PNG, SVG"), @Param(name="refresh", value="true to refresh the representation")}, result="insert the image of the given representation if it's a diagram.", examples={@Example(expression="dRepresentation.asImage('JPG', true)", result="insert the image of the given representation after refreshing it if it's a diagram")})
    public MImage asImage(DRepresentation representation, String format, boolean refresh) throws SizeTooLargeException, IOException {
        MImage res;
        if ((this.forceRefresh || refresh) && representation instanceof DDiagram) {
            Set<String> layerNames = this.getActivatedLayerNames(representation);
            res = this.asImage(representation, this.forceRefresh || refresh, layerNames);
        } else {
            res = this.internalAsImage(representation, format);
        }
        return res;
    }

    private Set<String> getActivatedLayerNames(DRepresentation representation) {
        LinkedHashSet<String> layerNames = new LinkedHashSet<String>();
        for (Layer layer : ((DDiagram)representation).getActivatedLayers()) {
            layerNames.add(layer.getName());
        }
        return layerNames;
    }

    protected MImage internalAsImage(final DRepresentation representation, String format) throws IOException {
        if (!VALID_IMAGE_FORMATS.contains(format)) {
            String validFormatString = Arrays.toString(VALID_IMAGE_FORMATS.toArray());
            throw new IllegalArgumentException(String.valueOf(format) + " is not a valide format: " + validFormatString);
        }
        final ExportFormat exportFormat = new ExportFormat(ExportFormat.ExportDocumentFormat.NONE, ImageFileFormat.resolveImageFormat((String)format), this.scalingPolicy, this.scaleLevel);
        final File tmpFile = File.createTempFile(String.valueOf(this.sanitize(representation.getName())) + "-m2doc", "." + format.toLowerCase());
        this.tmpFiles.add(tmpFile);
        Runnable exportDiagUnitOfWork = new Runnable(){

            @Override
            public void run() {
                try {
                    DialectUIManager.INSTANCE.export(representation, M2DocSiriusServices.this.session, (IPath)new Path(tmpFile.getAbsolutePath()), exportFormat, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (SizeTooLargeException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        if (Display.getDefault() != null) {
            Display.getDefault().syncExec(exportDiagUnitOfWork);
        } else {
            exportDiagUnitOfWork.run();
        }
        MImageImpl res = new MImageImpl(this.uriConverter, URI.createFileURI((String)tmpFile.getAbsolutePath()));
        return res;
    }

    private String sanitize(String name) {
        return name.replaceAll("[<>:\"/\\|?*'\u0000]", "_");
    }

    @Documentation(value="Insert the table of the given representation table (with header styles).", params={@Param(name="representation", value="the DTable")}, result="insert the table of the given representation table (with header styles).", examples={@Example(expression="dTable.asTable()", result="insert the table of the given representation table (with header styles)")})
    public MTable asTable(DTable table) {
        return this.asTable(table, true);
    }

    @Documentation(value="Insert the table of the given representation table.", params={@Param(name="representation", value="the DTable"), @Param(name="withHeader", value="true to add header styles, false otherwise")}, result="insert the table of the given representation table.", examples={@Example(expression="dTable.asTable(false)", result="insert the table of the given representation table")})
    public MTable asTable(DTable table, boolean withHeader) {
        return this.tableConverter.convertTable(table, withHeader);
    }

    @Documentation(value="Gets the Sequence DRepresentation associated to the given EObject with the given description name.", params={@Param(name="eObject", value="Any eObject that is in the session where to search"), @Param(name="representationDescriptionName", value="the name of the searched representation description")}, result="the Sequence of DRepresentation associated to the given EObject with the given description name.", examples={@Example(expression="ePackage.asImageByRepresentationDescriptionName('class diagram')", result="Sequence{dRepresentation1, dRepresentation2}")})
    public List<DRepresentation> representationByDescriptionName(EObject eObj, String descriptionName) {
        return SiriusRepresentationUtils.getRepresentationByRepresentationDescriptionName(this.session, eObj, descriptionName);
    }

    @Documentation(value="Gets the Sequence of images for the diagrams associated to the given EObject with the given description name.", params={@Param(name="eObject", value="Any eObject that is in the session where to search"), @Param(name="representationDescriptionName", value="the name of the searched representation description"), @Param(name="refresh", value="true to refresh the representation"), @Param(name="layerNames", value="the OrderedSet of layer names to activate")}, result="the Sequence of images for the diagrams associated to the given EObject with the given description name.", examples={@Example(expression="ePackage.asImageByRepresentationDescriptionName('class diagram', true, OrderedSet{'Layer 1', 'Layer 2'})", result="Sequence{image1, image2}")})
    public List<MImage> asImageByRepresentationDescriptionName(EObject eObj, String descriptionName, boolean refresh, Set<String> layerNames) throws SizeTooLargeException, IOException {
        ArrayList<MImage> res = new ArrayList<MImage>();
        ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>(SiriusRepresentationUtils.getRepresentationByRepresentationDescriptionName(this.session, eObj, descriptionName));
        for (DRepresentation representation : representations) {
            res.add(this.asImage(representation, refresh, layerNames));
        }
        return res;
    }

    @Documentation(value="Gets the Sequence of images for the diagrams associated to the given EObject with the given description name.", params={@Param(name="eObject", value="Any eObject that is in the session where to search"), @Param(name="representationDescriptionName", value="the name of the searched representation description"), @Param(name="format", value="the image format: BMP, GIF, JPG, JPEG, PNG, SVG"), @Param(name="refresh", value="true to refresh the representation"), @Param(name="layerNames", value="the OrderedSet of layer names to activate")}, result="the Sequence of images for the diagrams associated to the given EObject with the given description name.", examples={@Example(expression="ePackage.asImageByRepresentationDescriptionName('class diagram', 'JPG', true, OrderedSet{'Layer 1', 'Layer 2'})", result="Sequence{image1, image2}")})
    public List<MImage> asImageByRepresentationDescriptionName(EObject eObj, String descriptionName, String format, boolean refresh, Set<String> layerNames) throws SizeTooLargeException, IOException {
        ArrayList<MImage> res = new ArrayList<MImage>();
        ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>(SiriusRepresentationUtils.getRepresentationByRepresentationDescriptionName(this.session, eObj, descriptionName));
        for (DRepresentation representation : representations) {
            res.add(this.asImage(representation, format, refresh, layerNames));
        }
        return res;
    }

    @Documentation(value="Gets the Sequence of images for the diagrams associated to the given EObject with the given description name.", params={@Param(name="eObject", value="Any eObject that is in the session where to search"), @Param(name="representationDescriptionName", value="the name of the searched representation description")}, result="the Sequence of images for the diagrams associated to the given EObject with the given description name.", examples={@Example(expression="ePackage.asImageByRepresentationDescriptionName('class diagram')", result="Sequence{image1, image2}")})
    public List<MImage> asImageByRepresentationDescriptionName(EObject eObj, String descriptionName) throws SizeTooLargeException, IOException {
        return this.asImageByRepresentationDescriptionName(eObj, descriptionName, false);
    }

    @Documentation(value="Gets the Sequence of images for the diagrams associated to the given EObject with the given description name.", params={@Param(name="eObject", value="Any eObject that is in the session where to search"), @Param(name="representationDescriptionName", value="the name of the searched representation description"), @Param(name="refresh", value="true to refresh the representation")}, result="the Sequence of images for the diagrams associated to the given EObject with the given description name.", examples={@Example(expression="ePackage.asImageByRepresentationDescriptionName('class diagram', true)", result="Sequence{image1, image2}")})
    public List<MImage> asImageByRepresentationDescriptionName(EObject eObj, String descriptionName, boolean refresh) throws SizeTooLargeException, IOException {
        ArrayList<MImage> res = new ArrayList<MImage>();
        ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>(SiriusRepresentationUtils.getRepresentationByRepresentationDescriptionName(this.session, eObj, descriptionName));
        for (DRepresentation representation : representations) {
            res.add(this.asImage(representation, refresh));
        }
        return res;
    }

    @Documentation(value="Gets the Sequence of images for the diagrams associated to the given EObject with the given description name.", params={@Param(name="eObject", value="Any eObject that is in the session where to search"), @Param(name="representationDescriptionName", value="the name of the searched representation description"), @Param(name="format", value="the image format: BMP, GIF, JPG, JPEG, PNG, SVG"), @Param(name="refresh", value="true to refresh the representation")}, result="the Sequence of images for the diagrams associated to the given EObject with the given description name.", examples={@Example(expression="ePackage.asImageByRepresentationDescriptionName('class diagram', 'JPG', true)", result="Sequence{image1, image2}")})
    public List<MImage> asImageByRepresentationDescriptionName(EObject eObj, String descriptionName, String format, boolean refresh) throws SizeTooLargeException, IOException {
        ArrayList<MImage> res = new ArrayList<MImage>();
        ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>(SiriusRepresentationUtils.getRepresentationByRepresentationDescriptionName(this.session, eObj, descriptionName));
        for (DRepresentation representation : representations) {
            res.add(this.asImage(representation, format, refresh));
        }
        return res;
    }

    @Documentation(value="Gets the Sequence of tables for the tables associated to the given EObject with the given description name (with header styles).", params={@Param(name="eObject", value="Any eObject that is in the session where to search"), @Param(name="representationDescriptionName", value="the name of the searched representation description (with header styles)")}, result="the Sequence of tables for the tables associated to the given EObject with the given description name (with header styles).", examples={@Example(expression="ePackage.asTableByRepresentationDescriptionName('dependency table')", result="Sequence{table1, table2}")})
    public List<MTable> asTableByRepresentationDescriptionName(EObject eObj, String descriptionName) {
        return this.asTableByRepresentationDescriptionName(eObj, descriptionName, true);
    }

    @Documentation(value="Gets the Sequence of tables for the tables associated to the given EObject with the given description name.", params={@Param(name="eObject", value="Any eObject that is in the session where to search"), @Param(name="representationDescriptionName", value="the name of the searched representation description"), @Param(name="withHeader", value="true to had header styles, false otherwise")}, result="the Sequence of tables for the tables associated to the given EObject with the given description name.", examples={@Example(expression="ePackage.asTableByRepresentationDescriptionName('dependency table', false)", result="Sequence{table1, table2}")})
    public List<MTable> asTableByRepresentationDescriptionName(EObject eObj, String descriptionName, boolean withHeader) {
        ArrayList<MTable> res = new ArrayList<MTable>();
        Collection repDescs = DialectManager.INSTANCE.getRepresentationDescriptors(eObj, this.session);
        Collection selectedViewpoints = this.session.getSelectedViewpoints(false);
        for (DRepresentationDescriptor repDesc : repDescs) {
            Viewpoint vp;
            boolean isDangling = new DRepresentationDescriptorQuery(repDesc).isDangling();
            if (isDangling || !(repDesc.getDescription() instanceof TableDescription) || !descriptionName.equals(repDesc.getDescription().getName()) || !(repDesc.getDescription().eContainer() instanceof Viewpoint) || !selectedViewpoints.contains(vp = (Viewpoint)repDesc.getDescription().eContainer())) continue;
            res.add(this.asTable((DTable)repDesc.getRepresentation(), withHeader));
        }
        return res;
    }

    @Documentation(value="Gets the DRepresentation of the given representation name.", params={@Param(name="representationName", value="the name of the searched representation")}, result="Insert the image of the given representation name", examples={@Example(expression="'MyEPackage class diagram'.asImageByRepresentationName()", result="dRepresentation1")})
    public DRepresentation representationByName(String representationName) {
        DRepresentationDescriptor description = SiriusRepresentationUtils.getAssociatedRepresentationByName(representationName, this.session);
        DRepresentation res = description != null ? description.getRepresentation() : null;
        return res;
    }

    @Documentation(value="Insert the image of the given representation name.", params={@Param(name="representationName", value="the name of the searched representation"), @Param(name="refresh", value="true to refresh the representation"), @Param(name="layerNames", value="the OrderedSet of layer names to activate")}, result="Insert the image of the given representation name", examples={@Example(expression="'MyEPackage class diagram'.asImageByRepresentationName(true, OrderedSet{'Layer 1', 'Layer 2'})", result="insert the image")})
    public MImage asImageByRepresentationName(String representationName, boolean refresh, Set<String> layerNames) throws SizeTooLargeException, IOException {
        DRepresentationDescriptor description = SiriusRepresentationUtils.getAssociatedRepresentationByName(representationName, this.session);
        MImage res = description != null ? this.asImage(description.getRepresentation(), refresh, layerNames) : MImage.EMPTY;
        return res;
    }

    @Documentation(value="Insert the image of the given representation name.", params={@Param(name="representationName", value="the name of the searched representation"), @Param(name="format", value="the image format: BMP, GIF, JPG, JPEG, PNG, SVG"), @Param(name="refresh", value="true to refresh the representation"), @Param(name="layerNames", value="the OrderedSet of layer names to activate")}, result="Insert the image of the given representation name", examples={@Example(expression="'MyEPackage class diagram'.asImageByRepresentationName('JPG, 'true, OrderedSet{'Layer 1', 'Layer 2'})", result="insert the image")})
    public MImage asImageByRepresentationName(String representationName, String format, boolean refresh, Set<String> layerNames) throws SizeTooLargeException, IOException {
        DRepresentationDescriptor description = SiriusRepresentationUtils.getAssociatedRepresentationByName(representationName, this.session);
        MImage res = description != null ? this.asImage(description.getRepresentation(), format, refresh, layerNames) : MImage.EMPTY;
        return res;
    }

    @Documentation(value="Insert the image of the given representation name.", params={@Param(name="representationName", value="the name of the searched representation")}, result="Insert the image of the given representation name", examples={@Example(expression="'MyEPackage class diagram'.asImageByRepresentationName()", result="insert the image")})
    public MImage asImageByRepresentationName(String representationName) throws SizeTooLargeException, IOException {
        return this.asImageByRepresentationName(representationName, false);
    }

    @Documentation(value="Insert the image of the given representation name.", params={@Param(name="representationName", value="the name of the searched representation"), @Param(name="format", value="the image format: BMP, GIF, JPG, JPEG, PNG, SVG")}, result="Insert the image of the given representation name", examples={@Example(expression="'MyEPackage class diagram'.asImageByRepresentationName('JPG')", result="insert the image")})
    public MImage asImageByRepresentationName(String representationName, String format) throws SizeTooLargeException, IOException {
        return this.asImageByRepresentationName(representationName, format, false);
    }

    @Documentation(value="Insert the image of the given representation name.", params={@Param(name="representationName", value="the name of the searched representation"), @Param(name="refresh", value="true to refresh the representation")}, result="Insert the image of the given representation name", examples={@Example(expression="'MyEPackage class diagram'.asImageByRepresentationName(true)", result="insert the image after refreshing the representation")})
    public MImage asImageByRepresentationName(String representationName, boolean refresh) throws SizeTooLargeException, IOException {
        DRepresentationDescriptor descriptor = SiriusRepresentationUtils.getAssociatedRepresentationByName(representationName, this.session);
        MImage res = descriptor != null ? this.asImage(descriptor.getRepresentation(), refresh) : MImage.EMPTY;
        return res;
    }

    @Documentation(value="Insert the image of the given representation name.", params={@Param(name="representationName", value="the name of the searched representation"), @Param(name="format", value="the image format: BMP, GIF, JPG, JPEG, PNG, SVG"), @Param(name="refresh", value="true to refresh the representation")}, result="Insert the image of the given representation name", examples={@Example(expression="'MyEPackage class diagram'.asImageByRepresentationName('JPG', true)", result="insert the image after refreshing the representation")})
    public MImage asImageByRepresentationName(String representationName, String format, boolean refresh) throws SizeTooLargeException, IOException {
        DRepresentationDescriptor descriptor = SiriusRepresentationUtils.getAssociatedRepresentationByName(representationName, this.session);
        MImage res = descriptor != null ? this.asImage(descriptor.getRepresentation(), format, refresh) : MImage.EMPTY;
        return res;
    }

    @Documentation(value="Insert the table of the given representation name (with header styles).", params={@Param(name="representationName", value="the name of the searched representation (with header styles)")}, result="Insert the table of the given representation name (with header styles)", examples={@Example(expression="'MyEPackage class diagram'.asTableByRepresentationName()", result="insert the table")})
    public MTable asTableByRepresentationName(String representationName) {
        return this.asTableByRepresentationName(representationName, true);
    }

    @Documentation(value="Insert the table of the given representation name.", params={@Param(name="representationName", value="the name of the searched representation"), @Param(name="withHeader", value="true to add header styles, false otherwise")}, result="Insert the table of the given representation name", examples={@Example(expression="'MyEPackage class diagram'.asTableByRepresentationName(false)", result="insert the table")})
    public MTable asTableByRepresentationName(String representationName, boolean withHeader) {
        DRepresentationDescriptor description = SiriusRepresentationUtils.getAssociatedRepresentationByName(representationName, this.session);
        MTable res = description != null && description.getRepresentation() instanceof DTable ? this.asTable((DTable)description.getRepresentation(), withHeader) : MTable.EMPTY;
        return res;
    }

    public void clean() {
        for (File tmpFile : this.tmpFiles) {
            tmpFile.delete();
        }
        this.registry.clean(this);
        if (this.shouldCloseSession) {
            this.session.close((IProgressMonitor)new NullProgressMonitor());
        }
        this.tmpFiles.clear();
        this.adapterFactory.dispose();
    }

    @Documentation(value="Gets the DRepresentationDescriptor of the given DRepresentation.", params={@Param(name="representation", value="the representation")}, result="Gets the DRepresentationDescriptor of the given DRepresentation", examples={@Example(expression="myDiagram.getDescriptor().name", result="the name of the DRepresentationDescriptor")})
    public DRepresentationDescriptor getDescriptor(DRepresentation representation) {
        return new DRepresentationQuery(representation).getRepresentationDescriptor();
    }

    @Documentation(value="List all available DRepresentation in a table.", params={@Param(name="obj", value="Any object")}, result="List all available DRepresentation in a table", examples={@Example(expression="''.availableRepresentations()", result="the table listing available DRepresentation")})
    public MTable availableRepresentations(Object obj) {
        MTableImpl res = new MTableImpl();
        MTableImpl.MRowImpl titleRow = new MTableImpl.MRowImpl();
        res.getRows().add(titleRow);
        titleRow.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl("Representation Name", null), null));
        titleRow.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl("Description Name", null), null));
        titleRow.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl("Type", null), null));
        titleRow.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl("Root EObject Type", null), null));
        for (DView view : this.session.getOwnedViews()) {
            for (DRepresentationDescriptor descriptor : view.getOwnedRepresentationDescriptors()) {
                MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
                res.getRows().add(row);
                RepresentationDescription description = descriptor.getDescription();
                row.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl(descriptor.getName(), null), null));
                row.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl(description.getName(), null), null));
                if (description instanceof DiagramDescription) {
                    row.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl("Diagram", null), null));
                } else if (description instanceof TableDescription) {
                    row.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl("Table", null), null));
                } else {
                    row.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl("", null), null));
                }
                row.getCells().add(new MTableImpl.MCellImpl((MElement)new MTextImpl(String.valueOf(descriptor.getTarget().eClass().getEPackage().getName()) + "::" + descriptor.getTarget().eClass().getName(), null), null));
            }
        }
        return res;
    }

    @Documentation(value="Transforms the serialized text to a text that will be used for html page. This method only changes the image paths. It also ensures that the image is available at the modified location", params={@Param(name="htmlString", value="The HTML text"), @Param(name="context", value="An EObject context")}, result="Transformed HTML text")
    public String computeAndConvertPathsToHtmlFromOriginal(String htmlString, EObject context) {
        return ImageManagerProvider.getImageManager().computeAndConvertPathsToHtmlFromOriginal(context, htmlString);
    }

    private class CleaningJobRegistry {
        private Set<Runnable> jobs = new LinkedHashSet<Runnable>();

        private CleaningJobRegistry() {
        }

        public void registerJob(Runnable job) {
            this.jobs.add(job);
        }

        public void clean(Object key) {
            for (Runnable job : this.jobs) {
                try {
                    job.run();
                }
                finally {
                    this.jobs.clear();
                }
            }
        }
    }
}

