/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.sirius.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DRepresentationDescriptorQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.GMFDiagramUpdater;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.obeonetwork.m2doc.sirius.commands.PrepareDiagramCommand;

public final class SiriusRepresentationUtils {
    private static final String GET_ALL_LAYERS = "getAllLayers";
    private static final String SIRIUS_COMPATIBILITY_FAILED = "Sirius compatibility failed.";

    private SiriusRepresentationUtils() {
    }

    public static DRepresentationDescriptor getAssociatedRepresentationByName(String representationName, Session session) {
        if (representationName != null) {
            Collection representations = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
            Collection selectedViewpoints = session.getSelectedViewpoints(false);
            for (DRepresentationDescriptor representation : representations) {
                Viewpoint vp;
                boolean isDangling = new DRepresentationDescriptorQuery(representation).isDangling();
                if (isDangling || representation == null || !representationName.equals(representation.getName()) || !(representation.getDescription().eContainer() instanceof Viewpoint) || !selectedViewpoints.contains(vp = (Viewpoint)representation.getDescription().eContainer())) continue;
                return representation;
            }
        }
        return null;
    }

    public static RepresentationDescription findDescription(Session session, String descriptionName) {
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (Viewpoint viewpoint : selectedViewpoints) {
            EList ownedRepresentations = viewpoint.getOwnedRepresentations();
            for (RepresentationDescription representationDescription : ownedRepresentations) {
                if (!descriptionName.equals(representationDescription.getName())) continue;
                return representationDescription;
            }
        }
        return null;
    }

    public static DDiagram getDDiagramToExport(DDiagram diagram, boolean refreshRepresentations, List<Layer> layers, Session session, boolean isDiagramOpened) {
        if (layers.isEmpty() && !refreshRepresentations) {
            return diagram;
        }
        SiriusRepresentationUtils.siriusDiagramSessionEventBrokerGetInstance(session);
        GMFDiagramUpdater gmfDiagramUpdater = null;
        if (!isDiagramOpened) {
            gmfDiagramUpdater = new GMFDiagramUpdater(session, diagram);
        }
        PrepareDiagramCommand exportRepresentationCommand = new PrepareDiagramCommand(session.getTransactionalEditingDomain(), layers, diagram, session, isDiagramOpened, refreshRepresentations);
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)exportRepresentationCommand);
        if (gmfDiagramUpdater != null) {
            gmfDiagramUpdater.dispose();
        }
        return exportRepresentationCommand.getExportedDiagram();
    }

    private static void siriusDiagramSessionEventBrokerGetInstance(Session session) {
        Class<?> cls;
        try {
            cls = SiriusRepresentationUtils.class.getClassLoader().loadClass("org.eclipse.sirius.diagram.ui.internal.refresh.SiriusDiagramSessionEventBroker");
        }
        catch (ClassNotFoundException e) {
            try {
                cls = SiriusRepresentationUtils.class.getClassLoader().loadClass("org.eclipse.sirius.diagram.business.internal.refresh.SiriusDiagramSessionEventBroker");
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalStateException("Sirius compatibility failed: can't find SiriusDiagramSessionEventBroker.");
            }
        }
        try {
            Method method = cls.getMethod("getInstance", Session.class);
            method.invoke(null, session);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(SIRIUS_COMPATIBILITY_FAILED, e);
        }
    }

    public static DialectEditor getEditor(Session session, DRepresentation representation) {
        IEditingSession ui = SessionUIManager.INSTANCE.getUISession(session);
        if (ui != null) {
            return ui.getEditor(representation);
        }
        return null;
    }

    public static List<DRepresentation> getRepresentationByRepresentationDescriptionName(Session session, EObject eObj, String descriptionName) {
        ArrayList<DRepresentation> res = new ArrayList<DRepresentation>();
        Collection repDescs = DialectManager.INSTANCE.getRepresentationDescriptors(eObj, session);
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (DRepresentationDescriptor repDesc : repDescs) {
            Viewpoint vp;
            boolean isDangling = new DRepresentationDescriptorQuery(repDesc).isDangling();
            if (isDangling || !(repDesc.getDescription() instanceof DiagramDescription) || !descriptionName.equals(repDesc.getDescription().getName()) || !(repDesc.getDescription().eContainer() instanceof Viewpoint) || !selectedViewpoints.contains(vp = (Viewpoint)repDesc.getDescription().eContainer())) continue;
            res.add(repDesc.getRepresentation());
        }
        return res;
    }

    public static List<Layer> getAllLayer(DiagramDescription description) {
        ArrayList<Layer> res = new ArrayList<Layer>();
        try {
            Method method = DiagramDescription.class.getMethod(GET_ALL_LAYERS, new Class[0]);
            res.addAll((List)method.invoke((Object)description, new Object[0]));
        }
        catch (NoSuchMethodException | SecurityException e) {
            try {
                Method method = LayerHelper.class.getMethod(GET_ALL_LAYERS, DiagramDescription.class);
                res.addAll((List)method.invoke(null, description));
            }
            catch (NoSuchMethodException | SecurityException e1) {
                try {
                    Class<?> cls = SiriusRepresentationUtils.class.getClassLoader().loadClass("org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager");
                    Object diagramComponentizationManager = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Method method = cls.getMethod(GET_ALL_LAYERS, Collection.class, DiagramDescription.class);
                    Collection selectedViewpoints = new EObjectQuery((EObject)description).getSession().getSelectedViewpoints(false);
                    res.addAll((List)method.invoke(diagramComponentizationManager, selectedViewpoints, description));
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                    throw new IllegalStateException(SIRIUS_COMPATIBILITY_FAILED, e2);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
                throw new IllegalStateException(SIRIUS_COMPATIBILITY_FAILED, e1);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(SIRIUS_COMPATIBILITY_FAILED, e);
        }
        return res;
    }
}

