/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.sirius.services.configurator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.session.SessionTransientAttachment;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.obeonetwork.m2doc.services.configurator.IServicesConfigurator;
import org.obeonetwork.m2doc.sirius.services.M2DocSiriusServices;

public class SiriusServiceConfigurator
implements IServicesConfigurator {
    public static final List<String> OPTIONS = SiriusServiceConfigurator.initOptions();
    private final Map<IReadOnlyQueryEnvironment, M2DocSiriusServices> services = new HashMap<IReadOnlyQueryEnvironment, M2DocSiriusServices>();
    private final Map<Object, Session> sessions = new HashMap<Object, Session>();
    private final Set<Session> sessionToClose = new HashSet<Session>();
    private final Map<Session, SessionTransientAttachment> transientAttachments = new HashMap<Session, SessionTransientAttachment>();

    private static List<String> initOptions() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("SiriusSession");
        res.add("SiriusForceRefresh");
        res.add("SiriusScalingPolicy");
        res.add("SiriusScaleLevel");
        return res;
    }

    public Map<String, String> getInitializedOptions(Map<String, String> options) {
        String genConfURIStr;
        String sessionURIStr;
        HashMap<String, String> res = new HashMap<String, String>();
        if (!options.containsKey("SiriusSession") && (sessionURIStr = this.getSessionString(genConfURIStr = options.get("GenconfURI"))) != null) {
            res.put("SiriusSession", sessionURIStr);
        }
        return res;
    }

    public Map<String, String> getInitializedOptions(Map<String, String> options, EObject eObj) {
        Session session;
        HashMap<String, String> res = new HashMap<String, String>();
        if (!options.containsKey("SiriusSession") && (session = new EObjectQuery(eObj).getSession()) != null) {
            String genConfURIStr = options.get("GenconfURI");
            URI genConfURI = URI.createURI((String)genConfURIStr, (boolean)true);
            URI sessionURI = session.getSessionResource().getURI();
            String sessionURIStr = URI.decode((String)sessionURI.deresolve(genConfURI, false, true, true).toString());
            res.put("SiriusSession", sessionURIStr);
        }
        return res;
    }

    protected String getSessionString(String genConfURIStr) {
        URI genConfURI;
        String res = genConfURIStr != null ? ((genConfURI = URI.createURI((String)genConfURIStr, (boolean)true)).isPlatformResource() ? this.getSessionFromPlatformResource(genConfURI) : null) : null;
        return res;
    }

    private String getSessionFromPlatformResource(URI genconfPlatformResourceURI) {
        String res;
        String filePath = genconfPlatformResourceURI.toPlatformString(true);
        IFile genconfFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        IProject project = genconfFile.getProject();
        ModelingProject modelingProject = this.getModelingProject(project);
        if (modelingProject != null) {
            Session session = modelingProject.getSession();
            if (session != null) {
                URI sessionURI = session.getSessionResource().getURI();
                res = URI.decode((String)sessionURI.deresolve(genconfPlatformResourceURI, false, true, true).toString());
            } else {
                res = this.getSessionFile(genconfPlatformResourceURI, (IContainer)project);
            }
        } else {
            res = null;
        }
        return res;
    }

    private String getSessionFile(URI genconfPlatformResourceURI, IContainer container) {
        String res = null;
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Session session;
                IResource member = iResourceArray[n2];
                if (member instanceof IContainer) {
                    res = this.getSessionFile(genconfPlatformResourceURI, (IContainer)member);
                    if (res != null) {
                        break;
                    }
                } else if (member instanceof IFile && "aird".equals(member.getFileExtension()) && (session = SessionManager.INSTANCE.getSession(URI.createPlatformResourceURI((String)member.getFullPath().toString(), (boolean)true), (IProgressMonitor)new NullProgressMonitor())) != null) {
                    URI sessionURI = session.getSessionResource().getURI();
                    res = URI.decode((String)sessionURI.deresolve(genconfPlatformResourceURI, false, true, true).toString());
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return res;
    }

    private ModelingProject getModelingProject(IProject project) {
        ModelingProject modelingProject = null;
        try {
            String[] stringArray = project.getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                IProjectNature nature = project.getNature(natureId);
                if (nature instanceof ModelingProject) {
                    modelingProject = (ModelingProject)nature;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return modelingProject;
    }

    public Set<IService> getServices(IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels, Map<String, String> options) {
        LinkedHashSet<IService> res = new LinkedHashSet<IService>();
        String sessionURIStr = options.get("SiriusSession");
        if (sessionURIStr != null) {
            URI sessionURI = URI.createURI((String)sessionURIStr, (boolean)false);
            String genconfURIStr = options.get("GenconfURI");
            if (genconfURIStr != null) {
                sessionURI = sessionURI.resolve(URI.createURI((String)genconfURIStr));
            }
            if (URIConverter.INSTANCE.exists(sessionURI, Collections.emptyMap())) {
                Session session = SessionManager.INSTANCE.getSession(sessionURI, (IProgressMonitor)new NullProgressMonitor());
                boolean forceRefresh = Boolean.valueOf(options.get("SiriusForceRefresh"));
                ExportFormat.ScalingPolicy scalingPolicy = options.containsKey("SiriusScalingPolicy") ? ExportFormat.ScalingPolicy.valueOf((String)options.get("SiriusScalingPolicy")) : ExportFormat.ScalingPolicy.WORKSPACE_DEFAULT;
                Integer scaleLevel = options.containsKey("SiriusScaleLevel") ? Integer.valueOf(options.get("SiriusScaleLevel")) : null;
                M2DocSiriusServices serviceInstance = new M2DocSiriusServices(session, forceRefresh, scalingPolicy, scaleLevel);
                res.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, (Object)serviceInstance));
                this.services.put(queryEnvironment, serviceInstance);
            }
        }
        return res;
    }

    public void startGeneration(IReadOnlyQueryEnvironment queryEnvironment, XWPFDocument destinationDocument) {
    }

    public void cleanServices(IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels) {
        M2DocSiriusServices serviceInstance = this.services.remove(queryEnvironment);
        if (serviceInstance != null) {
            serviceInstance.clean();
        }
    }

    public List<String> getOptions() {
        return OPTIONS;
    }

    public Map<String, List<Diagnostic>> validate(IReadOnlyQueryEnvironment queryEnvironment, Map<String, String> options) {
        String scalePolicyStr;
        String forceRefreshStr;
        ArrayList<BasicDiagnostic> diagnostics;
        HashMap<String, List<Diagnostic>> res = new HashMap<String, List<Diagnostic>>();
        String sessionURIStr = options.get("SiriusSession");
        if (sessionURIStr != null) {
            URI sessionURI = URI.createURI((String)sessionURIStr, (boolean)false);
            String genconfURIStr = options.get("GenconfURI");
            if (genconfURIStr != null) {
                sessionURI = sessionURI.resolve(URI.createURI((String)genconfURIStr, (boolean)false));
            }
            if (!URIConverter.INSTANCE.exists(sessionURI, Collections.emptyMap())) {
                diagnostics = new ArrayList<BasicDiagnostic>();
                res.put("SiriusSession", diagnostics);
                diagnostics.add(new BasicDiagnostic(4, "org.obeonetwork.m2doc.sirius", 0, "The Sirius session doesn't exist: " + sessionURI.toString(), new Object[]{sessionURI}));
            }
        }
        if ((forceRefreshStr = options.get("SiriusForceRefresh")) != null) {
            ArrayList<BasicDiagnostic> diagnostics2 = new ArrayList<BasicDiagnostic>();
            res.put("SiriusForceRefresh", diagnostics2);
            if (!Boolean.TRUE.toString().equalsIgnoreCase(forceRefreshStr) && !Boolean.FALSE.toString().equalsIgnoreCase(forceRefreshStr)) {
                diagnostics2.add(new BasicDiagnostic(4, "org.obeonetwork.m2doc.sirius", 0, "The Sirius force refresh must be a boolean true or false: " + forceRefreshStr, new Object[]{forceRefreshStr}));
            }
        }
        if (!this.isValidScalePolicy(scalePolicyStr = options.get("SiriusScalingPolicy"))) {
            diagnostics = new ArrayList();
            res.put("SiriusScalingPolicy", diagnostics);
            diagnostics.add(new BasicDiagnostic(4, "org.obeonetwork.m2doc.sirius", 0, "The Sirius scale policy must be one of " + Arrays.toString(ExportFormat.ScalingPolicy.values()) + ": " + scalePolicyStr, new Object[]{scalePolicyStr}));
        }
        String scaleLevelStr = options.get("SiriusScaleLevel");
        try {
            Integer.valueOf(scaleLevelStr);
        }
        catch (NumberFormatException e) {
            ArrayList<BasicDiagnostic> diagnostics3 = new ArrayList<BasicDiagnostic>();
            res.put("SiriusScaleLevel", diagnostics3);
            diagnostics3.add(new BasicDiagnostic(4, "org.obeonetwork.m2doc.sirius", 0, "The Sirius scale level must be an integer: " + scalePolicyStr, new Object[]{scaleLevelStr}));
        }
        return res;
    }

    private boolean isValidScalePolicy(String scalePolicyStr) {
        boolean res = false;
        ExportFormat.ScalingPolicy[] scalingPolicyArray = ExportFormat.ScalingPolicy.values();
        int n = scalingPolicyArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportFormat.ScalingPolicy policy = scalingPolicyArray[n2];
            if (policy.name().equals(scalePolicyStr)) {
                res = true;
                break;
            }
            ++n2;
        }
        return res;
    }

    public ResourceSet createResourceSetForModels(Object context, Map<String, String> options) {
        ResourceSet created = null;
        String sessionURIStr = options.get("SiriusSession");
        if (sessionURIStr != null && !sessionURIStr.isEmpty()) {
            URI sessionURI = URI.createURI((String)sessionURIStr, (boolean)false);
            String genconfURIStr = options.get("GenconfURI");
            if (genconfURIStr != null) {
                sessionURI = sessionURI.resolve(URI.createURI((String)genconfURIStr));
            }
            if (URIConverter.INSTANCE.exists(sessionURI, Collections.emptyMap())) {
                try {
                    Session session = SessionManager.INSTANCE.getSession(sessionURI, (IProgressMonitor)new NullProgressMonitor());
                    this.sessions.put(context, session);
                    if (!session.isOpen()) {
                        session.open((IProgressMonitor)new NullProgressMonitor());
                        this.sessionToClose.add(session);
                    }
                    created = session.getTransactionalEditingDomain().getResourceSet();
                    SessionTransientAttachment transiantAttachment = new SessionTransientAttachment(session);
                    created.eAdapters().add((Object)transiantAttachment);
                    this.transientAttachments.put(session, transiantAttachment);
                }
                catch (Exception e) {
                    if (PlatformUI.isWorkbenchRunning()) {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to open Sirius Session", (String)("Check the SiriusSession option or try to open the session manually by double clicking the .aird file:\n" + e.getMessage()));
                    }
                }
            } else {
                throw new IllegalArgumentException("The Sirius session doesn't exist: " + sessionURI);
            }
        }
        return created;
    }

    public void cleanResourceSetForModels(Object context) {
        Session session = this.sessions.remove(context);
        if (session != null) {
            if (session.isOpen()) {
                session.getTransactionalEditingDomain().getResourceSet().eAdapters().remove((Object)this.transientAttachments.remove(session));
            }
            if (this.sessionToClose.remove(session)) {
                session.close((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

