/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.wikitext.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.mylyn.wikitext.asciidoc.AsciiDocLanguage;
import org.eclipse.mylyn.wikitext.confluence.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.textile.TextileLanguage;
import org.eclipse.mylyn.wikitext.tracwiki.TracWikiLanguage;
import org.eclipse.mylyn.wikitext.twiki.TWikiLanguage;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.wikitext.services.M2DocMElementBuilder;

@ServiceProvider(value="Services available for WikiText insertion.")
public class M2DocWikiTextServices {
    private final URIConverter uriConverter;
    private final URI templateURI;
    private M2DocMElementBuilder builder;
    private final MarkupParser asciiDocParser = new MarkupParser((MarkupLanguage)new AsciiDocLanguage());
    private final MarkupParser confluenceParser = new MarkupParser((MarkupLanguage)new ConfluenceLanguage());
    private final MarkupParser markdownParser = new MarkupParser((MarkupLanguage)new MarkdownLanguage());
    private final MarkupParser mediaWikiParser = new MarkupParser((MarkupLanguage)new MediaWikiLanguage());
    private final MarkupParser textileParser = new MarkupParser((MarkupLanguage)new TextileLanguage());
    private final MarkupParser tracWikiParser = new MarkupParser((MarkupLanguage)new TracWikiLanguage());
    private final MarkupParser tWikiParser = new MarkupParser((MarkupLanguage)new TWikiLanguage());

    public M2DocWikiTextServices(URIConverter uriConverter, URI templateURI) {
        this.uriConverter = uriConverter;
        this.templateURI = templateURI;
    }

    protected List<MElement> parse(MarkupParser parser, URI baseURI, String markupContents) {
        this.builder.setBaseURI(baseURI);
        parser.parse(markupContents);
        return this.builder.getResult();
    }

    protected List<MElement> parse(MarkupParser parser, URI baseURI, URI markupURI) throws IOException {
        this.builder.setBaseURI(baseURI);
        URI uri = markupURI.resolve(this.templateURI);
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream input = this.uriConverter.createInputStream(uri);){
            String markupContents = new String(IOUtils.toByteArray((InputStream)input));
            parser.parse(markupContents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.builder.getResult();
    }

    public void setDestinationDocument(XWPFDocument destinationDocument) {
        this.builder = new M2DocMElementBuilder(this.uriConverter, destinationDocument);
        this.asciiDocParser.setBuilder((DocumentBuilder)this.builder);
        this.confluenceParser.setBuilder((DocumentBuilder)this.builder);
        this.markdownParser.setBuilder((DocumentBuilder)this.builder);
        this.mediaWikiParser.setBuilder((DocumentBuilder)this.builder);
        this.textileParser.setBuilder((DocumentBuilder)this.builder);
        this.tracWikiParser.setBuilder((DocumentBuilder)this.builder);
        this.tWikiParser.setBuilder((DocumentBuilder)this.builder);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"http://asciidoc.org/\">AsciiDoc</a> String.", params={@Param(name="markupContents", value="The markup contents.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'The First Chapter\\n-----------------'.fromAsciiDocString()", result="The Sequence of MElement corresponding to the given <a href=\"http://asciidoc.org/\">AsciiDoc</a> String.")})
    public List<MElement> fromAsciiDocString(String markupContent) {
        return this.parse(this.asciiDocParser, this.templateURI, markupContent);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"http://asciidoc.org/\">AsciiDoc</a> String.", params={@Param(name="markupContents", value="The markup contents."), @Param(name="baseURI", value="The base URI to use for link and images resolving.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'The First Chapter\\n-----------------'.fromAsciiDocString('https://www.m2doc.org/')", result="The Sequence of MElement corresponding to the given <a href=\"http://asciidoc.org/\">AsciiDoc</a> String.")})
    public List<MElement> fromAsciiDocString(String markupContents, String baseURI) {
        return this.parse(this.asciiDocParser, URI.createURI((String)baseURI, (boolean)false), markupContents);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"http://asciidoc.org/\">AsciiDoc</a> contents at the given URI.", params={@Param(name="srcURI", value="The markup contents URI.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'contents.txt'.fromAsciiDocString()", result="The Sequence of MElement corresponding to the given <a href=\"http://asciidoc.org/\">AsciiDoc</a> contents at the given URI.")})
    public List<MElement> fromAsciiDocURI(String srcURI) throws IOException {
        return this.parse(this.asciiDocParser, this.templateURI, URI.createURI((String)srcURI, (boolean)false));
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://confluence.atlassian.com/doc/confluence-wiki-markup-251003035.html\">Confluence</a> String.", params={@Param(name="markupContents", value="The markup contents.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'h1. The First Chapter'.fromConfluenceString()", result="The Sequence of MElement corresponding to the given <a href=\"https://confluence.atlassian.com/doc/confluence-wiki-markup-251003035.html\">Confluence</a> String.")})
    public List<MElement> fromConfluenceString(String markupContent) {
        return this.parse(this.confluenceParser, this.templateURI, markupContent);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://confluence.atlassian.com/doc/confluence-wiki-markup-251003035.html\">Confluence</a> String.", params={@Param(name="markupContents", value="The markup contents."), @Param(name="baseURI", value="The base URI to use for link and images resolving.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'h1. The First Chapter'.fromConfluenceString('https://www.m2doc.org/')", result="The Sequence of MElement corresponding to the given <a href=\"https://confluence.atlassian.com/doc/confluence-wiki-markup-251003035.html\">Confluence</a> String.")})
    public List<MElement> fromConfluenceString(String markupContents, String baseURI) {
        return this.parse(this.confluenceParser, URI.createURI((String)baseURI, (boolean)false), markupContents);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://confluence.atlassian.com/doc/confluence-wiki-markup-251003035.html\">Confluence</a> contents at the given URI.", params={@Param(name="srcURI", value="The markup contents URI.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'contents.txt'.fromConfluenceString()", result="The Sequence of MElement corresponding to the given <a href=\"https://confluence.atlassian.com/doc/confluence-wiki-markup-251003035.html\">Confluence</a> contents at the given URI.")})
    public List<MElement> fromConfluenceURI(String srcURI) throws IOException {
        return this.parse(this.confluenceParser, this.templateURI, URI.createURI((String)srcURI, (boolean)false));
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://en.wikipedia.org/wiki/Markdown\">Markdown</a> String.", params={@Param(name="markupContents", value="The markup contents.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'The First Chapter\\n================='.fromMarkdownString()", result="The Sequence of MElement corresponding to the given <a href=\"https://en.wikipedia.org/wiki/Markdown\">Markdown</a> String.")})
    public List<MElement> fromMarkdownString(String markupContent) {
        return this.parse(this.markdownParser, this.templateURI, markupContent);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://en.wikipedia.org/wiki/Markdown\">Markdown</a> String.", params={@Param(name="markupContents", value="The markup contents."), @Param(name="baseURI", value="The base URI to use for link and images resolving.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'The First Chapter\\n================='.fromMarkdownString('https://www.m2doc.org/')", result="The Sequence of MElement corresponding to the given <a href=\"https://en.wikipedia.org/wiki/Markdown\">Markdown</a> String.")})
    public List<MElement> fromMarkdownString(String markupContents, String baseURI) {
        return this.parse(this.markdownParser, URI.createURI((String)baseURI, (boolean)false), markupContents);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://en.wikipedia.org/wiki/Markdown\">Markdown</a> contents at the given URI.", params={@Param(name="srcURI", value="The markup contents URI.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'contents.txt'.fromMarkdownString()", result="The Sequence of MElement corresponding to the given <a href=\"https://en.wikipedia.org/wiki/Markdown\">Markdown</a> contents at the given URI.")})
    public List<MElement> fromMarkdownURI(String srcURI) throws IOException {
        return this.parse(this.markdownParser, this.templateURI, URI.createURI((String)srcURI, (boolean)false));
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://www.mediawiki.org/wiki/Help:Formatting\">MediaWiki</a> String.", params={@Param(name="markupContents", value="The markup contents.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'== The First Chapter =='.fromMediaWikiString()", result="The Sequence of MElement corresponding to the given <a href=\"https://www.mediawiki.org/wiki/Help:Formatting\">MediaWiki</a> String.")})
    public List<MElement> fromMediaWikiString(String markupContent) {
        return this.parse(this.mediaWikiParser, this.templateURI, markupContent);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://www.mediawiki.org/wiki/Help:Formatting\">MediaWiki</a> String.", params={@Param(name="markupContents", value="The markup contents."), @Param(name="baseURI", value="The base URI to use for link and images resolving.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'== The First Chapter =='.fromMediaWikiString('https://www.m2doc.org/')", result="The Sequence of MElement corresponding to the given <a href=\"https://www.mediawiki.org/wiki/Help:Formatting\">MediaWiki</a> String.")})
    public List<MElement> fromMediaWikiString(String markupContents, String baseURI) {
        return this.parse(this.mediaWikiParser, URI.createURI((String)baseURI, (boolean)false), markupContents);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://www.mediawiki.org/wiki/Help:Formatting\">MediaWiki</a> contents at the given URI.", params={@Param(name="srcURI", value="The markup contents URI.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'contents.txt'.fromMediaWikiString()", result="The Sequence of MElement corresponding to the given <a href=\"https://www.mediawiki.org/wiki/Help:Formatting\">MediaWiki</a> contents at the given URI.")})
    public List<MElement> fromMediaWikiURI(String srcURI) throws IOException {
        return this.parse(this.mediaWikiParser, this.templateURI, URI.createURI((String)srcURI, (boolean)false));
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://textile-lang.com/\">Textile</a> String.", params={@Param(name="markupContents", value="The markup contents.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'h1. The First Chapter'.fromTextileString()", result="The Sequence of MElement corresponding to the given <a href=\"https://textile-lang.com/\">Textile</a> String.")})
    public List<MElement> fromTextileString(String markupContent) {
        return this.parse(this.textileParser, this.templateURI, markupContent);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://textile-lang.com/\">Textile</a> String.", params={@Param(name="markupContents", value="The markup contents."), @Param(name="baseURI", value="The base URI to use for link and images resolving.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'h1. The First Chapter'.fromTextileString('https://www.m2doc.org/')", result="The Sequence of MElement corresponding to the given <a href=\"https://textile-lang.com/\">Textile</a> String.")})
    public List<MElement> fromTextileString(String markupContents, String baseURI) {
        return this.parse(this.textileParser, URI.createURI((String)baseURI, (boolean)false), markupContents);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://textile-lang.com/\">Textile</a> contents at the given URI.", params={@Param(name="srcURI", value="The markup contents URI.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'contents.txt'.fromTextileString()", result="The Sequence of MElement corresponding to the given <a href=\"https://textile-lang.com/\">Textile</a> contents at the given URI.")})
    public List<MElement> fromTextileURI(String srcURI) throws IOException {
        return this.parse(this.textileParser, this.templateURI, URI.createURI((String)srcURI, (boolean)false));
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://trac.edgewall.org/wiki/WikiFormatting/\">TracWiki</a> String.", params={@Param(name="markupContents", value="The markup contents.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'= The First Chapter ='.fromTracWikiString()", result="The Sequence of MElement corresponding to the given <a href=\"https://trac.edgewall.org/wiki/WikiFormatting/\">TracWiki</a> String.")})
    public List<MElement> fromTracWikiString(String markupContent) {
        return this.parse(this.tracWikiParser, this.templateURI, markupContent);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://trac.edgewall.org/wiki/WikiFormatting/\">TracWiki</a> String.", params={@Param(name="markupContents", value="The markup contents."), @Param(name="baseURI", value="The base URI to use for link and images resolving.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'= The First Chapter ='.fromTracWikiString('https://www.m2doc.org/')", result="The Sequence of MElement corresponding to the given <a href=\"https://trac.edgewall.org/wiki/WikiFormatting/\">TracWiki</a> String.")})
    public List<MElement> fromTracWikiString(String markupContents, String baseURI) {
        return this.parse(this.tracWikiParser, URI.createURI((String)baseURI, (boolean)false), markupContents);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://trac.edgewall.org/wiki/WikiFormatting/\">TracWiki</a> contents at the given URI.", params={@Param(name="srcURI", value="The markup contents URI.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'contents.txt'.fromTracWikiString()", result="The Sequence of MElement corresponding to the given <a href=\"https://trac.edgewall.org/wiki/WikiFormatting/\">TracWiki</a> contents at the given URI.")})
    public List<MElement> fromTracWikiURI(String srcURI) throws IOException {
        return this.parse(this.tracWikiParser, this.templateURI, URI.createURI((String)srcURI, (boolean)false));
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://twiki.org/cgi-bin/view/TWiki/TWikiDocumentation#TWiki%20Text%20Formatting/\">TWiki</a> String.", params={@Param(name="markupContents", value="The markup contents.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'---+ The First Chapter'.fromTWikiString()", result="The Sequence of MElement corresponding to the given <a href=\"https://twiki.org/cgi-bin/view/TWiki/TWikiDocumentation#TWiki%20Text%20Formatting/\">TWiki</a> String.")})
    public List<MElement> fromTWikiString(String markupContent) {
        return this.parse(this.tWikiParser, this.templateURI, markupContent);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://twiki.org/cgi-bin/view/TWiki/TWikiDocumentation#TWiki%20Text%20Formatting/\">TWiki</a> String.", params={@Param(name="markupContents", value="The markup contents."), @Param(name="baseURI", value="The base URI to use for link and images resolving.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'---+ The First Chapter'.fromTWikiString('https://www.m2doc.org/')", result="The Sequence of MElement corresponding to the given <a href=\"https://twiki.org/cgi-bin/view/TWiki/TWikiDocumentation#TWiki%20Text%20Formatting/\">TWiki</a> String.")})
    public List<MElement> fromTWikiString(String markupContents, String baseURI) {
        return this.parse(this.tWikiParser, URI.createURI((String)baseURI, (boolean)false), markupContents);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given <a href=\"https://twiki.org/cgi-bin/view/TWiki/TWikiDocumentation#TWiki%20Text%20Formatting/\">TWiki</a> contents at the given URI.", params={@Param(name="srcURI", value="The markup contents URI.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'contents.txt'.fromTWikiString()", result="The Sequence of MElement corresponding to the given <a href=\"https://twiki.org/cgi-bin/view/TWiki/TWikiDocumentation#TWiki%20Text%20Formatting/\">TWiki</a> contents at the given URI.")})
    public List<MElement> fromTWikiURI(String srcURI) throws IOException {
        return this.parse(this.tWikiParser, this.templateURI, URI.createURI((String)srcURI, (boolean)false));
    }
}

