/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.generator.RawCopier;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.UserContent;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.obeonetwork.m2doc.util.MemoryURIHandler;

public class UserContentManager {
    public static final String USERDOC_COPY_ERROR = "userdoc copy error : ";
    private static final int BUFFER_SIZE = 8192;
    private final DateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private URI memoryCopy;
    private Map<String, List<UserContent>> mapIdUserContent;
    private final URI sourceURI;
    private final URI destinationURI;
    private final URIConverter uriConverter;
    private final MemoryURIHandler uriHandler = new MemoryURIHandler();
    private DocumentTemplate userDocDocument;
    private boolean copyToLostDocument;

    public UserContentManager(URIConverter uriConverter, URI sourceURI, URI destinationURI) {
        this.uriConverter = uriConverter;
        this.sourceURI = sourceURI;
        this.destinationURI = destinationURI;
        if (uriConverter != null && destinationURI != null && uriConverter.exists(destinationURI, Collections.EMPTY_MAP)) {
            uriConverter.getURIHandlers().add(0, (Object)this.uriHandler);
            this.memoryCopy = this.memoryCopy(destinationURI);
        } else {
            this.memoryCopy = null;
        }
    }

    private void launchParsing() {
        IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.mapIdUserContent = new HashMap<String, List<UserContent>>();
        if (this.memoryCopy != null) {
            try {
                try {
                    this.userDocDocument = M2DocUtils.parseUserContent(this.uriConverter, this.memoryCopy, queryEnvironment);
                    this.copyToLostDocument = this.hasError(this.userDocDocument);
                    TreeIterator iter = this.userDocDocument.eAllContents();
                    while (iter.hasNext()) {
                        EObject eObject = (EObject)iter.next();
                        if (!(eObject instanceof UserContent)) continue;
                        UserContent userContent = (UserContent)eObject;
                        this.storeUserContent(this.mapIdUserContent, userContent);
                    }
                }
                catch (Exception exception) {
                    this.uriConverter.getURIHandlers().remove((Object)this.uriHandler);
                    this.uriHandler.clear();
                }
            }
            finally {
                this.uriConverter.getURIHandlers().remove((Object)this.uriHandler);
                this.uriHandler.clear();
            }
        }
    }

    private boolean hasError(DocumentTemplate document) {
        boolean res = false;
        TreeIterator it = document.eAllContents();
        block0: while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            if (!(eObj instanceof IConstruct)) continue;
            for (TemplateValidationMessage message : ((IConstruct)eObj).getValidationMessages()) {
                if (message.getLevel() != ValidationMessageLevel.ERROR) continue;
                res = true;
                break block0;
            }
        }
        return res;
    }

    private void storeUserContent(Map<String, List<UserContent>> idToUserContent, UserContent userContent) {
        if (userContent.getId() != null) {
            String id = userContent.getId();
            List<UserContent> userContents = idToUserContent.get(id);
            if (userContents == null) {
                userContents = new ArrayList<UserContent>();
                idToUserContent.put(id, userContents);
            }
            userContents.add(userContent);
        }
    }

    public UserContent consumeUserContent(String id) {
        UserContent res;
        List<UserContent> userContents;
        if (this.mapIdUserContent == null) {
            this.launchParsing();
        }
        if ((userContents = this.mapIdUserContent.get(id)) != null && !userContents.isEmpty()) {
            res = userContents.remove(0);
            if (userContents.isEmpty()) {
                this.mapIdUserContent.remove(id);
            }
        } else {
            res = null;
        }
        return res;
    }

    private URI memoryCopy(URI source) {
        URI uri = URI.createURI((String)("m2docmemory://resources/" + source.lastSegment()), (boolean)false);
        Object res = this.copy(source, uri) ? uri : null;
        return res;
    }

    public void dispose() throws IOException {
        this.uriHandler.clear();
        if (this.userDocDocument != null) {
            this.userDocDocument.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean copy(URI source, URI dest) {
        boolean res = true;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                InputStream is = this.uriConverter.createInputStream(source);
                try {
                    try (OutputStream os = this.uriConverter.createOutputStream(dest);){
                        int length;
                        byte[] buffer = new byte[8192];
                        while ((length = is.read(buffer)) > 0) {
                            os.write(buffer, 0, length);
                        }
                    }
                    if (is == null) return res;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return res;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<String> getDuplicatedUserContentIDs() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.mapIdUserContent != null) {
            for (Map.Entry<String, List<UserContent>> entry : this.mapIdUserContent.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                res.add(entry.getKey());
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateLostFiles(GenerationResult result, RawCopier copier) throws IOException, InvalidFormatException {
        Iterator<Map.Entry<String, List<UserContent>>> iterator;
        block48: {
            if (this.mapIdUserContent == null) {
                this.launchParsing();
            }
            Throwable throwable = null;
            iterator = null;
            try {
                InputStream is = this.uriConverter.createInputStream(this.sourceURI);
                try {
                    block47: {
                        OPCPackage oPackage = OPCPackage.open((InputStream)is);
                        try {
                            try (XWPFDocument destinationDocument = new XWPFDocument(oPackage);){
                                if (this.copyToLostDocument) {
                                    URI lostDocumentURI = this.getLostDocumentURI(this.destinationURI);
                                    result.setLostDocumentURI(lostDocumentURI);
                                    this.copy(this.destinationURI, lostDocumentURI);
                                    XWPFParagraph currentGeneratedParagraph = destinationDocument.createParagraph();
                                    result.addMessage(M2DocUtils.appendMessageRun(currentGeneratedParagraph, ValidationMessageLevel.WARNING, "backup document created"));
                                }
                            }
                            if (oPackage == null) break block47;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (oPackage == null) throw throwable;
                            oPackage.close();
                            throw throwable;
                        }
                        oPackage.close();
                    }
                    if (is == null) break block48;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        iterator = this.mapIdUserContent.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean isNewUserContentLoss;
            URI inputURI;
            Map.Entry<String, List<UserContent>> entry = iterator.next();
            URI lostUserContentURI = this.getLostUserContentURI(this.destinationURI, entry.getKey());
            result.getLostUserContents().put(entry.getKey(), lostUserContentURI);
            if (this.uriConverter.exists(lostUserContentURI, Collections.EMPTY_MAP)) {
                inputURI = lostUserContentURI;
                isNewUserContentLoss = false;
            } else {
                inputURI = this.sourceURI;
                isNewUserContentLoss = true;
            }
            Throwable throwable = null;
            Object var9_15 = null;
            try {
                InputStream is = this.uriConverter.createInputStream(inputURI);
                try {
                    block50: {
                        OPCPackage oPackage = OPCPackage.open((InputStream)is);
                        try {
                            try (XWPFDocument destinationDocument = new XWPFDocument(oPackage);){
                                if (isNewUserContentLoss) {
                                    int size = destinationDocument.getBodyElements().size();
                                    int i = 0;
                                    while (i < size) {
                                        destinationDocument.removeBodyElement(0);
                                        ++i;
                                    }
                                }
                                XWPFParagraph currentGeneratedParagraph = destinationDocument.createParagraph();
                                result.addMessage(M2DocUtils.appendMessageRun(currentGeneratedParagraph, ValidationMessageLevel.WARNING, String.valueOf(this.format.format(new Date())) + " - Lost user content " + entry.getKey()));
                                currentGeneratedParagraph = destinationDocument.createParagraph();
                                Iterator<UserContent> iterator2 = entry.getValue().iterator();
                                while (true) {
                                    if (!iterator2.hasNext()) {
                                        POIServices.getInstance().saveFile(this.uriConverter, destinationDocument, lostUserContentURI);
                                        break;
                                    }
                                    UserContent userContent = iterator2.next();
                                    try {
                                        currentGeneratedParagraph = destinationDocument.createParagraph();
                                        currentGeneratedParagraph = copier.copyUserContent(userContent, currentGeneratedParagraph);
                                    }
                                    catch (Exception e) {
                                        result.addMessage(M2DocUtils.appendMessageRun(currentGeneratedParagraph, ValidationMessageLevel.ERROR, USERDOC_COPY_ERROR + e.getMessage()));
                                    }
                                }
                            }
                            if (oPackage == null) break block50;
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            if (oPackage == null) throw throwable;
                            oPackage.close();
                            throw throwable;
                        }
                        oPackage.close();
                    }
                    if (is == null) continue;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        return;
    }

    protected URI getLostUserContentURI(URI dest, String id) {
        URI res = URI.createURI((String)("./" + dest.lastSegment() + "-" + id + "-lost.docx"), (boolean)false);
        return res.resolve(dest);
    }

    protected URI getLostDocumentURI(URI dest) {
        String date = this.format.format(new Date()).replace("/", "_").replace(" ", "_");
        URI res = URI.createURI((String)("./" + dest.lastSegment() + "-" + date + "-backup.docx"), (boolean)false);
        return res.resolve(dest);
    }

    public void reset() {
        this.mapIdUserContent = null;
        this.uriHandler.clear();
    }
}

