/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.ParsingErrorMessage;
import org.obeonetwork.m2doc.parser.ParsingToken;
import org.obeonetwork.m2doc.parser.ParsingTokenKind;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.TokenProvider;
import org.obeonetwork.m2doc.parser.TokenType;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.Cell;
import org.obeonetwork.m2doc.template.ContentControl;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.Row;
import org.obeonetwork.m2doc.template.StaticFragment;
import org.obeonetwork.m2doc.template.Table;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.TemplatePackage;
import org.obeonetwork.m2doc.util.AQL56Compatibility;
import org.obeonetwork.m2doc.util.FieldUtils;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;

public abstract class AbstractBodyParser {
    protected IBody document;
    protected TokenProvider runIterator;
    protected IQueryBuilderEngine queryParser;
    protected final IQueryEnvironment queryEnvironment;
    protected final FieldUtils fieldUtils;

    public AbstractBodyParser(IBody inputDocument, IQueryEnvironment queryEnvironment) {
        this.document = inputDocument;
        this.runIterator = new TokenProvider(inputDocument);
        this.queryParser = AQL56Compatibility.createQueryBuilderEngine(queryEnvironment);
        this.queryEnvironment = queryEnvironment;
        this.fieldUtils = new FieldUtils();
    }

    protected AbstractBodyParser(IBody inputDocument, IQueryBuilderEngine queryParser, IQueryEnvironment queryEnvironment) {
        this.document = inputDocument;
        this.runIterator = new TokenProvider(inputDocument);
        this.queryParser = queryParser;
        this.queryEnvironment = queryEnvironment;
        this.fieldUtils = new FieldUtils();
    }

    protected TokenType getNextTokenType() {
        ParsingToken token = this.runIterator.lookAhead(1);
        TokenType result = token == null ? TokenType.EOF : (token.getKind() == ParsingTokenKind.TABLE ? TokenType.WTABLE : (token.getKind() == ParsingTokenKind.CONTENTCONTROL ? TokenType.CONTENTCONTROL : this.getNextTokenMTag(token)));
        return result;
    }

    protected abstract TokenType getNextTokenMTag(ParsingToken var1);

    protected String getType(String tag) {
        StringBuilder res = new StringBuilder();
        if (tag.startsWith("m:")) {
            res.append("m:");
            int i = 2;
            while (i < tag.length()) {
                char currentChar = tag.charAt(i);
                if (!Character.isAlphabetic(currentChar) && !Character.isDigit(currentChar)) break;
                res.append(currentChar);
                ++i;
            }
            return res.toString();
        }
        return null;
    }

    public Block parseBlock(List<Template> templates, TokenType ... endTypes) throws DocumentParserException {
        return this.parseBlock(templates, (String)null, endTypes);
    }

    public abstract Block parseBlock(List<Template> var1, String var2, TokenType ... var3) throws DocumentParserException;

    protected String readTag(IConstruct construct, List<XWPFRun> runsToFill) {
        XWPFRun run = this.runIterator.lookAhead(1).getRun();
        if (run == null) {
            throw new IllegalStateException("readTag shouldn't be called with a table in the lookahead window.");
        }
        if (!this.fieldUtils.isFieldBegin(run)) {
            throw new IllegalStateException("Shouldn't call readTag if the current run doesn't start a field");
        }
        StringBuilder result = new StringBuilder();
        runsToFill.add(this.runIterator.next().getRun());
        XWPFRun styleRun = null;
        boolean columnRead = false;
        while (this.runIterator.hasNext()) {
            run = this.runIterator.next().getRun();
            if (run == null) {
                throw new IllegalArgumentException("table cannot be inserted into tags.");
            }
            runsToFill.add(run);
            if (this.fieldUtils.isFieldEnd(run)) break;
            String runText = FieldUtils.readUpInstrText(run).toString();
            result.append(runText);
            if (styleRun != null) continue;
            if (columnRead && !runText.isEmpty()) {
                styleRun = run;
                construct.setStyleRun(styleRun);
                continue;
            }
            int indexOfColumn = runText.indexOf(58);
            boolean bl = columnRead = indexOfColumn >= 0;
            if (!columnRead || indexOfColumn >= runText.length() - 1) continue;
            styleRun = run;
            construct.setStyleRun(styleRun);
        }
        return result.toString();
    }

    protected List<TemplateValidationMessage> getValidationMessage(Diagnostic diagnostic, String queryText, XWPFRun location) {
        ArrayList<TemplateValidationMessage> res = new ArrayList<TemplateValidationMessage>();
        for (Diagnostic child : diagnostic.getChildren()) {
            ValidationMessageLevel level;
            switch (diagnostic.getSeverity()) {
                case 1: {
                    level = ValidationMessageLevel.INFO;
                    break;
                }
                case 2: {
                    level = ValidationMessageLevel.WARNING;
                    break;
                }
                case 4: {
                    level = ValidationMessageLevel.ERROR;
                    break;
                }
                default: {
                    level = ValidationMessageLevel.INFO;
                }
            }
            res.add(new TemplateValidationMessage(level, M2DocUtils.message(ParsingErrorMessage.INVALIDEXPR, queryText, child.getMessage()), location));
            res.addAll(this.getValidationMessage(child, queryText, location));
        }
        return res;
    }

    protected StaticFragment parseStaticFragment() throws DocumentParserException {
        StaticFragment result = (StaticFragment)EcoreUtil.create((EClass)TemplatePackage.Literals.STATIC_FRAGMENT);
        while (this.getNextTokenType() == TokenType.STATIC) {
            result.getRuns().add((Object)this.runIterator.next().getRun());
        }
        return result;
    }

    protected Table parseTable(XWPFTable wtable) throws DocumentParserException {
        if (wtable == null) {
            throw new IllegalArgumentException("parseTable can't be called on a null argument.");
        }
        Table table = (Table)EcoreUtil.create((EClass)TemplatePackage.Literals.TABLE);
        table.setTable(wtable);
        for (XWPFTableRow tablerow : wtable.getRows()) {
            Row row = (Row)EcoreUtil.create((EClass)TemplatePackage.Literals.ROW);
            table.getRows().add((Object)row);
            row.setTableRow(tablerow);
            for (XWPFTableCell tableCell : tablerow.getTableCells()) {
                Cell cell = (Cell)EcoreUtil.create((EClass)TemplatePackage.Literals.CELL);
                row.getCells().add((Object)cell);
                cell.setTableCell(tableCell);
                AbstractBodyParser parser = this.getNewParser((IBody)tableCell);
                cell.setBody(parser.parseBlock(null, TokenType.EOF));
            }
        }
        return table;
    }

    protected ContentControl parseContentControl(XWPFSDT control) {
        if (control == null) {
            throw new IllegalArgumentException("parseContentControl can't be called on a null argument.");
        }
        ContentControl contentControl = (ContentControl)EcoreUtil.create((EClass)TemplatePackage.Literals.CONTENT_CONTROL);
        contentControl.setBlock(AbstractBodyParser.getCTSdtBlock(this.document, control));
        return contentControl;
    }

    public static CTSdtBlock getCTSdtBlock(IBody body, XWPFSDT sdt) {
        int sdtIndex = -1;
        for (IBodyElement element : body.getBodyElements()) {
            if (!(element instanceof XWPFSDT)) continue;
            ++sdtIndex;
            if (element == sdt) break;
        }
        CTSdtBlock res = sdtIndex > -1 ? AbstractBodyParser.getCTSdtBlock(body, sdtIndex) : null;
        return res;
    }

    private static CTSdtBlock getCTSdtBlock(IBody body, int sdtIndex) {
        CTSdtBlock res;
        if (body instanceof XWPFDocument) {
            res = ((XWPFDocument)body).getDocument().getBody().getSdtArray(sdtIndex);
        } else if (body instanceof XWPFHeaderFooter) {
            res = ((XWPFHeaderFooter)body)._getHdrFtr().getSdtArray(sdtIndex);
        } else if (body instanceof XWPFFootnote) {
            res = ((XWPFFootnote)body).getCTFtnEdn().getSdtArray(sdtIndex);
        } else if (body instanceof XWPFTableCell) {
            res = ((XWPFTableCell)body).getCTTc().getSdtArray(sdtIndex);
        } else {
            throw new IllegalStateException("can't insert control in " + body.getClass().getCanonicalName());
        }
        return res;
    }

    protected abstract AbstractBodyParser getNewParser(IBody var1);
}

