/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MList;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.PictureType;
import org.obeonetwork.m2doc.element.impl.MImageAWTImpl;
import org.obeonetwork.m2doc.element.impl.MImageImpl;

@ServiceProvider(value="Services available for Images. See [document examples](https://github.com/ObeoNetwork/M2Doc/tree/master/tests/org.obeonetwork.m2doc.tests/resources/imageServices).")
public class ImageServices {
    private final URIConverter uriConverter;
    private final URI templateURI;

    public ImageServices(URIConverter uriConverter, URI templateURI) {
        this.uriConverter = uriConverter;
        this.templateURI = templateURI;
    }

    @Documentation(value="Convert a String representing an URI to an Image.", params={@Param(name="uri", value="The Image uri, it can be relative to the template")}, result="insert the image", examples={@Example(expression="'image.png'.asImage()", result="insert the image 'image.png'")})
    public MImage asImage(String uriStr) {
        MImage res;
        if (uriStr != null) {
            URI imageURI = URI.createURI((String)uriStr, (boolean)true);
            res = this.asImage(uriStr, PictureType.toType(imageURI));
        } else {
            res = null;
        }
        return res;
    }

    @Documentation(value="Convert a String representing an URI to an Image and specify the image format of the input.", params={@Param(name="uri", value="The Image uri, it can be relative to the template"), @Param(name="format", value="the image format: BMP, DIB, EMF, EPS, GIF, JPG, JPEG, PICT, PNG, SVG, TIFF, WMF, WPG")}, result="insert the image", examples={@Example(expression="'image'.asImage('jpg')", result="insert the image as a jpg image")})
    public MImage asImage(String uriStr, String format) {
        MImage res = uriStr != null && format != null ? this.asImage(uriStr, PictureType.valueOf(format.toUpperCase())) : null;
        return res;
    }

    private MImage asImage(String uriStr, PictureType type) {
        MImageImpl res;
        if (uriStr != null && type != null) {
            URI imageURI = URI.createURI((String)uriStr, (boolean)true);
            URI uri = imageURI.resolve(this.templateURI);
            res = new MImageImpl(this.uriConverter, uri, type);
        } else {
            res = null;
        }
        return res;
    }

    @Documentation(value="Gets the width of the image.", params={@Param(name="image", value="The Image")}, result="gets the width of the image, -1 if the image is null", examples={@Example(expression="myImage.getWidth()", result="300")})
    public Integer getWidth(MImage image) {
        Integer res = image != null ? Integer.valueOf(image.getWidth()) : Integer.valueOf(-1);
        return res;
    }

    @Documentation(value="Sets the width of the image.", params={@Param(name="image", value="The Image"), @Param(name="width", value="The width")}, result="sets the width of the image", examples={@Example(expression="myImage.setWidth(300)", result="set the witdh to 300")})
    public MImage setWidth(MImage image, Integer width) {
        if (image != null && width != null) {
            image.setWidth(width);
        }
        return image;
    }

    @Documentation(value="Gets the height of the image.", params={@Param(name="image", value="The Image")}, result="gets the height of the image, -1 if the image is null", examples={@Example(expression="myImage.getHeight()", result="300")})
    public Integer getHeight(MImage image) {
        Integer res = image != null ? Integer.valueOf(image.getHeight()) : Integer.valueOf(-1);
        return res;
    }

    @Documentation(value="Sets the height of the image.", params={@Param(name="image", value="The Image"), @Param(name="height", value="The height")}, result="sets the height of the image", examples={@Example(expression="myImage.setHeight(300)", result="set the height to 300")})
    public MImage setHeight(MImage image, Integer height) {
        if (image != null && height != null) {
            image.setHeight(height);
        }
        return image;
    }

    @Documentation(value="Sets the conserve ratio of the image.", params={@Param(name="image", value="The Image"), @Param(name="conserve", value="A Boolean")}, result="sets the conserve ratio of the image", examples={@Example(expression="myImage.setConserveRatio(false)", result="set the conserve ratio to false")})
    public MImage setConserveRatio(MImage image, Boolean conserve) {
        if (image != null && conserve != null) {
            image.setConserveRatio(conserve);
        }
        return image;
    }

    @Documentation(value="Fits the Image in the given rectangle width and height. same as myImage.fit(width, height, true)", params={@Param(name="image", value="The Image"), @Param(name="width", value="The width to fit"), @Param(name="height", value="The height to fit")}, result="the image with new dimensions", examples={@Example(expression="myImage.fit(200, 300)", result="will fit the image in a rectangle (width=200, height=300)")})
    public MImage fit(MImage image, Integer width, Integer height) {
        MImage res;
        if (image != null && width != null && height != null) {
            image.setWidth(width);
            if (!image.conserveRatio() || image.getHeight() > height) {
                image.setHeight(height);
            }
            res = this.fit(image, width, height, true);
        } else {
            res = null;
        }
        return res;
    }

    @Documentation(value="Fits the Image in the given rectangle width and height.", params={@Param(name="image", value="The Image"), @Param(name="width", value="The width to fit"), @Param(name="height", value="The height to fit"), @Param(name="zoomIn", value="The image will be zoomed in if smaller")}, result="the image with new dimensions", examples={@Example(expression="myImage.fit(200, 300, false)", result="will fit the image in a rectangle (width=200, height=300) if the original image size is smaller it will not be zoomed in")})
    public MImage fit(MImage image, Integer width, Integer height, boolean zoomIn) {
        if (image != null && width != null && height != null) {
            if (zoomIn) {
                image.setWidth(width);
                if (!image.conserveRatio() || image.getHeight() > height) {
                    image.setHeight(height);
                }
            } else if (image.getWidth() > width) {
                image.setWidth(width);
                if (image.getHeight() > height) {
                    image.setHeight(height);
                }
            } else if (image.getHeight() > height) {
                image.setHeight(height);
                if (image.getWidth() > width) {
                    image.setWidth(width);
                }
            }
        }
        return image;
    }

    @Documentation(value="Resizes the Image by the given factor.", params={@Param(name="image", value="The Image"), @Param(name="factor", value="The resize factor")}, result="resize the image", examples={@Example(expression="myImage.resize(0.5)", result="will resize the image by a factor 0.5")})
    public MImage resize(MImage image, Double factor) throws IOException {
        MImageAWTImpl res;
        if (image != null && factor != null) {
            BufferedImage bufferedImage = MImageAWTImpl.getBufferedImage(image);
            BufferedImage resized = new BufferedImage((int)((double)bufferedImage.getWidth() * factor), (int)((double)bufferedImage.getHeight() * factor), bufferedImage.getType());
            AffineTransform zoomTransfort = AffineTransform.getScaleInstance(factor, factor);
            AffineTransformOp retaillerImage = new AffineTransformOp(zoomTransfort, 2);
            retaillerImage.filter(bufferedImage, resized);
            res = new MImageAWTImpl(resized, image.getURI());
        } else {
            res = null;
        }
        return res;
    }

    @Documentation(value="Rotates the Image by the given angle in degres.", params={@Param(name="image", value="The Image"), @Param(name="angle", value="The angle in degres")}, result="rotate the image", examples={@Example(expression="myImage.rotate(90)", result="will rotate the image by an angle of 90 degres")})
    public MImage rotate(MImage image, Integer angle) throws IOException {
        MImageAWTImpl res;
        if (image != null && angle != null) {
            BufferedImage bufferedImage = MImageAWTImpl.getBufferedImage(image);
            double rads = Math.toRadians(angle.intValue());
            double sin = Math.abs(Math.sin(rads));
            double cos = Math.abs(Math.cos(rads));
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            int x = width / 2;
            int y = height / 2;
            int newWidth = (int)Math.floor((double)width * cos + (double)height * sin);
            int newHeight = (int)Math.floor((double)height * cos + (double)width * sin);
            BufferedImage rotated = new BufferedImage(newWidth, newHeight, 2);
            AffineTransform translateTransform = new AffineTransform();
            translateTransform.translate((newWidth - width) / 2, (newHeight - height) / 2);
            translateTransform.rotate(rads, x, y);
            Graphics2D g2d = rotated.createGraphics();
            g2d.setTransform(translateTransform);
            g2d.drawImage((Image)bufferedImage, 0, 0, null);
            g2d.dispose();
            res = new MImageAWTImpl(rotated, image.getURI());
        } else {
            res = null;
        }
        return res;
    }

    @Documentation(value="Fits all Images of the given MElement in the given rectangle width and height.", params={@Param(name="element", value="The MElement"), @Param(name="width", value="The width to fit"), @Param(name="height", value="The height to fit"), @Param(name="zoomIn", value="The image will be zoomed in if smaller")}, result="the MElement with resized images", examples={@Example(expression="myImage.fitAll(200, 300, false)", result="will fit all images in a rectangle (width=200, height=300) if the original image size is smaller it will not be zoomed in")})
    public MElement fitAll(MElement element, Integer width, Integer height, boolean zoomIn) {
        MElement res;
        if (element instanceof MList) {
            ArrayList<MElement> newElements = new ArrayList<MElement>();
            for (MElement e : (MList)element) {
                newElements.add(this.fitAll(e, width, height, zoomIn));
            }
            ((MList)element).clear();
            ((MList)element).addAll(newElements);
            res = element;
        } else if (element instanceof MParagraph) {
            MElement newContent = this.fitAll(((MParagraph)element).getContents(), width, height, zoomIn);
            if (newContent != ((MParagraph)element).getContents()) {
                ((MParagraph)element).setContents(newContent);
            }
            res = element;
        } else if (element instanceof MTable) {
            for (MTable.MRow row : ((MTable)element).getRows()) {
                for (MTable.MCell cell : row.getCells()) {
                    MElement newContent = this.fitAll(cell.getContents(), width, height, zoomIn);
                    if (newContent == cell.getContents()) continue;
                    cell.setContents(newContent);
                }
            }
            res = element;
        } else if (element instanceof MImage) {
            MImage image = (MImage)element;
            this.fit(image, width, height, zoomIn);
            res = image;
        } else {
            res = element;
        }
        return res;
    }
}

