/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlCursor;
import org.obeonetwork.m2doc.parser.TokenProvider;
import org.obeonetwork.m2doc.util.SequenceField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

public class FieldUtils {
    private static final Pattern SEQ_PATTERN = Pattern.compile("\\s+SEQ\\s+([A-Za-z0-9_-]+)\\s+\\\\\\*\\s+(" + SequenceField.Type.ALPHABETIC.getType() + "|" + SequenceField.Type.ALPHABETIC_CAP.getType() + "|" + SequenceField.Type.ARABIC.getType() + "|" + SequenceField.Type.ROMAN.getType() + "|" + SequenceField.Type.ROMAN_CAP.getType() + ")\\s+");
    private static final int NAME_INDEX = 1;
    private static final int TYPE_INDEX = 2;

    public String lookAheadTag(TokenProvider runIterator) {
        int i = 1;
        XWPFRun run = runIterator.lookAhead(i).getRun();
        if (run == null) {
            throw new IllegalStateException("lookAheadTag shouldn't be called on a table.");
        }
        if (this.isFieldBegin(run)) {
            StringBuilder builder = new StringBuilder();
            run = runIterator.lookAhead(++i).getRun();
            while (run != null && !this.isFieldEnd(run)) {
                builder.append((CharSequence)FieldUtils.readUpInstrText(run));
                run = runIterator.lookAhead(++i).getRun();
            }
            return builder.toString().trim();
        }
        return "";
    }

    public boolean isFieldBegin(XWPFRun run) {
        if (run.getCTR().getFldCharList().size() > 0) {
            CTFldChar fldChar = (CTFldChar)run.getCTR().getFldCharList().get(0);
            return STFldCharType.BEGIN.equals(fldChar.getFldCharType());
        }
        return false;
    }

    public boolean isFieldBegin(CTR ctr) {
        if (ctr.getFldCharList().size() > 0) {
            CTFldChar fldChar = (CTFldChar)ctr.getFldCharList().get(0);
            return STFldCharType.BEGIN.equals(fldChar.getFldCharType());
        }
        return false;
    }

    public boolean isFieldSeparate(CTR ctr) {
        if (ctr.getFldCharList().size() > 0) {
            CTFldChar fldChar = (CTFldChar)ctr.getFldCharList().get(0);
            return STFldCharType.SEPARATE.equals(fldChar.getFldCharType());
        }
        return false;
    }

    public boolean isFieldEnd(CTR ctr) {
        if (ctr.getFldCharList().size() > 0) {
            CTFldChar fldChar = (CTFldChar)ctr.getFldCharList().get(0);
            return STFldCharType.END.equals(fldChar.getFldCharType());
        }
        return false;
    }

    public SequenceField getSequenceField(CTR run) {
        SequenceField res;
        if (this.isFieldBegin(run)) {
            Throwable throwable = null;
            Object var4_4 = null;
            try (XmlCursor cursor = run.newCursor();){
                if (cursor.toNextSibling() && cursor.getObject() instanceof CTR && ((CTR)cursor.getObject()).getInstrTextArray().length == 1) {
                    CTText instr = ((CTR)cursor.getObject()).getInstrTextArray()[0];
                    if (instr.getStringValue() != null) {
                        res = this.getSequenceFieldFromStart(cursor, instr.getStringValue());
                    }
                    res = null;
                }
                res = null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        } else {
            res = null;
        }
        return res;
    }

    private SequenceField getSequenceFieldFromStart(XmlCursor cursor, String instr) {
        SequenceField res;
        Matcher matcher = SEQ_PATTERN.matcher(instr);
        if (matcher.matches()) {
            String name = matcher.group(1);
            SequenceField.Type type = SequenceField.Type.getType(matcher.group(2));
            if (cursor.toNextSibling() && cursor.getObject() instanceof CTR && this.isFieldSeparate((CTR)cursor.getObject())) {
                if (cursor.toNextSibling() && cursor.getObject() instanceof CTR && ((CTR)cursor.getObject()).getTArray().length == 1) {
                    CTText indexText = ((CTR)cursor.getObject()).getTArray()[0];
                    res = new SequenceField(name, type, indexText);
                } else {
                    res = null;
                }
            } else {
                res = null;
            }
        } else {
            res = null;
        }
        return res;
    }

    public boolean isFieldEnd(XWPFRun run) {
        return this.isFieldEnd(run.getCTR());
    }

    public static StringBuilder readUpInstrText(XWPFRun run) {
        List texts = run.getCTR().getInstrTextList();
        StringBuilder runBuilder = new StringBuilder();
        for (CTText text : texts) {
            runBuilder.append(text.getStringValue());
        }
        return runBuilder;
    }
}

