/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

public class SequenceField {
    private static final int ALPHABETIC_BASE = 26;
    private static final Map<Integer, String> ROMAN_MAP = SequenceField.initializeRomanMap();
    private final String name;
    private final Type type;
    private final CTText indexText;

    public SequenceField(String name, Type type, CTText indexText) {
        this.name = name;
        this.type = type;
        this.indexText = indexText;
    }

    private static Map<Integer, String> initializeRomanMap() {
        LinkedHashMap<Integer, String> res = new LinkedHashMap<Integer, String>();
        res.put(1000, "M");
        res.put(900, "CM");
        res.put(500, "D");
        res.put(400, "CD");
        res.put(100, "C");
        res.put(90, "XC");
        res.put(50, "L");
        res.put(40, "XL");
        res.put(10, "X");
        res.put(9, "IX");
        res.put(5, "V");
        res.put(4, "IV");
        res.put(1, "I");
        return res;
    }

    public String getName() {
        return this.name;
    }

    public void setIndex(int index) {
        switch (this.type) {
            case ROMAN: {
                this.indexText.setStringValue(this.getRoman(index));
                break;
            }
            case ROMAN_CAP: {
                this.indexText.setStringValue(this.getRoman(index).toUpperCase());
                break;
            }
            case ARABIC: {
                this.indexText.setStringValue(String.valueOf(index));
                break;
            }
            case ALPHABETIC: {
                this.indexText.setStringValue(this.getAlphabetic(index));
                break;
            }
            case ALPHABETIC_CAP: {
                this.indexText.setStringValue(this.getAlphabetic(index).toUpperCase());
                break;
            }
        }
    }

    private String getRoman(int index) {
        StringBuilder res = new StringBuilder();
        int localIndex = index;
        for (Map.Entry<Integer, String> entry : ROMAN_MAP.entrySet()) {
            while (localIndex >= entry.getKey()) {
                localIndex -= entry.getKey().intValue();
                res.append(entry.getValue());
            }
        }
        return res.toString();
    }

    private String getAlphabetic(int index) {
        StringBuilder res = new StringBuilder();
        int localIndex = index;
        while (--localIndex >= 0) {
            res.insert(0, Character.valueOf((char)(97 + localIndex % 26)));
            localIndex /= 26;
        }
        return res.toString();
    }

    static enum Type {
        ROMAN("roman"),
        ROMAN_CAP("ROMAN"),
        ARABIC("ARABIC"),
        ALPHABETIC("alphabetic"),
        ALPHABETIC_CAP("ALPHABETIC");

        private static final Map<String, Type> MAP;
        private final String type;

        static {
            MAP = Type.initializeStringTypes();
        }

        private Type(String type) {
            this.type = type;
        }

        private static Map<String, Type> initializeStringTypes() {
            HashMap<String, Type> res = new HashMap<String, Type>();
            res.put(Type.ROMAN.type, ROMAN);
            res.put(Type.ROMAN_CAP.type, ROMAN_CAP);
            res.put(Type.ARABIC.type, ARABIC);
            res.put(Type.ALPHABETIC.type, ALPHABETIC);
            res.put(Type.ALPHABETIC_CAP.type, ALPHABETIC_CAP);
            return res;
        }

        public static Type getType(String type) {
            return MAP.get(type);
        }

        public String getType() {
            return this.type;
        }
    }
}

