/*******************************************************************************
 * Copyright (c) 2017, 2024 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.obeonetwork.m2doc.sirius;

/**
 * M2Doc Sirius utility class.
 * 
 * @author <a href="mailto:yvan.lussaud@obeo.fr">Yvan Lussaud</a>
 */
public final class M2DocSiriusUtils {

    /**
     * The Plug-in ID.
     */
    public static final String PLUGIN_ID = "org.obeonetwork.m2doc.sirius";

    /**
     * The Sirius session option.
     */
    public static final String SIRIUS_SESSION_OPTION = "SiriusSession";

    /**
     * The Sirius force refresh option.
     */
    public static final String SIRIUS_FORCE_REFRESH = "SiriusForceRefresh";

    /**
     * The Sirius scale policy option.
     */
    public static final String SIRIUS_SCALING_POLICY = "SiriusScalingPolicy";

    /**
     * The Sirius scale level option.
     */
    public static final String SIRIUS_SCALE_LEVEL = "SiriusScaleLevel";

    /**
     * Constructor.
     */
    private M2DocSiriusUtils() {
        // nothing to do here
    }

}
