/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CancellationException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.emf.common.util.Monitor;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.services.M2DocTemplateService;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.Bookmark;
import org.obeonetwork.m2doc.template.Cell;
import org.obeonetwork.m2doc.template.Comment;
import org.obeonetwork.m2doc.template.Conditional;
import org.obeonetwork.m2doc.template.ContentControl;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.Let;
import org.obeonetwork.m2doc.template.Link;
import org.obeonetwork.m2doc.template.Parameter;
import org.obeonetwork.m2doc.template.Query;
import org.obeonetwork.m2doc.template.Repetition;
import org.obeonetwork.m2doc.template.Row;
import org.obeonetwork.m2doc.template.StaticFragment;
import org.obeonetwork.m2doc.template.Table;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.UserDoc;
import org.obeonetwork.m2doc.template.util.TemplateSwitch;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class M2DocValidator
extends TemplateSwitch<org.obeonetwork.m2doc.parser.ValidationMessageLevel> {
    public static final String INDEX_SUFFIX = "Index";
    private static final int INIT_ENGINE_MONITOR_WORK = 5;
    private static final int VALIDATE_TEMPLATE_MONITOR_WORK = 95;
    private static final int TOTAL_VALIDATE_MONITOR_WORK = 100;
    private IType booleanObjectType;
    private IType booleanType;
    private IType integerType;
    private final Stack<Map<String, Set<IType>>> stack = new Stack();
    private AstValidator aqlValidator;
    private Monitor progressMonitor;
    private IReadOnlyQueryEnvironment queryEnvironment;

    public org.obeonetwork.m2doc.parser.ValidationMessageLevel validate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnv, Monitor monitor) {
        return this.validate(documentTemplate, queryEnv, false, monitor);
    }

    public org.obeonetwork.m2doc.parser.ValidationMessageLevel validate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnv, boolean ignoreVersionCheck, Monitor monitor) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel result;
        this.progressMonitor = monitor;
        this.progressMonitor.beginTask("Validating " + String.valueOf(documentTemplate.eResource().getURI()), 100);
        this.progressMonitor.subTask("Initialize engine");
        this.queryEnvironment = queryEnv;
        this.aqlValidator = new AstValidator(new ValidationServices(this.queryEnvironment));
        XWPFDocument document = documentTemplate.getDocument();
        TemplateCustomProperties templateProperties = new TemplateCustomProperties(document);
        XWPFRun run = M2DocUtils.getOrCreateFirstRun(document);
        if (templateProperties.getM2DocVersion() == null) {
            documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(org.obeonetwork.m2doc.parser.ValidationMessageLevel.WARNING, "No M2Doc version set in the template.", run));
        } else if (!ignoreVersionCheck && !"4.0.0".equals(templateProperties.getM2DocVersion())) {
            documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(org.obeonetwork.m2doc.parser.ValidationMessageLevel.WARNING, "M2Doc version mismatch: template is " + templateProperties.getM2DocVersion() + " and runtime is 4.0.0", run));
        }
        if (!documentTemplate.getTemplates().isEmpty()) {
            for (Template template : documentTemplate.getTemplates()) {
                ((IQueryEnvironment)this.queryEnvironment).registerService((IService)new M2DocTemplateService(template, this.queryEnvironment));
            }
        }
        LinkedHashMap<String, Set<IType>> types = new LinkedHashMap<String, Set<IType>>();
        for (Map.Entry<String, String> entry : templateProperties.getVariables().entrySet()) {
            Set<IType> variableTypes = templateProperties.getVariableTypes(this.aqlValidator, this.queryEnvironment, entry.getValue());
            types.put(entry.getKey(), variableTypes);
        }
        this.booleanObjectType = new ClassType(this.queryEnvironment, Boolean.class);
        this.booleanType = new ClassType(this.queryEnvironment, Boolean.TYPE);
        this.integerType = new ClassType(this.queryEnvironment, Integer.class);
        this.stack.clear();
        this.stack.push(types);
        this.worked(this.progressMonitor, 5);
        try {
            result = (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(documentTemplate));
        }
        finally {
            this.stack.pop();
            this.progressMonitor.done();
        }
        return result;
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseDocumentTemplate(DocumentTemplate documentTemplate) {
        this.progressMonitor.subTask("Validating document");
        int unitOfWork = 95 / (documentTemplate.getHeaders().size() + 1 + documentTemplate.getFooters().size() + documentTemplate.getTemplates().size());
        org.obeonetwork.m2doc.parser.ValidationMessageLevel headerLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        for (Block header : documentTemplate.getHeaders()) {
            headerLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(headerLevel, (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(header)));
            this.worked(this.progressMonitor, unitOfWork);
        }
        org.obeonetwork.m2doc.parser.ValidationMessageLevel bodyLevel = (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(documentTemplate.getBody()));
        this.worked(this.progressMonitor, unitOfWork);
        org.obeonetwork.m2doc.parser.ValidationMessageLevel footerLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        for (Block footer : documentTemplate.getFooters()) {
            footerLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(footerLevel, (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(footer)));
            this.worked(this.progressMonitor, unitOfWork);
        }
        org.obeonetwork.m2doc.parser.ValidationMessageLevel templateLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        for (Template template : documentTemplate.getTemplates()) {
            templateLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(templateLevel, (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(template)));
            this.worked(this.progressMonitor, unitOfWork);
        }
        return org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(headerLevel, bodyLevel, footerLevel, templateLevel);
    }

    private void worked(Monitor monitor, int work) {
        if (monitor.isCanceled()) {
            throw new CancellationException("Canceled by user");
        }
        monitor.worked(work);
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseTemplate(Template template) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel bodyLevel;
        org.obeonetwork.m2doc.parser.ValidationMessageLevel parsingLevel = this.getHighestMessageLevel(template);
        HashMap<String, Set> parameters = new HashMap<String, Set>();
        org.obeonetwork.m2doc.parser.ValidationMessageLevel parameterLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        for (Parameter parameter : template.getParameters()) {
            IValidationResult validationResult = this.aqlValidator.validate(null, parameter.getType());
            XWPFRun run = (XWPFRun)template.getRuns().get(template.getRuns().size() - 1);
            this.addValidationMessages(template, run, validationResult);
            if (parameters.containsKey(parameter.getName())) {
                parameterLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
                template.getValidationMessages().add((Object)new TemplateValidationMessage(parameterLevel, String.format("duplicated parameter (%s).", parameter.getName()), run));
            }
            Set possibleTypes = this.aqlValidator.getDeclarationTypes(this.queryEnvironment, validationResult.getPossibleTypes(parameter.getType().getAst()));
            parameters.put(parameter.getName(), possibleTypes);
        }
        this.stack.push(parameters);
        try {
            bodyLevel = (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(template.getBody()));
        }
        finally {
            this.stack.pop();
        }
        return org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(parsingLevel, bodyLevel, parameterLevel);
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseBookmark(Bookmark bookmark) {
        if (bookmark.getName().getDiagnostic().getSeverity() != 4) {
            IValidationResult validationResult = this.aqlValidator.validate(this.stack.peek(), bookmark.getName());
            XWPFRun run = (XWPFRun)bookmark.getRuns().get(bookmark.getRuns().size() - 1);
            this.addValidationMessages(bookmark, run, validationResult);
        }
        org.obeonetwork.m2doc.parser.ValidationMessageLevel bodyLevel = (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(bookmark.getBody()));
        return org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(this.getHighestMessageLevel(bookmark), bodyLevel);
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseLink(Link link) {
        XWPFRun run;
        if (link.getName().getDiagnostic().getSeverity() != 4) {
            IValidationResult nameValidationResult = this.aqlValidator.validate(this.stack.peek(), link.getName());
            run = (XWPFRun)link.getRuns().get(link.getRuns().size() - 1);
            this.addValidationMessages(link, run, nameValidationResult);
        }
        if (link.getText().getDiagnostic().getSeverity() != 4) {
            IValidationResult textValidationResult = this.aqlValidator.validate(this.stack.peek(), link.getText());
            run = (XWPFRun)link.getRuns().get(link.getRuns().size() - 1);
            this.addValidationMessages(link, run, textValidationResult);
        }
        return this.getHighestMessageLevel(link);
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseUserDoc(UserDoc userDoc) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel idLevel;
        if (userDoc.getId().getDiagnostic().getSeverity() != 4) {
            IValidationResult validationResult = this.aqlValidator.validate(this.stack.peek(), userDoc.getId());
            XWPFRun run = (XWPFRun)userDoc.getRuns().get(userDoc.getRuns().size() - 1);
            this.addValidationMessages(userDoc, run, validationResult);
            idLevel = this.checkUserDocIdTypes(userDoc, run, validationResult);
        } else {
            idLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
        }
        return org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(this.getHighestMessageLevel(userDoc), idLevel, (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(userDoc.getBody())));
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseBlock(Block block) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel res = this.getHighestMessageLevel(block);
        for (IConstruct construct : block.getStatements()) {
            res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(res, (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(construct)));
        }
        return res;
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseStaticFragment(StaticFragment staticFragment) {
        return org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseConditional(Conditional conditional) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel elseLevel;
        org.obeonetwork.m2doc.parser.ValidationMessageLevel thenLevel;
        org.obeonetwork.m2doc.parser.ValidationMessageLevel conditionLevel;
        IValidationResult validationResult = this.aqlValidator.validate(this.stack.peek(), conditional.getCondition());
        Set types = validationResult.getPossibleTypes(conditional.getCondition().getAst());
        if (conditional.getCondition().getDiagnostic().getSeverity() != 4) {
            XWPFRun run = (XWPFRun)conditional.getRuns().get(conditional.getRuns().size() - 1);
            this.addValidationMessages(conditional, run, validationResult);
            conditionLevel = this.checkConditionalConditionTypes(conditional, run, types);
        } else {
            conditionLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
        }
        HashMap<String, Set<IType>> thenVariables = new HashMap<String, Set<IType>>(this.stack.peek());
        thenVariables.putAll(validationResult.getInferredVariableTypes(conditional.getCondition().getAst(), Boolean.TRUE));
        this.stack.push(thenVariables);
        try {
            thenLevel = (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(conditional.getThen()));
        }
        finally {
            this.stack.pop();
        }
        if (conditional.getElse() != null) {
            HashMap<String, Set<IType>> elseVariables = new HashMap<String, Set<IType>>(this.stack.peek());
            elseVariables.putAll(validationResult.getInferredVariableTypes(conditional.getCondition().getAst(), Boolean.FALSE));
            this.stack.push(elseVariables);
            try {
                elseLevel = (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(conditional.getElse()));
            }
            finally {
                this.stack.pop();
            }
        } else {
            elseLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        }
        return org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(this.getHighestMessageLevel(conditional), conditionLevel, thenLevel, elseLevel);
    }

    private org.obeonetwork.m2doc.parser.ValidationMessageLevel checkConditionalConditionTypes(Conditional conditional, XWPFRun run, Set<IType> conditionTypes) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel res;
        if (!conditionTypes.isEmpty()) {
            boolean onlyBoolean = true;
            boolean onlyNotBoolean = true;
            for (IType type : conditionTypes) {
                boolean assignableFrom = this.booleanObjectType.isAssignableFrom(type) || this.booleanType.isAssignableFrom(type);
                onlyBoolean = onlyBoolean && assignableFrom;
                boolean bl = onlyNotBoolean = onlyNotBoolean && !assignableFrom;
                if (!onlyBoolean && !onlyNotBoolean) break;
            }
            if (!onlyBoolean) {
                if (onlyNotBoolean) {
                    res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
                    conditional.getValidationMessages().add((Object)new TemplateValidationMessage(res, String.format("The predicate never evaluates to a boolean type (%s).", conditionTypes), run));
                } else {
                    res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.WARNING;
                    conditional.getValidationMessages().add((Object)new TemplateValidationMessage(res, String.format("The predicate may evaluate to a value that is not a boolean type (%s).", conditionTypes), run));
                }
            } else {
                res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
            }
        } else {
            res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
            conditional.getValidationMessages().add((Object)new TemplateValidationMessage(res, String.format("The predicate never evaluates to a boolean type (%s).", conditionTypes), run));
        }
        return res;
    }

    private org.obeonetwork.m2doc.parser.ValidationMessageLevel checkUserDocIdTypes(UserDoc userDoc, XWPFRun run, IValidationResult validationResult) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        Set types = validationResult.getPossibleTypes(userDoc.getId().getAst());
        for (IType type : types) {
            if (!(type instanceof ICollectionType)) continue;
            userDoc.getValidationMessages().add((Object)new TemplateValidationMessage(org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR, String.format("The id type must not be a collection (%s).", type), run));
            res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
            break;
        }
        return res;
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseRepetition(Repetition repetition) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel bodyLevel;
        org.obeonetwork.m2doc.parser.ValidationMessageLevel iteratorLevel;
        IValidationResult validationResult = this.aqlValidator.validate(this.stack.peek(), repetition.getQuery());
        Set types = validationResult.getPossibleTypes(repetition.getQuery().getAst());
        XWPFRun run = (XWPFRun)repetition.getRuns().get(repetition.getRuns().size() - 1);
        if (repetition.getQuery().getDiagnostic().getSeverity() != 4) {
            this.addValidationMessages(repetition, run, validationResult);
            iteratorLevel = this.validateRepetitionQueryType(repetition, run, types);
        } else {
            iteratorLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
        }
        if (this.stack.peek().containsKey(repetition.getIterationVar())) {
            iteratorLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(iteratorLevel, org.obeonetwork.m2doc.parser.ValidationMessageLevel.WARNING);
            repetition.getValidationMessages().add((Object)new TemplateValidationMessage(org.obeonetwork.m2doc.parser.ValidationMessageLevel.WARNING, String.format("The iteration variable mask an existing variable (%s).", repetition.getIterationVar()), run));
        }
        LinkedHashSet<Object> iteratorTypes = new LinkedHashSet<Object>();
        for (IType type : types) {
            if (!(type instanceof ICollectionType)) continue;
            iteratorTypes.add(((ICollectionType)type).getCollectionType());
        }
        if (iteratorTypes.isEmpty()) {
            iteratorTypes.add(new NothingType("No collection type for the iterator " + repetition.getIterationVar()));
        }
        HashMap<String, Set<IType>> iterationVariables = new HashMap<String, Set<IType>>(this.stack.peek());
        iterationVariables.put(repetition.getIterationVar(), iteratorTypes);
        LinkedHashSet<IType> indexTypes = new LinkedHashSet<IType>();
        indexTypes.add(this.integerType);
        iterationVariables.put(repetition.getIterationVar() + INDEX_SUFFIX, indexTypes);
        this.stack.push(iterationVariables);
        try {
            bodyLevel = (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(repetition.getBody()));
        }
        finally {
            this.stack.pop();
        }
        return org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(this.getHighestMessageLevel(repetition), iteratorLevel, bodyLevel);
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseLet(Let let) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel bodyLevel;
        org.obeonetwork.m2doc.parser.ValidationMessageLevel variableLevel;
        IValidationResult validationResult = this.aqlValidator.validate(this.stack.peek(), let.getValue());
        Set types = validationResult.getPossibleTypes(let.getValue().getAst());
        XWPFRun run = (XWPFRun)let.getRuns().get(let.getRuns().size() - 1);
        if (let.getValue().getDiagnostic().getSeverity() != 4) {
            this.addValidationMessages(let, run, validationResult);
            variableLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        } else {
            variableLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
        }
        if (this.stack.peek().containsKey(let.getName())) {
            variableLevel = org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(variableLevel, org.obeonetwork.m2doc.parser.ValidationMessageLevel.WARNING);
            let.getValidationMessages().add((Object)new TemplateValidationMessage(org.obeonetwork.m2doc.parser.ValidationMessageLevel.WARNING, String.format("The variable mask an existing variable (%s).", let.getName()), run));
        }
        HashMap<String, Set<IType>> iterationVariables = new HashMap<String, Set<IType>>(this.stack.peek());
        iterationVariables.put(let.getName(), types);
        this.stack.push(iterationVariables);
        try {
            bodyLevel = (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(let.getBody()));
        }
        finally {
            this.stack.pop();
        }
        return org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(this.getHighestMessageLevel(let), variableLevel, bodyLevel);
    }

    private org.obeonetwork.m2doc.parser.ValidationMessageLevel validateRepetitionQueryType(Repetition repetition, XWPFRun run, Set<IType> types) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        for (IType type : types) {
            if (type instanceof ICollectionType) continue;
            res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
            repetition.getValidationMessages().add((Object)new TemplateValidationMessage(res, String.format("The iteration variable types must be collections (%s).", types), run));
            break;
        }
        return res;
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseQuery(Query query) {
        if (query.getQuery().getDiagnostic().getSeverity() != 4) {
            IValidationResult validationResult = this.aqlValidator.validate(this.stack.peek(), query.getQuery());
            XWPFRun run = query.getRuns().isEmpty() ? query.getStyleRun() : (XWPFRun)query.getRuns().get(query.getRuns().size() - 1);
            this.addValidationMessages(query, run, validationResult);
        }
        return this.getHighestMessageLevel(query);
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseComment(Comment comment) {
        return this.getHighestMessageLevel(comment);
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseTable(Table table) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        for (Row row : table.getRows()) {
            res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(res, (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(row)));
        }
        return res;
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseRow(Row row) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        for (Cell cell : row.getCells()) {
            res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(res, (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(cell)));
        }
        return res;
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseCell(Cell cell) {
        return (org.obeonetwork.m2doc.parser.ValidationMessageLevel)((Object)this.doSwitch(cell.getBody()));
    }

    @Override
    public org.obeonetwork.m2doc.parser.ValidationMessageLevel caseContentControl(ContentControl contentControl) {
        return org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
    }

    private void addValidationMessages(IConstruct construct, XWPFRun run, IValidationResult validationResult) {
        for (IValidationMessage message : validationResult.getMessages()) {
            org.obeonetwork.m2doc.parser.ValidationMessageLevel level = this.getLevel(message);
            construct.getValidationMessages().add((Object)new TemplateValidationMessage(level, message.getMessage(), run));
        }
    }

    private org.obeonetwork.m2doc.parser.ValidationMessageLevel getLevel(IValidationMessage message) {
        return switch (message.getLevel()) {
            case ValidationMessageLevel.INFO -> org.obeonetwork.m2doc.parser.ValidationMessageLevel.INFO;
            case ValidationMessageLevel.WARNING -> org.obeonetwork.m2doc.parser.ValidationMessageLevel.WARNING;
            case ValidationMessageLevel.ERROR -> org.obeonetwork.m2doc.parser.ValidationMessageLevel.ERROR;
            default -> org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        };
    }

    protected org.obeonetwork.m2doc.parser.ValidationMessageLevel getHighestMessageLevel(IConstruct construct) {
        org.obeonetwork.m2doc.parser.ValidationMessageLevel res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.OK;
        for (TemplateValidationMessage message : construct.getValidationMessages()) {
            res = org.obeonetwork.m2doc.parser.ValidationMessageLevel.updateLevel(res, message.getLevel());
        }
        return res;
    }
}

