/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.migrator;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.obeonetwork.m2doc.migrator.IM2DocMigrator;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.TokenType;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.Visibility;
import org.obeonetwork.m2doc.util.FieldUtils;

public class M2Doc4Migrator
implements IM2DocMigrator {
    private static final FieldUtils FIELD_UTILS = new FieldUtils();

    @Override
    public List<TemplateValidationMessage> migrate(IBody body) {
        ArrayList<TemplateValidationMessage> result = new ArrayList<TemplateValidationMessage>();
        for (IBodyElement element : body.getBodyElements()) {
            if (element instanceof XWPFParagraph) {
                result.addAll(this.migrateParagraph((XWPFParagraph)element));
                continue;
            }
            if (!(element instanceof XWPFTable)) continue;
            result.addAll(this.migrateTable((XWPFTable)element));
        }
        return result;
    }

    protected List<TemplateValidationMessage> migrateParagraph(XWPFParagraph paragraph) {
        ArrayList<TemplateValidationMessage> result = new ArrayList<TemplateValidationMessage>();
        boolean inField = false;
        boolean isM2DocInstruction = false;
        StringBuilder instructionText = null;
        ArrayList<XWPFRun> fieldRuns = null;
        for (XWPFRun run : new ArrayList(paragraph.getRuns())) {
            String runInstructionText;
            if (FIELD_UTILS.isFieldBegin(run)) {
                inField = true;
                fieldRuns = new ArrayList<XWPFRun>();
                instructionText = new StringBuilder();
            }
            if (!inField) continue;
            fieldRuns.add(run);
            if (!isM2DocInstruction && !(runInstructionText = FIELD_UTILS.readUpInstrText(run)).isEmpty()) {
                instructionText.append(runInstructionText);
                isM2DocInstruction = instructionText.indexOf("m:") > -1;
            }
            boolean bl = inField = !FIELD_UTILS.isFieldEnd(run);
            if (!FIELD_UTILS.isFieldEnd(run)) continue;
            inField = false;
            if (!isM2DocInstruction) continue;
            this.migrateField(paragraph, fieldRuns);
            isM2DocInstruction = false;
        }
        if (inField) {
            XWPFRun lastParagraphRun = (XWPFRun)paragraph.getRuns().get(paragraph.getRuns().size() - 1);
            result.add(new TemplateValidationMessage(ValidationMessageLevel.ERROR, "Multi paragraph field detected.", lastParagraphRun));
        }
        return result;
    }

    private List<TemplateValidationMessage> migrateField(XWPFParagraph paragraph, List<XWPFRun> fieldRuns) {
        ArrayList<TemplateValidationMessage> result = new ArrayList<TemplateValidationMessage>();
        XWPFRun lastRun = null;
        boolean isFirstRun = true;
        for (XWPFRun run : fieldRuns) {
            String instructionText = FIELD_UTILS.readUpInstrText(run).replace(TokenType.TEMPLATE.getValue(), TokenType.TEMPLATE.getValue() + " " + Visibility.PUBLIC.getName());
            if (FIELD_UTILS.isFieldBegin(run) || FIELD_UTILS.isFieldEnd(run) || FIELD_UTILS.isFieldSeparate(run.getCTR())) {
                int index = paragraph.getRuns().indexOf(run);
                paragraph.removeRun(index);
                continue;
            }
            lastRun = run;
            run.getCTR().setInstrTextArray(null);
            run.getCTR().setTArray(null);
            if (isFirstRun) {
                int startIndex = 0;
                while (startIndex < instructionText.length() && Character.isWhitespace(instructionText.charAt(startIndex))) {
                    ++startIndex;
                }
                run.setText("{" + instructionText.substring(startIndex));
                isFirstRun = false;
                continue;
            }
            run.setText(instructionText);
        }
        if (lastRun != null) {
            String text = lastRun.getText(0);
            int endIndex = text.length();
            while (endIndex > 0 && Character.isWhitespace(text.charAt(endIndex - 1))) {
                --endIndex;
            }
            lastRun.setText(lastRun.getText(0).substring(0, endIndex) + "}", 0);
        }
        return result;
    }

    protected List<TemplateValidationMessage> migrateTable(XWPFTable table) {
        ArrayList<TemplateValidationMessage> result = new ArrayList<TemplateValidationMessage>();
        for (XWPFTableRow row : table.getRows()) {
            for (XWPFTableCell cell : row.getTableCells()) {
                this.migrate((IBody)cell);
            }
        }
        return result;
    }
}

