/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.parser;

import java.util.Arrays;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.obeonetwork.m2doc.parser.ParsingToken;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

class RunSplit {
    private final XWPFParagraph paragraph;
    private List<ParsingToken> tokens;
    private final int runIndex;
    private final int tIndex;
    private final int charIndex;
    private final ParsingToken tokenToInsert;

    RunSplit(XWPFParagraph paragraph, List<ParsingToken> tokens, int runIndex, int tIndex, int charIndex, ParsingToken tokenToInsert) {
        this.paragraph = paragraph;
        this.tokens = tokens;
        this.runIndex = runIndex;
        this.tIndex = tIndex;
        this.charIndex = charIndex;
        this.tokenToInsert = tokenToInsert;
    }

    void split() {
        if (this.tokenToInsert == ParsingToken.START_FIELD_TOKEN) {
            if (this.tIndex == 0 && this.charIndex == 0) {
                this.doSplitStartFieldStartRun();
            } else {
                this.doSplitStartField();
            }
        } else if (this.tokenToInsert == ParsingToken.END_FIELD_TOKEN) {
            XWPFRun run = (XWPFRun)this.paragraph.getRuns().get(this.runIndex);
            CTText text = (CTText)run.getCTR().getTList().get(this.tIndex);
            if (this.tIndex == run.getCTR().getTList().size() - 1 && this.charIndex == text.getStringValue().length() - 1) {
                this.doSplitEndFieldEndRun(run, text);
            } else {
                this.doSplitEndField();
            }
        } else {
            throw new IllegalStateException("Use ParsingToken.START_FIELD_TOKEN or ParsingToken.END_FIELD_TOKEN");
        }
    }

    private void doSplitStartFieldStartRun() {
        this.tokens.add(this.runIndex, this.tokenToInsert);
    }

    private void doSplitStartField() {
        CTText[] newTArray;
        XWPFRun run = (XWPFRun)this.paragraph.getRuns().get(this.runIndex);
        XWPFRun runCopy = this.paragraph.insertNewRun(this.runIndex + 1);
        runCopy.getCTR().set(run.getCTR().copy());
        if (this.charIndex == 0) {
            newTArray = Arrays.copyOfRange(run.getCTR().getTArray(), 0, this.tIndex);
        } else {
            CTText[] tmpTArray = Arrays.copyOfRange(run.getCTR().getTArray(), 0, this.tIndex + 1);
            String stringToCut = tmpTArray[tmpTArray.length - 1].getStringValue();
            tmpTArray[tmpTArray.length - 1].setStringValue(stringToCut.substring(0, this.charIndex));
            newTArray = tmpTArray[tmpTArray.length - 1].getStringValue().isEmpty() ? Arrays.copyOfRange(tmpTArray, 1, tmpTArray.length) : tmpTArray;
        }
        run.getCTR().setTArray(newTArray);
        this.preserveSpace(newTArray);
        CTText[] newCopyTArray = Arrays.copyOfRange(runCopy.getCTR().getTArray(), this.tIndex, runCopy.getCTR().getTArray().length);
        String stringCoptyToCut = newCopyTArray[0].getStringValue();
        newCopyTArray[0].setStringValue(stringCoptyToCut.substring(this.charIndex, stringCoptyToCut.length()));
        runCopy.getCTR().setTArray(newCopyTArray);
        this.preserveSpace(newCopyTArray);
        this.tokens.add(this.runIndex + 1, this.tokenToInsert);
        this.tokens.add(this.runIndex + 2, new ParsingToken(runCopy));
    }

    private void doSplitEndFieldEndRun(XWPFRun runtoSplit, CTText textToSplit) {
        this.tokens.add(this.runIndex + 1, this.tokenToInsert);
    }

    private void doSplitEndField() {
        CTText[] newCopyTArray;
        XWPFRun run = (XWPFRun)this.paragraph.getRuns().get(this.runIndex);
        XWPFRun runCopy = this.paragraph.insertNewRun(this.runIndex + 1);
        runCopy.getCTR().set(run.getCTR().copy());
        CTText[] newTArray = Arrays.copyOfRange(run.getCTR().getTArray(), 0, this.tIndex + 1);
        String stringToCut = newTArray[newTArray.length - 1].getStringValue();
        newTArray[newTArray.length - 1].setStringValue(stringToCut.substring(0, this.charIndex + 1));
        run.getCTR().setTArray(newTArray);
        this.preserveSpace(newTArray);
        if (this.charIndex == stringToCut.length() - 1) {
            newCopyTArray = Arrays.copyOfRange(runCopy.getCTR().getTArray(), this.tIndex + 1, runCopy.getCTR().getTArray().length);
        } else {
            CTText[] tmpCopyTArray = Arrays.copyOfRange(runCopy.getCTR().getTArray(), this.tIndex, runCopy.getCTR().getTArray().length);
            String stringCoptyToCut = tmpCopyTArray[tmpCopyTArray.length - 1].getStringValue();
            tmpCopyTArray[tmpCopyTArray.length - 1].setStringValue(stringCoptyToCut.substring(this.charIndex + 1, stringCoptyToCut.length()));
            newCopyTArray = tmpCopyTArray[tmpCopyTArray.length - 1].getStringValue().isEmpty() ? Arrays.copyOfRange(tmpCopyTArray, 0, tmpCopyTArray.length - 1) : tmpCopyTArray;
        }
        runCopy.getCTR().setTArray(newCopyTArray);
        this.preserveSpace(newCopyTArray);
        this.tokens.add(this.runIndex + 1, this.tokenToInsert);
        this.tokens.add(this.runIndex + 2, new ParsingToken(runCopy));
    }

    private void preserveSpace(CTText[] ctArray) {
        int fisrtNonEmptyIndex = -1;
        int lastNonEmptyIndex = -1;
        if (ctArray.length > 0) {
            int i = 0;
            while (i < ctArray.length) {
                if (!ctArray[i].getStringValue().isEmpty()) {
                    fisrtNonEmptyIndex = i;
                    break;
                }
                ++i;
            }
            i = ctArray.length - 1;
            while (i > -1) {
                if (!ctArray[i].getStringValue().isEmpty()) {
                    lastNonEmptyIndex = i;
                    break;
                }
                --i;
            }
        }
        if (fisrtNonEmptyIndex != -1 && Character.isWhitespace(ctArray[fisrtNonEmptyIndex].getStringValue().charAt(0))) {
            ctArray[fisrtNonEmptyIndex].setSpace(SpaceAttribute.Space.PRESERVE);
        }
        if (lastNonEmptyIndex != -1 && Character.isWhitespace(ctArray[lastNonEmptyIndex].getStringValue().charAt(ctArray[lastNonEmptyIndex].getStringValue().length() - 1))) {
            ctArray[lastNonEmptyIndex].setSpace(SpaceAttribute.Space.PRESERVE);
        }
    }
}

