/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.obeonetwork.m2doc.parser.CharIterator;
import org.obeonetwork.m2doc.parser.ParsingToken;
import org.obeonetwork.m2doc.parser.RunSplit;
import org.obeonetwork.m2doc.parser.TokenIterator;

public class TokenIteratorFieldRewriter
extends TokenIterator {
    public TokenIteratorFieldRewriter(IBody inputBody) {
        super(inputBody);
    }

    @Override
    protected Iterator<ParsingToken> getParagraphIterator(XWPFParagraph paragraph) {
        List<ParsingToken> result = this.getParagraphTokens(paragraph);
        ArrayList<RunSplit> splits = new ArrayList<RunSplit>();
        boolean inField = false;
        CharIterator iterator = new CharIterator(paragraph, result);
        int startFieldMachingIndex = 0;
        RunSplit currentSplit = null;
        while (iterator.hasNext()) {
            if (inField) {
                Character lastChar = this.consuteUntilAqlExpressionEndLimit(iterator);
                if (lastChar == null || lastChar.charValue() != "}".charAt(0)) continue;
                inField = false;
                splits.add(iterator.getRunSplit(ParsingToken.END_FIELD_TOKEN));
                continue;
            }
            char currentChar = iterator.next().charValue();
            if (currentChar == "{m:".charAt(startFieldMachingIndex)) {
                if (++startFieldMachingIndex == 1) {
                    currentSplit = iterator.getRunSplit(ParsingToken.START_FIELD_TOKEN);
                    continue;
                }
                if (startFieldMachingIndex != "{m:".length()) continue;
                splits.add(currentSplit);
                inField = true;
                startFieldMachingIndex = 0;
                continue;
            }
            startFieldMachingIndex = 0;
            currentSplit = null;
        }
        int i = splits.size() - 1;
        while (i >= 0) {
            ((RunSplit)splits.get(i)).split();
            --i;
        }
        if (inField) {
            result.add(ParsingToken.MISSING_END_FIELD_TOKEN);
        }
        return result.iterator();
    }

    protected Character consuteUntilAqlExpressionEndLimit(CharIterator iterator) {
        int parenthesisDepth = 0;
        int curlyBracketDepth = 0;
        Character currentCharacter = null;
        block11: while (iterator.hasNext()) {
            currentCharacter = iterator.next();
            if (currentCharacter.charValue() == "}".charAt(0) && parenthesisDepth == 0 && curlyBracketDepth == 0) break;
            switch (currentCharacter.charValue()) {
                case '\'': {
                    boolean isEscaped = false;
                    while (iterator.hasNext()) {
                        currentCharacter = iterator.next();
                        switch (currentCharacter.charValue()) {
                            case '\\': {
                                isEscaped = !isEscaped;
                                break;
                            }
                            case '\'': {
                                if (!isEscaped) continue block11;
                                isEscaped = false;
                                break;
                            }
                            default: {
                                isEscaped = false;
                            }
                        }
                    }
                    continue block11;
                }
                case '{': {
                    ++curlyBracketDepth;
                    break;
                }
                case '}': {
                    --curlyBracketDepth;
                    break;
                }
                case '(': {
                    ++parenthesisDepth;
                    break;
                }
                case ')': {
                    --parenthesisDepth;
                    break;
                }
            }
        }
        return currentCharacter;
    }

    private List<ParsingToken> getParagraphTokens(XWPFParagraph paragraph) {
        ArrayList<ParsingToken> result = new ArrayList<ParsingToken>();
        if (paragraph.getRuns().size() == 0) {
            paragraph.createRun().setText("");
        }
        for (XWPFRun run : paragraph.getRuns()) {
            result.add(new ParsingToken(run));
        }
        return result;
    }
}

