/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;

@ServiceProvider(value="Services available to manipulate the document ifself: title, version, ....")
public class DocumentServices {
    private static final String PROPERTY_DOSNT_EXIST_FORMAT = "The property %s doesn't exist.";
    private static final String PROPERTY_ISNT_A_NUMBER_FORMAT = "The property %s isn't a number.";
    private POIXMLProperties.CustomProperties customProperties;
    private POIXMLProperties.CoreProperties coreProperties;
    private POIXMLProperties.ExtendedProperties extendedProperties;

    public void setDestinationDocument(XWPFDocument destinationDocument) {
        this.customProperties = destinationDocument.getProperties().getCustomProperties();
        this.coreProperties = destinationDocument.getProperties().getCoreProperties();
        this.extendedProperties = destinationDocument.getProperties().getExtendedProperties();
    }

    @Documentation(value="Adds a custom property with the given name and boolean value.", params={@Param(name="value", value="The boolean value."), @Param(name="propertyName", value="The custom property name.")}, result="Nothing.", examples={@Example(expression="true.addDocumentProperty('myBoolean')", result="Adds a custom propery named myBoolean with the value true.")})
    public void addDocumentProperty(boolean value, String propertyName) {
        this.customProperties.addProperty(propertyName, value);
    }

    @Documentation(value="Adds a custom property with the given name and double value.", params={@Param(name="value", value="The double value."), @Param(name="propertyName", value="The custom property name.")}, result="Nothing.", examples={@Example(expression="myDouble.addDocumentProperty('myDouble')", result="Adds a custom propery named myDouble with the reveiver value.")})
    public void addDocumentProperty(double value, String propertyName) {
        this.customProperties.addProperty(propertyName, value);
    }

    @Documentation(value="Adds a custom property with the given name and float value.", params={@Param(name="value", value="The float value."), @Param(name="propertyName", value="The custom property name.")}, result="Nothing.", examples={@Example(expression="myFloat.addDocumentProperty('myFloat')", result="Adds a custom propery named myFloat with the reveiver value.")})
    public void addDocumentProperty(float value, String propertyName) {
        this.customProperties.addProperty(propertyName, (double)value);
    }

    @Documentation(value="Adds a custom property with the given name and integer value.", params={@Param(name="value", value="The integer value."), @Param(name="propertyName", value="The custom property name.")}, result="Nothing.", examples={@Example(expression="myInteger.addDocumentProperty('myInteger')", result="Adds a custom propery named myInteger with the reveiver value.")})
    public void addDocumentProperty(int value, String propertyName) {
        this.customProperties.addProperty(propertyName, value);
    }

    @Documentation(value="Adds a custom property with the given name and long value.", params={@Param(name="value", value="The long value."), @Param(name="propertyName", value="The custom property name.")}, result="Nothing.", examples={@Example(expression="myLong.addDocumentProperty('myLong')", result="Adds a custom propery named myLong with the reveiver value.")})
    public void addDocumentProperty(long value, String propertyName) {
        this.customProperties.addProperty(propertyName, (double)value);
    }

    @Documentation(value="Adds a custom property with the given name and string value.", params={@Param(name="value", value="The string value."), @Param(name="propertyName", value="The custom property name.")}, result="Nothing.", examples={@Example(expression="'Some Value'.addDocumentProperty('myString')", result="Adds a custom propery named myString with the reveiver value.")})
    public void addDocumentProperty(String value, String propertyName) {
        this.customProperties.addProperty(propertyName, value);
    }

    @Documentation(value="Removes a custom property with the given name.", params={@Param(name="propertyName", value="The custom property name.")}, result="Nothing.", examples={@Example(expression="'MyProperty'.removeDocumentCustomProperty()", result="Removes a custom propery named MyProperty.")})
    public void removeDocumentProperty(String propertyName) {
        CTProperties underlyingCustomProperties = this.customProperties.getUnderlyingProperties();
        int index = -1;
        for (CTProperty property : underlyingCustomProperties.getPropertyList()) {
            if (propertyName.equals(property.getName())) break;
            ++index;
        }
        if (index != -1) {
            underlyingCustomProperties.removeProperty(index + 1);
        }
    }

    @Documentation(value="Gets the value of the custom property with the given name as boolean.", params={@Param(name="propertyName", value="The custom property name.")}, result="The property value as boolean.", examples={@Example(expression="'MyProperty'.getDocumentPropertyAsBoolean()", result="The property value as boolean.")})
    public boolean getDocumentPropertyAsBoolean(String propertyName) {
        boolean res;
        CTProperty property = this.customProperties.getProperty(propertyName);
        if (property != null) {
            res = property.isSetBool() ? property.getBool() : (property.isSetLpstr() ? Boolean.valueOf(property.getLpstr()) : (property.isSetLpwstr() ? Boolean.valueOf(property.getLpwstr()) : (this.documentPropertyIsNumber(propertyName) ? this.getNumberValue(property).doubleValue() != 0.0 : false)));
        } else {
            throw new IllegalArgumentException(String.format(PROPERTY_DOSNT_EXIST_FORMAT, propertyName));
        }
        return res;
    }

    @Documentation(value="Gets the value of the custom property with the given name as double.", params={@Param(name="propertyName", value="The custom property name.")}, result="The property value as double.", examples={@Example(expression="'MyProperty'.getDocumentPropertyAsDouble()", result="The property value as double.")})
    public double getDocumentPropertyAsDouble(String propertyName) {
        CTProperty property = this.customProperties.getProperty(propertyName);
        if (property == null) {
            throw new IllegalArgumentException(String.format(PROPERTY_DOSNT_EXIST_FORMAT, propertyName));
        }
        double res = this.getNumberValue(property).doubleValue();
        return res;
    }

    @Documentation(value="Gets the value of the custom property with the given name as float.", params={@Param(name="propertyName", value="The custom property name.")}, result="The property value as float.", examples={@Example(expression="'MyProperty'.getDocumentPropertyAsFloat()", result="The property value as float.")})
    public float getDocumentPropertyAsFloat(String propertyName) {
        CTProperty property = this.customProperties.getProperty(propertyName);
        if (property == null) {
            throw new IllegalArgumentException(String.format(PROPERTY_DOSNT_EXIST_FORMAT, propertyName));
        }
        float res = this.getNumberValue(property).floatValue();
        return res;
    }

    @Documentation(value="Gets the value of the custom property with the given name as integer.", params={@Param(name="propertyName", value="The custom property name.")}, result="The property value as integer.", examples={@Example(expression="'MyProperty'.getDocumentPropertyAsInteger()", result="The property value as integer.")})
    public int getDocumentPropertyAsInteger(String propertyName) {
        CTProperty property = this.customProperties.getProperty(propertyName);
        if (property == null) {
            throw new IllegalArgumentException(String.format(PROPERTY_DOSNT_EXIST_FORMAT, propertyName));
        }
        int res = this.getNumberValue(property).intValue();
        return res;
    }

    @Documentation(value="Gets the value of the custom property with the given name as long.", params={@Param(name="propertyName", value="The custom property name.")}, result="The property value as long.", examples={@Example(expression="'MyProperty'.getDocumentPropertyAsLong()", result="The property value as long.")})
    public long getDocumentPropertyAsLong(String propertyName) {
        CTProperty property = this.customProperties.getProperty(propertyName);
        if (property == null) {
            throw new IllegalArgumentException(String.format(PROPERTY_DOSNT_EXIST_FORMAT, propertyName));
        }
        long res = this.getNumberValue(property).longValue();
        return res;
    }

    @Documentation(value="Tells if the value of the custom property with the given name is a number.", params={@Param(name="propertyName", value="The custom property name.")}, result="True if the value of the custom property with the given name is a number, false otherwise.", examples={@Example(expression="'MyProperty'.getDocumentPropertyAsLong()", result="The property value as long.")})
    public boolean documentPropertyIsNumber(String propertyName) {
        boolean res;
        CTProperty property = this.customProperties.getProperty(propertyName);
        if (property != null) {
            boolean bl = res = property.isSetI1() || property.isSetI2() || property.isSetI4() || property.isSetI8() || property.isSetInt() || property.isSetR4() || property.isSetR8() || property.isSetUi1() || property.isSetUi2() || property.isSetUi4() || property.isSetUi8() || property.isSetDecimal();
            if (!res) {
                if (property.isSetLpstr()) {
                    try {
                        Integer.valueOf(property.getLpstr());
                        res = true;
                    }
                    catch (NumberFormatException e) {
                        try {
                            Double.valueOf(property.getLpwstr());
                            res = true;
                        }
                        catch (NumberFormatException e1) {
                            res = false;
                        }
                    }
                } else if (property.isSetLpwstr()) {
                    try {
                        Integer.valueOf(property.getLpwstr());
                        res = true;
                    }
                    catch (NumberFormatException e) {
                        try {
                            Double.valueOf(property.getLpwstr());
                            res = true;
                        }
                        catch (NumberFormatException e1) {
                            res = false;
                        }
                    }
                }
            }
        } else {
            res = false;
        }
        return res;
    }

    private Number getNumberValue(CTProperty property) {
        Number res;
        if (property.isSetI1()) {
            res = property.getI1();
        } else if (property.isSetI2()) {
            res = property.getI2();
        } else if (property.isSetI4()) {
            res = property.getI4();
        } else if (property.isSetI8()) {
            res = property.getI8();
        } else if (property.isSetInt()) {
            res = property.getInt();
        } else if (property.isSetR4()) {
            res = Float.valueOf(property.getR4());
        } else if (property.isSetR8()) {
            res = property.getR8();
        } else if (property.isSetUi1()) {
            res = property.getUi1();
        } else if (property.isSetUi2()) {
            res = property.getUi2();
        } else if (property.isSetUi4()) {
            res = property.getUi4();
        } else if (property.isSetUi8()) {
            res = property.getUi8();
        } else if (property.isSetDecimal()) {
            res = property.getDecimal();
        } else if (property.isSetLpstr()) {
            try {
                res = Integer.valueOf(property.getLpstr());
            }
            catch (NumberFormatException e) {
                res = Double.valueOf(property.getLpstr());
            }
        } else if (property.isSetLpwstr()) {
            try {
                res = Integer.valueOf(property.getLpwstr());
            }
            catch (NumberFormatException e) {
                res = Double.valueOf(property.getLpwstr());
            }
        } else {
            throw new IllegalArgumentException(String.format(PROPERTY_ISNT_A_NUMBER_FORMAT, property.getName()));
        }
        return res;
    }

    @Documentation(value="Gets the value of the custom property with the given name as string.", params={@Param(name="propertyName", value="The custom property name.")}, result="The property value as string.", examples={@Example(expression="'MyProperty'.getDocumentPropertyAsString()", result="The property value as string.")})
    public String getDocumentPropertyAsString(String propertyName) {
        String res;
        CTProperty property = this.customProperties.getProperty(propertyName);
        if (property != null) {
            res = property.isSetLpstr() ? property.getLpstr() : (property.isSetLpwstr() ? property.getLpwstr() : (property.isSetBool() ? Boolean.valueOf(property.getBool()).toString() : (this.documentPropertyIsNumber(propertyName) ? this.getNumberValue(property).toString() : "")));
        } else {
            throw new IllegalArgumentException(String.format(PROPERTY_DOSNT_EXIST_FORMAT, propertyName));
        }
        return res;
    }

    @Documentation(value="Tells if the custom property with the given name exists.", params={@Param(name="propertyName", value="The custom property name.")}, result="true if the custom property with the given name exists, false otherwise.", examples={@Example(expression="'MyProperty'.getDocumentPropertyAsString()", result="The property value as string.")})
    public boolean hasDocumentProperty(String propertyName) {
        return this.customProperties.contains(propertyName);
    }

    @Documentation(value="Sets the document application.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Application'.setDocumentApplication()", result="Sets the document application to My Application.")})
    public void setDocumentApplication(String value) {
        this.extendedProperties.setApplication(value);
    }

    @Documentation(value="Gets the document application.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document application.", examples={@Example(expression="''.getDocumentApplication()", result="The document application.")})
    public String getDocumentApplication(Object reveiver) {
        return this.extendedProperties.getApplication();
    }

    @Documentation(value="Sets the document appplication version.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My AppVersion'.setDocumentAppVersion()", result="Sets the document appplication version to My AppVersion.")})
    public void setDocumentAppVersion(String value) {
        this.extendedProperties.setAppVersion(value);
    }

    @Documentation(value="Gets the document appplication version.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document appplication version.", examples={@Example(expression="''.getDocumentAppVersion()", result="The document appplication version.")})
    public String getDocumentAppVersion(Object reveiver) {
        return this.extendedProperties.getAppVersion();
    }

    @Documentation(value="Sets the document company.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Company'.setDocumentCompany()", result="Sets the document company to My Company.")})
    public void setDocumentCompany(String value) {
        this.extendedProperties.setCompany(value);
    }

    @Documentation(value="Gets the document company.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document company.", examples={@Example(expression="''.getDocumentCompany()", result="The document company.")})
    public String getDocumentCompany(Object reveiver) {
        return this.extendedProperties.getCompany();
    }

    @Documentation(value="Sets the document manager.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Manager'.setDocumentManager()", result="Sets the document manager to My Manager.")})
    public void setDocumentManager(String value) {
        this.extendedProperties.setManager(value);
    }

    @Documentation(value="Gets the document manager.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document manager.", examples={@Example(expression="''.getDocumentManager()", result="The document manager.")})
    public String getDocumentManager(Object reveiver) {
        return this.extendedProperties.getManager();
    }

    @Documentation(value="Sets the document category.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Category'.setDocumentCategory()", result="Sets the document category to My Category.")})
    public void setDocumentCategory(String value) {
        this.coreProperties.setCategory(value);
    }

    @Documentation(value="Gets the document category.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document category.", examples={@Example(expression="''.getDocumentCategory()", result="The document category.")})
    public String getDocumentCategory(Object reveiver) {
        return this.coreProperties.getCategory();
    }

    @Documentation(value="Sets the document content status.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My ContentStatus'.setDocumentContentStatus()", result="Sets the document content status to My ContentStatus.")})
    public void setDocumentContentStatus(String value) {
        this.coreProperties.setContentStatus(value);
    }

    @Documentation(value="Gets the document content status.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document content status.", examples={@Example(expression="''.getDocumentContentStatus()", result="The document content status.")})
    public String getDocumentContentStatus(Object reveiver) {
        return this.coreProperties.getContentStatus();
    }

    @Documentation(value="Sets the document content type.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My ContentType'.setDocumentContentType()", result="Sets the document content type to My ContentType.")})
    public void setDocumentContentType(String value) {
        this.coreProperties.setContentType(value);
    }

    @Documentation(value="Gets the document content type.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document content type.", examples={@Example(expression="''.getDocumentContentType()", result="The document content type.")})
    public String getDocumentContentType(Object reveiver) {
        return this.coreProperties.getContentType();
    }

    @Documentation(value="Sets the document creator.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Creator'.setDocumentCreator()", result="Sets the document creator to My Creator.")})
    public void setDocumentCreator(String value) {
        this.coreProperties.setCreator(value);
    }

    @Documentation(value="Gets the document creator.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document creator.", examples={@Example(expression="''.getDocumentCreator()", result="The document creator.")})
    public String getDocumentCreator(Object reveiver) {
        return this.coreProperties.getCreator();
    }

    @Documentation(value="Sets the document description.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Description'.setDocumentDescription()", result="Sets the document description to My Description.")})
    public void setDocumentDescription(String value) {
        this.coreProperties.setDescription(value);
    }

    @Documentation(value="Gets the document description.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document description.", examples={@Example(expression="''.getDocumentDescription()", result="The document description.")})
    public String getDocumentDescription(Object reveiver) {
        return this.coreProperties.getDescription();
    }

    @Documentation(value="Sets the document identifier.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Identifier'.setDocumentIdentifier()", result="Sets the document identifier to My Identifier.")})
    public void setDocumentIdentifier(String value) {
        this.coreProperties.setIdentifier(value);
    }

    @Documentation(value="Gets the document identifier.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document identifier.", examples={@Example(expression="''.getDocumentIdentifier()", result="The document identifier.")})
    public String getDocumentIdentifier(Object reveiver) {
        return this.coreProperties.getIdentifier();
    }

    @Documentation(value="Sets the document keywords.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Keywords'.setDocumentKeywords()", result="Sets the document keywords to My Keywords.")})
    public void setDocumentKeywords(String value) {
        this.coreProperties.setKeywords(value);
    }

    @Documentation(value="Gets the document keywords.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document keywords.", examples={@Example(expression="''.getDocumentKeywords()", result="The document keywords.")})
    public String getDocumentKeywords(Object reveiver) {
        return this.coreProperties.getKeywords();
    }

    @Documentation(value="Sets the document revision.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Revision'.setDocumentRevision()", result="Sets the document revision to My Revision.")})
    public void setDocumentRevision(String value) {
        this.coreProperties.setRevision(value);
    }

    @Documentation(value="Gets the document revision.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document revision.", examples={@Example(expression="''.getDocumentRevision()", result="The document revision.")})
    public String getDocumentRevision(Object reveiver) {
        return this.coreProperties.getRevision();
    }

    @Documentation(value="Sets the document subject.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Subject'.setDocumentSubject()", result="Sets the document subject to My Subject.")})
    public void setDocumentSubject(String value) {
        this.coreProperties.setSubjectProperty(value);
    }

    @Documentation(value="Gets the document subject.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document subject.", examples={@Example(expression="''.getDocumentSubject()", result="The document subject.")})
    public String getDocumentSubject(Object reveiver) {
        return this.coreProperties.getSubject();
    }

    @Documentation(value="Sets the document title.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Title'.setDocumentTitle()", result="Sets the document title to My Title.")})
    public void setDocumentTitle(String value) {
        this.coreProperties.setTitle(value);
    }

    @Documentation(value="Gets the document title.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document title.", examples={@Example(expression="''.getDocumentTitle()", result="The document title.")})
    public String getDocumentTitle(Object reveiver) {
        return this.coreProperties.getTitle();
    }

    @Documentation(value="Sets the document version.", params={@Param(name="value", value="The value.")}, result="Nothing.", examples={@Example(expression="'My Version'.setDocumentVersion()", result="Sets the document version to My Version.")})
    public void setDocumentVersion(String value) {
        this.coreProperties.setVersion(value);
    }

    @Documentation(value="Gets the document version.", params={@Param(name="reveiver", value="Any receiver object.")}, result="The document version.", examples={@Example(expression="''.getDocumentVersion()", result="The document version.")})
    public String getDocumentVersion(Object reveiver) {
        return this.coreProperties.getVersion();
    }
}

