/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.obeonetwork.m2doc.element.MBookmark;
import org.obeonetwork.m2doc.element.MHyperLink;
import org.obeonetwork.m2doc.element.impl.MBookmarkImpl;
import org.obeonetwork.m2doc.element.impl.MHyperLinkImpl;

@ServiceProvider(value="Services available for links. See [document examples](https://github.com/ObeoNetwork/M2Doc/tree/master/tests/org.obeonetwork.m2doc.tests/resources/linkServices).")
public class LinkServices {
    @Documentation(value="Converts a String to an hyperlink", params={@Param(name="text", value="The label of the link"), @Param(name="url", value="The destination of the link")}, result="A link with the given label that point to the given url.", examples={@Example(expression="'My website'.asLink('https://www.example.org')", result="a link to https://www.example.org with the label My website")})
    public MHyperLink asLink(String text, String url) {
        return this.asLink(text, url, null);
    }

    @Documentation(value="Converts a String to an hyperlink", params={@Param(name="text", value="The label of the link"), @Param(name="url", value="The destination of the link"), @Param(name="toolTip", value="The tool tip of the link")}, result="A link with the given label that point to the given url.", examples={@Example(expression="'My website'.asLink('https://www.example.org', 'My tool tip')", result="a link to https://www.example.org with the label My website with a tool tip")})
    public MHyperLink asLink(String text, String url, String toolTip) {
        String localText = text != null ? text : "";
        String localURL = url != null ? url : "";
        return new MHyperLinkImpl(localText, null, localURL, toolTip);
    }

    @Documentation(value="Converts a String to a bookmark declaration", params={@Param(name="text", value="The label of the bookmark declaration"), @Param(name="id", value="The ID of the bookmark declaration")}, result="A bookmark declaration with the given label and ID.", examples={@Example(expression="'Definition of Artifact1'.asBookmark('Art1')", result="a bookmark with the ID 'Art1' the label 'Definition of Artifact1'")})
    public MBookmark asBookmark(String text, String id) {
        return new MBookmarkImpl(text, id, false);
    }

    @Documentation(value="Converts a String to a bookmark reference", params={@Param(name="text", value="The label of the bookmark reference"), @Param(name="id", value="The ID of the bookmark reference")}, result="A bookmark reference with the given label and ID.", examples={@Example(expression="'Artifact1'.asBookmarkRef('Art1')", result="a bookmark reference with the ID 'Art1' the label 'Artifact1'")})
    public MBookmark asBookmarkRef(String text, String id) {
        return this.asBookmarkRef(text, id, false);
    }

    @Documentation(value="Converts a String to a bookmark reference", params={@Param(name="text", value="The label of the bookmark reference"), @Param(name="id", value="The ID of the bookmark reference"), @Param(name="optional", value="If true, this reference will only generate the text if the corresponding bookmark doesn't exists")}, result="A bookmark reference with the given label and ID.", examples={@Example(expression="'Artifact1'.asBookmarkRef('Art1', true)", result="a bookmark reference with the ID 'Art1' the label 'Artifact1' only if a bookmark with ID 'Art1' exists, otherwise only the label 'Artifact1'")})
    public MBookmark asBookmarkRef(String text, String id, boolean optional) {
        MBookmarkImpl res = new MBookmarkImpl(text, id, true);
        res.setOptional(optional);
        return res;
    }
}

