/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MElementContainer;
import org.obeonetwork.m2doc.element.MPagination;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.impl.MParagraphImpl;
import org.obeonetwork.m2doc.element.impl.MTableImpl;
import org.obeonetwork.m2doc.element.impl.MTextImpl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumbering;

@ServiceProvider(value="Services available for pagination. See [document examples](https://github.com/ObeoNetwork/M2Doc/tree/master/tests/org.obeonetwork.m2doc.tests/resources/paginationServices).")
public class PaginationServices {
    private final Map<String, String> textStyleIDs = new HashMap<String, String>();
    private final Map<String, String> tableStyleIDs = new HashMap<String, String>();
    private final Map<BigInteger, BigInteger> numberingIDs = new HashMap<BigInteger, BigInteger>();

    public PaginationServices(URIConverter uriConverter, URI templateURI) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(uriConverter, templateURI);){
                List<XWPFStyle> styles = this.getStyles(document.getStyles());
                for (XWPFStyle style : styles) {
                    switch (style.getType().intValue()) {
                        case 1: {
                            this.textStyleIDs.put(style.getStyleId(), style.getName());
                            break;
                        }
                        case 3: {
                            this.tableStyleIDs.put(style.getStyleId(), style.getName());
                            break;
                        }
                    }
                }
                if (document.getNumbering() != null) {
                    CTNumbering numbering = PaginationServices.getCTNumbering(document.getNumbering());
                    for (CTAbstractNum num : numbering.getAbstractNumList()) {
                        BigInteger id = num.getAbstractNumId().add(BigInteger.valueOf(1L));
                        BigInteger maxLevel = BigInteger.valueOf(num.getLvlList().size());
                        this.numberingIDs.put(id, maxLevel);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<XWPFStyle> getStyles(XWPFStyles styles) {
        ArrayList<XWPFStyle> res = new ArrayList<XWPFStyle>();
        Field[] fieldArray = styles.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ("listStyle".equals(field.getName())) {
                try {
                    field.setAccessible(true);
                    res.addAll((List)field.get(styles));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("can't retreive style names.", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("can't retreive style names.", e);
                }
                finally {
                    field.setAccessible(false);
                }
            }
            ++n2;
        }
        return res;
    }

    public static CTNumbering getCTNumbering(XWPFNumbering numbering) {
        CTNumbering res = null;
        Field[] fieldArray = numbering.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ("ctNumbering".equals(field.getName())) {
                try {
                    field.setAccessible(true);
                    res = (CTNumbering)field.get(numbering);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("can't retreive numbering IDs.", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("can't retreive numbering IDs.", e);
                }
                finally {
                    field.setAccessible(false);
                }
            }
            ++n2;
        }
        return res;
    }

    @Documentation(value="Converts a String to an hyperlink", params={@Param(name="paginationElement", value="The name of the pagination element: 'newTableOfContent', 'newPage', 'newParagraph', 'newColumn', 'newTextWrapping'")}, result="Insert the element.", examples={@Example(expression="'newPage'.asPagination()", result="insert a page break")})
    public MPagination asPagination(String paginationElement) {
        return MPagination.valueOf(paginationElement);
    }

    @Documentation(value="Converts a String with a given style if the style exists in the template, this service will insert a new paragraph. You can add styled text in comment to make sure they are present.", params={@Param(name="text", value="The text"), @Param(name="style", value="The style ID. see availableTextStyles().")}, result="Insert the given text as the given style.", examples={@Example(expression="'Section 1'.asStyle('Title1')", result="insert 'Section 1' as style 'Titre1' in a new paragraph if the style exists in the template.")})
    public MParagraph asStyle(String text, String styleID) {
        String styleName = this.textStyleIDs.get(styleID);
        if (styleName != null) {
            return new MParagraphImpl(new MTextImpl(text, null), styleID);
        }
        throw new IllegalArgumentException("no text style " + styleID);
    }

    @Documentation(value="Lists available text styles in the template. You can add styled text in comment to make sure a style is present.", params={@Param(name="obj", value="Any object")}, result="List available text styles in the template.", examples={@Example(expression="''.availableTextStyles()", result="insert 'List of available text styles:...'.")})
    public List<MParagraph> availableTextStyles(Object obj) {
        ArrayList<MParagraph> res = new ArrayList<MParagraph>();
        res.add(new MParagraphImpl(new MTextImpl("List of available text styles:", null), null));
        for (String styleID : this.textStyleIDs.keySet()) {
            res.add(this.asStyle(styleID, styleID));
        }
        return res;
    }

    @Documentation(value="Converts a MTable with a given style if the style exists in the template. You can add styled text in blockcomment to make sure they are present.", params={@Param(name="table", value="The MTable"), @Param(name="styleID", value="The style ID. see availableTableStyles().")}, result="Apply the given style to the given table.", examples={@Example(expression="myTable.asStyle('Title1')", result="set the given style to myTable.")})
    public MTable asStyle(MTable table, String styleID) {
        String styleName = this.tableStyleIDs.get(styleID);
        if (styleName != null) {
            table.setStyleID(styleID);
            return table;
        }
        throw new IllegalArgumentException("no table style " + styleID);
    }

    @Documentation(value="Lists available table styles in the template. You can add styled table in comment to make sure a style is present.", params={@Param(name="obj", value="Any object")}, result="List available table styles in the template.", examples={@Example(expression="''.availableTableStyles()", result="insert 'List of available table styles:...'.")})
    public List<MElement> availableTableStyles(Object obj) {
        ArrayList<MElement> res = new ArrayList<MElement>();
        res.add(new MParagraphImpl(new MTextImpl("List of available table styles:", null), null));
        for (String styleID : this.tableStyleIDs.keySet()) {
            res.add(this.asStyle(this.styledTable(styleID), styleID));
        }
        return res;
    }

    private MTable styledTable(String styleID) {
        MTableImpl res = new MTableImpl();
        res.setStyleID(styleID);
        int i = 0;
        while (i < 3) {
            MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
            res.getRows().add(row);
            int j = 0;
            while (j < 3) {
                row.getCells().add(new MTableImpl.MCellImpl(new MTextImpl(styleID, null), null));
                ++j;
            }
            ++i;
        }
        return res;
    }

    @Documentation(value="Lists available numbering IDs in the template. You can add bullet/numbered list in comment to make sure a numbering is present.", params={@Param(name="obj", value="Any object")}, result="List available numbering IDs in the template.", examples={@Example(expression="''.availableNumberingIDs()", result="insert 'List of available numbering IDs:...'.")})
    public List<MParagraph> availableNumberingIDs(Object obj) {
        ArrayList<MParagraph> res = new ArrayList<MParagraph>();
        res.add(new MParagraphImpl(new MTextImpl("List of available numbering IDs:", null), null));
        for (Map.Entry<BigInteger, BigInteger> entry : this.numberingIDs.entrySet()) {
            long level = 0L;
            while (level < entry.getValue().longValue()) {
                MParagraphImpl paragraph = new MParagraphImpl(new MTextImpl(String.valueOf("ID: " + String.valueOf(entry.getKey()) + " Level: " + level), null), null);
                paragraph.setNumberingID(entry.getKey().longValue());
                paragraph.setNumberingLevel(level);
                res.add(paragraph);
                ++level;
            }
        }
        return res;
    }

    @Documentation(value="Convert a String into a MParagraph.", params={@Param(name="text", value="The text")}, result="Convert a String into a MParagraph.", examples={@Example(expression="'some text'.asParagraph()", result="insert 'some text' in a new paragraph.")})
    public MParagraph asParagraph(String text) {
        return new MParagraphImpl(new MTextImpl(text, null), null);
    }

    @Documentation(value="Sets the style of the paragraph.", params={@Param(name="paragraph", value="The paragraph"), @Param(name="styleID", value="The style ID. see availableTextStyles().")}, result="Sets the style of the paragraph.", examples={@Example(expression="myParagraph.setStyle('Title1')", result="Sets the style to Title1.")})
    public MParagraph setStyle(MParagraph paragraph, String styleID) {
        String styleName = this.textStyleIDs.get(styleID);
        if (styleName != null) {
            paragraph.setStyleName(styleID);
            return paragraph;
        }
        throw new IllegalArgumentException("no text style " + styleID);
    }

    @Documentation(value="Sets the alignment of the paragraph.", params={@Param(name="paragraph", value="The paragraph"), @Param(name="alignment", value="The alignment name: 'BOTH', 'CENTER', 'DISTRIBUTED', 'HIGH_KASHIDA', 'LEFT', 'LOW_KASHIDA', 'MEDIUM_KASHIDA', 'NUM_TAB', 'RIGHT', 'THAI_DISTRIBUTE'.")}, result="Sets the alignement of the paragraph.", examples={@Example(expression="myParagraph.setAlignment('CENTER')", result="Sets the alignment to center.")})
    public MParagraph setAlignment(MParagraph paragraph, String alignment) {
        paragraph.setHAlignment(MElementContainer.HAlignment.valueOf(alignment));
        return paragraph;
    }

    @Documentation(value="Sets the numbering and level of the paragraph.", params={@Param(name="paragraph", value="The paragraph"), @Param(name="numberingID", value="The integer idenfying the numbering. see availableNumberingIDs()."), @Param(name="level", value="The level in the numbering. see availableNumberingIDs().")}, result="Sets the numbering and level on the paragraph.", examples={@Example(expression="myParagraph.setNumbering(0, 3)", result="Sets the numbering to the 0 numbering and level to 3 in this numbering.")})
    public MParagraph setNumbering(MParagraph paragraph, Integer numberingID, Integer level) {
        BigInteger maxLevel = this.numberingIDs.get(BigInteger.valueOf(numberingID.intValue()));
        if (maxLevel != null) {
            if (maxLevel.longValue() <= (long)level.intValue()) {
                throw new IllegalArgumentException("maximum level for numbering with ID " + String.valueOf(numberingID) + " is " + String.valueOf(maxLevel.subtract(BigInteger.ONE)) + ", " + String.valueOf(level) + " is too high.");
            }
        } else {
            throw new IllegalArgumentException("no numbering with ID " + String.valueOf(numberingID));
        }
        paragraph.setNumberingID((long)numberingID);
        paragraph.setNumberingLevel((long)level);
        return paragraph;
    }
}

