/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.generator.M2DocValidator;
import org.obeonetwork.m2doc.generator.TemplateValidationGenerator;
import org.obeonetwork.m2doc.migrator.IM2DocMigrator;
import org.obeonetwork.m2doc.migrator.M2Doc4Migrator;
import org.obeonetwork.m2doc.migrator.Version;
import org.obeonetwork.m2doc.parser.BodyGeneratedParser;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.M2DocParser;
import org.obeonetwork.m2doc.parser.ParsingErrorMessage;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.TokenType;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.services.BooleanServices;
import org.obeonetwork.m2doc.services.DocumentServiceConfigurator;
import org.obeonetwork.m2doc.services.ExcelServices;
import org.obeonetwork.m2doc.services.ImageServices;
import org.obeonetwork.m2doc.services.LinkServices;
import org.obeonetwork.m2doc.services.PaginationServices;
import org.obeonetwork.m2doc.services.configurator.IServicesConfigurator;
import org.obeonetwork.m2doc.services.configurator.IServicesConfiguratorDescriptor;
import org.obeonetwork.m2doc.services.configurator.ServicesConfiguratorDescriptor;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.TemplatePackage;
import org.obeonetwork.m2doc.util.ECrossReferenceAdapterCrossReferenceProvider;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.obeonetwork.m2doc.util.ResourceSetRootEObjectProvider;
import org.obeonetwork.m2doc.util.SampleTemplateGenerator;

public final class M2DocUtils {
    public static final String VERSION = "4.0.0";
    public static final String PLUGIN_ID = "org.obeonetwork.m2doc";
    public static final String M = "m:";
    public static final String FIELD_START = "{";
    public static final String M_FIELD_START = "{m:";
    public static final String FIELD_END = "}";
    public static final String INFO_COLOR = "0000FF";
    public static final String WARNING_COLOR = "FFA500";
    public static final String ERROR_COLOR = "FF0000";
    public static final String DOCX_EXTENSION_FILE = "docx";
    public static final String TEMPLATE_URI_OPTION = "TemplateURI";
    public static final String RESULT_URI_OPTION = "ResultURI";
    public static final String VALIDATION_URI_OPTION = "ValidationURI";
    public static final String UPDATE_FIELDS_OPTION = "UpdateFields";
    public static final String INSTALL_CROSS_REFERENCE_ADAPTER_OPTION = "InstallCrossReferenceAdapter";
    public static final String IGNORE_VERSION_CHECK_OPTION = "IgnoreVersionCheck";
    public static final String BLANK_SEPARATOR = "    ";
    public static final String LOCATION_SEPARATOR = "<---";
    private static final List<IServicesConfiguratorDescriptor> CONFIGURATORS = new ArrayList<IServicesConfiguratorDescriptor>();
    private static final int LOAD_TEMPLATE_MONITOR_WORK = 20;
    private static final int PARSE_TEMPLATE_CUSTOM_PROPERTIES_MONITOR_WORK = 5;
    private static final int PARSE_TEMPLATE_MONITOR_WORK = 30;
    private static final int TOTAL_PARSE_MONITOR_WORK = 55;
    private static final int INIT_DEST_DOC_MONITOR_WORK = 20;
    private static final int ENGINE_INIT_MONITOR_WORK = 5;
    private static final int TEMPLATE_SERVICES_MONITOR_WORK = 10;
    private static final int LOST_FILES_MONITOR_WORK = 10;
    private static final int DOCUMENT_SAVE_MONITOR_WORK = 20;
    private static final int ENGINE_CLEAN_MONITOR_WORK = 5;
    private static final int TOTAL_GENERATE_MONITOR_WORK = 95;
    private static final Map<Object, ECrossReferenceAdapter> CROSS_REFERENCE_ADAPTERS = new HashMap<Object, ECrossReferenceAdapter>();

    static {
        M2DocUtils.registerServicesConfigurator(new ServicesConfiguratorDescriptor(new DocumentServiceConfigurator()));
    }

    private M2DocUtils() {
    }

    public static TemplateValidationMessage appendMessageRun(XWPFParagraph paragraph, ValidationMessageLevel level, String message) {
        XWPFRun run = paragraph.createRun();
        M2DocUtils.setRunMessage(run, level, "    <---" + message);
        return new TemplateValidationMessage(level, message, run);
    }

    public static List<TemplateValidationMessage> appendDiagnosticMessage(XWPFParagraph paragraph, Diagnostic diagnostic) {
        ArrayList<TemplateValidationMessage> res = new ArrayList<TemplateValidationMessage>();
        for (Diagnostic child : diagnostic.getChildren()) {
            switch (child.getSeverity()) {
                case 1: {
                    res.add(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.INFO, M2DocUtils.getMessageWithException(child)));
                    break;
                }
                case 2: {
                    res.add(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.WARNING, M2DocUtils.getMessageWithException(child)));
                    break;
                }
                case 4: {
                    res.add(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, M2DocUtils.getMessageWithException(child)));
                    break;
                }
                default: {
                    res.add(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.INFO, M2DocUtils.getMessageWithException(child)));
                }
            }
            ((XWPFRun)paragraph.getRuns().get(paragraph.getRuns().size() - 1)).addBreak();
            if (child.getChildren().isEmpty()) continue;
            res.addAll(M2DocUtils.appendDiagnosticMessage(paragraph, child));
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getMessageWithException(Diagnostic diagnostic) {
        Throwable exception = diagnostic.getException() != null ? diagnostic.getException().getCause() : null;
        if (exception == null) return diagnostic.getMessage();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                String res;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    try (PrintWriter printWriter = new PrintWriter(out);){
                        exception.printStackTrace(printWriter);
                        printWriter.flush();
                        out.flush();
                        res = diagnostic.getMessage() + "\n" + new String(out.toByteArray());
                    }
                    if (out == null) return res;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
                return res;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return diagnostic.getMessage();
        }
    }

    public static TemplateValidationMessage insertMessageAfter(XWPFRun run, ValidationMessageLevel level, String message) {
        IRunBody parent = run.getParent();
        if (parent instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)parent;
            XWPFRun newRun = paragraph.insertNewRun(paragraph.getRuns().indexOf(run));
            M2DocUtils.setRunMessage(newRun, level, message);
            return new TemplateValidationMessage(level, message, newRun);
        }
        throw new IllegalStateException("this should not happend");
    }

    public static TemplateValidationMessage setRunMessage(XWPFRun run, ValidationMessageLevel level, String message) {
        run.setText(message);
        run.setBold(true);
        run.setColor(M2DocUtils.getColor(level));
        return new TemplateValidationMessage(level, message, run);
    }

    public static String getColor(ValidationMessageLevel level) {
        return switch (level) {
            case ValidationMessageLevel.INFO -> INFO_COLOR;
            case ValidationMessageLevel.WARNING -> WARNING_COLOR;
            case ValidationMessageLevel.ERROR -> ERROR_COLOR;
            default -> INFO_COLOR;
        };
    }

    public static void validationError(IConstruct construct, String msg) {
        XWPFRun lastRun = (XWPFRun)construct.getRuns().get(construct.getRuns().size() - 1);
        construct.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, msg, lastRun));
    }

    public static void validationWarning(IConstruct construct, String msg) {
        XWPFRun lastRun = (XWPFRun)construct.getRuns().get(construct.getRuns().size() - 1);
        construct.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.WARNING, msg, lastRun));
    }

    public static void validationInfo(IConstruct construct, String msg) {
        XWPFRun lastRun = (XWPFRun)construct.getRuns().get(construct.getRuns().size() - 1);
        construct.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.INFO, msg, lastRun));
    }

    public static String message(ParsingErrorMessage message, Object ... objects) {
        return MessageFormat.format(message.getMessage(), objects);
    }

    public static IQueryEnvironment getQueryEnvironment(ResourceSet resourceSetForModels, URI templateURI, Map<String, String> options) {
        ECrossReferenceAdapterCrossReferenceProvider crossReferenceProvider = new ECrossReferenceAdapterCrossReferenceProvider(ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSetForModels));
        ResourceSetRootEObjectProvider rootProvider = new ResourceSetRootEObjectProvider(resourceSetForModels);
        return M2DocUtils.getQueryEnvironment(resourceSetForModels, crossReferenceProvider, rootProvider, templateURI, options);
    }

    public static IQueryEnvironment getQueryEnvironment(ResourceSet resourceSetForModels, CrossReferenceProvider crossReferenceProvider, IRootEObjectProvider rootProvider, URI templateURI, Map<String, String> options) {
        IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices((CrossReferenceProvider)crossReferenceProvider, (IRootEObjectProvider)rootProvider);
        M2DocUtils.prepareEnvironmentServices(queryEnvironment, resourceSetForModels, templateURI, options);
        return queryEnvironment;
    }

    public static void prepareEnvironmentServices(IQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels, URI templateURI, Map<String, String> options) {
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, BooleanServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, LinkServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, (Object)new PaginationServices(resourceSetForModels.getURIConverter(), templateURI));
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, (Object)new ImageServices(resourceSetForModels.getURIConverter(), templateURI));
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, (Object)new ExcelServices(resourceSetForModels.getURIConverter(), templateURI));
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
            ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, configurator.getServices((IReadOnlyQueryEnvironment)queryEnvironment, resourceSetForModels, options));
        }
    }

    public static DocumentTemplate parse(URIConverter uriConverter, URI templateURI, IQueryEnvironment queryEnvironment, IClassProvider classProvider, Monitor monitor) throws DocumentParserException {
        DocumentTemplate result = (DocumentTemplate)EcoreUtil.create((EClass)TemplatePackage.Literals.DOCUMENT_TEMPLATE);
        ResourceImpl r = new ResourceImpl(templateURI);
        try {
            try {
                monitor.beginTask("Parsing " + String.valueOf(templateURI), 55);
                monitor.subTask("Loading template");
                InputStream is = uriConverter.createInputStream(templateURI);
                OPCPackage oPackage = OPCPackage.open((InputStream)is);
                XWPFDocument document = new XWPFDocument(oPackage);
                M2DocUtils.nextSubTask(monitor, 20, "Parsing template custom properties");
                List<TemplateValidationMessage> messages = M2DocUtils.parseTemplateCustomProperties(queryEnvironment, classProvider, document);
                r.getContents().add((Object)result);
                M2DocUtils.nextSubTask(monitor, 5, "Parsing template body");
                int unitOfWork = 30 / (1 + document.getFooterList().size() + document.getHeaderList().size());
                M2DocParser parser = new M2DocParser((IBody)document, queryEnvironment);
                Block documentBody = parser.parseBlock((List<Template>)result.getTemplates(), TokenType.EOF);
                for (TemplateValidationMessage validationMessage : messages) {
                    documentBody.getValidationMessages().add((Object)validationMessage);
                }
                result.setBody(documentBody);
                result.setInputStream(is);
                result.setOpcPackage(oPackage);
                result.setDocument(document);
                M2DocUtils.nextSubTask(monitor, unitOfWork, "Parsing template footers");
                for (XWPFFooter footer : document.getFooterList()) {
                    M2DocParser footerParser = new M2DocParser((IBody)footer, queryEnvironment);
                    result.getFooters().add((Object)footerParser.parseBlock(null, TokenType.EOF));
                    monitor.worked(unitOfWork);
                }
                M2DocUtils.nextSubTask(monitor, 0, "Parsing template headers");
                for (XWPFHeader header : document.getHeaderList()) {
                    M2DocParser headerParser = new M2DocParser((IBody)header, queryEnvironment);
                    result.getHeaders().add((Object)headerParser.parseBlock(null, TokenType.EOF));
                    monitor.worked(unitOfWork);
                }
            }
            catch (IOException e) {
                throw new DocumentParserException("Unable to open " + String.valueOf(templateURI), e);
            }
            catch (InvalidFormatException e1) {
                throw new DocumentParserException("Invalid .docx format " + String.valueOf(templateURI), e1);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static List<TemplateValidationMessage> parseTemplateCustomProperties(IQueryEnvironment queryEnvironment, IClassProvider classProvider, XWPFDocument document) {
        TemplateValidationMessage validationMessage;
        XWPFRun run;
        TemplateCustomProperties properties = new TemplateCustomProperties(document);
        ArrayList<TemplateValidationMessage> messages = new ArrayList<TemplateValidationMessage>();
        List<String> missingNsURIs = properties.configureQueryEnvironmentWithResult(queryEnvironment);
        for (String string : missingNsURIs) {
            XWPFRun run2 = M2DocUtils.getOrCreateFirstRun(document);
            TemplateValidationMessage validationMessage2 = new TemplateValidationMessage(ValidationMessageLevel.ERROR, "can't find EPackage: " + string, run2);
            messages.add(validationMessage2);
        }
        for (Map.Entry entry : properties.getServiceClasses().entrySet()) {
            try {
                Class<?> cls = classProvider.getClass((String)entry.getKey(), (String)entry.getValue());
                Set s = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, cls);
                ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)s);
            }
            catch (ClassNotFoundException e) {
                run = M2DocUtils.getOrCreateFirstRun(document);
                validationMessage = new TemplateValidationMessage(ValidationMessageLevel.ERROR, "can't load service class: " + (String)entry.getKey(), run);
                messages.add(validationMessage);
            }
        }
        List<String> list = properties.configureQueryEnvironmentWithResult(queryEnvironment, classProvider);
        for (String notLoadedClass : list) {
            run = M2DocUtils.getOrCreateFirstRun(document);
            validationMessage = new TemplateValidationMessage(ValidationMessageLevel.ERROR, "can't load service class: " + notLoadedClass, run);
            messages.add(validationMessage);
        }
        return messages;
    }

    public static XWPFRun getOrCreateFirstRun(XWPFDocument document) {
        XWPFParagraph paragraph = !document.getParagraphs().isEmpty() ? (XWPFParagraph)document.getParagraphs().get(0) : document.createParagraph();
        XWPFRun res = !paragraph.getRuns().isEmpty() ? (XWPFRun)paragraph.getRuns().get(0) : paragraph.createRun();
        return res;
    }

    public static DocumentTemplate parseUserContent(URIConverter uriConverter, URI documentURI, IQueryEnvironment queryEnvironment) throws DocumentParserException {
        DocumentTemplate result = (DocumentTemplate)EcoreUtil.create((EClass)TemplatePackage.Literals.DOCUMENT_TEMPLATE);
        ResourceImpl r = new ResourceImpl(documentURI);
        try {
            InputStream is = uriConverter.createInputStream(documentURI);
            OPCPackage oPackage = OPCPackage.open((InputStream)is);
            XWPFDocument document = new XWPFDocument(oPackage);
            r.getContents().add((Object)result);
            BodyGeneratedParser parser = new BodyGeneratedParser((IBody)document, queryEnvironment);
            result.setBody(parser.parseBlock(null, TokenType.EOF));
            result.setInputStream(is);
            result.setOpcPackage(oPackage);
            result.setDocument(document);
            for (XWPFFooter footer : document.getFooterList()) {
                BodyGeneratedParser footerParser = new BodyGeneratedParser((IBody)footer, queryEnvironment);
                result.getFooters().add((Object)footerParser.parseBlock(null, TokenType.EOF));
            }
            for (XWPFHeader header : document.getHeaderList()) {
                BodyGeneratedParser headerParser = new BodyGeneratedParser((IBody)header, queryEnvironment);
                result.getHeaders().add((Object)headerParser.parseBlock(null, TokenType.EOF));
            }
        }
        catch (IOException e) {
            throw new DocumentParserException("Unable to open " + String.valueOf(documentURI), e);
        }
        catch (InvalidFormatException e1) {
            throw new DocumentParserException("Invalid .docx format " + String.valueOf(documentURI), e1);
        }
        return result;
    }

    public static ValidationMessageLevel validate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment, Monitor monitor) {
        return M2DocUtils.validate(documentTemplate, queryEnvironment, false, monitor);
    }

    public static ValidationMessageLevel validate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment, boolean ignoreVersionCheck, Monitor monitor) {
        M2DocValidator validator = new M2DocValidator();
        return validator.validate(documentTemplate, queryEnvironment, ignoreVersionCheck, monitor);
    }

    public static void serializeValidatedDocumentTemplate(URIConverter uriConverter, DocumentTemplate documentTemplate, URI destination) throws IOException {
        TemplateValidationGenerator generator = new TemplateValidationGenerator();
        generator.doSwitch(documentTemplate);
        POIServices.getInstance().saveFile(uriConverter, documentTemplate.getDocument(), destination);
    }

    @Deprecated
    public static GenerationResult generate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment, Map<String, Object> variables, ResourceSet resourceSetForModels, URI destination, Monitor monitor) throws DocumentGenerationException {
        return M2DocUtils.generate(documentTemplate, queryEnvironment, variables, resourceSetForModels, destination, false, monitor);
    }

    /*
     * Exception decompiling
     */
    public static GenerationResult generate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment, Map<String, Object> variables, ResourceSet resourceSetForModels, URI destination, boolean updateFields, Monitor monitor) throws DocumentGenerationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void nextSubTask(Monitor monitor, int previousTaskDone, String nextSubTaskName) {
        if (monitor.isCanceled()) {
            throw new CancellationException("Canceled by user");
        }
        monitor.worked(previousTaskDone);
        monitor.subTask(nextSubTaskName);
    }

    private static byte[] serializeDocument(DocumentTemplate documentTemplate) throws IOException {
        byte[] serializedDocument;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            documentTemplate.getDocument().write((OutputStream)output);
            serializedDocument = output.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return serializedDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServicesConfigurator(IServicesConfiguratorDescriptor configurator) {
        if (configurator != null) {
            List<IServicesConfiguratorDescriptor> list = CONFIGURATORS;
            synchronized (list) {
                CONFIGURATORS.add(configurator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterServicesConfigurator(IServicesConfiguratorDescriptor configuratorDescriptor) {
        if (configuratorDescriptor != null) {
            List<IServicesConfiguratorDescriptor> list = CONFIGURATORS;
            synchronized (list) {
                CONFIGURATORS.remove(configuratorDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IServicesConfigurator> getConfigurators() {
        ArrayList<IServicesConfigurator> res = new ArrayList<IServicesConfigurator>();
        List<IServicesConfiguratorDescriptor> list = CONFIGURATORS;
        synchronized (list) {
            for (IServicesConfiguratorDescriptor descriptor : CONFIGURATORS) {
                IServicesConfigurator configurator = descriptor.getServicesConfigurator();
                if (configurator == null) continue;
                res.add(configurator);
            }
        }
        return res;
    }

    public static Map<String, String> getInitializedOptions(Map<String, String> options) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        res.put(UPDATE_FIELDS_OPTION, Boolean.FALSE.toString());
        res.put(IGNORE_VERSION_CHECK_OPTION, Boolean.FALSE.toString());
        for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
            res.putAll(configurator.getInitializedOptions(options));
        }
        return res;
    }

    public static Map<String, String> getInitializedOptions(Map<String, String> options, EObject eObj) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        res.put(UPDATE_FIELDS_OPTION, Boolean.FALSE.toString());
        res.put(IGNORE_VERSION_CHECK_OPTION, Boolean.FALSE.toString());
        for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
            res.putAll(configurator.getInitializedOptions(options));
        }
        return res;
    }

    public static List<String> getPossibleOptionNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
            res.addAll(configurator.getOptions());
        }
        res.add(UPDATE_FIELDS_OPTION);
        res.add(IGNORE_VERSION_CHECK_OPTION);
        res.add(INSTALL_CROSS_REFERENCE_ADAPTER_OPTION);
        return res;
    }

    public static ResourceSet createResourceSetForModels(List<Exception> exceptions, Object key, ResourceSet defaultResourceSet, Map<String, String> options) {
        ResourceSet res = null;
        for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
            try {
                res = configurator.createResourceSetForModels(key, options);
                if (res == null) continue;
                break;
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (res == null) {
            res = defaultResourceSet;
        }
        if (Boolean.valueOf(options.get(INSTALL_CROSS_REFERENCE_ADAPTER_OPTION)).booleanValue()) {
            ECrossReferenceAdapter adapter = new ECrossReferenceAdapter();
            adapter.setTarget((Notifier)res);
            res.eAdapters().add((Object)adapter);
            CROSS_REFERENCE_ADAPTERS.put(key, adapter);
        }
        return res;
    }

    public static void cleanResourceSetForModels(Object key, ResourceSet resourceSet) {
        ECrossReferenceAdapter adapter = CROSS_REFERENCE_ADAPTERS.remove(key);
        if (adapter != null) {
            adapter.unsetTarget((Notifier)resourceSet);
            resourceSet.eAdapters().remove((Object)adapter);
        }
        for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
            configurator.cleanResourceSetForModels(key);
        }
    }

    public static XWPFDocument createSampleTemplate(String variableName, EClass eCls) throws InvalidFormatException, IOException {
        SampleTemplateGenerator generator = new SampleTemplateGenerator();
        return generator.generate(variableName, eCls);
    }

    public static List<TemplateValidationMessage> migrate(URIConverter uriConverter, URI templateURI, URI outputURI, URI outputErrorURI, Monitor monitor) throws DocumentParserException {
        ArrayList<TemplateValidationMessage> result = new ArrayList<TemplateValidationMessage>();
        monitor.beginTask("Migrating " + String.valueOf(templateURI), 75);
        monitor.subTask("Loading template");
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(uriConverter, templateURI);){
                    M2DocUtils.nextSubTask(monitor, 20, "Parsing template custom properties");
                    TemplateCustomProperties properties = new TemplateCustomProperties(document);
                    if (properties.getM2DocVersion() != null) {
                        Version templateVersion = new Version(properties.getM2DocVersion());
                        List<IM2DocMigrator> migrators = M2DocUtils.getTemplateMigrators(templateVersion);
                        int unitOfWork = 30 / (1 + document.getFooterList().size() + document.getHeaderList().size());
                        M2DocUtils.nextSubTask(monitor, 5, "Parsing template body");
                        for (IM2DocMigrator migrator : migrators) {
                            result.addAll(migrator.migrate((IBody)document));
                        }
                        M2DocUtils.nextSubTask(monitor, unitOfWork, "Migrating template footers");
                        for (XWPFFooter footer : document.getFooterList()) {
                            for (IM2DocMigrator migrator : migrators) {
                                result.addAll(migrator.migrate((IBody)footer));
                            }
                            monitor.worked(unitOfWork);
                        }
                        M2DocUtils.nextSubTask(monitor, 0, "Migrating template headers");
                        for (XWPFHeader header : document.getHeaderList()) {
                            for (IM2DocMigrator migrator : migrators) {
                                result.addAll(migrator.migrate((IBody)header));
                            }
                            monitor.worked(unitOfWork);
                        }
                        M2DocUtils.nextSubTask(monitor, 0, "Save template " + String.valueOf(outputURI));
                        properties.setM2DocVersion(VERSION);
                        properties.save();
                        POIServices.getInstance().saveFile(uriConverter, document, outputURI);
                        if (!result.isEmpty() && outputErrorURI != null) {
                            for (TemplateValidationMessage message : result) {
                                M2DocUtils.insertMessageAfter(message.getLocation(), message.getLevel(), message.getMessage());
                            }
                            POIServices.getInstance().saveFile(uriConverter, document, outputErrorURI);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new DocumentParserException("Unable to open " + String.valueOf(templateURI) + " or save " + String.valueOf(outputURI), e);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static List<IM2DocMigrator> getTemplateMigrators(Version version) {
        ArrayList<IM2DocMigrator> result = new ArrayList<IM2DocMigrator>();
        if (new Version(VERSION).compareTo(version) > 0) {
            result.add(new M2Doc4Migrator());
        }
        return result;
    }

    public static boolean needMigration(URIConverter uriConverter, URI templateURI) throws IOException {
        boolean result;
        Throwable throwable = null;
        Object var4_4 = null;
        try (XWPFDocument document = POIServices.getInstance().getXWPFDocument(uriConverter, templateURI);){
            Version templateVersion;
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            result = properties.getM2DocVersion() != null ? !M2DocUtils.getTemplateMigrators(templateVersion = new Version(properties.getM2DocVersion())).isEmpty() : false;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }
}

