/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;

public class MemoryURIHandler
implements URIHandler {
    public static final String PROTOCOL = "m2docmemory";
    private final Map<URI, ByteArrayOutputStream> resources = new HashMap<URI, ByteArrayOutputStream>();

    public void clear() {
        this.resources.clear();
    }

    public boolean canHandle(URI uri) {
        return PROTOCOL.equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        ByteArrayOutputStream outputStream = this.resources.get(uri);
        if (outputStream == null) {
            throw new IOException("Resource " + String.valueOf(uri) + " doesn't exist in memory.");
        }
        ByteArrayInputStream res = new ByteArrayInputStream(outputStream.toByteArray());
        return res;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        this.resources.put(uri, res);
        return res;
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        this.resources.remove(uri);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return Collections.emptyMap();
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return this.resources.containsKey(uri);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return Collections.emptyMap();
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }
}

