/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.html.services;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;

public abstract class Parser {
    protected static final Map<String, Color> COLORS = Parser.initializeColors();
    protected static final int DEFAULT_FONT_SIZE = 11;
    protected static final String CLASS_ATTR = "class";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String PERCENT = "%";
    private static final int HEXA_COLOR_LENGTH = 7;
    private static final Pattern RGB_PATTERN = Pattern.compile("\\s*rgb\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)\\s*");
    private static final int R_GROUP_INDEX = 1;
    private static final int G_GROUP_INDEX = 2;
    private static final int B_GROUP_INDEX = 3;
    private static final Pattern FIXED_SIZE_PATTERN = Pattern.compile("([0-9]+(\\.[0-9]+)?)(cm|mm|px|in|pt|pc|em|%)");
    private static final int FIXED_SIZE_PATTERN_VALUE_GROUP = 1;
    private static final int FIXED_SIZE_PATTERN_UNIT_GROUP = 3;
    private static final Pattern FONT_SIZE_PATTERN = Pattern.compile("([0-9]+(\\.[0-9]+)?)(pt|px|em|%)?");
    private static final int FONT_SIZE_PATTERN_VALUE_GROUP = 1;
    private static final int FONT_SIZE_PATTERN_UNIT_GROUP = 3;
    private static final int RELATIVE_CELL_WIDTH_MULTIPLIER = 50;

    private static Map<String, Color> initializeColors() {
        HashMap<String, Color> res = new HashMap<String, Color>();
        res.put("AliceBlue".toLowerCase(), Color.decode("0xF0F8FF"));
        res.put("AntiqueWhite".toLowerCase(), Color.decode("0xFAEBD7"));
        res.put("Aqua".toLowerCase(), Color.decode("0x00FFFF"));
        res.put("Aquamarine".toLowerCase(), Color.decode("0x7FFFD4"));
        res.put("Azure".toLowerCase(), Color.decode("0xF0FFFF"));
        res.put("Beige".toLowerCase(), Color.decode("0xF5F5DC"));
        res.put("Bisque".toLowerCase(), Color.decode("0xFFE4C4"));
        res.put("Black".toLowerCase(), Color.decode("0x000000"));
        res.put("BlanchedAlmond".toLowerCase(), Color.decode("0xFFEBCD"));
        res.put("Blue".toLowerCase(), Color.decode("0x0000FF"));
        res.put("BlueViolet".toLowerCase(), Color.decode("0x8A2BE2"));
        res.put("Brown".toLowerCase(), Color.decode("0xA52A2A"));
        res.put("BurlyWood".toLowerCase(), Color.decode("0xDEB887"));
        res.put("CadetBlue".toLowerCase(), Color.decode("0x5F9EA0"));
        res.put("Chartreuse".toLowerCase(), Color.decode("0x7FFF00"));
        res.put("Chocolate".toLowerCase(), Color.decode("0xD2691E"));
        res.put("Coral".toLowerCase(), Color.decode("0xFF7F50"));
        res.put("CornflowerBlue".toLowerCase(), Color.decode("0x6495ED"));
        res.put("Cornsilk".toLowerCase(), Color.decode("0xFFF8DC"));
        res.put("Crimson".toLowerCase(), Color.decode("0xDC143C"));
        res.put("Cyan".toLowerCase(), Color.decode("0x00FFFF"));
        res.put("DarkBlue".toLowerCase(), Color.decode("0x00008B"));
        res.put("DarkCyan".toLowerCase(), Color.decode("0x008B8B"));
        res.put("DarkGoldenRod".toLowerCase(), Color.decode("0xB8860B"));
        res.put("DarkGray".toLowerCase(), Color.decode("0xA9A9A9"));
        res.put("DarkGrey".toLowerCase(), Color.decode("0xA9A9A9"));
        res.put("DarkGreen".toLowerCase(), Color.decode("0x006400"));
        res.put("DarkKhaki".toLowerCase(), Color.decode("0xBDB76B"));
        res.put("DarkMagenta".toLowerCase(), Color.decode("0x8B008B"));
        res.put("DarkOliveGreen".toLowerCase(), Color.decode("0x556B2F"));
        res.put("DarkOrange".toLowerCase(), Color.decode("0xFF8C00"));
        res.put("DarkOrchid".toLowerCase(), Color.decode("0x9932CC"));
        res.put("DarkRed".toLowerCase(), Color.decode("0x8B0000"));
        res.put("DarkSalmon".toLowerCase(), Color.decode("0xE9967A"));
        res.put("DarkSeaGreen".toLowerCase(), Color.decode("0x8FBC8F"));
        res.put("DarkSlateBlue".toLowerCase(), Color.decode("0x483D8B"));
        res.put("DarkSlateGray".toLowerCase(), Color.decode("0x2F4F4F"));
        res.put("DarkSlateGrey".toLowerCase(), Color.decode("0x2F4F4F"));
        res.put("DarkTurquoise".toLowerCase(), Color.decode("0x00CED1"));
        res.put("DarkViolet".toLowerCase(), Color.decode("0x9400D3"));
        res.put("DeepPink".toLowerCase(), Color.decode("0xFF1493"));
        res.put("DeepSkyBlue".toLowerCase(), Color.decode("0x00BFFF"));
        res.put("DimGray".toLowerCase(), Color.decode("0x696969"));
        res.put("DimGrey".toLowerCase(), Color.decode("0x696969"));
        res.put("DodgerBlue".toLowerCase(), Color.decode("0x1E90FF"));
        res.put("FireBrick".toLowerCase(), Color.decode("0xB22222"));
        res.put("FloralWhite".toLowerCase(), Color.decode("0xFFFAF0"));
        res.put("ForestGreen".toLowerCase(), Color.decode("0x228B22"));
        res.put("Fuchsia".toLowerCase(), Color.decode("0xFF00FF"));
        res.put("Gainsboro".toLowerCase(), Color.decode("0xDCDCDC"));
        res.put("GhostWhite".toLowerCase(), Color.decode("0xF8F8FF"));
        res.put("Gold".toLowerCase(), Color.decode("0xFFD700"));
        res.put("GoldenRod".toLowerCase(), Color.decode("0xDAA520"));
        res.put("Gray".toLowerCase(), Color.decode("0x808080"));
        res.put("Grey".toLowerCase(), Color.decode("0x808080"));
        res.put("Green".toLowerCase(), Color.decode("0x008000"));
        res.put("GreenYellow".toLowerCase(), Color.decode("0xADFF2F"));
        res.put("HoneyDew".toLowerCase(), Color.decode("0xF0FFF0"));
        res.put("HotPink".toLowerCase(), Color.decode("0xFF69B4"));
        res.put("IndianRed".toLowerCase(), Color.decode("0xCD5C5C"));
        res.put("Indigo".toLowerCase(), Color.decode("0x4B0082"));
        res.put("Ivory".toLowerCase(), Color.decode("0xFFFFF0"));
        res.put("Khaki".toLowerCase(), Color.decode("0xF0E68C"));
        res.put("Lavender".toLowerCase(), Color.decode("0xE6E6FA"));
        res.put("LavenderBlush".toLowerCase(), Color.decode("0xFFF0F5"));
        res.put("LawnGreen".toLowerCase(), Color.decode("0x7CFC00"));
        res.put("LemonChiffon".toLowerCase(), Color.decode("0xFFFACD"));
        res.put("LightBlue".toLowerCase(), Color.decode("0xADD8E6"));
        res.put("LightCoral".toLowerCase(), Color.decode("0xF08080"));
        res.put("LightCyan".toLowerCase(), Color.decode("0xE0FFFF"));
        res.put("LightGoldenRodYellow".toLowerCase(), Color.decode("0xFAFAD2"));
        res.put("LightGray".toLowerCase(), Color.decode("0xD3D3D3"));
        res.put("LightGrey".toLowerCase(), Color.decode("0xD3D3D3"));
        res.put("LightGreen".toLowerCase(), Color.decode("0x90EE90"));
        res.put("LightPink".toLowerCase(), Color.decode("0xFFB6C1"));
        res.put("LightSalmon".toLowerCase(), Color.decode("0xFFA07A"));
        res.put("LightSeaGreen".toLowerCase(), Color.decode("0x20B2AA"));
        res.put("LightSkyBlue".toLowerCase(), Color.decode("0x87CEFA"));
        res.put("LightSlateGray".toLowerCase(), Color.decode("0x778899"));
        res.put("LightSlateGrey".toLowerCase(), Color.decode("0x778899"));
        res.put("LightSteelBlue".toLowerCase(), Color.decode("0xB0C4DE"));
        res.put("LightYellow".toLowerCase(), Color.decode("0xFFFFE0"));
        res.put("Lime".toLowerCase(), Color.decode("0x00FF00"));
        res.put("LimeGreen".toLowerCase(), Color.decode("0x32CD32"));
        res.put("Linen".toLowerCase(), Color.decode("0xFAF0E6"));
        res.put("Magenta".toLowerCase(), Color.decode("0xFF00FF"));
        res.put("Maroon".toLowerCase(), Color.decode("0x800000"));
        res.put("MediumAquaMarine".toLowerCase(), Color.decode("0x66CDAA"));
        res.put("MediumBlue".toLowerCase(), Color.decode("0x0000CD"));
        res.put("MediumOrchid".toLowerCase(), Color.decode("0xBA55D3"));
        res.put("MediumPurple".toLowerCase(), Color.decode("0x9370DB"));
        res.put("MediumSeaGreen".toLowerCase(), Color.decode("0x3CB371"));
        res.put("MediumSlateBlue".toLowerCase(), Color.decode("0x7B68EE"));
        res.put("MediumSpringGreen".toLowerCase(), Color.decode("0x00FA9A"));
        res.put("MediumTurquoise".toLowerCase(), Color.decode("0x48D1CC"));
        res.put("MediumVioletRed".toLowerCase(), Color.decode("0xC71585"));
        res.put("MidnightBlue".toLowerCase(), Color.decode("0x191970"));
        res.put("MintCream".toLowerCase(), Color.decode("0xF5FFFA"));
        res.put("MistyRose".toLowerCase(), Color.decode("0xFFE4E1"));
        res.put("Moccasin".toLowerCase(), Color.decode("0xFFE4B5"));
        res.put("NavajoWhite".toLowerCase(), Color.decode("0xFFDEAD"));
        res.put("Navy".toLowerCase(), Color.decode("0x000080"));
        res.put("OldLace".toLowerCase(), Color.decode("0xFDF5E6"));
        res.put("Olive".toLowerCase(), Color.decode("0x808000"));
        res.put("OliveDrab".toLowerCase(), Color.decode("0x6B8E23"));
        res.put("Orange".toLowerCase(), Color.decode("0xFFA500"));
        res.put("OrangeRed".toLowerCase(), Color.decode("0xFF4500"));
        res.put("Orchid".toLowerCase(), Color.decode("0xDA70D6"));
        res.put("PaleGoldenRod".toLowerCase(), Color.decode("0xEEE8AA"));
        res.put("PaleGreen".toLowerCase(), Color.decode("0x98FB98"));
        res.put("PaleTurquoise".toLowerCase(), Color.decode("0xAFEEEE"));
        res.put("PaleVioletRed".toLowerCase(), Color.decode("0xDB7093"));
        res.put("PapayaWhip".toLowerCase(), Color.decode("0xFFEFD5"));
        res.put("PeachPuff".toLowerCase(), Color.decode("0xFFDAB9"));
        res.put("Peru".toLowerCase(), Color.decode("0xCD853F"));
        res.put("Pink".toLowerCase(), Color.decode("0xFFC0CB"));
        res.put("Plum".toLowerCase(), Color.decode("0xDDA0DD"));
        res.put("PowderBlue".toLowerCase(), Color.decode("0xB0E0E6"));
        res.put("Purple".toLowerCase(), Color.decode("0x800080"));
        res.put("RebeccaPurple".toLowerCase(), Color.decode("0x663399"));
        res.put("Red".toLowerCase(), Color.decode("0xFF0000"));
        res.put("RosyBrown".toLowerCase(), Color.decode("0xBC8F8F"));
        res.put("RoyalBlue".toLowerCase(), Color.decode("0x4169E1"));
        res.put("SaddleBrown".toLowerCase(), Color.decode("0x8B4513"));
        res.put("Salmon".toLowerCase(), Color.decode("0xFA8072"));
        res.put("SandyBrown".toLowerCase(), Color.decode("0xF4A460"));
        res.put("SeaGreen".toLowerCase(), Color.decode("0x2E8B57"));
        res.put("SeaShell".toLowerCase(), Color.decode("0xFFF5EE"));
        res.put("Sienna".toLowerCase(), Color.decode("0xA0522D"));
        res.put("Silver".toLowerCase(), Color.decode("0xC0C0C0"));
        res.put("SkyBlue".toLowerCase(), Color.decode("0x87CEEB"));
        res.put("SlateBlue".toLowerCase(), Color.decode("0x6A5ACD"));
        res.put("SlateGray".toLowerCase(), Color.decode("0x708090"));
        res.put("SlateGrey".toLowerCase(), Color.decode("0x708090"));
        res.put("Snow".toLowerCase(), Color.decode("0xFFFAFA"));
        res.put("SpringGreen".toLowerCase(), Color.decode("0x00FF7F"));
        res.put("SteelBlue".toLowerCase(), Color.decode("0x4682B4"));
        res.put("Tan".toLowerCase(), Color.decode("0xD2B48C"));
        res.put("Teal".toLowerCase(), Color.decode("0x008080"));
        res.put("Thistle".toLowerCase(), Color.decode("0xD8BFD8"));
        res.put("Tomato".toLowerCase(), Color.decode("0xFF6347"));
        res.put("Turquoise".toLowerCase(), Color.decode("0x40E0D0"));
        res.put("Violet".toLowerCase(), Color.decode("0xEE82EE"));
        res.put("Wheat".toLowerCase(), Color.decode("0xF5DEB3"));
        res.put("White".toLowerCase(), Color.decode("0xFFFFFF"));
        res.put("WhiteSmoke".toLowerCase(), Color.decode("0xF5F5F5"));
        res.put("Yellow".toLowerCase(), Color.decode("0xFFFF00"));
        res.put("YellowGreen".toLowerCase(), Color.decode("0x9ACD32"));
        return res;
    }

    protected void setModifiers(MStyle mStyle, int modifier) {
        if (mStyle.getFontModifiers() == -1) {
            mStyle.setModifiers(modifier);
        } else {
            mStyle.setModifiers(mStyle.getFontModifiers() | modifier);
        }
    }

    protected Color htmlToColor(String htmlColor) {
        Color res;
        try {
            Color knownColor = COLORS.get(htmlColor);
            if (knownColor != null) {
                res = knownColor;
            } else {
                Matcher matcher = RGB_PATTERN.matcher(htmlColor);
                if (matcher.matches()) {
                    int r = Integer.valueOf(matcher.group(1));
                    int g = Integer.valueOf(matcher.group(2));
                    int b = Integer.valueOf(matcher.group(3));
                    res = new Color(r, g, b);
                } else {
                    res = htmlColor.length() == 7 ? Color.decode(htmlColor.replace("#", "0x")) : (htmlColor.length() == 4 ? Color.decode("0x" + htmlColor.charAt(1) + htmlColor.charAt(1) + htmlColor.charAt(2) + htmlColor.charAt(2) + htmlColor.charAt(3) + htmlColor.charAt(3)) : null);
                }
                COLORS.put(htmlColor, res);
            }
        }
        catch (Exception e) {
            res = null;
        }
        return res;
    }

    protected int fontSizeToPoint(String fontSize) {
        int res;
        String localPropertyValue = fontSize.trim().toLowerCase();
        Matcher matcher = localPropertyValue.startsWith(".") ? FONT_SIZE_PATTERN.matcher("0" + localPropertyValue) : FONT_SIZE_PATTERN.matcher(localPropertyValue);
        if (matcher.find()) {
            double value = Double.valueOf(matcher.group(1));
            String unit = matcher.group(3);
            if (unit == null || "pt".equals(unit)) {
                switch ((int)value) {
                    case 1: {
                        res = 7;
                        break;
                    }
                    case 2: {
                        res = 10;
                        break;
                    }
                    case 3: {
                        res = 12;
                        break;
                    }
                    case 4: {
                        res = 14;
                        break;
                    }
                    case 5: {
                        res = 18;
                        break;
                    }
                    case 6: {
                        res = 24;
                        break;
                    }
                    default: {
                        res = 36;
                        break;
                    }
                }
            } else {
                res = "px".equals(unit) ? (int)(0.75 * value) : ("em".equals(unit) ? (int)(value * Double.valueOf(11.0)) : (PERCENT.equals(unit) ? (int)(value / 100.0 * Double.valueOf(11.0)) : -1));
            }
        } else {
            res = -1;
        }
        return res;
    }

    protected int getPixels(String propertyValue) {
        int res;
        block30: {
            block28: {
                String unit;
                String localPropertyValue = propertyValue.trim().toLowerCase();
                Matcher matcher = localPropertyValue.startsWith(".") ? FIXED_SIZE_PATTERN.matcher("0" + localPropertyValue) : FIXED_SIZE_PATTERN.matcher(localPropertyValue);
                if (!matcher.find()) break block28;
                double value = Double.valueOf(matcher.group(1));
                switch (unit = matcher.group(3)) {
                    case "cm": {
                        res = (int)(value * 96.0 / 2.54);
                        break;
                    }
                    case "mm": {
                        res = (int)(value / 100.0 * 96.0 / 2.54);
                        break;
                    }
                    case "px": {
                        res = (int)value;
                        break;
                    }
                    case "in": {
                        res = (int)(value * 96.0);
                        break;
                    }
                    case "pt": {
                        res = (int)(value / 72.0 * 96.0);
                        break;
                    }
                    case "pc": {
                        res = (int)(value * 12.0 / 72.0 * 96.0);
                        break;
                    }
                    case "em": {
                        res = (int)(value * Double.valueOf(11.0));
                        break;
                    }
                    case "%": {
                        res = (int)(value / 100.0 * Double.valueOf(11.0));
                        break;
                    }
                    default: {
                        res = -1;
                        break;
                    }
                }
                break block30;
            }
            res = -1;
        }
        return res;
    }

    protected int getRelativeSize(String size) {
        int percentIndex = size.indexOf(PERCENT);
        int res = percentIndex >= 0 ? Integer.valueOf(size.substring(0, percentIndex)) : -1;
        return res;
    }

    protected void setCellWidth(MTable.MCell mCell, String width) {
        int relativeWidth = this.getRelativeSize(width);
        if (relativeWidth != -1) {
            mCell.setWidth(relativeWidth * 50);
            mCell.setWidthType(MTable.MCell.WidthType.PCT);
        } else {
            int pixels = this.getPixels(width);
            if (pixels == -1) {
                try {
                    pixels = Integer.valueOf(width);
                }
                catch (NumberFormatException e) {
                    pixels = -1;
                }
            }
            if (pixels != -1) {
                double twipSize = (double)pixels / 1.3333333333333333 * 20.0;
                mCell.setWidth((int)twipSize);
                mCell.setWidthType(MTable.MCell.WidthType.DXA);
            }
        }
    }

    protected void setRowHeight(MTable.MRow row, String height) {
        int relativeHeight = this.getRelativeSize(height);
        if (relativeHeight == -1) {
            int pixels = this.getPixels(height);
            if (pixels == -1) {
                try {
                    pixels = Integer.valueOf(height);
                }
                catch (NumberFormatException e) {
                    pixels = -1;
                }
            }
            if (pixels != -1) {
                row.setHeight(pixels * 10);
                row.setHeightRule(MTable.MRow.HeightRule.AT_LEAST);
            }
        }
    }

    protected void setImageSize(MImage mImage, String width, String height) {
        if (width != null) {
            if (height != null) {
                mImage.setConserveRatio(false);
                this.setImageWidth(mImage, width);
                this.setImageHeight(mImage, height);
            } else {
                this.setImageWidth(mImage, width);
            }
        } else if (height != null) {
            this.setImageHeight(mImage, height);
        }
    }

    private void setImageHeight(MImage mImage, String height) {
        int relativeHeight = this.getRelativeSize(height);
        if (relativeHeight != -1) {
            mImage.setRelativeHeight(relativeHeight);
        } else {
            int pixels = this.getPixels(height);
            if (pixels == -1) {
                try {
                    pixels = Integer.valueOf(height);
                }
                catch (NumberFormatException e) {
                    pixels = -1;
                }
            }
            if (pixels != -1) {
                mImage.setHeight(pixels);
            }
        }
    }

    private void setImageWidth(MImage mImage, String width) {
        int relativeWidth = this.getRelativeSize(width);
        if (relativeWidth != -1) {
            mImage.setRelativeWidth(relativeWidth);
        } else {
            int pixels = this.getPixels(width);
            if (pixels == -1) {
                try {
                    pixels = Integer.valueOf(width);
                }
                catch (NumberFormatException e) {
                    pixels = -1;
                }
            }
            if (pixels != -1) {
                mImage.setWidth(pixels);
            }
        }
    }
}

