/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.html.services;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Node;
import org.obeonetwork.m2doc.element.MBorder;
import org.obeonetwork.m2doc.element.MElementContainer;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.impl.MBorderImpl;
import org.obeonetwork.m2doc.html.services.M2DocHTMLParser;
import org.obeonetwork.m2doc.html.services.Parser;

public class M2DocCSSParser
extends Parser {
    protected static final String CSS_COLOR = "color";
    protected static final String CSS_BACKGROUND_COLOR = "background-color";
    protected static final String CSS_BACKGROUND = "background";
    protected static final String CSS_LIST_STYLE_TYPE = "list-style-type";
    protected static final String CSS_TEXT_ALIGN = "text-align";
    protected static final String CSS_TEXT_TRANSFORM = "text-transform";
    protected static final String CSS_VERTICAL_ALIGN = "vertical-align";
    protected static final String CSS_TEXT_DECORATION = "text-decoration";
    protected static final String CSS_FONT_STYLE = "font-style";
    protected static final String CSS_FONT_WEIGHT = "font-weight";
    protected static final String CSS_FONT_FAMILY = "font-family";
    protected static final String CSS_FONT_SIZE = "font-size";
    protected static final String CSS_FONT_VARIANT = "font-variant";
    protected static final String CSS_MARGIN = "margin";
    protected static final String CSS_MARGIN_LEFT = "margin-left";
    protected static final String CSS_MARGIN_RIGHT = "margin-right";
    protected static final String CSS_MARGIN_TOP = "margin-top";
    protected static final String CSS_MARGIN_BOTTOM = "margin-bottoms";
    protected static final String CSS_PADDING = "padding";
    protected static final String CSS_PADDING_LEFT = "padding-left";
    protected static final String CSS_PADDING_RIGHT = "padding-right";
    protected static final String CSS_PADDING_TOP = "padding-top";
    protected static final String CSS_PADDING_BOTTOM = "padding-bottom";
    protected static final String CSS_BORDER_STYLE = "border-style";
    protected static final String CSS_BORDER = "border";
    protected static final String CSS_DISPLAY = "display";
    protected static final String CSS_FLOAT = "float";
    private static final String CSS_WIDTH = "width";
    private static final String CSS_HEIGHT = "height";
    private static final String CSS_CLASS_DOT = ".";
    private static final String LINE_THROUGH = "line-through";
    private static final String UNDERLINE = "underline";
    private static final String BOLD = "bold";
    private static final String OBLIQUE = "oblique";
    private static final String ITALIC = "italic";
    private static final String NORMAL = "normal";
    private static final String FIELD_SEPARATOR = ";";
    private static final String VALUE_SEPARATOR = ":";
    private static final String CSS_COMMENT = "!";
    private static final int ALL_FONT_MODIFIERS_MASK = -1;
    private static final Pattern CSS_COMMENT_PATTERN = Pattern.compile("/\\*.*?\\*/");
    private static final Pattern CSS_CLASS_PATTERN = Pattern.compile("(([_a-zA-Z0-9.:\\->,\\[\\]()\"=@^* #+~$\n\r]+\\s)+)\\{([^\\}]*)\\}");
    private static final int CSS_CLASS_PATTERN_NAME_GROUP = 1;
    private static final int CSS_CLASS_PATTERN_CSS_STYLES_GROUP = 3;
    private static final int CSS_FONT_WEIGHT_BOLD_THRESHOLD = 700;
    private static final String REG_EXP_SPACES = "\\s+";
    private static final String CLASS_DEFINITION_SEPARATOR = ",";
    private static final String STYLE_ATTR = "style";

    public Map<String, Map<String, List<String>>> parseClasses(String cssClasses) {
        LinkedHashMap<String, Map<String, List<String>>> res = new LinkedHashMap<String, Map<String, List<String>>>();
        String cssNoComments = CSS_COMMENT_PATTERN.matcher(cssClasses).replaceAll("");
        String cssNoAtRule = this.removeAtRules(cssNoComments);
        Matcher matcher = CSS_CLASS_PATTERN.matcher(cssNoAtRule);
        while (matcher.find()) {
            String classNames = matcher.group(1);
            Map<String, List<String>> styles = this.parseStyles(matcher.group(3));
            String[] stringArray = classNames.split(CLASS_DEFINITION_SEPARATOR);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String name = stringArray[n3];
                String className = name.trim();
                if (className != null && !className.isEmpty()) {
                    res.computeIfAbsent(className.trim(), n -> new LinkedHashMap()).putAll(styles);
                }
                ++n3;
            }
        }
        return res;
    }

    private String removeAtRules(String cssNoComments) {
        StringBuilder res = new StringBuilder();
        boolean inAtRule = false;
        int curlyBraceDepth = 0;
        int i = 0;
        while (i < cssNoComments.length()) {
            char current = cssNoComments.charAt(i);
            if (current == '@') {
                inAtRule = true;
            } else if (inAtRule) {
                if (current == '{') {
                    ++curlyBraceDepth;
                } else if (current == '}') {
                    inAtRule = --curlyBraceDepth > 0;
                }
            } else {
                res.append(current);
            }
            ++i;
        }
        return res.toString();
    }

    public void mergeCSSStyles(Map<String, Map<String, List<String>>> source, Map<String, Map<String, List<String>>> target) {
        for (Map.Entry<String, Map<String, List<String>>> entry : source.entrySet()) {
            target.computeIfAbsent(entry.getKey(), n -> new LinkedHashMap()).putAll(entry.getValue());
        }
    }

    public List<String> getCSSClassNames(Node node) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(node.nodeName());
        if (node.hasAttr("class")) {
            String[] stringArray = node.attr("class").split(REG_EXP_SPACES);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                res.add(CSS_CLASS_DOT + className);
                res.add(VALUE_SEPARATOR + className);
                res.add(node.nodeName() + CSS_CLASS_DOT + className);
                res.add(node.nodeName() + VALUE_SEPARATOR + className);
                ++n2;
            }
        }
        return res;
    }

    public Map<String, List<String>> getCSSProperties(Node node, Map<String, Map<String, List<String>>> cssClasses) {
        HashMap<String, List<String>> cssProperties = new HashMap<String, List<String>>();
        List<String> cssClasseNames = this.getCSSClassNames(node);
        for (String cssClasseName : cssClasseNames) {
            Map cssClassesProperties = cssClasses.getOrDefault(cssClasseName, Collections.emptyMap());
            cssProperties.putAll(cssClassesProperties);
        }
        if (node.hasAttr(STYLE_ATTR)) {
            Map<String, List<String>> cssStyleProperties = this.parseStyles(node.attr(STYLE_ATTR));
            cssProperties.putAll(cssStyleProperties);
        }
        return cssProperties;
    }

    public Map<String, List<String>> parse(String cssStyle) {
        return this.parseStyles(cssStyle);
    }

    public Map<String, List<String>> parseStyles(String cssStyle) {
        LinkedHashMap<String, List<String>> res = new LinkedHashMap<String, List<String>>();
        String[] stringArray = cssStyle.split(FIELD_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            String[] keyValue = field.split(VALUE_SEPARATOR);
            if (keyValue.length >= 1 && !keyValue[0].trim().isEmpty()) {
                List values = res.computeIfAbsent(keyValue[0].trim().toLowerCase(), key -> new ArrayList());
                if (keyValue.length == 2) {
                    int commentIndex = keyValue[1].indexOf(CSS_COMMENT);
                    if (commentIndex >= 0) {
                        values.add(keyValue[1].substring(0, commentIndex).trim().toLowerCase());
                    } else {
                        values.add(keyValue[1].trim().toLowerCase());
                    }
                }
            }
            ++n2;
        }
        return res;
    }

    public void setStyle(Map<String, List<String>> cssProperties, MImage mImage) {
        List<String> cssWidths = cssProperties.get(CSS_WIDTH);
        String width = null;
        if (cssWidths != null) {
            Iterator<String> iterator = cssWidths.iterator();
            while (iterator.hasNext()) {
                String cssWidth;
                width = cssWidth = iterator.next();
            }
        }
        List<String> cssHeights = cssProperties.get(CSS_HEIGHT);
        String height = null;
        if (cssHeights != null) {
            Iterator<String> iterator = cssHeights.iterator();
            while (iterator.hasNext()) {
                String cssHeight;
                height = cssHeight = iterator.next();
            }
        }
        this.setImageSize(mImage, width, height);
    }

    public void setStyle(Map<String, List<String>> cssProperties, MStyle mStyle) {
        List<String> cssVerticalAligns;
        List<String> cssFontVariants;
        List<String> cssFontSizes;
        List<String> cssFontFamilies;
        List<String> cssFontWeights;
        List<String> cssFontStyles;
        List<String> cssTextDecorations;
        int modifiers;
        List<String> cssBackgrounds;
        List<String> cssBackgroundColors;
        List<String> cssColors = cssProperties.get(CSS_COLOR);
        if (cssColors != null) {
            for (String cssColor : cssColors) {
                mStyle.setForegroundColor(this.htmlToColor(cssColor));
            }
        }
        if ((cssBackgroundColors = cssProperties.get(CSS_BACKGROUND_COLOR)) != null) {
            for (String cssBackgroundColor : cssBackgroundColors) {
                mStyle.setBackgroundColor(this.htmlToColor(cssBackgroundColor));
            }
        }
        if ((cssBackgrounds = cssProperties.get(CSS_BACKGROUND)) != null) {
            for (String cssBackground : cssBackgrounds) {
                mStyle.setBackgroundColor(this.htmlToColor(cssBackground));
            }
        }
        if ((modifiers = mStyle.getFontModifiers()) == -1) {
            modifiers = 0;
        }
        if ((cssTextDecorations = cssProperties.get(CSS_TEXT_DECORATION)) != null) {
            for (String cssTextDecoration : cssTextDecorations) {
                if (LINE_THROUGH.equals(cssTextDecoration)) {
                    modifiers |= 8;
                    continue;
                }
                if (!UNDERLINE.equals(cssTextDecoration)) continue;
                modifiers |= 4;
            }
        }
        if ((cssFontStyles = cssProperties.get(CSS_FONT_STYLE)) != null) {
            for (String cssFontStyle : cssFontStyles) {
                if (ITALIC.equals(cssFontStyle) || OBLIQUE.equals(cssFontStyle)) {
                    modifiers |= 2;
                    continue;
                }
                if (!NORMAL.equals(cssFontStyle)) continue;
                modifiers &= 0xFFFFFFFD;
            }
        }
        if ((cssFontWeights = cssProperties.get(CSS_FONT_WEIGHT)) != null) {
            for (String cssFontWeight : cssFontWeights) {
                if (BOLD.equals(cssFontWeight)) {
                    modifiers |= 1;
                    continue;
                }
                if (NORMAL.equals(cssFontWeight) || "lighter".equals(cssFontWeight)) {
                    modifiers &= 0xFFFFFFFE;
                    continue;
                }
                try {
                    int value = Integer.valueOf(cssFontWeight);
                    if (value >= 700) {
                        modifiers |= 1;
                        continue;
                    }
                    modifiers &= 0xFFFFFFFE;
                }
                catch (Exception value) {
                    // empty catch block
                }
            }
        }
        if ((cssFontFamilies = cssProperties.get(CSS_FONT_FAMILY)) != null) {
            for (String cssFontFamily : cssFontFamilies) {
                String[] family = cssFontFamily.split("\\s*,\\s*");
                if (family.length < 1) continue;
                mStyle.setFontName(family[0].trim());
            }
        }
        if ((cssFontSizes = cssProperties.get(CSS_FONT_SIZE)) != null) {
            for (String cssFontSize : cssFontSizes) {
                int fontSize = this.fontSizeToPoint(cssFontSize);
                if (fontSize == -1) continue;
                mStyle.setFontSize(fontSize);
            }
        }
        if ((cssFontVariants = cssProperties.get(CSS_FONT_VARIANT)) != null) {
            for (String cssFontVariant : cssFontVariants) {
                if ("small-caps".equals(cssFontVariant.trim())) {
                    modifiers |= 0x40;
                    continue;
                }
                if (!NORMAL.equals(cssFontVariant.trim())) continue;
                modifiers &= 0xFFFFFFBF;
            }
        }
        if ((cssVerticalAligns = cssProperties.get(CSS_VERTICAL_ALIGN)) != null) {
            for (String cssVerticalAlign : cssVerticalAligns) {
                if ("sub".equals(cssVerticalAlign)) {
                    modifiers |= 0x10;
                    continue;
                }
                if (!"super".equals(cssVerticalAlign)) continue;
                modifiers |= 0x20;
            }
        }
        mStyle.setModifiers(modifiers);
    }

    public void setStyle(Map<String, List<String>> cssProperties, MTable.MCell mCell) {
        this.setContainerBackgroundColor(cssProperties, (MElementContainer)mCell);
        List<String> cssWidths = cssProperties.get(CSS_WIDTH);
        if (cssWidths != null) {
            for (String cssWidth : cssWidths) {
                this.setCellWidth(mCell, cssWidth);
            }
        }
        this.setContainerStyle(cssProperties, (MElementContainer)mCell);
    }

    public void setContainerBackgroundColor(Map<String, List<String>> cssProperties, MElementContainer mContainer) {
        List<String> cssBackgrounds;
        List<String> cssBackgroundColors = cssProperties.get(CSS_BACKGROUND_COLOR);
        if (cssBackgroundColors != null) {
            for (String cssBackgroundColor : cssBackgroundColors) {
                mContainer.setBackgroundColor(this.htmlToColor(cssBackgroundColor));
            }
        }
        if ((cssBackgrounds = cssProperties.get(CSS_BACKGROUND)) != null) {
            for (String cssBackground : cssBackgrounds) {
                mContainer.setBackgroundColor(this.htmlToColor(cssBackground));
            }
        }
    }

    public void setStyle(Map<String, List<String>> cssProperties, MTable.MRow mRow) {
        List<String> cssHeights = cssProperties.get(CSS_HEIGHT);
        if (cssHeights != null) {
            for (String cssHeight : cssHeights) {
                this.setRowHeight(mRow, cssHeight);
            }
        }
    }

    private void setContainerStyle(Map<String, List<String>> cssProperties, MElementContainer mContainer) {
        List<String> cssFloats;
        List<String> cssTextAligns = cssProperties.get(CSS_TEXT_ALIGN);
        if (cssTextAligns != null) {
            for (String cssTextAlign : cssTextAligns) {
                if ("center".equalsIgnoreCase(cssTextAlign)) {
                    mContainer.setHAlignment(MElementContainer.HAlignment.CENTER);
                    continue;
                }
                if ("left".equalsIgnoreCase(cssTextAlign)) {
                    mContainer.setHAlignment(MElementContainer.HAlignment.LEFT);
                    continue;
                }
                if ("right".equalsIgnoreCase(cssTextAlign)) {
                    mContainer.setHAlignment(MElementContainer.HAlignment.RIGHT);
                    continue;
                }
                if (!"justify".equalsIgnoreCase(cssTextAlign)) continue;
                mContainer.setHAlignment(MElementContainer.HAlignment.BOTH);
            }
        }
        if ((cssFloats = cssProperties.get(CSS_FLOAT)) != null) {
            for (String cssFloat : cssFloats) {
                if ("left".equalsIgnoreCase(cssFloat)) {
                    mContainer.setHAlignment(MElementContainer.HAlignment.LEFT);
                    continue;
                }
                if (!"right".equalsIgnoreCase(cssFloat)) continue;
                mContainer.setHAlignment(MElementContainer.HAlignment.RIGHT);
            }
        }
    }

    public boolean hasCSS(Map<String, List<String>> cssProperties, String propertyName, String propertyValue) {
        boolean res = false;
        List<String> values = cssProperties.get(propertyName);
        if (values != null) {
            for (String value : values) {
                if (!value.equals(propertyValue)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    public void setStyle(M2DocHTMLParser.Context context, MParagraph paragraph) {
        this.setMarginAll(context, paragraph);
        this.setPaddingAll(context, paragraph);
        this.setMarginLeft(context, paragraph);
        this.setMarginRight(context, paragraph);
        this.setMarginTop(context, paragraph);
        this.setMarginBottom(context, paragraph);
        this.setBorderStyles(context, paragraph);
        this.setBorders(context, paragraph);
        this.setContainerStyle(context.getCssProperties(), (MElementContainer)paragraph);
    }

    private void setBorderStyles(M2DocHTMLParser.Context context, MParagraph paragraph) {
        List<String> cssBorderStyles = context.getCssProperties().get(CSS_BORDER_STYLE);
        if (cssBorderStyles != null) {
            for (String cssBorderStyle : cssBorderStyles) {
                String[] borderStyles = cssBorderStyle.split(REG_EXP_SPACES);
                if (borderStyles.length == 1) {
                    MBorder.Type type = this.getBorderType(borderStyles[0]);
                    MBorderImpl leftBorder = new MBorderImpl();
                    leftBorder.setType(type);
                    paragraph.setLeftBorder((MBorder)leftBorder);
                    MBorderImpl rightBorder = new MBorderImpl();
                    rightBorder.setType(type);
                    paragraph.setRightBorder((MBorder)rightBorder);
                    MBorderImpl topBorder = new MBorderImpl();
                    topBorder.setType(type);
                    paragraph.setTopBorder((MBorder)topBorder);
                    MBorderImpl bottomBorder = new MBorderImpl();
                    bottomBorder.setType(type);
                    paragraph.setBottomBorder((MBorder)bottomBorder);
                    continue;
                }
                if (borderStyles.length != 4) continue;
                MBorder.Type topType = this.getBorderType(borderStyles[0]);
                MBorder.Type rightType = this.getBorderType(borderStyles[1]);
                MBorder.Type bottomType = this.getBorderType(borderStyles[2]);
                MBorder.Type leftType = this.getBorderType(borderStyles[3]);
                MBorderImpl leftBorder = new MBorderImpl();
                leftBorder.setType(leftType);
                paragraph.setLeftBorder((MBorder)leftBorder);
                MBorderImpl rightBorder = new MBorderImpl();
                rightBorder.setType(rightType);
                paragraph.setRightBorder((MBorder)rightBorder);
                MBorderImpl topBorder = new MBorderImpl();
                topBorder.setType(topType);
                paragraph.setTopBorder((MBorder)topBorder);
                MBorderImpl bottomBorder = new MBorderImpl();
                bottomBorder.setType(bottomType);
                paragraph.setBottomBorder((MBorder)bottomBorder);
            }
        }
    }

    private void setBorders(M2DocHTMLParser.Context context, MParagraph paragraph) {
        List<String> cssBorders = context.getCssProperties().get(CSS_BORDER);
        if (cssBorders != null) {
            for (String cssBorder : cssBorders) {
                String[] borders = cssBorder.split(REG_EXP_SPACES);
                if (borders.length == 1) {
                    MBorder.Type type = this.getBorderType(borders[0]);
                    MBorderImpl leftBorder = new MBorderImpl();
                    leftBorder.setType(type);
                    paragraph.setLeftBorder((MBorder)leftBorder);
                    MBorderImpl rightBorder = new MBorderImpl();
                    rightBorder.setType(type);
                    paragraph.setRightBorder((MBorder)rightBorder);
                    MBorderImpl topBorder = new MBorderImpl();
                    topBorder.setType(type);
                    paragraph.setTopBorder((MBorder)topBorder);
                    MBorderImpl bottomBorder = new MBorderImpl();
                    bottomBorder.setType(type);
                    paragraph.setBottomBorder((MBorder)bottomBorder);
                    continue;
                }
                if (borders.length != 3) continue;
                int size = this.getPixels(borders[0]);
                MBorder.Type type = this.getBorderType(borders[1]);
                Color color = this.htmlToColor(borders[2]);
                MBorderImpl leftBorder = new MBorderImpl();
                leftBorder.setSize(size);
                leftBorder.setType(type);
                leftBorder.setColor(color);
                paragraph.setLeftBorder((MBorder)leftBorder);
                MBorderImpl rightBorder = new MBorderImpl();
                rightBorder.setSize(size);
                rightBorder.setType(type);
                rightBorder.setColor(color);
                paragraph.setRightBorder((MBorder)rightBorder);
                MBorderImpl topBorder = new MBorderImpl();
                topBorder.setSize(size);
                topBorder.setType(type);
                topBorder.setColor(color);
                paragraph.setTopBorder((MBorder)topBorder);
                MBorderImpl bottomBorder = new MBorderImpl();
                bottomBorder.setSize(size);
                bottomBorder.setType(type);
                bottomBorder.setColor(color);
                paragraph.setBottomBorder((MBorder)bottomBorder);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private MBorder.Type getBorderType(String cssName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[12] lbl82 : CaseStatement: default:\u000a, @NONE, blocks:[12] lbl82 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setMarginAll(M2DocHTMLParser.Context context, MParagraph paragraph) {
        List<String> cssMargins = context.getCssProperties().get(CSS_MARGIN);
        if (cssMargins != null) {
            Integer marginBottom;
            Integer marginTop;
            Integer marginRight;
            for (String cssMargin : cssMargins) {
                int marginBottom2;
                int marginTop2;
                int marginRight2;
                int marginLeft;
                String[] margins = cssMargin.split(REG_EXP_SPACES);
                if (margins.length == 1) {
                    if ("auto".equals(margins[0])) {
                        paragraph.setHAlignment(MElementContainer.HAlignment.CENTER);
                        marginLeft = -1;
                        marginRight2 = -1;
                        marginTop2 = -1;
                        marginBottom2 = -1;
                    } else {
                        int value;
                        marginLeft = value = this.getPixels(margins[0]);
                        marginRight2 = value;
                        marginTop2 = value;
                        marginBottom2 = value;
                    }
                } else if (margins.length == 2) {
                    int topBottom = this.getPixels(margins[0]);
                    marginLeft = leftRight = this.getPixels(margins[1]);
                    marginRight2 = leftRight;
                    marginTop2 = topBottom;
                    marginBottom2 = topBottom;
                } else if (margins.length == 3) {
                    top = this.getPixels(margins[0]);
                    leftRight = this.getPixels(margins[1]);
                    bottom = this.getPixels(margins[2]);
                    marginLeft = leftRight;
                    marginRight2 = leftRight;
                    marginTop2 = top;
                    marginBottom2 = bottom;
                } else if (margins.length == 4) {
                    int left;
                    top = this.getPixels(margins[0]);
                    int right = this.getPixels(margins[1]);
                    bottom = this.getPixels(margins[2]);
                    marginLeft = left = this.getPixels(margins[3]);
                    marginRight2 = right;
                    marginTop2 = top;
                    marginBottom2 = bottom;
                } else {
                    marginLeft = -1;
                    marginRight2 = -1;
                    marginTop2 = -1;
                    marginBottom2 = -1;
                }
                if (marginLeft != -1) {
                    context.replaceLastDefaultMarginLeft(marginLeft);
                }
                if (marginRight2 != -1) {
                    context.replaceLastDefaultMarginRight(marginRight2);
                }
                if (marginTop2 != -1) {
                    context.replaceLastDefaultMarginTop(marginTop2);
                }
                if (marginBottom2 == -1) continue;
                context.replaceLastDefaultMarginBottom(marginBottom2);
            }
            Integer marginLeft = context.getMarginLeft();
            if (marginLeft != null) {
                paragraph.setMarginLeft(marginLeft.intValue());
            }
            if ((marginRight = context.getMarginRight()) != null) {
                paragraph.setMarginRight(marginRight.intValue());
            }
            if ((marginTop = context.getMarginTop()) != null) {
                paragraph.setMarginTop(marginTop.intValue());
            }
            if ((marginBottom = context.getMarginBottom()) != null) {
                paragraph.setMarginBottom(marginBottom.intValue());
            }
        }
    }

    private void setPaddingAll(M2DocHTMLParser.Context context, MParagraph paragraph) {
        List<String> cssPaddings = context.getCssProperties().get(CSS_PADDING);
        if (cssPaddings != null) {
            Integer marginBottom;
            Integer marginTop;
            Integer marginRight;
            for (String cssPadding : cssPaddings) {
                int paddingBottom;
                int paddingTop;
                int paddingRight;
                int paddingLeft;
                String[] paddings = cssPadding.split(REG_EXP_SPACES);
                if (paddings.length == 1) {
                    int value;
                    paddingLeft = value = this.getPixels(paddings[0]);
                    paddingRight = value;
                    paddingTop = value;
                    paddingBottom = value;
                } else if (paddings.length == 2) {
                    int topBottom = this.getPixels(paddings[0]);
                    paddingLeft = leftRight = this.getPixels(paddings[1]);
                    paddingRight = leftRight;
                    paddingTop = topBottom;
                    paddingBottom = topBottom;
                } else if (paddings.length == 3) {
                    top = this.getPixels(paddings[0]);
                    leftRight = this.getPixels(paddings[1]);
                    bottom = this.getPixels(paddings[2]);
                    paddingLeft = leftRight;
                    paddingRight = leftRight;
                    paddingTop = top;
                    paddingBottom = bottom;
                } else if (paddings.length == 4) {
                    int left;
                    top = this.getPixels(paddings[0]);
                    int right = this.getPixels(paddings[1]);
                    bottom = this.getPixels(paddings[2]);
                    paddingLeft = left = this.getPixels(paddings[3]);
                    paddingRight = right;
                    paddingTop = top;
                    paddingBottom = bottom;
                } else {
                    paddingLeft = -1;
                    paddingRight = -1;
                    paddingTop = -1;
                    paddingBottom = -1;
                }
                if (paddingLeft != -1) {
                    context.replaceLastDefaultMarginLeft(paddingLeft);
                }
                if (paddingRight != -1) {
                    context.replaceLastDefaultMarginRight(paddingRight);
                }
                if (paddingTop != -1) {
                    context.replaceLastDefaultMarginTop(paddingTop);
                }
                if (paddingBottom == -1) continue;
                context.replaceLastDefaultMarginBottom(paddingBottom);
            }
            Integer marginLeft = context.getMarginLeft();
            if (marginLeft != null) {
                paragraph.setMarginLeft(marginLeft.intValue());
            }
            if ((marginRight = context.getMarginRight()) != null) {
                paragraph.setMarginRight(marginRight.intValue());
            }
            if ((marginTop = context.getMarginTop()) != null) {
                paragraph.setMarginTop(marginTop.intValue());
            }
            if ((marginBottom = context.getMarginBottom()) != null) {
                paragraph.setMarginBottom(marginBottom.intValue());
            }
        }
    }

    private void setMarginLeft(M2DocHTMLParser.Context context, MParagraph paragraph) {
        Integer paddingLeft;
        List<String> cssPaddingLefts;
        Integer marginLeft;
        List<String> cssMarginLefts = context.getCssProperties().get(CSS_MARGIN_LEFT);
        if (cssMarginLefts != null) {
            int value = -1;
            for (String cssMarginLeft : cssMarginLefts) {
                value = this.getPixels(cssMarginLeft);
            }
            if (value != -1) {
                context.replaceLastDefaultMarginLeft(value);
            }
        }
        if ((marginLeft = context.getMarginLeft()) != null) {
            paragraph.setMarginLeft(marginLeft.intValue());
        }
        if ((cssPaddingLefts = context.getCssProperties().get(CSS_PADDING_LEFT)) != null) {
            int value = -1;
            for (String cssMarginLeft : cssPaddingLefts) {
                value = this.getPixels(cssMarginLeft);
            }
            if (value != -1) {
                context.replaceLastDefaultMarginLeft(value);
            }
        }
        if ((paddingLeft = context.getMarginLeft()) != null) {
            paragraph.setMarginLeft(paddingLeft.intValue());
        }
    }

    private void setMarginRight(M2DocHTMLParser.Context context, MParagraph paragraph) {
        Integer paddingRight;
        List<String> cssPaddingRights;
        Integer marginRight;
        List<String> cssMarginRights = context.getCssProperties().get(CSS_MARGIN_RIGHT);
        if (cssMarginRights != null) {
            int value = -1;
            for (String cssMarginRight : cssMarginRights) {
                value = this.getPixels(cssMarginRight);
            }
            if (value != -1) {
                context.replaceLastDefaultMarginRight(value);
            }
        }
        if ((marginRight = context.getMarginRight()) != null) {
            paragraph.setMarginRight(marginRight.intValue());
        }
        if ((cssPaddingRights = context.getCssProperties().get(CSS_PADDING_RIGHT)) != null) {
            int value = -1;
            for (String cssMarginRight : cssPaddingRights) {
                value = this.getPixels(cssMarginRight);
            }
            if (value != -1) {
                context.replaceLastDefaultMarginRight(value);
            }
        }
        if ((paddingRight = context.getMarginRight()) != null) {
            paragraph.setMarginRight(paddingRight.intValue());
        }
    }

    private void setMarginTop(M2DocHTMLParser.Context context, MParagraph paragraph) {
        Integer paddingTop;
        List<String> cssPaddingTops;
        Integer marginTop;
        List<String> cssMarginTops = context.getCssProperties().get(CSS_MARGIN_TOP);
        if (cssMarginTops != null) {
            int value = -1;
            for (String cssMarginTop : cssMarginTops) {
                value = this.getPixels(cssMarginTop);
            }
            if (value != -1) {
                context.replaceLastDefaultMarginTop(value);
            }
        }
        if ((marginTop = context.getMarginTop()) != null) {
            paragraph.setMarginTop(marginTop.intValue());
        }
        if ((cssPaddingTops = context.getCssProperties().get(CSS_PADDING_TOP)) != null) {
            int value = -1;
            for (String cssMarginTop : cssPaddingTops) {
                value = this.getPixels(cssMarginTop);
            }
            if (value != -1) {
                context.replaceLastDefaultMarginTop(value);
            }
        }
        if ((paddingTop = context.getMarginTop()) != null) {
            paragraph.setMarginTop(paddingTop.intValue());
        }
    }

    private void setMarginBottom(M2DocHTMLParser.Context context, MParagraph paragraph) {
        Integer paddingBottom;
        List<String> cssPaddingBottoms;
        Integer marginBottom;
        List<String> cssMarginBottoms = context.getCssProperties().get(CSS_MARGIN_BOTTOM);
        if (cssMarginBottoms != null) {
            int value = -1;
            for (String cssMarginBottom : cssMarginBottoms) {
                value = this.getPixels(cssMarginBottom);
            }
            if (value != -1) {
                context.replaceLastDefaultMarginBottom(value);
            }
        }
        if ((marginBottom = context.getMarginBottom()) != null) {
            paragraph.setMarginBottom(marginBottom.intValue());
        }
        if ((cssPaddingBottoms = context.getCssProperties().get(CSS_PADDING_BOTTOM)) != null) {
            int value = -1;
            for (String cssMarginBottom : cssPaddingBottoms) {
                value = this.getPixels(cssMarginBottom);
            }
            if (value != -1) {
                context.replaceLastDefaultMarginBottom(value);
            }
        }
        if ((paddingBottom = context.getMarginBottom()) != null) {
            paragraph.setMarginBottom(paddingBottom.intValue());
        }
    }
}

