/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.tests;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.services.HTTPServiceConfigurator;
import org.obeonetwork.m2doc.services.TemplateRegistry;
import org.obeonetwork.m2doc.services.TokenRegistry;
import org.obeonetwork.m2doc.services.configurator.IServicesConfigurator;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.osgi.framework.Bundle;

public class BundleTests {
    @Before
    public void setUp() {
        M2DocUtils.class.getName();
        M2DocPlugin.getPlugin();
    }

    @Test
    public void notSingleton() {
        Bundle bundle = Platform.getBundle((String)"org.obeonetwork.m2doc");
        Assert.assertNotNull((Object)bundle);
        Assert.assertNull(bundle.getHeaders().get("singleton"));
    }

    @Test
    public void isRegistredEcore() {
        Assert.assertNotNull((Object)EPackage.Registry.INSTANCE.getEPackage("http://www.obeonetwork.org/m2doc/template/1.0"));
    }

    @Test
    public void serviceTokenExtensionPoint() {
        Map map = TokenRegistry.INSTANCE.getServices("test token");
        Assert.assertNotNull((Object)map);
        List list = (List)map.get("org.obeonetwork.m2doc.ide.tests");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"org.obeonetwork.m2doc.ide.tests.services.TestServiceClass1", list.get(0));
        Assert.assertEquals((Object)"org.obeonetwork.m2doc.ide.tests.services.TestServiceClass2", list.get(1));
    }

    @Test
    public void packageTokenExtensionPoint() {
        List list = TokenRegistry.INSTANCE.getPackages("test token");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"http://www.obeonetwork.org/m2doc/template/1.0", list.get(0));
        Assert.assertEquals((Object)"http://www.eclipse.org/emf/2002/Ecore", list.get(1));
    }

    @Test
    public void templateExtensionPoint() {
        Map map = TemplateRegistry.INSTANCE.getTemplates();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"platform:/plugin/org.obeonetwork.m2doc.ide.tests/resources/test-template.docx", (Object)((URI)map.get("Test template")).toString());
    }

    @Test
    public void isRegisteredHTTPServiceConfigurator() {
        boolean hasHTTPServiceConfigurator = false;
        for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
            if (!(configurator instanceof HTTPServiceConfigurator)) continue;
            hasHTTPServiceConfigurator = true;
            break;
        }
        Assert.assertTrue((boolean)hasHTTPServiceConfigurator);
    }
}

