/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.junit.Assert;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.TemplatePackage;
import org.obeonetwork.m2doc.tests.ImageTestUtils;

public final class M2DocTestUtils {
    private static final MessageDigest MESSAGE_DIGEST = M2DocTestUtils.initialiseMessageDigest();
    private static final double IMAGE_THRESHOLD = 0.4;
    private static final int BUFFER_SIZE = 8192;

    protected static MessageDigest initialiseMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private M2DocTestUtils() {
    }

    public static void assertTemplateValidationMessage(TemplateValidationMessage actualMessage, ValidationMessageLevel expectedLevel, String exprectedMessage, XWPFRun expectetLocation) {
        Assert.assertEquals((Object)expectedLevel, (Object)actualMessage.getLevel());
        Assert.assertEquals((Object)exprectedMessage, (Object)actualMessage.getMessage());
        Assert.assertEquals((Object)expectetLocation, (Object)actualMessage.getLocation());
    }

    public static XWPFRun getRunContaining(XWPFDocument document, String text) {
        XWPFRun res = null;
        block0: for (XWPFParagraph paragraph : document.getParagraphs()) {
            for (XWPFRun run : paragraph.getRuns()) {
                if (!run.text().contains(text)) continue;
                res = run;
                continue block0;
            }
        }
        return res;
    }

    public static DocumentTemplate createDocumentTemplate(Block body) {
        DocumentTemplate res = TemplatePackage.eINSTANCE.getTemplateFactory().createDocumentTemplate();
        XMIResourceImpl r = new XMIResourceImpl();
        r.getContents().add((Object)res);
        XWPFDocument document = new XWPFDocument();
        res.setDocument(document);
        res.setBody(body);
        XWPFParagraph paragraph = document.createParagraph();
        M2DocTestUtils.linkRuns(paragraph, (IConstruct)body);
        return res;
    }

    private static void linkRuns(XWPFParagraph paragraph, IConstruct construct) {
        construct.setStyleRun(paragraph.createRun());
        construct.getRuns().add((Object)paragraph.createRun());
        construct.getRuns().add((Object)paragraph.createRun());
        construct.getRuns().add((Object)paragraph.createRun());
        for (EObject child : construct.eContents()) {
            if (!(child instanceof IConstruct)) continue;
            M2DocTestUtils.linkRuns(paragraph, (IConstruct)child);
        }
        construct.getClosingRuns().add((Object)paragraph.createRun());
        construct.getClosingRuns().add((Object)paragraph.createRun());
        construct.getClosingRuns().add((Object)paragraph.createRun());
    }

    public static void assertDocx(URI expectedURI, URI actualURI) throws FileNotFoundException, IOException {
        M2DocTestUtils.assertDocx(URIConverter.INSTANCE, expectedURI, actualURI);
    }

    public static void assertDocx(URIConverter uriConverter, URI expectedURI, URI actualURI) throws FileNotFoundException, IOException {
        String expectedTextContent = M2DocTestUtils.getPortableString(M2DocTestUtils.getTextContent(uriConverter, expectedURI));
        String actualTextContent = M2DocTestUtils.getPortableString(M2DocTestUtils.getTextContent(uriConverter, actualURI));
        Assert.assertEquals((Object)expectedTextContent, (Object)actualTextContent);
        M2DocTestUtils.assertArchiveContent(uriConverter, expectedURI, actualURI);
    }

    public static String getPortableString(String textContent) {
        String res = textContent.replaceAll("/home/.*/M2Doc", "/home/.../M2Doc");
        res = res.replaceAll("file:/.*/M2Doc", "file:/.../M2Doc");
        res = res.replaceAll("Aucun fichier ou dossier de ce nom", "No such file or directory");
        res = res.replaceAll("Aucun fichier ou dossier de ce type", "No such file or directory");
        res = res.replaceAll("20[^ ]* [^ ]* - Lost", "20...date and time... - Lost");
        res = res.replaceAll("@[a-f0-9]{5,8}[, )]", "@00000000 ");
        res = res.replaceAll("(\\tat [a-zA-Z0-9$./]+((<|&lt;)init(>|&gt;))?\\((Unknown Source|Native Method|[a-zA-Z0-9$./]+java:[0-9]+)\\)\n?)+", "...STACK...");
        res = res.replaceAll("127.0.0.100:12.345", "127.0.0.100:12 345");
        res = res.replaceAll("127.0.0.100:12,345", "127.0.0.100:12 345");
        return res;
    }

    public static String getTextContent(URI uri) {
        return M2DocTestUtils.getTextContent(URIConverter.INSTANCE, uri);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTextContent(URIConverter uriConverter, URI uri) {
        Object result = "";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                InputStream is = uriConverter.createInputStream(uri);
                try {
                    block26: {
                        OPCPackage oPackage = OPCPackage.open((InputStream)is);
                        try {
                            block25: {
                                XWPFDocument document = new XWPFDocument(oPackage);
                                try {
                                    try (XWPFWordExtractor ex = new XWPFWordExtractor(document);){
                                        result = (String)result + "===== Document Text ====\n";
                                        result = (String)result + ex.getText();
                                    }
                                    if (document == null) break block25;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (document == null) throw throwable;
                                    document.close();
                                    throw throwable;
                                }
                                document.close();
                            }
                            if (oPackage == null) break block26;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (oPackage == null) throw throwable;
                            oPackage.close();
                            throw throwable;
                        }
                        oPackage.close();
                    }
                    if (is == null) return result;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return result;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static void assertArchiveContent(URI expectedURI, URI actualURI) throws IOException, FileNotFoundException {
        M2DocTestUtils.assertArchiveContent(URIConverter.INSTANCE, expectedURI, actualURI);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertArchiveContent(URIConverter uriConverter, URI expectedURI, URI actualURI) throws IOException, FileNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream expectedIs = uriConverter.createInputStream(expectedURI);
            try {
                block31: {
                    ZipInputStream expectedZin = new ZipInputStream(new BufferedInputStream(expectedIs));
                    try {
                        block30: {
                            InputStream actualIs = uriConverter.createInputStream(actualURI);
                            try {
                                try (ZipInputStream actualZin = new ZipInputStream(new BufferedInputStream(actualIs));){
                                    Map<String, byte[]> expectedContent = M2DocTestUtils.getContentMap(expectedZin);
                                    Map<String, byte[]> actualContent = M2DocTestUtils.getContentMap(actualZin);
                                    Iterator<Map.Entry<String, byte[]>> iterator = expectedContent.entrySet().iterator();
                                    while (true) {
                                        File imageDiff;
                                        if (!iterator.hasNext()) {
                                            Assert.assertEquals((long)expectedContent.size(), (long)actualContent.size());
                                            break;
                                        }
                                        Map.Entry<String, byte[]> entry = iterator.next();
                                        ByteArrayInputStream expectedInputStream = new ByteArrayInputStream(entry.getValue());
                                        ByteArrayInputStream actualInputStream = new ByteArrayInputStream(actualContent.get(entry.getKey()));
                                        if (entry.getKey().endsWith(".xml") || entry.getKey().endsWith(".rels")) {
                                            String expectedXMLContent = M2DocTestUtils.getXMLContent(expectedInputStream, entry.getKey());
                                            String actualXMLContent = M2DocTestUtils.getXMLContent(actualInputStream, entry.getKey());
                                            Assert.assertEquals((Object)expectedXMLContent, (Object)actualXMLContent);
                                            continue;
                                        }
                                        if (entry.getKey().endsWith(".jpeg") || entry.getKey().endsWith(".jpg")) {
                                            imageDiff = M2DocTestUtils.getDiffImageFile(expectedURI.toFileString(), entry.getKey());
                                            ImageTestUtils.assertJPG(imageDiff, expectedInputStream, actualInputStream, 0.4);
                                            continue;
                                        }
                                        if (entry.getKey().endsWith(".gif")) {
                                            imageDiff = M2DocTestUtils.getDiffImageFile(expectedURI.toFileString(), entry.getKey());
                                            ImageTestUtils.assertGIF(imageDiff, expectedInputStream, actualInputStream, 0.4);
                                            continue;
                                        }
                                        if (entry.getKey().endsWith(".png")) {
                                            imageDiff = M2DocTestUtils.getDiffImageFile(expectedURI.toFileString(), entry.getKey());
                                            ImageTestUtils.assertPNG(imageDiff, expectedInputStream, actualInputStream, 0.4);
                                            continue;
                                        }
                                        if (entry.getKey().endsWith(".bmp")) {
                                            imageDiff = M2DocTestUtils.getDiffImageFile(expectedURI.toFileString(), entry.getKey());
                                            ImageTestUtils.assertBMP(imageDiff, expectedInputStream, actualInputStream, 0.4);
                                            continue;
                                        }
                                        String expectedHash = M2DocTestUtils.getZipEntryHash(expectedInputStream, entry.getKey());
                                        String actualHash = M2DocTestUtils.getZipEntryHash(actualInputStream, entry.getKey());
                                        Assert.assertEquals((Object)expectedHash, (Object)actualHash);
                                    }
                                }
                                if (actualIs == null) break block30;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (actualIs == null) throw throwable;
                                actualIs.close();
                                throw throwable;
                            }
                            actualIs.close();
                        }
                        if (expectedZin == null) break block31;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (expectedZin == null) throw throwable;
                        expectedZin.close();
                        throw throwable;
                    }
                    expectedZin.close();
                }
                if (expectedIs == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (expectedIs == null) throw throwable;
                expectedIs.close();
                throw throwable;
            }
            expectedIs.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    protected static Map<String, byte[]> getContentMap(ZipInputStream zin) throws IOException {
        ZipEntry zipEntry;
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        while ((zipEntry = zin.getNextEntry()) != null) {
            res.put(zipEntry.getName(), M2DocTestUtils.getBytes(zin));
        }
        return res;
    }

    private static byte[] getBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int size = stream.read(buffer, 0, buffer.length);
        while (size != -1) {
            out.write(buffer, 0, size);
            size = stream.read(buffer, 0, buffer.length);
        }
        out.flush();
        return out.toByteArray();
    }

    private static String getString(InputStream stream) {
        String res;
        Throwable throwable = null;
        Object var3_3 = null;
        try {
            Scanner scanner = new Scanner(stream, "UTF-8");
            try {
                try (Scanner s = scanner.useDelimiter("\\A");){
                    res = s.hasNext() ? s.next() : "";
                }
                if (scanner != null) {
                    scanner.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (scanner != null) {
                    scanner.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return res;
    }

    private static File getDiffImageFile(String expectedDocxPath, String entryName) throws IOException {
        File result = new File(expectedDocxPath + "-diff-" + entryName.replaceAll("/", "-"));
        return result;
    }

    private static String getXMLContent(InputStream inputStream, String entryName) throws IOException {
        StringBuilder result = new StringBuilder();
        result.append(String.format("\n%s | ", entryName));
        String fileContent = M2DocTestUtils.getString(inputStream);
        fileContent = M2DocTestUtils.indentXML(fileContent);
        fileContent = fileContent.replace("\r\n", "\n");
        fileContent = fileContent.replaceAll("rsidR=\"([^\"]+)", "");
        fileContent = fileContent.replaceAll("id=\"([^\"]+)", "");
        fileContent = fileContent.replaceAll("descr=\"([^\"]+)", "");
        fileContent = M2DocTestUtils.getPortableString(fileContent);
        result.append(String.format("\n%s\n", fileContent));
        return result.toString();
    }

    private static String getZipEntryHash(InputStream inputStream, String entryName) throws IOException {
        StringBuilder result = new StringBuilder();
        byte[] code = MESSAGE_DIGEST.digest(M2DocTestUtils.getBytes(inputStream));
        result.append(String.format("\n%s | ", entryName));
        result.append(String.format("\n md5:%s", M2DocTestUtils.getHexString(code)));
        return result.toString();
    }

    public static String getHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
            ++i;
        }
        return hexString.toString();
    }

    private static String indentXML(String fileContent) throws IOException {
        String res;
        block15: {
            StreamResult xmlOutput = null;
            try {
                StreamSource xmlInput = new StreamSource(new StringReader(fileContent));
                xmlOutput = new StreamResult(new StringWriter());
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                try {
                    transformer.transform(xmlInput, xmlOutput);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerFactoryConfigurationError e) {
                e.printStackTrace();
            }
            if (xmlOutput != null) {
                Throwable throwable = null;
                Object var4_2 = null;
                try (Writer writer = xmlOutput.getWriter();){
                    res = writer.toString();
                    break block15;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            res = fileContent;
        }
        return res;
    }
}

