/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.Bookmark;
import org.obeonetwork.m2doc.template.Cell;
import org.obeonetwork.m2doc.template.Comment;
import org.obeonetwork.m2doc.template.ContentControl;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.Link;
import org.obeonetwork.m2doc.template.Parameter;
import org.obeonetwork.m2doc.template.Query;
import org.obeonetwork.m2doc.template.Repetition;
import org.obeonetwork.m2doc.template.Row;
import org.obeonetwork.m2doc.template.StaticFragment;
import org.obeonetwork.m2doc.template.Table;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.UserDoc;
import org.obeonetwork.m2doc.template.util.TemplateSwitch;

public class TemplateAstSerializer
extends TemplateSwitch<Void> {
    private StringBuilder builder;
    private QueryAstSerializer querySerializer = new QueryAstSerializer();
    private String indentation;

    protected void indent() {
        this.indentation = String.valueOf(this.indentation) + "  ";
    }

    protected void deindent() {
        this.indentation = this.indentation.substring(0, this.indentation.length() - 2);
    }

    public String serialize(DocumentTemplate documentTemplate) {
        this.builder = new StringBuilder();
        this.indentation = "";
        this.doSwitch((EObject)documentTemplate);
        return this.builder.toString();
    }

    protected void newLine() {
        this.builder.append("\n" + this.indentation);
    }

    public Void caseDocumentTemplate(DocumentTemplate documentTemplate) {
        this.newLine();
        this.builder.append("=== HEADER ===");
        this.newLine();
        for (Block header : documentTemplate.getHeaders()) {
            this.doSwitch((EObject)header);
        }
        this.newLine();
        this.builder.append("=== BODY ===");
        this.newLine();
        this.doSwitch((EObject)documentTemplate.getBody());
        this.newLine();
        this.builder.append("=== FOOTER ===");
        this.newLine();
        for (Block footer : documentTemplate.getFooters()) {
            this.doSwitch((EObject)footer);
        }
        this.newLine();
        this.builder.append("=== TEMPLATES ===");
        for (Template template : documentTemplate.getTemplates()) {
            this.newLine();
            this.doSwitch((EObject)template);
        }
        return null;
    }

    public Void caseTemplate(Template template) {
        this.newLine();
        this.builder.append("template ");
        this.builder.append(template.getVisibility());
        this.builder.append(" ");
        this.builder.append(template.getName());
        this.builder.append(" (");
        if (!template.getParameters().isEmpty()) {
            Iterator it = template.getParameters().iterator();
            this.doSwitch((EObject)it.next());
            while (it.hasNext()) {
                this.builder.append(", ");
                this.doSwitch((EObject)it.next());
            }
        }
        this.builder.append(")");
        this.doSwitch((EObject)template.getBody());
        return null;
    }

    public Void caseParameter(Parameter parameter) {
        this.builder.append(parameter.getName());
        this.builder.append(" : ");
        this.builder.append(this.querySerializer.serialize(parameter.getType().getAst()));
        return null;
    }

    public Void caseStaticFragment(StaticFragment staticFragment) {
        for (XWPFRun run : staticFragment.getRuns()) {
            this.builder.append(run.text().replaceAll("\r\n", "\n" + this.indentation).replaceAll("\r", "\n" + this.indentation));
        }
        return null;
    }

    public Void caseComment(Comment comment) {
        this.builder.append(String.format("comment: %s", comment.getText()));
        return null;
    }

    public Void caseQuery(Query query) {
        this.builder.append(String.format("[query: %s]", this.querySerializer.serialize(query.getQuery().getAst())));
        return null;
    }

    public Void caseRepetition(Repetition repetition) {
        this.newLine();
        this.builder.append("for ");
        this.builder.append(repetition.getIterationVar());
        this.builder.append(" | ");
        this.builder.append(this.querySerializer.serialize(repetition.getQuery().getAst()));
        this.builder.append(" do");
        this.doSwitch((EObject)repetition.getBody());
        this.newLine();
        this.builder.append("endfor");
        this.newLine();
        return null;
    }

    public Void caseLet(org.obeonetwork.m2doc.template.Let let) {
        this.newLine();
        this.builder.append("let ");
        this.builder.append(let.getName());
        this.builder.append(" = ");
        this.builder.append(this.querySerializer.serialize(let.getValue().getAst()));
        this.builder.append(" in");
        this.doSwitch((EObject)let.getBody());
        this.newLine();
        this.builder.append("endfor");
        this.newLine();
        return null;
    }

    public Void caseUserDoc(UserDoc userDoc) {
        this.newLine();
        this.builder.append("userdoc ");
        this.builder.append(this.querySerializer.serialize(userDoc.getId().getAst()));
        this.builder.append(" do");
        this.indent();
        this.newLine();
        this.doSwitch((EObject)userDoc.getBody());
        this.deindent();
        this.newLine();
        this.builder.append("enduserdoc");
        this.newLine();
        return null;
    }

    public Void caseConditional(org.obeonetwork.m2doc.template.Conditional conditional) {
        this.newLine();
        this.builder.append("if ");
        this.builder.append(this.querySerializer.serialize(conditional.getCondition().getAst()));
        this.builder.append(" then");
        this.doSwitch((EObject)conditional.getThen());
        if (conditional.getElse() != null) {
            this.newLine();
            this.builder.append("else");
            this.doSwitch((EObject)conditional.getElse());
        }
        this.newLine();
        this.builder.append("endif");
        this.newLine();
        return null;
    }

    public Void caseBlock(Block block) {
        this.indent();
        for (IConstruct construct : block.getStatements()) {
            this.newLine();
            this.doSwitch((EObject)construct);
        }
        this.deindent();
        return null;
    }

    public Void caseTable(Table table) {
        this.builder.append("table");
        this.indent();
        this.newLine();
        for (Row row : table.getRows()) {
            this.doSwitch((EObject)row);
            this.newLine();
        }
        this.deindent();
        return null;
    }

    public Void caseRow(Row row) {
        this.builder.append("row");
        this.indent();
        this.newLine();
        for (Cell cell : row.getCells()) {
            this.doSwitch((EObject)cell);
            this.newLine();
        }
        this.deindent();
        return null;
    }

    public Void caseCell(Cell cell) {
        this.doSwitch((EObject)cell.getBody());
        return null;
    }

    public Void caseBookmark(Bookmark bookmark) {
        this.newLine();
        this.builder.append("bookmark ");
        this.builder.append(this.querySerializer.serialize(bookmark.getName().getAst()));
        this.doSwitch((EObject)bookmark.getBody());
        this.newLine();
        this.builder.append("endbookmark");
        this.newLine();
        return null;
    }

    public Void caseLink(Link link) {
        this.newLine();
        this.builder.append("link ");
        this.builder.append(this.querySerializer.serialize(link.getName().getAst()));
        this.builder.append(" ");
        this.builder.append(this.querySerializer.serialize(link.getText().getAst()));
        this.builder.append(" endlink");
        this.newLine();
        return null;
    }

    public Void caseContentControl(ContentControl contentControl) {
        this.newLine();
        this.builder.append("content control");
        this.newLine();
        return null;
    }

    private final class QueryAstSerializer
    extends AstSwitch<Void> {
        private StringBuilder builder;

        private QueryAstSerializer() {
        }

        public String serialize(Expression expression) {
            this.builder = new StringBuilder();
            if (expression != null) {
                this.doSwitch((EObject)expression);
            } else {
                this.builder.append("null");
            }
            return this.builder.toString();
        }

        public Void caseBinding(Binding binding) {
            this.builder.append(binding.getName());
            if (binding.getType() != null) {
                this.builder.append(" : ");
                this.builder.append(this.doSwitch((EObject)binding.getType()));
            }
            this.builder.append(" = ");
            this.builder.append(this.doSwitch((EObject)binding.getValue()));
            return null;
        }

        public Void caseBooleanLiteral(BooleanLiteral booleanLiteral) {
            this.builder.append(booleanLiteral.isValue());
            return null;
        }

        public Void caseCall(Call call) {
            if (call.getType() == CallType.COLLECTIONCALL) {
                this.builder.append("->");
            } else {
                this.builder.append(".");
            }
            this.builder.append(call.getServiceName());
            this.builder.append("(");
            StringBuilder previousBuilder = this.builder;
            this.builder = new StringBuilder();
            for (Expression argument : call.getArguments()) {
                this.doSwitch((EObject)argument);
                this.builder.append(", ");
            }
            if (this.builder.length() > 0) {
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            this.builder = previousBuilder;
            this.builder.append(")");
            return null;
        }

        public Void caseCollectionTypeLiteral(CollectionTypeLiteral collectionTypeLiteral) {
            if (collectionTypeLiteral.getValue() == List.class) {
                this.builder.append("Sequence(");
            } else if (collectionTypeLiteral.getValue() == Set.class) {
                this.builder.append("OrderedSet(");
            } else {
                this.builder.append("***invalid type of collection ***(");
            }
            this.doSwitch((EObject)collectionTypeLiteral.getElementType());
            this.builder.append("");
            return null;
        }

        public Void caseConditional(Conditional conditional) {
            this.builder.append("if (");
            this.doSwitch((EObject)conditional.getPredicate());
            this.builder.append(") then ");
            if (conditional.getTrueBranch() != null) {
                this.doSwitch((EObject)conditional.getTrueBranch());
            }
            this.builder.append(" else ");
            if (conditional.getFalseBranch() != null) {
                this.doSwitch((EObject)conditional.getFalseBranch());
            }
            this.builder.append(" endif ");
            return null;
        }

        public Void caseEnumLiteral(EnumLiteral enumLiteral) {
            this.builder.append(enumLiteral.getLiteral().getEEnum().getEPackage().getName());
            this.builder.append("::");
            this.builder.append(enumLiteral.getLiteral().getEEnum().getName());
            this.builder.append("::");
            this.builder.append(enumLiteral.getLiteral().getName());
            return null;
        }

        public Void caseError(Error error) {
            this.builder.append("***ERROR***");
            return null;
        }

        public Void caseIntegerLiteral(IntegerLiteral object) {
            this.builder.append(object.getValue());
            return null;
        }

        public Void caseLambda(Lambda lambda) {
            this.doSwitch((EObject)lambda.getParameters().get(0));
            this.builder.append(" | ");
            this.doSwitch((EObject)lambda.getExpression());
            return null;
        }

        public Void caseLet(Let let) {
            this.builder.append("let ");
            StringBuilder previousBuilder = this.builder;
            this.builder = new StringBuilder();
            for (Binding binding : let.getBindings()) {
                this.doSwitch((EObject)binding);
                this.builder.append(", ");
            }
            previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            this.builder.append(" in ");
            this.doSwitch((EObject)let.getBody());
            return (Void)super.caseLet(let);
        }

        public Void caseNullLiteral(NullLiteral nullLiteral) {
            this.builder.append("null");
            return null;
        }

        public Void caseSequenceInExtensionLiteral(SequenceInExtensionLiteral sequenceInExtensionLiteral) {
            this.builder.append("Sequence{");
            if (!sequenceInExtensionLiteral.getValues().isEmpty()) {
                StringBuilder previousBuilder = this.builder;
                this.builder = new StringBuilder();
                for (Expression value : sequenceInExtensionLiteral.getValues()) {
                    this.doSwitch((EObject)value);
                    this.builder.append(", ");
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
                this.builder = previousBuilder;
            }
            this.builder.append("}");
            return null;
        }

        public Void caseRealLiteral(RealLiteral realLiteral) {
            this.builder.append(realLiteral.getValue());
            return null;
        }

        public Void caseSetInExtensionLiteral(SetInExtensionLiteral setInExtensionLiteral) {
            this.builder.append("OrderedSet{");
            if (!setInExtensionLiteral.getValues().isEmpty()) {
                StringBuilder previousBuilder = this.builder;
                this.builder = new StringBuilder();
                for (Expression value : setInExtensionLiteral.getValues()) {
                    this.doSwitch((EObject)value);
                    this.builder.append(", ");
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
                this.builder = previousBuilder;
            }
            this.builder.append("}");
            return null;
        }

        public Void caseStringLiteral(StringLiteral stringLiteral) {
            this.builder.append("'");
            this.builder.append(stringLiteral.getValue().replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r").replaceAll("\t", "\\\\t"));
            this.builder.append("'");
            return null;
        }

        public Void caseTypeSetLiteral(TypeSetLiteral typeSetLiteral) {
            this.builder.append("{");
            StringBuilder previousBuilder = this.builder;
            this.builder = new StringBuilder();
            for (TypeLiteral type : typeSetLiteral.getTypes()) {
                this.doSwitch((EObject)type);
                this.builder.append(" | ");
            }
            previousBuilder.append(this.builder.substring(0, this.builder.length() - 3));
            this.builder.append("}");
            return null;
        }

        public Void caseTypeLiteral(TypeLiteral object) {
            if (object.getValue() instanceof Class) {
                this.builder.append(((Class)object.getValue()).getName());
            } else if (object.getValue() instanceof EClassifier) {
                this.builder.append(((EClassifier)object.getValue()).getName());
            }
            return null;
        }

        public Void caseVariableDeclaration(VariableDeclaration variableDeclaration) {
            this.builder.append(variableDeclaration.getName());
            if (variableDeclaration.getType() != null) {
                this.builder.append(" : ");
                this.doSwitch((EObject)variableDeclaration.getType());
            }
            this.builder.append(" = ");
            this.doSwitch((EObject)variableDeclaration.getExpression());
            return null;
        }

        public Void caseVarRef(VarRef varRef) {
            this.builder.append(varRef.getVariableName());
            return null;
        }
    }
}

