/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.tests.AbstractTemplatesTestSuite;

public class TestMigration {
    public static void main(String[] args) {
        if (args.length >= 2) {
            int i = 1;
            while (i < args.length) {
                String rootName = args[i];
                File root = new File(rootName);
                TestMigration.walkFolder(root, args[0]);
                ++i;
            }
        } else {
            System.out.println("USAGE: 3.3.0 /mnt/development/git/M2Doc /mnt/development/git/M2Doc-gh-pages");
        }
    }

    private static void walkFolder(File root, String oldVersion) {
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                TestMigration.walkFolder(child, oldVersion);
            } else if (child.getName().endsWith(".docx")) {
                uri = URI.createFileURI((String)child.getAbsolutePath());
                if (!TestMigration.isEmpty(uri)) {
                    ZipSecureFile.setMinInflateRatio((double)0.002);
                    try {
                        Throwable throwable = null;
                        var8_10 = null;
                        try (XWPFDocument xwpfDocument = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, uri);){
                            TemplateCustomProperties properties = new TemplateCustomProperties(xwpfDocument);
                            if (oldVersion.equals(properties.getM2DocVersion())) {
                                properties.setM2DocVersion("4.0.1");
                                properties.save();
                                POIServices.getInstance().saveFile(URIConverter.INSTANCE, xwpfDocument, uri);
                                System.out.println("Migrated: " + child.getAbsolutePath());
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (child.getName().endsWith(".test")) {
                String content;
                Object var9_16;
                uri = URI.createFileURI((String)child.getAbsolutePath());
                try {
                    var8_10 = null;
                    var9_16 = null;
                    try (InputStream input = URIConverter.INSTANCE.createInputStream(uri);){
                        content = AbstractTemplatesTestSuite.getContent(input, StandardCharsets.UTF_8.name());
                    }
                    catch (Throwable throwable) {
                        if (var8_10 == null) {
                            var8_10 = throwable;
                        } else if (var8_10 != throwable) {
                            var8_10.addSuppressed(throwable);
                        }
                        throw var8_10;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    content = null;
                }
                if (content != null && content.contains(oldVersion)) {
                    content = content.replace(oldVersion, "4.0.1");
                    try {
                        Throwable e = null;
                        var9_16 = null;
                        try (OutputStream output = URIConverter.INSTANCE.createOutputStream(uri);){
                            AbstractTemplatesTestSuite.setContent(output, StandardCharsets.UTF_8.name(), content);
                            System.out.println("Migrated: " + child.getAbsolutePath());
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                            } else if (e != throwable) {
                                e.addSuppressed(throwable);
                            }
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }

    private static boolean isEmpty(URI uri) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = URIConverter.INSTANCE.createInputStream(uri);){
                boolean bl = inputStream.read() == -1;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return true;
        }
    }
}

