/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.junit.Assert;
import org.junit.Test;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.tests.M2DocTestUtils;
import org.obeonetwork.m2doc.util.ClassProvider;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class TemplateValidationGeneratorTests {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testInfoGeneration() throws InvalidFormatException, IOException, DocumentParserException, DocumentGenerationException {
        File tempFile;
        block27: {
            IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
            tempFile = File.createTempFile("testParsingErrorSimpleTag", ".docx");
            Throwable throwable = null;
            Object var4_6 = null;
            try (DocumentTemplate documentTemplate = M2DocUtils.parse((URIConverter)URIConverter.INSTANCE, (URI)URI.createFileURI((String)"resources/document/notEmpty/notEmpty-template.docx"), (IQueryEnvironment)queryEnvironment, (IClassProvider)new ClassProvider(this.getClass().getClassLoader()), (Monitor)new BasicMonitor());){
                XWPFRun location = (XWPFRun)((XWPFParagraph)documentTemplate.getDocument().getBodyElements().get(0)).getRuns().get(0);
                documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.INFO, "XXXXXXXXXXXXXXXXXXXXXXXX", location));
                M2DocUtils.serializeValidatedDocumentTemplate((URIConverter)URIConverter.INSTANCE, (DocumentTemplate)documentTemplate, (URI)URI.createFileURI((String)tempFile.getAbsolutePath()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
            Assert.assertTrue((boolean)new File(tempFile.getAbsolutePath()).exists());
            throwable = null;
            var4_6 = null;
            try {
                FileInputStream resIs = new FileInputStream(tempFile.getAbsolutePath());
                try {
                    block26: {
                        OPCPackage resOPackage = OPCPackage.open((InputStream)resIs);
                        try {
                            try (XWPFDocument resDocument = new XWPFDocument(resOPackage);){
                                XWPFRun messageRun = M2DocTestUtils.getRunContaining(resDocument, "XXXXXXXXXXXXXXXXXXXXXXXX");
                                Assert.assertNotNull((Object)messageRun);
                                Assert.assertEquals((Object)"XXXXXXXXXXXXXXXXXXXXXXXX", (Object)messageRun.text());
                                Assert.assertEquals((Object)"0000FF", (Object)messageRun.getColor());
                            }
                            if (resOPackage == null) break block26;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (resOPackage == null) throw throwable;
                            resOPackage.close();
                            throw throwable;
                        }
                        resOPackage.close();
                    }
                    if (resIs == null) break block27;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (resIs == null) throw throwable;
                    resIs.close();
                    throw throwable;
                }
                resIs.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        tempFile.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testWarningGeneration() throws InvalidFormatException, IOException, DocumentParserException, DocumentGenerationException {
        File tempFile;
        block27: {
            IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
            tempFile = File.createTempFile("testParsingErrorSimpleTag", ".docx");
            Throwable throwable = null;
            Object var4_6 = null;
            try (DocumentTemplate documentTemplate = M2DocUtils.parse((URIConverter)URIConverter.INSTANCE, (URI)URI.createFileURI((String)"resources/document/notEmpty/notEmpty-template.docx"), (IQueryEnvironment)queryEnvironment, (IClassProvider)new ClassProvider(this.getClass().getClassLoader()), (Monitor)new BasicMonitor());){
                XWPFRun location = (XWPFRun)((XWPFParagraph)documentTemplate.getDocument().getBodyElements().get(0)).getRuns().get(0);
                documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.WARNING, "XXXXXXXXXXXXXXXXXXXXXXXX", location));
                M2DocUtils.serializeValidatedDocumentTemplate((URIConverter)URIConverter.INSTANCE, (DocumentTemplate)documentTemplate, (URI)URI.createFileURI((String)tempFile.getAbsolutePath()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
            Assert.assertTrue((boolean)new File(tempFile.getAbsolutePath()).exists());
            throwable = null;
            var4_6 = null;
            try {
                FileInputStream resIs = new FileInputStream(tempFile.getAbsolutePath());
                try {
                    block26: {
                        OPCPackage resOPackage = OPCPackage.open((InputStream)resIs);
                        try {
                            try (XWPFDocument resDocument = new XWPFDocument(resOPackage);){
                                XWPFRun messageRun = M2DocTestUtils.getRunContaining(resDocument, "XXXXXXXXXXXXXXXXXXXXXXXX");
                                Assert.assertNotNull((Object)messageRun);
                                Assert.assertEquals((Object)"XXXXXXXXXXXXXXXXXXXXXXXX", (Object)messageRun.text());
                                Assert.assertEquals((Object)"FFA500", (Object)messageRun.getColor());
                            }
                            if (resOPackage == null) break block26;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (resOPackage == null) throw throwable;
                            resOPackage.close();
                            throw throwable;
                        }
                        resOPackage.close();
                    }
                    if (resIs == null) break block27;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (resIs == null) throw throwable;
                    resIs.close();
                    throw throwable;
                }
                resIs.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        tempFile.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testErrorGeneration() throws InvalidFormatException, IOException, DocumentParserException, DocumentGenerationException {
        File tempFile;
        block27: {
            IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
            tempFile = File.createTempFile("testParsingErrorSimpleTag", ".docx");
            Throwable throwable = null;
            Object var4_6 = null;
            try (DocumentTemplate documentTemplate = M2DocUtils.parse((URIConverter)URIConverter.INSTANCE, (URI)URI.createFileURI((String)"resources/document/notEmpty/notEmpty-template.docx"), (IQueryEnvironment)queryEnvironment, (IClassProvider)new ClassProvider(this.getClass().getClassLoader()), (Monitor)new BasicMonitor());){
                XWPFRun location = (XWPFRun)((XWPFParagraph)documentTemplate.getDocument().getBodyElements().get(0)).getRuns().get(0);
                documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, "XXXXXXXXXXXXXXXXXXXXXXXX", location));
                M2DocUtils.serializeValidatedDocumentTemplate((URIConverter)URIConverter.INSTANCE, (DocumentTemplate)documentTemplate, (URI)URI.createFileURI((String)tempFile.getAbsolutePath()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
            Assert.assertTrue((boolean)new File(tempFile.getAbsolutePath()).exists());
            throwable = null;
            var4_6 = null;
            try {
                FileInputStream resIs = new FileInputStream(tempFile.getAbsolutePath());
                try {
                    block26: {
                        OPCPackage resOPackage = OPCPackage.open((InputStream)resIs);
                        try {
                            try (XWPFDocument resDocument = new XWPFDocument(resOPackage);){
                                XWPFRun messageRun = M2DocTestUtils.getRunContaining(resDocument, "XXXXXXXXXXXXXXXXXXXXXXXX");
                                Assert.assertNotNull((Object)messageRun);
                                Assert.assertEquals((Object)"XXXXXXXXXXXXXXXXXXXXXXXX", (Object)messageRun.text());
                                Assert.assertEquals((Object)"FF0000", (Object)messageRun.getColor());
                            }
                            if (resOPackage == null) break block26;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (resOPackage == null) throw throwable;
                            resOPackage.close();
                            throw throwable;
                        }
                        resOPackage.close();
                    }
                    if (resIs == null) break block27;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (resIs == null) throw throwable;
                    resIs.close();
                    throw throwable;
                }
                resIs.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        tempFile.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testErrorGenerationOrder() throws InvalidFormatException, IOException, DocumentParserException, DocumentGenerationException {
        File tempFile;
        block27: {
            IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
            tempFile = File.createTempFile("testParsingErrorSimpleTag", ".docx");
            Throwable throwable = null;
            Object var4_6 = null;
            try (DocumentTemplate documentTemplate = M2DocUtils.parse((URIConverter)URIConverter.INSTANCE, (URI)URI.createFileURI((String)"resources/document/notEmpty/notEmpty-template.docx"), (IQueryEnvironment)queryEnvironment, (IClassProvider)new ClassProvider(this.getClass().getClassLoader()), (Monitor)new BasicMonitor());){
                XWPFRun location = (XWPFRun)((XWPFParagraph)documentTemplate.getDocument().getBodyElements().get(0)).getRuns().get(0);
                documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, "AAAA", location));
                documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, "BBBB", location));
                documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, "CCCC", location));
                documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, "DDDD", location));
                M2DocUtils.serializeValidatedDocumentTemplate((URIConverter)URIConverter.INSTANCE, (DocumentTemplate)documentTemplate, (URI)URI.createFileURI((String)tempFile.getAbsolutePath()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
            Assert.assertTrue((boolean)new File(tempFile.getAbsolutePath()).exists());
            throwable = null;
            var4_6 = null;
            try {
                FileInputStream resIs = new FileInputStream(tempFile.getAbsolutePath());
                try {
                    block26: {
                        OPCPackage resOPackage = OPCPackage.open((InputStream)resIs);
                        try {
                            try (XWPFDocument resDocument = new XWPFDocument(resOPackage);){
                                XWPFRun messageARun = M2DocTestUtils.getRunContaining(resDocument, "AAAA");
                                XWPFRun messageBRun = M2DocTestUtils.getRunContaining(resDocument, "BBBB");
                                XWPFRun messageCRun = M2DocTestUtils.getRunContaining(resDocument, "CCCC");
                                XWPFRun messageDRun = M2DocTestUtils.getRunContaining(resDocument, "DDDD");
                                Assert.assertNotNull((Object)messageARun);
                                Assert.assertEquals((Object)"AAAA", (Object)messageARun.text());
                                Assert.assertEquals((Object)"FF0000", (Object)messageARun.getColor());
                                Assert.assertNotNull((Object)messageBRun);
                                Assert.assertEquals((Object)"BBBB", (Object)messageBRun.text());
                                Assert.assertEquals((Object)"FF0000", (Object)messageBRun.getColor());
                                Assert.assertNotNull((Object)messageCRun);
                                Assert.assertEquals((Object)"CCCC", (Object)messageCRun.text());
                                Assert.assertEquals((Object)"FF0000", (Object)messageCRun.getColor());
                                Assert.assertNotNull((Object)messageDRun);
                                Assert.assertEquals((Object)"DDDD", (Object)messageDRun.text());
                                Assert.assertEquals((Object)"FF0000", (Object)messageDRun.getColor());
                                int indexA = ((XWPFParagraph)messageARun.getParent()).getRuns().indexOf(messageARun);
                                int indexB = ((XWPFParagraph)messageBRun.getParent()).getRuns().indexOf(messageBRun);
                                int indexC = ((XWPFParagraph)messageCRun.getParent()).getRuns().indexOf(messageCRun);
                                int indexD = ((XWPFParagraph)messageDRun.getParent()).getRuns().indexOf(messageDRun);
                                Assert.assertTrue((indexA < indexB ? 1 : 0) != 0);
                                Assert.assertTrue((indexB < indexC ? 1 : 0) != 0);
                                Assert.assertTrue((indexC < indexD ? 1 : 0) != 0);
                            }
                            if (resOPackage == null) break block26;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (resOPackage == null) throw throwable;
                            resOPackage.close();
                            throw throwable;
                        }
                        resOPackage.close();
                    }
                    if (resIs == null) break block27;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (resIs == null) throw throwable;
                    resIs.close();
                    throw throwable;
                }
                resIs.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        tempFile.delete();
    }
}

