/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests.migration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.tests.AbstractTemplatesTestSuite;
import org.obeonetwork.m2doc.tests.M2DocTestUtils;
import org.obeonetwork.m2doc.tests.TestMemoryURIHandler;
import org.obeonetwork.m2doc.util.M2DocUtils;

@RunWith(value=Parameterized.class)
public class MigrationTests {
    private static final String DOESN_T_EXIST = " doesn't exist.";
    private static final String ROOT = "resources-migration";
    private final TestMemoryURIHandler uriHandler = new TestMemoryURIHandler();
    private final URIConverter uriConverter;
    private File testTemplateFile;

    public MigrationTests(String testTemplatePath) {
        this.testTemplateFile = new File(testTemplatePath);
        this.uriConverter = new ResourceSetImpl().getURIConverter();
        this.uriConverter.getURIHandlers().add(0, (Object)this.uriHandler);
    }

    @After
    public void after() {
        this.uriHandler.clear();
    }

    @Test
    public void migrate() throws IOException {
        URI templateURI = this.getTemplateURI(this.testTemplateFile);
        URI expectedMigratedURI = this.getExpectedMigratedURI(this.testTemplateFile);
        ArrayList<TemplateValidationMessage> messages = new ArrayList<TemplateValidationMessage>();
        try {
            if (!this.uriConverter.exists(expectedMigratedURI, Collections.EMPTY_MAP)) {
                URI actualMigratedURI = this.getActualMigratedURI(this.testTemplateFile);
                messages.addAll(M2DocUtils.migrate((URIConverter)this.uriConverter, (URI)templateURI, (URI)actualMigratedURI, null, (Monitor)new BasicMonitor()));
                Assert.fail((String)(String.valueOf(expectedMigratedURI) + DOESN_T_EXIST));
            } else {
                URI memoryMigratedURI = this.getMemoryMigratedURI(this.testTemplateFile);
                messages.addAll(M2DocUtils.migrate((URIConverter)this.uriConverter, (URI)templateURI, (URI)memoryMigratedURI, null, (Monitor)new BasicMonitor()));
                M2DocTestUtils.assertDocx(this.uriConverter, expectedMigratedURI, memoryMigratedURI);
            }
        }
        catch (Exception e) {
            messages.add(new TemplateValidationMessage(ValidationMessageLevel.ERROR, e.getMessage(), null));
        }
        URI expectedMigratedMessagesURI = this.getExpectedMigratedMessagesURI(this.testTemplateFile);
        String actualMigrationMessages = this.getMigrationMessagesText(messages);
        if (!this.uriConverter.exists(expectedMigratedMessagesURI, Collections.EMPTY_MAP)) {
            URI actualMigratedMessagesURI = this.getActualMigratedMessagesURI(this.testTemplateFile);
            Throwable throwable = null;
            Object var8_14 = null;
            try (OutputStream stream = this.uriConverter.createOutputStream(actualMigratedMessagesURI);){
                AbstractTemplatesTestSuite.setContent(stream, "UTF-8", actualMigrationMessages);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Assert.fail((String)(String.valueOf(expectedMigratedMessagesURI) + DOESN_T_EXIST));
        } else {
            Throwable throwable = null;
            Object var7_12 = null;
            try (InputStream stream = this.uriConverter.createInputStream(expectedMigratedMessagesURI);){
                String expectedMigrationMessages = AbstractTemplatesTestSuite.getContent(stream, "UTF-8");
                Assert.assertEquals((Object)expectedMigrationMessages, (Object)actualMigrationMessages);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private String getMigrationMessagesText(List<TemplateValidationMessage> messages) {
        StringBuilder builder = new StringBuilder();
        for (TemplateValidationMessage message : messages) {
            builder.append(message.getLevel());
            builder.append(" - ");
            builder.append(message.getMessage());
            builder.append("\n");
        }
        return M2DocTestUtils.getPortableString(builder.toString());
    }

    private URI getExpectedMigratedURI(File file) {
        File parentFile = file.getParentFile();
        return URI.createFileURI((String)(parentFile.getAbsolutePath() + File.separator + parentFile.getName() + "-migrated-expected.docx"));
    }

    private URI getActualMigratedURI(File file) {
        File parentFile = file.getParentFile();
        return URI.createFileURI((String)(parentFile.getAbsolutePath() + File.separator + parentFile.getName() + "-migrated-actual.docx"));
    }

    private URI getMemoryMigratedURI(File file) {
        return URI.createURI((String)("m2doctest://" + String.valueOf(file) + "-migration-test.docx"), (boolean)false);
    }

    private URI getExpectedMigratedMessagesURI(File file) {
        File parentFile = file.getParentFile();
        return URI.createFileURI((String)(parentFile.getAbsolutePath() + File.separator + parentFile.getName() + "-messages-expected.txt"));
    }

    private URI getActualMigratedMessagesURI(File file) {
        File parentFile = file.getParentFile();
        return URI.createFileURI((String)(parentFile.getAbsolutePath() + File.separator + parentFile.getName() + "-messages-actual.txt"));
    }

    private URI getTemplateURI(File file) {
        return URI.createFileURI((String)file.getAbsolutePath());
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> retrieveTests() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        ArrayList<String> modules = new ArrayList<String>();
        File root = new File(ROOT);
        modules.addAll(MigrationTests.findTemplateFiles(root));
        Path currentPath = new File(".").toPath().toAbsolutePath();
        for (String module : modules) {
            Path relativePath = currentPath.relativize(new File(module).toPath().toAbsolutePath());
            res.add(new Object[]{relativePath.toString()});
        }
        return res;
    }

    private static List<String> findTemplateFiles(File root) {
        ArrayList<String> res = new ArrayList<String>();
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isFile()) {
                if (child.getName().endsWith("-template.docx")) {
                    res.add(child.getAbsolutePath());
                }
            } else {
                res.addAll(MigrationTests.findTemplateFiles(child));
            }
            ++n2;
        }
        return res;
    }
}

