/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests.parser;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.obeonetwork.m2doc.parser.TokenIteratorFieldRewriter;

@RunWith(value=Parameterized.class)
public class TokenIteratorFieldRewriterSplitTests {
    private static final Map<String, List<String>> EXPECTEDS = TokenIteratorFieldRewriterSplitTests.initializeExpecteds();
    private final String documentPath;

    public TokenIteratorFieldRewriterSplitTests(String documentPath) {
        this.documentPath = documentPath;
    }

    private static Map<String, List<String>> initializeExpecteds() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put("oneRun.docx", Arrays.asList("FIELD_START", "RUN: [{m:self}]", "FIELD_END"));
        result.put("oneRunWithPrefix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:self}]", "FIELD_END"));
        result.put("oneRunWithPrefixAndSuffix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:self}]", "FIELD_END", "RUN: [suffix]"));
        result.put("oneRunWithRunPrefix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:self}]", "FIELD_END"));
        result.put("oneRunWithRunPrefixAndRunSuffix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:self}]", "FIELD_END", "RUN: [suffix]"));
        result.put("oneRunWithRunSuffix.docx", Arrays.asList("FIELD_START", "RUN: [{m:self}]", "FIELD_END", "RUN: [suffix]"));
        result.put("oneRunWithSuffix.docx", Arrays.asList("FIELD_START", "RUN: [{m:self}]", "FIELD_END", "RUN: [suffix]"));
        result.put("oneRunWithTPrefix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:self}]", "FIELD_END"));
        result.put("oneRunWithTPrefixAndTSuffix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:self}]", "FIELD_END", "RUN: [suffix]"));
        result.put("oneRunWithTSuffix.docx", Arrays.asList("FIELD_START", "RUN: [{m:self}]", "FIELD_END", "RUN: [suffix]"));
        result.put("runSplit.docx", Arrays.asList("FIELD_START", "RUN: [{m:se]", "RUN: [lf}]", "FIELD_END"));
        result.put("runSplitEndFieldAlone.docx", Arrays.asList("FIELD_START", "RUN: [{m:se]", "RUN: [lf]", "RUN: [}]", "FIELD_END"));
        result.put("runSplitMissingEndField.docx", Arrays.asList("FIELD_START", "RUN: [{m:se]", "RUN: [lf]", "MISSING_FIELD_END"));
        result.put("runSplitStartField.docx", Arrays.asList("FIELD_START", "RUN: [{m]", "RUN: [:se]", "RUN: [lf}]", "FIELD_END"));
        result.put("runSplitStartFieldAlone.docx", Arrays.asList("FIELD_START", "RUN: [{]", "RUN: [m:se]", "RUN: [lf}]", "FIELD_END"));
        result.put("runSplitWithPrefix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se]", "RUN: [lf}]", "FIELD_END"));
        result.put("runSplitWithRunPrefix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se]", "RUN: [lf}]", "FIELD_END"));
        result.put("runSplitWithRunPrefixAndRunSuffix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se]", "RUN: [lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("runSplitWithRunSuffix.docx", Arrays.asList("FIELD_START", "RUN: [{m:se]", "RUN: [lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("runSplitWithSuffix.docx", Arrays.asList("FIELD_START", "RUN: [{m:se]", "RUN: [lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("runSplitWithTPrefix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se]", "RUN: [lf}]", "FIELD_END"));
        result.put("runSplitWithTPrefixAndTSuffix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se]", "RUN: [lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("runSplitWithTSuffix.docx", Arrays.asList("FIELD_START", "RUN: [{m:se]", "RUN: [lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("tSplit.docx", Arrays.asList("FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END"));
        result.put("tSplitEndFieldAlone.docx", Arrays.asList("FIELD_START", "RUN: [{m:se, lf, }]", "FIELD_END"));
        result.put("tSplitMissingEndField.docx", Arrays.asList("FIELD_START", "RUN: [{m:se, lf]", "MISSING_FIELD_END"));
        result.put("tSplitStartField.docx", Arrays.asList("FIELD_START", "RUN: [{m, :se, lf}]", "FIELD_END"));
        result.put("tSplitStartFieldAlone.docx", Arrays.asList("FIELD_START", "RUN: [{, m:se, lf}]", "FIELD_END"));
        result.put("tSplitWithPrefix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END"));
        result.put("tSplitWithPrefixAndSuffix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("tSplitWithRunPrefix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END"));
        result.put("tSplitWithRunPrefixAndRunSuffix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("tSplitWithRunSuffix.docx", Arrays.asList("FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("tSplitWithSuffix.docx", Arrays.asList("FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("tSplitWithTPrefix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END"));
        result.put("tSplitWithTPrefixAndTSuffix.docx", Arrays.asList("RUN: [prefix]", "FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END", "RUN: [suffix]"));
        result.put("tSplitWithTSuffix.docx", Arrays.asList("FIELD_START", "RUN: [{m:se, lf}]", "FIELD_END", "RUN: [suffix]"));
        return result;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> retrieveTestFolders() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        File folder = new File("resources/document/toSplit");
        Object[] children = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.canRead() && pathname.getName().endsWith(".docx");
            }
        });
        Arrays.sort(children);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            result.add(new Object[]{((File)child).getPath()});
            ++n2;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void tokenize() throws IOException, InvalidFormatException {
        File documentFile = new File(this.documentPath);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream is = new FileInputStream(documentFile);
            try {
                block20: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIteratorFieldRewriter iterator = new TokenIteratorFieldRewriter((IBody)document);
                            ArrayList<String> actual = new ArrayList<String>();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    List expected = EXPECTEDS.getOrDefault(documentFile.getName(), new ArrayList());
                                    Assert.assertArrayEquals((Object[])expected.toArray(new String[expected.size()]), (Object[])actual.toArray(new String[expected.size()]));
                                    break;
                                }
                                actual.add(iterator.next().toString());
                            }
                        }
                        if (oPackage == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }
}

