/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.apache.poi.EmptyFileException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.junit.Assert;
import org.junit.Test;
import org.obeonetwork.m2doc.parser.TokenIterator;

public class TokenIteratorTests {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testNonEmptyDoc() throws InvalidFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream is = new FileInputStream("resources/document/notEmpty/notEmpty-template.docx");
            try {
                block18: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIterator iterator = new TokenIterator((IBody)document);
                            XWPFRun run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P1Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P1Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)" P1Run3", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P2Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P2Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)" ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P2Run3", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"", (Object)run.getText(run.getTextPosition()));
                            Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
                        }
                        if (oPackage == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testAccessEmptyIterator() throws InvalidFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream is = new FileInputStream("resources/document/notEmpty/notEmpty-template.docx");
            try {
                block20: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIterator iterator = new TokenIterator((IBody)document);
                            Assert.assertNotNull((Object)iterator.next());
                            Assert.assertNotNull((Object)iterator.next());
                            Assert.assertNotNull((Object)iterator.next());
                            Assert.assertNotNull((Object)iterator.next());
                            Assert.assertNotNull((Object)iterator.next());
                            Assert.assertNotNull((Object)iterator.next());
                            Assert.assertNotNull((Object)iterator.next());
                            Assert.assertNotNull((Object)iterator.next());
                            Assert.assertFalse((boolean)iterator.hasNext());
                            boolean hasException = false;
                            try {
                                iterator.next();
                            }
                            catch (NoSuchElementException e) {
                                Assert.assertTrue((boolean)(e instanceof NoSuchElementException));
                                hasException = true;
                            }
                            Assert.assertTrue((boolean)hasException);
                        }
                        if (oPackage == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(expected=EmptyFileException.class)
    public void testEmptyDoc() throws InvalidFormatException, IOException {
        File file = new File("resources/document/empty/empty-template.docx");
        Assert.assertTrue((boolean)file.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                block18: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIterator iterator = new TokenIterator((IBody)document);
                            Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
                        }
                        if (oPackage == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }
}

