/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.junit.Assert;
import org.junit.Test;
import org.obeonetwork.m2doc.parser.TokenIterator;
import org.obeonetwork.m2doc.parser.TokenProvider;

public class TokenProviderTokenIteratorTests {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testNonEmptyDoc() throws InvalidFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream is = new FileInputStream("resources/document/notEmpty/notEmpty-template.docx");
            try {
                block18: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIterator tokenIterator = new TokenIterator((IBody)document);
                            TokenProvider iterator = new TokenProvider(tokenIterator);
                            XWPFRun run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P1Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P1Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)" P1Run3", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P2Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P2Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)" ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P2Run3", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"", (Object)run.getText(run.getTextPosition()));
                            Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
                        }
                        if (oPackage == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(expected=NoSuchElementException.class)
    public void testAccessEmptyIterator() throws InvalidFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream is = new FileInputStream("resources/document/notEmpty/notEmpty-template.docx");
            try {
                block18: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIterator tokenIterator = new TokenIterator((IBody)document);
                            TokenProvider iterator = new TokenProvider(tokenIterator);
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                        }
                        if (oPackage == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testLookaheadEmptyIterator() throws InvalidFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream is = new FileInputStream("resources/document/notEmpty/notEmpty-template.docx");
            try {
                block18: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIterator tokenIterator = new TokenIterator((IBody)document);
                            TokenProvider iterator = new TokenProvider(tokenIterator);
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            iterator.next().getRun();
                            Assert.assertNull((Object)iterator.lookAhead(1));
                        }
                        if (oPackage == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testHasElements() throws InvalidFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream is = new FileInputStream("resources/document/notEmpty/notEmpty-template.docx");
            try {
                block18: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIterator tokenIterator = new TokenIterator((IBody)document);
                            TokenProvider iterator = new TokenProvider(tokenIterator);
                            Assert.assertTrue((boolean)iterator.hasElements(7));
                            XWPFRun run = iterator.next().getRun();
                            Assert.assertTrue((boolean)iterator.hasElements(6));
                            Assert.assertEquals((Object)"P1Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertTrue((boolean)iterator.hasElements(5));
                            Assert.assertEquals((Object)"P1Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertTrue((boolean)iterator.hasElements(4));
                            Assert.assertEquals((Object)" P1Run3", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertTrue((boolean)iterator.hasElements(3));
                            Assert.assertEquals((Object)"P2Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertTrue((boolean)iterator.hasElements(2));
                            Assert.assertEquals((Object)"P2Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertTrue((boolean)iterator.hasElements(1));
                            Assert.assertEquals((Object)" ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertTrue((boolean)iterator.hasElements(0));
                            Assert.assertEquals((Object)"P2Run3", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"", (Object)run.getText(run.getTextPosition()));
                            Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
                        }
                        if (oPackage == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testLookAhead() throws InvalidFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream is = new FileInputStream("resources/document/notEmpty/notEmpty-template.docx");
            try {
                block18: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIterator tokenIterator = new TokenIterator((IBody)document);
                            TokenProvider iterator = new TokenProvider(tokenIterator);
                            Assert.assertTrue((boolean)iterator.hasElements(7));
                            XWPFRun run = iterator.lookAhead(1).getRun();
                            Assert.assertEquals((Object)"P1Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.lookAhead(2).getRun();
                            Assert.assertEquals((Object)"P1Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.lookAhead(3).getRun();
                            Assert.assertEquals((Object)" P1Run3", (Object)run.getText(run.getTextPosition()));
                            run = iterator.lookAhead(4).getRun();
                            Assert.assertEquals((Object)"P2Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.lookAhead(5).getRun();
                            Assert.assertEquals((Object)"P2Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.lookAhead(6).getRun();
                            Assert.assertEquals((Object)" ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.lookAhead(7).getRun();
                            Assert.assertEquals((Object)"P2Run3", (Object)run.getText(run.getTextPosition()));
                            Assert.assertTrue((boolean)iterator.hasElements(7));
                        }
                        if (oPackage == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testNextWitLookAhead() throws InvalidFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream is = new FileInputStream("resources/document/notEmpty/notEmpty-template.docx");
            try {
                block18: {
                    OPCPackage oPackage = OPCPackage.open((InputStream)is);
                    try {
                        try (XWPFDocument document = new XWPFDocument(oPackage);){
                            TokenIterator tokenIterator = new TokenIterator((IBody)document);
                            TokenProvider iterator = new TokenProvider(tokenIterator);
                            Assert.assertTrue((boolean)iterator.hasElements(7));
                            XWPFRun run = iterator.lookAhead(1).getRun();
                            Assert.assertEquals((Object)"P1Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P1Run1 ", (Object)run.getText(run.getTextPosition()));
                            run = iterator.lookAhead(1).getRun();
                            Assert.assertEquals((Object)"P1Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.lookAhead(2).getRun();
                            Assert.assertEquals((Object)" P1Run3", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)"P1Run2", (Object)run.getText(run.getTextPosition()));
                            run = iterator.next().getRun();
                            Assert.assertEquals((Object)" P1Run3", (Object)run.getText(run.getTextPosition()));
                            Assert.assertTrue((boolean)iterator.hasElements(4));
                        }
                        if (oPackage == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (oPackage == null) throw throwable;
                        oPackage.close();
                        throw throwable;
                    }
                    oPackage.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }
}

