/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.junit.Assert;
import org.junit.Test;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.services.TokenRegistry;
import org.obeonetwork.m2doc.tests.services.ServicePackage1;
import org.obeonetwork.m2doc.tests.services.ServicePackage2;
import org.obeonetwork.m2doc.tests.services.ServicePackage3;

public class TokenRegistryTests {
    @Test
    public void clearEmpty() {
        TokenRegistry registry = new TokenRegistry();
        registry.clear();
        Assert.assertTrue((boolean)registry.getRegisteredTokens().isEmpty());
    }

    @Test
    public void clear() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("someClass1");
        classes.add("someClass2");
        registry.registerServices("testToken", "someBundle", classes);
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("package1");
        packages.add("package2");
        registry.registerPackages("testToken", packages);
        Assert.assertEquals((long)1L, (long)registry.getRegisteredTokens().size());
        registry.clear();
        Assert.assertTrue((boolean)registry.getRegisteredTokens().isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void deselectTokenNullNull() {
        TokenRegistry registry = new TokenRegistry();
        registry.deselectToken(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void deselectTokenNullTokenName() {
        TokenRegistry registry = new TokenRegistry();
        registry.deselectToken(null, "someToken");
    }

    @Test
    public void deselectTokenTemplateCustomPropertiesNull() throws IOException {
        TokenRegistry registry = new TokenRegistry();
        Throwable throwable = null;
        Object var3_4 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            registry.deselectToken(properties, null);
            Assert.assertTrue((boolean)properties.getPackagesURIs().isEmpty());
            Assert.assertTrue((boolean)properties.getServiceClasses().isEmpty());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void deselectToken() throws IOException {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("someClass1");
        classes.add("someClass2");
        registry.registerServices("testToken", "someBundle", classes);
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("package1");
        packages.add("package2");
        registry.registerPackages("testToken", packages);
        Throwable throwable = null;
        Object var5_6 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            registry.deselectToken(properties, null);
            registry.selectToken(properties, "testToken");
            Assert.assertTrue((!properties.getPackagesURIs().isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((!properties.getServiceClasses().isEmpty() ? 1 : 0) != 0);
            registry.deselectToken(properties, "testToken");
            Assert.assertTrue((boolean)properties.getPackagesURIs().isEmpty());
            Assert.assertTrue((boolean)properties.getServiceClasses().isEmpty());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void deselectTokenMultiTokenWithIntersection() throws IOException {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> classes1 = new ArrayList<String>();
        classes1.add("someClass1");
        classes1.add("someClass2");
        registry.registerServices("testToken1", "someBundle", classes1);
        ArrayList<String> packages1 = new ArrayList<String>();
        packages1.add("package1");
        packages1.add("package2");
        registry.registerPackages("testToken1", packages1);
        ArrayList<String> classes2 = new ArrayList<String>();
        classes2.add("someClass2");
        classes2.add("someClass3");
        registry.registerServices("testToken2", "someBundle", classes2);
        ArrayList<String> packages2 = new ArrayList<String>();
        packages2.add("package2");
        packages2.add("package3");
        registry.registerPackages("testToken2", packages2);
        Throwable throwable = null;
        Object var7_8 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            registry.deselectToken(properties, null);
            registry.selectToken(properties, "testToken1");
            registry.selectToken(properties, "testToken2");
            Assert.assertEquals((long)3L, (long)properties.getPackagesURIs().size());
            Assert.assertEquals((long)3L, (long)properties.getServiceClasses().size());
            registry.deselectToken(properties, "testToken1");
            Assert.assertEquals((long)2L, (long)properties.getPackagesURIs().size());
            Assert.assertEquals((long)2L, (long)properties.getServiceClasses().size());
            Assert.assertEquals((Object)"package3", properties.getPackagesURIs().get(0));
            Assert.assertEquals((Object)"package2", properties.getPackagesURIs().get(1));
            Assert.assertEquals((Object)"someBundle", properties.getServiceClasses().get("someClass3"));
            Assert.assertEquals((Object)"someBundle", properties.getServiceClasses().get("someClass2"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getPackagesNull() {
        TokenRegistry registry = new TokenRegistry();
        Assert.assertTrue((boolean)registry.getPackages(null).isEmpty());
    }

    @Test
    public void getPackagesEmpty() {
        TokenRegistry registry = new TokenRegistry();
        Assert.assertTrue((boolean)registry.getPackages("").isEmpty());
    }

    @Test
    public void getPackages() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("someClass1");
        classes.add("someClass2");
        registry.registerServices("testToken", "someBundle", classes);
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("package1");
        packages.add("package2");
        registry.registerPackages("testToken", packages);
        Assert.assertEquals((long)2L, (long)registry.getPackages("testToken").size());
        Assert.assertEquals((Object)"package1", registry.getPackages("testToken").get(0));
        Assert.assertEquals((Object)"package2", registry.getPackages("testToken").get(1));
    }

    @Test
    public void getRegisteredTokensEmpty() {
        TokenRegistry registry = new TokenRegistry();
        Assert.assertTrue((boolean)registry.getRegisteredTokens().isEmpty());
    }

    @Test
    public void getRegisteredTokens() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("someClass1");
        classes.add("someClass2");
        registry.registerServices("testToken", "someBundle", classes);
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("package1");
        packages.add("package2");
        registry.registerPackages("testToken", packages);
        Assert.assertEquals((long)1L, (long)registry.getRegisteredTokens().size());
    }

    @Test
    public void getSelectedTokenNull() {
        TokenRegistry registry = new TokenRegistry();
        Assert.assertTrue((boolean)registry.getSelectedToken(null).isEmpty());
    }

    @Test
    public void getSelectedTokenEmpty() throws IOException {
        TokenRegistry registry = new TokenRegistry();
        Throwable throwable = null;
        Object var3_4 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            Assert.assertTrue((boolean)registry.getSelectedToken(properties).isEmpty());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getSelectedTokenMultiTokenWithIntersection() throws IOException {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> classes1 = new ArrayList<String>();
        classes1.add("someClass1");
        classes1.add("someClass2");
        registry.registerServices("testToken1", "someBundle", classes1);
        ArrayList<String> packages1 = new ArrayList<String>();
        packages1.add("package1");
        packages1.add("package2");
        registry.registerPackages("testToken1", packages1);
        ArrayList<String> classes2 = new ArrayList<String>();
        classes2.add("someClass2");
        classes2.add("someClass3");
        registry.registerServices("testToken2", "someBundle", classes2);
        ArrayList<String> packages2 = new ArrayList<String>();
        packages2.add("package2");
        packages2.add("package3");
        registry.registerPackages("testToken2", packages2);
        Throwable throwable = null;
        Object var7_8 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            registry.deselectToken(properties, null);
            registry.selectToken(properties, "testToken1");
            registry.selectToken(properties, "testToken2");
            Assert.assertEquals((long)2L, (long)registry.getSelectedToken(properties).size());
            Assert.assertEquals((Object)"testToken1", registry.getSelectedToken(properties).get(0));
            Assert.assertEquals((Object)"testToken2", registry.getSelectedToken(properties).get(1));
            registry.deselectToken(properties, "testToken2");
            Assert.assertEquals((long)1L, (long)registry.getSelectedToken(properties).size());
            Assert.assertEquals((Object)"testToken1", registry.getSelectedToken(properties).get(0));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getServicesNull() {
        TokenRegistry registry = new TokenRegistry();
        Assert.assertTrue((boolean)registry.getServices(null).isEmpty());
    }

    @Test
    public void getServicesEmpty() {
        TokenRegistry registry = new TokenRegistry();
        Assert.assertTrue((boolean)registry.getServices("").isEmpty());
    }

    @Test
    public void getServices() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("someClass1");
        classes.add("someClass2");
        registry.registerServices("testToken", "someBundle", classes);
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("package1");
        packages.add("package2");
        registry.registerPackages("testToken", packages);
        Assert.assertEquals((long)1L, (long)registry.getServices("testToken").size());
        Assert.assertEquals((long)2L, (long)((List)registry.getServices("testToken").get("someBundle")).size());
        Assert.assertEquals((Object)"someClass1", ((List)registry.getServices("testToken").get("someBundle")).get(0));
        Assert.assertEquals((Object)"someClass2", ((List)registry.getServices("testToken").get("someBundle")).get(1));
    }

    @Test
    public void registerServicesTestSingleToken() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> services = new ArrayList<String>();
        services.add(ServicePackage1.class.getCanonicalName());
        services.add(ServicePackage2.class.getCanonicalName());
        registry.registerServices("token1", "bundle", services);
        Map map = registry.getServices("token1");
        Assert.assertEquals((long)1L, (long)map.size());
        List list = (List)map.get("bundle");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)ServicePackage1.class.getCanonicalName(), list.get(0));
        Assert.assertEquals((Object)ServicePackage2.class.getCanonicalName(), list.get(1));
    }

    @Test
    public void registerServicesTestTwoTokens() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> services1 = new ArrayList<String>();
        services1.add(ServicePackage1.class.getCanonicalName());
        services1.add(ServicePackage2.class.getCanonicalName());
        ArrayList<String> services2 = new ArrayList<String>();
        services2.add(ServicePackage1.class.getCanonicalName());
        services2.add(ServicePackage2.class.getCanonicalName());
        services2.add(ServicePackage3.class.getCanonicalName());
        registry.registerServices("token1", "bundle", services1);
        registry.registerServices("token2", "bundle", services2);
        Map map1 = registry.getServices("token1");
        Assert.assertEquals((long)1L, (long)map1.size());
        List list1 = (List)map1.get("bundle");
        Assert.assertEquals((long)2L, (long)list1.size());
        Assert.assertEquals((Object)ServicePackage1.class.getCanonicalName(), list1.get(0));
        Assert.assertEquals((Object)ServicePackage2.class.getCanonicalName(), list1.get(1));
        Map map2 = registry.getServices("token2");
        Assert.assertEquals((long)1L, (long)map2.size());
        List list2 = (List)map2.get("bundle");
        Assert.assertEquals((long)3L, (long)list2.size());
        Assert.assertEquals((Object)ServicePackage1.class.getCanonicalName(), list2.get(0));
        Assert.assertEquals((Object)ServicePackage2.class.getCanonicalName(), list2.get(1));
        Assert.assertEquals((Object)ServicePackage3.class.getCanonicalName(), list2.get(2));
    }

    @Test
    public void unregisterServices() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> services = new ArrayList<String>();
        services.add(ServicePackage1.class.getCanonicalName());
        services.add(ServicePackage2.class.getCanonicalName());
        services.add(ServicePackage3.class.getCanonicalName());
        registry.registerServices("token", "bundle", services);
        ArrayList<String> servicesToRemove = new ArrayList<String>();
        servicesToRemove.add(ServicePackage1.class.getCanonicalName());
        servicesToRemove.add(ServicePackage2.class.getCanonicalName());
        registry.unregisterServices("token", "bundle", servicesToRemove);
        Map map = registry.getServices("token");
        Assert.assertEquals((long)1L, (long)map.size());
        List list = (List)map.get("bundle");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)ServicePackage3.class.getCanonicalName(), list.get(0));
    }

    @Test
    public void registerPackagesTestSingleToken() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("someNsURI1");
        packages.add("someNsURI2");
        registry.registerPackages("token1", packages);
        List list = registry.getPackages("token1");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"someNsURI1", list.get(0));
        Assert.assertEquals((Object)"someNsURI2", list.get(1));
    }

    @Test
    public void registerPackagesTestTwoTokens() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> packages1 = new ArrayList<String>();
        packages1.add("someNsURI1");
        packages1.add("someNsURI2");
        ArrayList<String> packages2 = new ArrayList<String>();
        packages2.add("someNsURI1");
        packages2.add("someNsURI2");
        packages2.add("someNsURI3");
        registry.registerPackages("token1", packages1);
        registry.registerPackages("token2", packages2);
        List list1 = registry.getPackages("token1");
        Assert.assertEquals((long)2L, (long)list1.size());
        Assert.assertEquals((Object)"someNsURI1", list1.get(0));
        Assert.assertEquals((Object)"someNsURI2", list1.get(1));
        List list2 = registry.getPackages("token2");
        Assert.assertEquals((long)3L, (long)list2.size());
        Assert.assertEquals((Object)"someNsURI1", list2.get(0));
        Assert.assertEquals((Object)"someNsURI2", list2.get(1));
        Assert.assertEquals((Object)"someNsURI3", list2.get(2));
    }

    @Test
    public void unregisterPackages() {
        TokenRegistry registry = new TokenRegistry();
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("someNsURI1");
        packages.add("someNsURI2");
        packages.add("someNsURI3");
        registry.registerPackages("token", packages);
        ArrayList<String> packagesToRemove = new ArrayList<String>();
        packagesToRemove.add("someNsURI1");
        packagesToRemove.add("someNsURI2");
        registry.unregisterPackages("token", packagesToRemove);
        List list = registry.getPackages("token");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"someNsURI3", list.get(0));
    }
}

