/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.wikitext.services;

import java.awt.Color;
import java.math.BigInteger;
import java.util.List;
import java.util.Stack;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MList;
import org.obeonetwork.m2doc.element.MPagination;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.impl.MHyperLinkImpl;
import org.obeonetwork.m2doc.element.impl.MImageImpl;
import org.obeonetwork.m2doc.element.impl.MListImpl;
import org.obeonetwork.m2doc.element.impl.MParagraphImpl;
import org.obeonetwork.m2doc.element.impl.MStyleImpl;
import org.obeonetwork.m2doc.element.impl.MTextImpl;
import org.obeonetwork.m2doc.services.PaginationServices;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLevelText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumFmt;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumbering;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMultiLevelType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public class M2DocMElementBuilder
extends DocumentBuilder {
    private static final int INDENT_LEFT = 720;
    private static final int INDENT_HANGING = 180;
    private static final String DISC_SYMBOL = "\uf0b7";
    private static final String SQUARE_SYMBOL = "\uf0a7";
    private static final int H6_FONT_SIZE = 8;
    private static final int H5_FONT_SIZE = 10;
    private static final int H4_FONT_SIZE = 12;
    private static final int H3_FONT_SIZE = 14;
    private static final int H2_FONT_SIZE = 18;
    private static final int H1_FONT_SIZE = 24;
    private static final Color LINK_COLOR = Color.BLUE;
    private MList result;
    private URI baseURI;
    private URIConverter uriConverter;
    private XWPFDocument destinationDocument;
    private final Stack<Context> contexts = new Stack();

    public M2DocMElementBuilder(URIConverter uriConverter, XWPFDocument destinationDocument) {
        this.uriConverter = uriConverter;
        this.destinationDocument = destinationDocument;
    }

    public List<MElement> getResult() {
        return this.result;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public void beginDocument() {
        this.result = new MListImpl();
        MStyleImpl defaultStyle = new MStyleImpl(null, -1, null, null, -1);
        this.contexts.push(new Context(this.result, this.baseURI, null, (MStyle)defaultStyle, null, null, 0L));
    }

    public void endDocument() {
        this.contexts.pop();
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        Context context = this.contexts.peek().copy();
        this.contexts.push(context);
        boolean isNumbering = false;
        switch (type) {
            case PARAGRAPH: {
                context.parent = this.createMParagraph(context.parent, attributes, null, null);
                break;
            }
            case LIST_ITEM: {
                context.parent = this.createMParagraph(context.parent, attributes, context.numberingID.longValue(), context.numberingLevel - 1L);
                isNumbering = true;
                break;
            }
            case NUMERIC_LIST: {
                this.setOrderedListNumbering(context, attributes);
                isNumbering = true;
                break;
            }
            case BULLETED_LIST: {
                this.setUnorderedListNumbering(context, attributes);
                isNumbering = true;
                break;
            }
        }
        if (!isNumbering) {
            context.numbering = null;
            context.numberingLevel = 0L;
        }
    }

    public void endBlock() {
        this.contexts.pop();
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        Context context = this.contexts.peek().copy();
        this.contexts.push(context);
        switch (type) {
            case STRONG: 
            case BOLD: {
                this.setModifiers(context, 1);
                break;
            }
            case EMPHASIS: 
            case ITALIC: {
                this.setModifiers(context, 2);
                break;
            }
            case DELETED: {
                this.setModifiers(context, 8);
                break;
            }
            case UNDERLINED: {
                this.setModifiers(context, 4);
                break;
            }
        }
    }

    public void endSpan() {
        this.contexts.pop();
    }

    public void beginHeading(int level, Attributes attributes) {
        Context context = this.contexts.peek().copy();
        this.contexts.push(context);
        context.parent = this.createMParagraph(context.parent, attributes, null, null);
        switch (level) {
            case 1: {
                context.style.setFontSize(24);
                break;
            }
            case 2: {
                context.style.setFontSize(18);
                break;
            }
            case 3: {
                context.style.setFontSize(14);
                break;
            }
            case 4: {
                context.style.setFontSize(12);
                break;
            }
            case 5: {
                context.style.setFontSize(10);
                break;
            }
            case 6: {
                context.style.setFontSize(8);
                break;
            }
        }
        this.setModifiers(context, 1);
    }

    public void endHeading() {
        this.contexts.pop();
    }

    public void characters(String text) {
        MTextImpl mText = new MTextImpl(text, this.contexts.peek().style);
        this.contexts.peek().parent.add((Object)mText);
    }

    public void entityReference(String entity) {
    }

    public void image(Attributes attributes, String url) {
        URI imageURI = URI.createURI((String)url).resolve(this.contexts.peek().baseURI);
        MImageImpl mImage = new MImageImpl(this.uriConverter, imageURI);
        this.contexts.peek().parent.add((Object)mImage);
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        Context context = this.contexts.peek().copy();
        context.style.setForegroundColor(LINK_COLOR);
        URI uri = hrefOrHashName != null ? (hrefOrHashName.startsWith("#") ? URI.createURI((String)hrefOrHashName) : URI.createURI((String)hrefOrHashName).resolve(context.baseURI)) : URI.createURI((String)"", (boolean)false);
        MHyperLinkImpl mLink = new MHyperLinkImpl(text, context.style, uri.toString());
        this.contexts.peek().parent.add((Object)mLink);
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        URI imageURI = URI.createURI((String)imageUrl).resolve(this.contexts.peek().baseURI);
        MImageImpl mImage = new MImageImpl(this.uriConverter, imageURI);
        this.contexts.peek().parent.add((Object)mImage);
    }

    public void acronym(String text, String definition) {
        MTextImpl mText = new MTextImpl(text, this.contexts.peek().style);
        this.contexts.peek().parent.add((Object)mText);
    }

    public void lineBreak() {
        this.contexts.peek().parent.add((Object)MPagination.ligneBreak);
    }

    public void charactersUnescaped(String literal) {
        MTextImpl mText = new MTextImpl(literal, this.contexts.peek().style);
        this.contexts.peek().parent.add((Object)mText);
    }

    private void setUnorderedListNumbering(Context context, Attributes attributes) {
        String symbol = DISC_SYMBOL;
        if (context.numbering == null) {
            this.createNumbering(context);
        }
        context.numberingLevel = this.incrementNumberingLevel(context.numbering, context.numberingLevel, STNumberFormat.BULLET, 1L, DISC_SYMBOL, false);
    }

    private void setOrderedListNumbering(Context context, Attributes attributes) {
        STNumberFormat.Enum type = STNumberFormat.DECIMAL;
        long start = 1L;
        if (context.numbering == null) {
            this.createNumbering(context);
        }
        context.numberingLevel = this.incrementNumberingLevel(context.numbering, context.numberingLevel, type, 1L, "", false);
    }

    private void createNumbering(Context context) {
        XWPFNumbering numbering = this.destinationDocument.createNumbering();
        CTNumbering ctNumbering = PaginationServices.getCTNumbering((XWPFNumbering)numbering);
        CTAbstractNum res = ctNumbering.addNewAbstractNum();
        res.addNewMultiLevelType().setVal(STMultiLevelType.HYBRID_MULTILEVEL);
        BigInteger id = BigInteger.valueOf(ctNumbering.sizeOfAbstractNumArray() - 1);
        res.setAbstractNumId(id);
        CTNum ctNum = ctNumbering.addNewNum();
        ctNum.setNumId(BigInteger.valueOf(ctNumbering.sizeOfNumArray()));
        ctNum.addNewAbstractNumId().setVal(id);
        context.numbering = res;
        context.numberingID = ctNum.getNumId();
    }

    private long incrementNumberingLevel(CTAbstractNum numbering, long currentLevel, STNumberFormat.Enum type, long start, String symbol, boolean reversed) {
        if ((long)numbering.getLvlList().size() <= currentLevel) {
            CTLvl level = numbering.addNewLvl();
            level.setIlvl(BigInteger.valueOf(currentLevel));
            CTDecimalNumber strt = level.addNewStart();
            strt.setVal(BigInteger.valueOf(start));
            CTNumFmt fmt = level.addNewNumFmt();
            fmt.setVal(type);
            CTLevelText text = level.addNewLvlText();
            if (type == STNumberFormat.BULLET) {
                text.setVal(symbol);
                CTFonts font = level.addNewRPr().addNewRFonts();
                if (symbol == DISC_SYMBOL) {
                    font.setAscii("Symbol");
                    font.setHAnsi("Symbol");
                } else if (symbol == SQUARE_SYMBOL) {
                    font.setAscii("Wingdings");
                    font.setHAnsi("Wingdings");
                } else if (symbol == DISC_SYMBOL) {
                    font.setAscii("Courier New");
                    font.setHAnsi("Courier New");
                }
                level.addNewLvlJc().setVal(STJc.LEFT);
                CTInd indentation = level.addNewPPr().addNewInd();
                indentation.setHanging((Object)BigInteger.valueOf(360L));
                indentation.setLeft((Object)BigInteger.valueOf(720L * (currentLevel + 1L)));
            } else {
                CTInd indentation = level.addNewPPr().addNewInd();
                text.setVal("%" + (currentLevel + 1L) + ".");
                if (currentLevel > 0L) {
                    STOnOff onOff = (STOnOff)STOnOff.Factory.newInstance();
                    onOff.setStringValue("1");
                    level.xsetTentative(onOff);
                }
                if (type == STNumberFormat.UPPER_ROMAN) {
                    level.addNewLvlJc().setVal(STJc.RIGHT);
                    indentation.setHanging((Object)BigInteger.valueOf(360L));
                } else if (type == STNumberFormat.LOWER_ROMAN) {
                    level.addNewLvlJc().setVal(STJc.RIGHT);
                    indentation.setHanging((Object)BigInteger.valueOf(180L));
                } else {
                    level.addNewLvlJc().setVal(STJc.LEFT);
                    indentation.setHanging((Object)BigInteger.valueOf(360L));
                }
                indentation.setLeft((Object)BigInteger.valueOf(720L * (currentLevel + 1L)));
            }
        }
        return currentLevel + 1L;
    }

    private void setModifiers(Context context, int modifier) {
        if (context.style.getFontModifiers() == -1) {
            context.style.setModifiers(modifier);
        } else {
            context.style.setModifiers(context.style.getFontModifiers() | modifier);
        }
    }

    private MList createMParagraph(MList parent, Attributes attributes, Long numberingID, Long numberingLevel) {
        MListImpl res = new MListImpl();
        MParagraphImpl paragraph = new MParagraphImpl((MElement)res, null);
        parent.add((Object)paragraph);
        paragraph.setNumberingID(numberingID);
        paragraph.setNumberingLevel(numberingLevel);
        return res;
    }

    private static final class Context {
        private final MStyle style;
        private CTAbstractNum numbering;
        private long numberingLevel;
        private final URI baseURI;
        private URI linkTargetURI;
        private BigInteger numberingID;
        private MList parent;

        private Context(MList parent, URI baseURI, URI linkTargetURI, MStyle style, CTAbstractNum numbering, BigInteger numberingID, long numberingLevel) {
            this.parent = parent;
            this.baseURI = baseURI;
            this.style = style;
            this.numbering = numbering;
            this.numberingID = numberingID;
            this.numberingLevel = numberingLevel;
        }

        private Context copy() {
            MStyleImpl mStyle = new MStyleImpl(this.style.getFontName(), this.style.getFontSize(), this.style.getForegroundColor(), this.style.getBackgroundColor(), this.style.getFontModifiers());
            return new Context(this.parent, this.baseURI, this.linkTargetURI, (MStyle)mStyle, this.numbering, this.numberingID, this.numberingLevel);
        }
    }
}

