/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.edit.tests.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.obeonetwork.m2doc.genconf.GenconfPackage;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.ModelDefinition;
import org.obeonetwork.m2doc.genconf.provider.GenconfItemProviderAdapterFactory;
import org.obeonetwork.m2doc.genconf.provider.ModelDefinitionItemProvider;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.tests.TestMemoryURIHandler;

public class ModelDefinitionItemProviderTests {
    private static final String SELF = "self";
    private static TestMemoryURIHandler uriHandler = new TestMemoryURIHandler();
    private final ModelDefinitionItemProvider provider = (ModelDefinitionItemProvider)new GenconfItemProviderAdapterFactory().createModelDefinitionAdapter();
    private ModelDefinition definition;
    private TemplateCustomProperties properties;
    private XWPFDocument document;

    @BeforeClass
    public static void beforeClass() {
        URIConverter.INSTANCE.getURIHandlers().add(0, (Object)uriHandler);
    }

    @Before
    public void before() {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getURIConverter().getURIHandlers().add(0, (Object)uriHandler);
        rs.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource res = rs.createResource(URI.createURI((String)"m2doctest://resources/test.genconf", (boolean)false));
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        generation.setTemplateFileName("test.docx");
        res.getContents().add((Object)generation);
        this.definition = GenconfPackage.eINSTANCE.getGenconfFactory().createModelDefinition();
        this.definition.setKey(SELF);
        generation.getDefinitions().add((Object)this.definition);
        EPackage ePkg1 = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg1.setName("package1");
        EPackage ePkg2 = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg2.setName("package2");
        EPackage ePkg3 = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg3.setName("package3");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("Class1");
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("Class2");
        EClass eCls3 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls3.setName("Class3");
        res.getContents().add((Object)ePkg1);
        res.getContents().add((Object)ePkg2);
        res.getContents().add((Object)ePkg3);
        res.getContents().add((Object)eCls1);
        res.getContents().add((Object)eCls2);
        res.getContents().add((Object)eCls3);
        try {
            res.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        this.document = new XWPFDocument();
        this.properties = new TemplateCustomProperties(this.document);
        this.properties.getPackagesURIs().add(GenconfPackage.eINSTANCE.getNsURI());
    }

    protected void saveDocument() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (OutputStream stream = URIConverter.INSTANCE.createOutputStream(URI.createURI((String)"m2doctest://resources/test.docx", (boolean)false));){
                this.document.write(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void after() {
        uriHandler.clear();
    }

    @AfterClass
    public static void afterClass() {
        URIConverter.INSTANCE.getURIHandlers().remove((Object)uriHandler);
    }

    @Test
    public void getChoiceOfValuesNotAVariable() {
        IItemPropertyDescriptor descriptor = this.provider.getPropertyDescriptor((Object)this.definition, (Object)GenconfPackage.Literals.MODEL_DEFINITION__VALUE);
        this.definition.setKey("NotAVariable");
        this.properties.save();
        this.saveDocument();
        List values = (List)descriptor.getChoiceOfValues((Object)this.definition);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals(null, values.get(0));
    }

    @Test
    public void getChoiceOfValuesNoType() {
        IItemPropertyDescriptor descriptor = this.provider.getPropertyDescriptor((Object)this.definition, (Object)GenconfPackage.Literals.MODEL_DEFINITION__VALUE);
        this.properties.getVariables().put(SELF, "");
        this.properties.save();
        this.saveDocument();
        List values = (List)descriptor.getChoiceOfValues((Object)this.definition);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals(null, values.get(0));
    }

    @Test
    public void getChoiceOfValuesInvalideType() {
        IItemPropertyDescriptor descriptor = this.provider.getPropertyDescriptor((Object)this.definition, (Object)GenconfPackage.Literals.MODEL_DEFINITION__VALUE);
        this.properties.getVariables().put(SELF, "InvalidType");
        this.properties.save();
        this.saveDocument();
        List values = (List)descriptor.getChoiceOfValues((Object)this.definition);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals(null, values.get(0));
    }

    @Test
    public void getChoiceOfValuesEPackage() {
        IItemPropertyDescriptor descriptor = this.provider.getPropertyDescriptor((Object)this.definition, (Object)GenconfPackage.Literals.MODEL_DEFINITION__VALUE);
        this.properties.getVariables().put(SELF, "ecore::EPackage");
        this.properties.save();
        this.saveDocument();
        List values = (List)descriptor.getChoiceOfValues((Object)this.definition);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)4L, (long)values.size());
        Assert.assertEquals((Object)"package1", (Object)((EPackage)values.get(0)).getName());
        Assert.assertEquals((Object)"package2", (Object)((EPackage)values.get(1)).getName());
        Assert.assertEquals((Object)"package3", (Object)((EPackage)values.get(2)).getName());
        Assert.assertEquals(null, values.get(3));
    }

    @Test
    public void getChoiceOfValuesEClass() {
        IItemPropertyDescriptor descriptor = this.provider.getPropertyDescriptor((Object)this.definition, (Object)GenconfPackage.Literals.MODEL_DEFINITION__VALUE);
        this.properties.getVariables().put(SELF, "ecore::EClass");
        this.properties.save();
        this.saveDocument();
        List values = (List)descriptor.getChoiceOfValues((Object)this.definition);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)4L, (long)values.size());
        Assert.assertEquals((Object)"Class1", (Object)((EClass)values.get(0)).getName());
        Assert.assertEquals((Object)"Class2", (Object)((EClass)values.get(1)).getName());
        Assert.assertEquals((Object)"Class3", (Object)((EClass)values.get(2)).getName());
        Assert.assertEquals(null, values.get(3));
    }

    @Test
    public void getChoiceOfValuesGeneration() {
        IItemPropertyDescriptor descriptor = this.provider.getPropertyDescriptor((Object)this.definition, (Object)GenconfPackage.Literals.MODEL_DEFINITION__VALUE);
        this.properties.getVariables().put(SELF, "genconf::Generation");
        this.properties.save();
        this.saveDocument();
        List values = (List)descriptor.getChoiceOfValues((Object)this.definition);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)this.definition.eContainer(), values.get(0));
        Assert.assertEquals(null, values.get(1));
    }
}

