/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.sirius.tests.tables;

import java.awt.Color;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.sirius.util.DTable2MTableConverter;

public class DMStyleTest {
    private DTableElementStyle dstyle;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    private final DTable2MTableConverter tableConverter = new DTable2MTableConverter(this.adapterFactoryLabelProvider);

    @Test
    public void testStyle() {
        MStyle style = this.tableConverter.convertStyle(this.dstyle);
        Assert.assertEquals((long)6L, (long)style.getFontSize());
        Assert.assertEquals((Object)new Color(33023), (Object)this.tableConverter.convertColor(this.dstyle.getBackgroundColor()));
        Assert.assertEquals((Object)new Color(0xFF8000), (Object)style.getForegroundColor());
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 4));
    }

    @Test
    public void testStyleFontModifiers() {
        this.dstyle.getLabelFormat().add((Object)FontFormat.BOLD_LITERAL);
        MStyle style = this.tableConverter.convertStyle(this.dstyle);
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 4));
        this.dstyle.getLabelFormat().clear();
        this.dstyle.getLabelFormat().add((Object)FontFormat.ITALIC_LITERAL);
        style = this.tableConverter.convertStyle(this.dstyle);
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 4));
        this.dstyle.getLabelFormat().clear();
        this.dstyle.getLabelFormat().add((Object)FontFormat.STRIKE_THROUGH_LITERAL);
        style = this.tableConverter.convertStyle(this.dstyle);
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 4));
        this.dstyle.getLabelFormat().clear();
        this.dstyle.getLabelFormat().add((Object)FontFormat.UNDERLINE_LITERAL);
        style = this.tableConverter.convertStyle(this.dstyle);
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 4));
        this.dstyle.getLabelFormat().clear();
        this.dstyle.getLabelFormat().add((Object)FontFormat.BOLD_LITERAL);
        this.dstyle.getLabelFormat().add((Object)FontFormat.ITALIC_LITERAL);
        this.dstyle.getLabelFormat().add((Object)FontFormat.STRIKE_THROUGH_LITERAL);
        this.dstyle.getLabelFormat().add((Object)FontFormat.UNDERLINE_LITERAL);
        style = this.tableConverter.convertStyle(this.dstyle);
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 1));
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 2));
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 8));
        Assert.assertNotEquals((long)0L, (long)(style.getFontModifiers() & 4));
    }

    @Before
    public void setUp() {
        this.dstyle = TableFactory.eINSTANCE.createDTableElementStyle();
        this.dstyle.setLabelSize(6);
        this.dstyle.setBackgroundColor(RGBValues.create((int)0, (int)128, (int)255));
        this.dstyle.setForegroundColor(RGBValues.create((int)255, (int)128, (int)0));
    }
}

