/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.tests;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.obeonetwork.m2doc.genconf.Definition;
import org.obeonetwork.m2doc.genconf.GenconfPackage;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.ModelDefinition;
import org.obeonetwork.m2doc.genconf.Option;
import org.obeonetwork.m2doc.genconf.StringDefinition;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.tests.M2DocUtilsTests;

public class GenconfUtilsTests {
    @BeforeClass
    public static void beforeClass() {
        M2DocUtilsTests.beforeClass();
    }

    @AfterClass
    public static void afterClass() {
        M2DocUtilsTests.afterClass();
    }

    @Test
    public void getOptionsNullResource() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        Map options = GenconfUtils.getOptions((Generation)generation);
        Assert.assertEquals((long)0L, (long)options.size());
    }

    @Test
    public void getOptionsNullResourceURI() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)generation);
        Map options = GenconfUtils.getOptions((Generation)generation);
        Assert.assertEquals((long)0L, (long)options.size());
    }

    @Test
    public void getOptionsGenconfURI() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        ResourceImpl resource = new ResourceImpl(URI.createURI((String)"test"));
        resource.getContents().add((Object)generation);
        Map options = GenconfUtils.getOptions((Generation)generation);
        Assert.assertEquals((long)1L, (long)options.size());
        Assert.assertEquals((Object)"test", options.get("GenconfURI"));
    }

    @Test
    public void getOptionsTemplateURI() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        generation.setTemplateFileName("test.docx");
        Map options = GenconfUtils.getOptions((Generation)generation);
        Assert.assertEquals((long)1L, (long)options.size());
        Assert.assertEquals((Object)"test.docx", options.get("TemplateURI"));
    }

    @Test
    public void getOptionsResultURI() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        generation.setResultFileName("test.docx");
        Map options = GenconfUtils.getOptions((Generation)generation);
        Assert.assertEquals((long)1L, (long)options.size());
        Assert.assertEquals((Object)"test.docx", options.get("ResultURI"));
    }

    @Test
    public void getOptionsValidationURI() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        generation.setValidationFileName("test.docx");
        Map options = GenconfUtils.getOptions((Generation)generation);
        Assert.assertEquals((long)1L, (long)options.size());
        Assert.assertEquals((Object)"test.docx", options.get("ValidationURI"));
    }

    @Test
    public void getOptionsNoOptions() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        ResourceImpl resource = new ResourceImpl(URI.createFileURI((String)"/generation.xmi"));
        resource.getContents().add((Object)generation);
        generation.setTemplateFileName("template.docx");
        generation.setResultFileName("result.docx");
        generation.setValidationFileName("validation.docx");
        Map options = GenconfUtils.getOptions((Generation)generation);
        Assert.assertEquals((long)4L, (long)options.size());
        Assert.assertEquals((Object)"file:/generation.xmi", options.get("GenconfURI"));
        Assert.assertEquals((Object)"file:/template.docx", options.get("TemplateURI"));
        Assert.assertEquals((Object)"file:/result.docx", options.get("ResultURI"));
        Assert.assertEquals((Object)"file:/validation.docx", options.get("ValidationURI"));
    }

    @Test
    public void getOptions() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        ResourceImpl resource = new ResourceImpl(URI.createFileURI((String)"/generation.xmi"));
        resource.getContents().add((Object)generation);
        generation.setTemplateFileName("template.docx");
        generation.setResultFileName("result.docx");
        generation.setValidationFileName("validation.docx");
        Option option1 = GenconfPackage.eINSTANCE.getGenconfFactory().createOption();
        option1.setName("option1");
        option1.setValue("value1");
        generation.getOptions().add((Object)option1);
        Option option2 = GenconfPackage.eINSTANCE.getGenconfFactory().createOption();
        option2.setName("option2");
        option2.setValue("value2");
        generation.getOptions().add((Object)option2);
        Option option3 = GenconfPackage.eINSTANCE.getGenconfFactory().createOption();
        option3.setName("option3");
        option3.setValue("value3");
        generation.getOptions().add((Object)option3);
        Map options = GenconfUtils.getOptions((Generation)generation);
        Assert.assertEquals((long)7L, (long)options.size());
        Assert.assertEquals((Object)"file:/generation.xmi", options.get("GenconfURI"));
        Assert.assertEquals((Object)"file:/template.docx", options.get("TemplateURI"));
        Assert.assertEquals((Object)"file:/result.docx", options.get("ResultURI"));
        Assert.assertEquals((Object)"file:/validation.docx", options.get("ValidationURI"));
        Assert.assertEquals((Object)"value1", options.get("option1"));
        Assert.assertEquals((Object)"value2", options.get("option2"));
        Assert.assertEquals((Object)"value3", options.get("option3"));
    }

    @Test
    public void initializeOptionsNotExistingOption() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        GenconfUtils.initializeOptions((Generation)generation);
        Assert.assertEquals((long)3L, (long)generation.getOptions().size());
        Assert.assertEquals((Object)"UpdateFields", (Object)((Option)generation.getOptions().get(0)).getName());
        Assert.assertEquals((Object)"false", (Object)((Option)generation.getOptions().get(0)).getValue());
        Assert.assertEquals((Object)"IgnoreVersionCheck", (Object)((Option)generation.getOptions().get(1)).getName());
        Assert.assertEquals((Object)"false", (Object)((Option)generation.getOptions().get(1)).getValue());
        Assert.assertEquals((Object)"option", (Object)((Option)generation.getOptions().get(2)).getName());
        Assert.assertEquals((Object)"value", (Object)((Option)generation.getOptions().get(2)).getValue());
    }

    @Test
    public void initializeOptionsExistingOption() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        Option option = GenconfPackage.eINSTANCE.getGenconfFactory().createOption();
        option.setName("option");
        generation.getOptions().add((Object)option);
        GenconfUtils.initializeOptions((Generation)generation);
        Assert.assertEquals((long)3L, (long)generation.getOptions().size());
        Assert.assertEquals((Object)"option", (Object)((Option)generation.getOptions().get(0)).getName());
        Assert.assertEquals((Object)"value", (Object)((Option)generation.getOptions().get(0)).getValue());
        Assert.assertEquals((Object)"UpdateFields", (Object)((Option)generation.getOptions().get(1)).getName());
        Assert.assertEquals((Object)"false", (Object)((Option)generation.getOptions().get(1)).getValue());
        Assert.assertEquals((Object)"IgnoreVersionCheck", (Object)((Option)generation.getOptions().get(2)).getName());
        Assert.assertEquals((Object)"false", (Object)((Option)generation.getOptions().get(2)).getValue());
    }

    @Test
    public void getResolvedURINullResource() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        URI uri = GenconfUtils.getResolvedURI((Generation)generation, (URI)URI.createURI((String)"test"));
        Assert.assertEquals((Object)"test", (Object)uri.toString());
    }

    @Test
    public void getResolvedURINullResourceURI() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)generation);
        URI uri = GenconfUtils.getResolvedURI((Generation)generation, (URI)URI.createURI((String)"test"));
        Assert.assertEquals((Object)"test", (Object)uri.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getResolvedRelativeResourceURI() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        ResourceImpl resource = new ResourceImpl(URI.createURI((String)"test/test.genconf"));
        resource.getContents().add((Object)generation);
        URI uri = GenconfUtils.getResolvedURI((Generation)generation, (URI)URI.createURI((String)"test"));
        Assert.assertEquals((Object)"test", (Object)uri.toString());
    }

    @Test
    public void getResolvedAbsoluteResourceURI() {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        ResourceImpl resource = new ResourceImpl(URI.createFileURI((String)"/test/test.genconf"));
        resource.getContents().add((Object)generation);
        URI uri = GenconfUtils.getResolvedURI((Generation)generation, (URI)URI.createURI((String)"test"));
        Assert.assertEquals((Object)"file:/test/test", (Object)uri.toString());
    }

    @Test
    public void getNewDefinitionsNotExistingModelDefinition() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        Throwable throwable = null;
        Object var3_4 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            properties.getVariables().put("variable", "ecore::EClass");
            List definitions = GenconfUtils.getNewDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)1L, (long)definitions.size());
            Assert.assertTrue((boolean)(definitions.get(0) instanceof ModelDefinition));
            Assert.assertEquals((Object)"variable", (Object)((Definition)definitions.get(0)).getKey());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getNewDefinitionsNotExistingStringDefinition() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        Throwable throwable = null;
        Object var3_4 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            properties.getVariables().put("variable", "String");
            List definitions = GenconfUtils.getNewDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)1L, (long)definitions.size());
            Assert.assertTrue((boolean)(definitions.get(0) instanceof StringDefinition));
            Assert.assertEquals((Object)"variable", (Object)((Definition)definitions.get(0)).getKey());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getNewDefinitionsExisting() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        StringDefinition stringDefinition = GenconfPackage.eINSTANCE.getGenconfFactory().createStringDefinition();
        stringDefinition.setKey("variable");
        generation.getDefinitions().add((Object)stringDefinition);
        Throwable throwable = null;
        Object var4_5 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            properties.getVariables().put("variable", "String");
            List definitions = GenconfUtils.getNewDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)0L, (long)definitions.size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getNewDefinitionsExistingInvalidType() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        StringDefinition stringDefinition = GenconfPackage.eINSTANCE.getGenconfFactory().createStringDefinition();
        stringDefinition.setKey("variable");
        generation.getDefinitions().add((Object)stringDefinition);
        Throwable throwable = null;
        Object var4_5 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            properties.getVariables().put("variable", "ecore::EClass");
            List definitions = GenconfUtils.getNewDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)1L, (long)definitions.size());
            Assert.assertTrue((boolean)(definitions.get(0) instanceof ModelDefinition));
            Assert.assertEquals((Object)"variable", (Object)((Definition)definitions.get(0)).getKey());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getNewDefinitionsExistingNotDeclared() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        StringDefinition stringDefinition = GenconfPackage.eINSTANCE.getGenconfFactory().createStringDefinition();
        stringDefinition.setKey("variable");
        generation.getDefinitions().add((Object)stringDefinition);
        Throwable throwable = null;
        Object var4_5 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            List definitions = GenconfUtils.getNewDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)0L, (long)definitions.size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getOldDefinitionsNotExistingModelDefinition() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        Throwable throwable = null;
        Object var3_4 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            properties.getVariables().put("variable", "ecore::EClass");
            List definitions = GenconfUtils.getOldDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)0L, (long)definitions.size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getOldDefinitionsNotExistingStringDefinition() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        Throwable throwable = null;
        Object var3_4 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            properties.getVariables().put("variable", "String");
            List definitions = GenconfUtils.getOldDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)0L, (long)definitions.size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getOldDefinitionsExisting() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        StringDefinition stringDefinition = GenconfPackage.eINSTANCE.getGenconfFactory().createStringDefinition();
        stringDefinition.setKey("variable");
        generation.getDefinitions().add((Object)stringDefinition);
        Throwable throwable = null;
        Object var4_5 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            properties.getVariables().put("variable", "String");
            List definitions = GenconfUtils.getOldDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)0L, (long)definitions.size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getOldDefinitionsExistingInvalidType() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        StringDefinition stringDefinition = GenconfPackage.eINSTANCE.getGenconfFactory().createStringDefinition();
        stringDefinition.setKey("variable");
        generation.getDefinitions().add((Object)stringDefinition);
        Throwable throwable = null;
        Object var4_5 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            properties.getVariables().put("variable", "ecore::EClass");
            List definitions = GenconfUtils.getOldDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)1L, (long)definitions.size());
            Assert.assertEquals((Object)stringDefinition, definitions.get(0));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void getOldDefinitionsExistingNotDeclared() throws IOException {
        Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        StringDefinition stringDefinition = GenconfPackage.eINSTANCE.getGenconfFactory().createStringDefinition();
        stringDefinition.setKey("variable");
        generation.getDefinitions().add((Object)stringDefinition);
        Throwable throwable = null;
        Object var4_5 = null;
        try (XWPFDocument document = new XWPFDocument();){
            TemplateCustomProperties properties = new TemplateCustomProperties(document);
            List definitions = GenconfUtils.getOldDefinitions((Generation)generation, (TemplateCustomProperties)properties);
            Assert.assertEquals((long)1L, (long)definitions.size());
            Assert.assertEquals((Object)stringDefinition, definitions.get(0));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

