/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.obeonetwork.m2doc.parser.AbstractBodyParser;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.ParsingErrorMessage;
import org.obeonetwork.m2doc.parser.ParsingToken;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.TokenIterator;
import org.obeonetwork.m2doc.parser.TokenProvider;
import org.obeonetwork.m2doc.parser.TokenType;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.TemplatePackage;
import org.obeonetwork.m2doc.template.UserContent;
import org.obeonetwork.m2doc.util.FieldUtils;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class BodyGeneratedParser
extends AbstractBodyParser {
    protected final FieldUtils fieldUtils = new FieldUtils();
    private List<String> userContentIds = new ArrayList<String>();

    public BodyGeneratedParser(IBody inputDocument, IQueryEnvironment queryEnvironment) {
        super(inputDocument, queryEnvironment);
    }

    private BodyGeneratedParser(IBody inputDocument, IQueryBuilderEngine queryParser, IQueryEnvironment queryEnvironment) {
        super(inputDocument, queryParser, queryEnvironment);
    }

    @Override
    protected TokenProvider createTokenProvider(IBody inputDocument) {
        return new TokenProvider(new TokenIterator(inputDocument));
    }

    @Override
    protected TokenType getNextTokenMTag(ParsingToken token) {
        String type;
        XWPFRun run = token.getRun();
        TokenType result = this.fieldUtils.isFieldBegin(run) ? ((type = this.getType(this.fieldUtils.lookAheadFieldTag(this.runIterator))) == null ? TokenType.STATIC : (type.equals(TokenType.ENDUSERCONTENT.getValue()) ? TokenType.ENDUSERCONTENT : (type.equals(TokenType.USERCONTENT.getValue()) ? TokenType.USERCONTENT : TokenType.STATIC))) : TokenType.STATIC;
        return result;
    }

    @Override
    public Block parseBlock(List<Template> templates, String header, TokenType ... endTypes) throws DocumentParserException {
        Block res = (Block)EcoreUtil.create((EClass)TemplatePackage.Literals.BLOCK);
        TokenType type = this.getNextTokenType();
        HashSet<TokenType> endTypeSet = new HashSet<TokenType>(Arrays.asList(endTypes));
        block8: while (!endTypeSet.contains((Object)type)) {
            switch (type) {
                case USERCONTENT: {
                    res.getStatements().add((Object)this.parseUserContent());
                    break;
                }
                case ENDUSERCONTENT: {
                    XWPFRun run = this.runIterator.lookAhead(1).getRun();
                    if (run == null) {
                        throw new IllegalStateException("Token of type " + String.valueOf((Object)type) + " detected. Run shouldn't be null at this place.");
                    }
                    if (header == null) {
                        res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, M2DocUtils.message(ParsingErrorMessage.UNEXPECTEDTAG, type.getValue()), run));
                    } else {
                        res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, M2DocUtils.message(ParsingErrorMessage.UNEXPECTEDTAGWITHHEADER, type.getValue(), header), run));
                    }
                    this.readFieldTag(res, (List<XWPFRun>)res.getRuns());
                    break;
                }
                case EOF: {
                    XWPFParagraph lastParagraph = (XWPFParagraph)this.document.getParagraphs().get(this.document.getParagraphs().size() - 1);
                    XWPFRun lastRun = (XWPFRun)lastParagraph.getRuns().get(lastParagraph.getRuns().size() - 1);
                    if (header == null) {
                        res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, M2DocUtils.message(ParsingErrorMessage.UNEXPECTEDTAGMISSING, new Object[]{type, Arrays.toString((Object[])endTypes)}), lastRun));
                        break block8;
                    }
                    res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, M2DocUtils.message(ParsingErrorMessage.UNEXPECTEDTAGMISSINGWITHHEADER, new Object[]{type, Arrays.toString((Object[])endTypes), header}), lastRun));
                    break block8;
                }
                case STATIC: {
                    res.getStatements().add((Object)this.parseStaticFragment());
                    break;
                }
                case WTABLE: {
                    res.getStatements().add((Object)this.parseTable((XWPFTable)this.runIterator.next().getBodyElement()));
                    break;
                }
                case CONTENTCONTROL: {
                    res.getStatements().add((Object)this.parseContentControl((XWPFSDT)this.runIterator.next().getBodyElement()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Developer error: TokenType %s is not supported", new Object[]{type}));
                }
            }
            type = this.getNextTokenType();
        }
        return res;
    }

    private UserContent parseUserContent() throws DocumentParserException {
        UserContent userContent = (UserContent)EcoreUtil.create((EClass)TemplatePackage.Literals.USER_CONTENT);
        String header = this.readFieldTag(userContent, (List<XWPFRun>)userContent.getRuns()).trim();
        String id = header.substring(TokenType.USERCONTENT.getValue().length()).trim();
        if (id == null || "".equals(id)) {
            lastRun = (XWPFRun)userContent.getRuns().get(userContent.getRuns().size() - 1);
            TemplateValidationMessage templateValidationMessage = new TemplateValidationMessage(ValidationMessageLevel.ERROR, ParsingErrorMessage.INVALID_USERCONTENT_VALUE.getMessage(), lastRun);
            userContent.getValidationMessages().add((Object)templateValidationMessage);
        } else {
            userContent.setId(id);
            if (this.userContentIds.contains(id)) {
                lastRun = (XWPFRun)userContent.getRuns().get(userContent.getRuns().size() - 1);
                TemplateValidationMessage templateValidationMessage = new TemplateValidationMessage(ValidationMessageLevel.WARNING, M2DocUtils.message(ParsingErrorMessage.INVALID_USERDOC_ID_NOT_UNIQUE, id), lastRun);
                userContent.getValidationMessages().add((Object)templateValidationMessage);
            } else {
                this.userContentIds.add(id);
            }
        }
        Block body = this.parseBlock(null, header, TokenType.ENDUSERCONTENT);
        userContent.setBody(body);
        if (this.getNextTokenType() != TokenType.EOF) {
            this.readFieldTag(userContent, (List<XWPFRun>)userContent.getClosingRuns());
        }
        return userContent;
    }

    protected String readFieldTag(IConstruct construct, List<XWPFRun> runsToFill) {
        XWPFRun run = this.runIterator.lookAhead(1).getRun();
        if (run == null) {
            throw new IllegalStateException("readTag shouldn't be called with a table in the lookahead window.");
        }
        if (!this.fieldUtils.isFieldBegin(run)) {
            throw new IllegalStateException("Shouldn't call readTag if the current run doesn't start a field");
        }
        StringBuilder result = new StringBuilder();
        runsToFill.add(this.runIterator.next().getRun());
        XWPFRun styleRun = null;
        boolean columnRead = false;
        while (this.runIterator.hasNext()) {
            run = this.runIterator.next().getRun();
            if (run == null) {
                throw new IllegalArgumentException("table cannot be inserted into tags.");
            }
            runsToFill.add(run);
            if (this.fieldUtils.isFieldEnd(run)) break;
            String runText = this.fieldUtils.readUpInstrText(run);
            result.append(runText);
            if (styleRun != null) continue;
            if (columnRead && !runText.isEmpty()) {
                styleRun = run;
                construct.setStyleRun(styleRun);
                continue;
            }
            int indexOfColumn = runText.indexOf(58);
            boolean bl = columnRead = indexOfColumn >= 0;
            if (!columnRead || indexOfColumn >= runText.length() - 1) continue;
            styleRun = run;
            construct.setStyleRun(styleRun);
        }
        return result.toString();
    }

    @Override
    protected AbstractBodyParser getNewParser(IBody inputDocument) {
        BodyGeneratedParser parser = new BodyGeneratedParser(inputDocument, this.queryParser, this.queryEnvironment);
        return parser;
    }
}

