/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.obeonetwork.m2doc.parser.ParsingToken;
import org.obeonetwork.m2doc.parser.RunSplit;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

final class CharIterator
implements Iterator<Character> {
    private final XWPFParagraph paragraph;
    private final List<ParsingToken> tokens;
    private final Iterator<Position> positionIt;
    private Position currentPosition;

    CharIterator(XWPFParagraph paragraph, List<ParsingToken> tokens) {
        this.paragraph = paragraph;
        this.tokens = tokens;
        ArrayList<Position> positions = new ArrayList<Position>();
        int runIndex = 0;
        for (XWPFRun run : paragraph.getRuns()) {
            int tIndex = 0;
            for (CTText text : run.getCTR().getTList()) {
                String value = text.getStringValue();
                int charIndex = 0;
                while (charIndex < value.length()) {
                    positions.add(new Position(Character.valueOf(value.charAt(charIndex)), runIndex, tIndex, charIndex));
                    ++charIndex;
                }
                ++tIndex;
            }
            ++runIndex;
        }
        this.positionIt = positions.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.positionIt.hasNext();
    }

    @Override
    public Character next() {
        this.currentPosition = this.positionIt.next();
        return this.currentPosition.character;
    }

    RunSplit getRunSplit(ParsingToken tokenToInsert) {
        RunSplit result = new RunSplit(this.paragraph, this.tokens, this.currentPosition.runIndex, this.currentPosition.tIndex, this.currentPosition.charIndex, tokenToInsert);
        return result;
    }

    private static final class Position {
        private final Character character;
        private final int runIndex;
        private final int tIndex;
        private final int charIndex;

        Position(Character character, int runIndex, int tIndex, int charIndex) {
            this.character = character;
            this.runIndex = runIndex;
            this.tIndex = tIndex;
            this.charIndex = charIndex;
        }

        public String toString() {
            return String.valueOf(this.character) + " " + this.runIndex + " " + this.tIndex + " " + this.charIndex;
        }
    }
}

