/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.parser;

import java.util.StringJoiner;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.obeonetwork.m2doc.parser.ParsingTokenKind;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

public class ParsingToken {
    public static final ParsingToken START_FIELD_TOKEN = new ParsingToken(ParsingTokenKind.FIELD_START);
    public static final ParsingToken END_FIELD_TOKEN = new ParsingToken(ParsingTokenKind.FIELD_END);
    public static final ParsingToken MISSING_END_FIELD_TOKEN = new ParsingToken(ParsingTokenKind.MISSING_FIELD_END);
    private final IBodyElement bodyElement;
    private final XWPFRun run;
    private final ParsingTokenKind kind;

    public ParsingToken(XWPFRun run) {
        this(run, null, ParsingTokenKind.RUN);
    }

    public ParsingToken(IBodyElement bodyElement) {
        this(null, bodyElement, ParsingTokenKind.getParsingTokenKind(bodyElement.getElementType()));
    }

    private ParsingToken(ParsingTokenKind kind) {
        this(null, null, kind);
    }

    private ParsingToken(XWPFRun run, IBodyElement bodyElement, ParsingTokenKind kind) {
        this.bodyElement = bodyElement;
        this.run = run;
        this.kind = kind;
    }

    public XWPFRun getRun() {
        return this.run;
    }

    public IBodyElement getBodyElement() {
        return this.bodyElement;
    }

    public ParsingTokenKind getKind() {
        return this.kind;
    }

    public String toString() {
        String result;
        if (this.getKind() == ParsingTokenKind.RUN) {
            StringJoiner joiner = new StringJoiner(", ", this.getKind().toString() + ": [", "]");
            for (CTText text : this.getRun().getCTR().getTList()) {
                joiner.add(text.getStringValue());
            }
            result = joiner.toString();
        } else {
            result = this.getKind().toString();
        }
        return result;
    }
}

