/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.obeonetwork.m2doc.ide.ui.wizard.SelectRegisteredTemplatePage;

public class M2DocTypeSelectionDialog
extends MessageDialog {
    private static final int TABLE_MINIMUM_HEIGHT = 400;
    private static final int TABLE_MINIMUM_WIDTH = 200;
    private final String defaultType;
    private List<String> nsURIs;
    private String selectedType;

    public M2DocTypeSelectionDialog(Shell parentShell, String variableName, String defaultType, List<String> nsURIs) {
        super(parentShell, "Select a variable type for " + variableName, null, "Select a type.", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.nsURIs = nsURIs;
        this.defaultType = defaultType;
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        FilteredTree filteredTree = new FilteredTree(container, 2048, new PatternFilter(), true);
        TreeViewer treeViewer = filteredTree.getViewer();
        Tree tree = treeViewer.getTree();
        GridData gdTable = new GridData(4, 4, true, true, 1, 1);
        gdTable.minimumWidth = 200;
        gdTable.minimumHeight = 400;
        tree.setLayoutData((Object)gdTable);
        treeViewer.setContentProvider((IContentProvider)new SelectRegisteredTemplatePage.CollectionContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                M2DocTypeSelectionDialog.this.selectedType = (String)selected;
            }
        });
        treeViewer.setInput(this.getAvailableTypes(this.nsURIs));
        if (this.defaultType != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.defaultType));
        }
        return container;
    }

    List<String> getAvailableTypes(List<String> uris) {
        HashSet<String> types = new HashSet<String>();
        types.add("String");
        types.add("Integer");
        types.add("Real");
        types.add("Boolean");
        types.addAll(this.getEClassifiers((EPackage)EcorePackage.eINSTANCE));
        if (uris != null) {
            for (String nsURI : uris) {
                EPackage ePkg = EPackageRegistryImpl.INSTANCE.getEPackage(nsURI);
                if (ePkg == null) continue;
                types.addAll(this.getEClassifiers(ePkg));
            }
        }
        ArrayList<String> res = new ArrayList<String>(types.size() * 3);
        for (String type : types) {
            res.add(type);
            res.add("Sequence(" + type + ")");
            res.add("OrderedSet(" + type + ")");
        }
        Collections.sort(res);
        return res;
    }

    private List<String> getEClassifiers(EPackage ePkg) {
        ArrayList<String> res = new ArrayList<String>();
        for (EClassifier eClassifier : ePkg.getEClassifiers()) {
            res.add(ePkg.getName() + "::" + eClassifier.getName());
        }
        for (EPackage child : ePkg.getESubpackages()) {
            res.addAll(this.getEClassifiers(child));
        }
        return res;
    }

    public String getSelectedType() {
        return this.selectedType;
    }
}

