/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.wizard;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;

public class M2DocMainVariablePage
extends WizardPage {
    private String variableName;
    private EObject variableValue;
    private final ComposedAdapterFactory adapterFactory;
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private final TransactionalEditingDomain editingDomain;

    public M2DocMainVariablePage() {
        super("Set the main variable value and name for your template.");
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.editingDomain = new TransactionalEditingDomainImpl((AdapterFactory)this.adapterFactory, this.resourceSet);
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, parent.getStyle());
        pageComposite.setLayout((Layout)new GridLayout(1, false));
        TreeViewer treeViewer = this.createVariableValueComposite(pageComposite);
        final Text variableNameText = this.createVariableNameComposite(pageComposite);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selected instanceof EObject) {
                    boolean wasDefaultName = M2DocMainVariablePage.this.variableValue == null || ("my" + M2DocMainVariablePage.this.variableValue.eClass().getName()).equals(variableNameText.getText());
                    M2DocMainVariablePage.this.variableValue = (EObject)selected;
                    if (wasDefaultName) {
                        variableNameText.setText("my" + M2DocMainVariablePage.this.variableValue.eClass().getName());
                        M2DocMainVariablePage.this.variableName = variableNameText.getText();
                    }
                }
                M2DocMainVariablePage.this.validatePage();
            }
        });
        this.validatePage();
        this.setControl((Control)pageComposite);
    }

    private Text createVariableNameComposite(Composite pageComposite) {
        Composite variableNameComposite = new Composite(pageComposite, pageComposite.getStyle());
        variableNameComposite.setLayout((Layout)new GridLayout(2, false));
        variableNameComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label variableNameLabel = new Label(variableNameComposite, pageComposite.getStyle());
        variableNameLabel.setText("Variable name:");
        final Text variableNameText = new Text(variableNameComposite, pageComposite.getStyle());
        variableNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                M2DocMainVariablePage.this.variableName = variableNameText.getText();
                M2DocMainVariablePage.this.validatePage();
            }
        });
        variableNameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                M2DocMainVariablePage.this.variableName = variableNameText.getText();
                M2DocMainVariablePage.this.validatePage();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        variableNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        return variableNameText;
    }

    private TreeViewer createVariableValueComposite(Composite pageComposite) {
        Composite valueComposite = new Composite(pageComposite, pageComposite.getStyle());
        valueComposite.setLayout((Layout)new GridLayout(2, false));
        valueComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        int style = 2820;
        FilteredTree filteredTree = new FilteredTree(valueComposite, 2820, new PatternFilter(), true);
        filteredTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        final TreeViewer treeViewer = filteredTree.getViewer();
        treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        Button loadResourceButton = new Button(valueComposite, pageComposite.getStyle());
        loadResourceButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        loadResourceButton.setText("Load resource");
        loadResourceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LoadResourceAction.LoadResourceDialog dialog = new LoadResourceAction.LoadResourceDialog(M2DocMainVariablePage.this.getShell(), (EditingDomain)M2DocMainVariablePage.this.editingDomain);
                dialog.open();
                treeViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        treeViewer.setInput((Object)this.resourceSet);
        return treeViewer;
    }

    private void validatePage() {
        if (this.variableValue instanceof EObject) {
            if (this.variableName != null && TemplateCustomProperties.isValidVariableName((String)this.variableName)) {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                this.setErrorMessage("Invalid variable name.");
                this.setPageComplete(false);
            }
        } else {
            this.setErrorMessage("The variable value should be a model element.");
            this.setPageComplete(false);
        }
    }

    public String getVariableName() {
        return this.variableName;
    }

    public EObject getVariableValue() {
        return this.variableValue;
    }
}

