/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.obeonetwork.m2doc.ide.ui.M2DocUIPlugin;
import org.obeonetwork.m2doc.ide.ui.util.IClassPropertyUpdater;
import org.obeonetwork.m2doc.ide.ui.wizard.TemplateVariablesPage;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.services.TokenRegistry;

public class TemplateCustomPropertiesPage
extends WizardPage {
    private static final int WIDTH = 300;
    private final TemplateCustomProperties properties;
    private TokenRegistry registry;
    private TemplateVariablesPage templateVariablesProperties;

    protected TemplateCustomPropertiesPage(TokenRegistry registry, TemplateCustomProperties properties, TemplateVariablesPage templateVariablesProperties) {
        super("Template properties");
        this.properties = properties;
        this.registry = registry;
        this.templateVariablesProperties = templateVariablesProperties;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(container, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        CheckboxTableViewer tokenViewer = this.addTokenTabItem(tabFolder, this.registry, this.properties);
        this.addNSURITabItem(tabFolder, tokenViewer, this.properties);
        this.addServicesTabItem(tabFolder, tokenViewer, this.properties);
        if (!"4.0.1".equals(this.properties.getM2DocVersion())) {
            this.setMessage("M2Doc version mismatch: template version is " + this.properties.getM2DocVersion() + " and current M2Doc version is 4.0.1", 2);
        } else {
            this.setMessage("Select services and packages");
        }
    }

    private void addServicesTabItem(TabFolder tabFolder, final CheckboxTableViewer tokenViewer, final TemplateCustomProperties customProperties) {
        TabItem servicesTabItem = new TabItem(tabFolder, tabFolder.getStyle());
        servicesTabItem.setText("Services (expert)");
        Composite servicesContainer = new Composite((Composite)tabFolder, tabFolder.getStyle());
        servicesTabItem.setControl((Control)servicesContainer);
        servicesContainer.setLayout((Layout)new GridLayout(2, false));
        final TableViewer servicesTable = new TableViewer(servicesContainer, servicesContainer.getStyle() | 2);
        Table table = servicesTable.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        servicesTable.getTable().setHeaderVisible(true);
        TableViewerColumn classNameColumn = new TableViewerColumn(servicesTable, tabFolder.getStyle());
        classNameColumn.getColumn().setText("Service class");
        classNameColumn.getColumn().setWidth(300);
        classNameColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText((String)((Map.Entry)cell.getElement()).getKey());
            }
        });
        TableViewerColumn bundleNameColumn = new TableViewerColumn(servicesTable, tabFolder.getStyle());
        bundleNameColumn.getColumn().setText("Bundle");
        bundleNameColumn.getColumn().setWidth(300);
        bundleNameColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText((String)((Map.Entry)cell.getElement()).getValue());
            }
        });
        servicesTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((TemplateCustomProperties)inputElement).getServiceClasses().entrySet().toArray();
            }
        });
        tokenViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                servicesTable.refresh();
            }
        });
        servicesTable.setInput((Object)customProperties);
        Composite servicesButtonComposite = new Composite(servicesContainer, tabFolder.getStyle());
        servicesButtonComposite.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        servicesButtonComposite.setLayout((Layout)new GridLayout(1, false));
        Button addButton = new Button(servicesButtonComposite, servicesButtonComposite.getStyle());
        addButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        addButton.setText("Add");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TemplateCustomPropertiesPage.this.openClassSelectionDialog((Viewer)tokenViewer, (Viewer)servicesTable, customProperties);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button removeButton = new Button(servicesButtonComposite, tabFolder.getStyle());
        removeButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        removeButton.setText("Remove");
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (Map.Entry entry : ((IStructuredSelection)servicesTable.getSelection()).toList()) {
                    customProperties.getServiceClasses().remove(entry.getKey());
                }
                servicesTable.refresh();
                tokenViewer.refresh();
                TemplateCustomPropertiesPage.this.templateVariablesProperties.validatePage(customProperties);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        servicesTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!((IStructuredSelection)event.getSelection()).isEmpty());
            }
        });
        removeButton.setEnabled(false);
    }

    private void addNSURITabItem(TabFolder tabFolder, final CheckboxTableViewer tokenViewer, final TemplateCustomProperties customProperties) {
        TabItem nsURITabItem = new TabItem(tabFolder, tabFolder.getStyle());
        nsURITabItem.setText("nsURI (expert)");
        Composite nsURIContainer = new Composite((Composite)tabFolder, tabFolder.getStyle());
        nsURITabItem.setControl((Control)nsURIContainer);
        nsURIContainer.setLayout((Layout)new GridLayout(2, false));
        final TableViewer nsURITable = new TableViewer(nsURIContainer, nsURIContainer.getStyle() | 2);
        Table table = nsURITable.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        nsURITable.getTable().setHeaderVisible(true);
        TableViewerColumn nsURIColumn = new TableViewerColumn(nsURITable, nsURITable.getTable().getStyle());
        nsURIColumn.getColumn().setText("Package nsURI");
        nsURIColumn.getColumn().setWidth(300);
        nsURIColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText((String)cell.getElement());
            }
        });
        nsURITable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((TemplateCustomProperties)inputElement).getPackagesURIs().toArray();
            }
        });
        tokenViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                nsURITable.refresh();
            }
        });
        nsURITable.setInput((Object)customProperties);
        Composite nsURIButtonComposite = new Composite(nsURIContainer, nsURIContainer.getStyle());
        nsURIButtonComposite.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        nsURIButtonComposite.setLayout((Layout)new GridLayout(1, false));
        Button addButton = new Button(nsURIButtonComposite, nsURIButtonComposite.getStyle());
        addButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        addButton.setText("Add");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog dialog = new EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog(Display.getCurrent().getActiveShell());
                if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length != 0) {
                    Object[] objectArray = dialog.getResult();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (!customProperties.getPackagesURIs().contains(object)) {
                            customProperties.getPackagesURIs().add((String)object);
                        }
                        ++n2;
                    }
                    nsURITable.refresh();
                    tokenViewer.refresh();
                    TemplateCustomPropertiesPage.this.templateVariablesProperties.validatePage(customProperties);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button removeButton = new Button(nsURIButtonComposite, nsURIButtonComposite.getStyle());
        removeButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        removeButton.setText("Remove");
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                customProperties.getPackagesURIs().removeAll(((IStructuredSelection)nsURITable.getSelection()).toList());
                nsURITable.refresh();
                tokenViewer.refresh();
                TemplateCustomPropertiesPage.this.templateVariablesProperties.validatePage(customProperties);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        nsURITable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!((IStructuredSelection)event.getSelection()).isEmpty());
            }
        });
        removeButton.setEnabled(false);
    }

    private CheckboxTableViewer addTokenTabItem(TabFolder tabFolder, final TokenRegistry tokenRegistry, final TemplateCustomProperties customProperties) {
        TabItem packageTabItem = new TabItem(tabFolder, tabFolder.getStyle());
        packageTabItem.setText("Packages");
        Composite packagesContainer = new Composite((Composite)tabFolder, tabFolder.getStyle());
        packageTabItem.setControl((Control)packagesContainer);
        packagesContainer.setLayout((Layout)new GridLayout(1, false));
        Table table = new Table(packagesContainer, packagesContainer.getStyle() | 0x200 | 0x20);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        final CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        tableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return !tokenRegistry.getSelectedToken(customProperties).contains(element) || !tokenRegistry.canDeselectToken(customProperties, (String)element);
            }

            public boolean isChecked(Object element) {
                return tokenRegistry.getSelectedToken(customProperties).contains(element);
            }
        });
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    String tokenName = (String)event.getElement();
                    TemplateCustomPropertiesPage.this.selectToken(tokenRegistry, customProperties, tokenName);
                } else {
                    String tokenName = (String)event.getElement();
                    TemplateCustomPropertiesPage.this.deselectToken(tokenRegistry, customProperties, tokenName);
                }
                tableViewer.refresh();
            }
        });
        ArrayList tokenNames = new ArrayList(tokenRegistry.getRegisteredTokens());
        Collections.sort(tokenNames);
        tableViewer.setInput(tokenNames);
        return tableViewer;
    }

    private void selectToken(TokenRegistry tokenRegistry, TemplateCustomProperties customProperties, String tokenName) {
        tokenRegistry.selectToken(customProperties, tokenName);
        this.templateVariablesProperties.validatePage(customProperties);
    }

    private void deselectToken(TokenRegistry tokenRegistry, TemplateCustomProperties customProperties, String tokenName) {
        tokenRegistry.deselectToken(customProperties, tokenName);
        this.templateVariablesProperties.validatePage(customProperties);
    }

    private void openClassSelectionDialog(Viewer tokenViewer, Viewer servicesTable, TemplateCustomProperties customProperties) {
        IClassPropertyUpdater updater = M2DocUIPlugin.getClassPropertyUpdater();
        if (updater == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"No class property updater is registered", (String)"You can try to install the M2Doc JDT feature to solve this issue.");
        } else if (updater.updatePropertyClasses(customProperties)) {
            tokenViewer.refresh();
            servicesTable.refresh();
            this.templateVariablesProperties.validatePage(customProperties);
        }
    }
}

