/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor;

import java.util.StringJoiner;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.obeonetwork.m2doc.genconf.BooleanDefinition;
import org.obeonetwork.m2doc.genconf.BooleanOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.BooleanSequenceDefinition;
import org.obeonetwork.m2doc.genconf.Definition;
import org.obeonetwork.m2doc.genconf.IntegerDefinition;
import org.obeonetwork.m2doc.genconf.IntegerOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.IntegerSequenceDefinition;
import org.obeonetwork.m2doc.genconf.ModelDefinition;
import org.obeonetwork.m2doc.genconf.ModelOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.ModelSequenceDefinition;
import org.obeonetwork.m2doc.genconf.RealDefinition;
import org.obeonetwork.m2doc.genconf.RealOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.RealSequenceDefinition;
import org.obeonetwork.m2doc.genconf.StringDefinition;
import org.obeonetwork.m2doc.genconf.StringOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.StringSequenceDefinition;

public class VariableValueCellLabelProvider
extends CellLabelProvider {
    static final String DON_T_KNOW_WHAT_TO_DO_WITH = "don't know what to do with ";
    private static final String DELIMITER = ", ";
    private AdapterFactory adapterFactory;

    public VariableValueCellLabelProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void update(ViewerCell cell) {
        Definition definition = (Definition)cell.getElement();
        if (definition instanceof StringDefinition) {
            cell.setText(((StringDefinition)definition).getValue());
        } else if (definition instanceof StringSequenceDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (String value : ((StringSequenceDefinition)definition).getValue()) {
                joiner.add(value);
            }
            cell.setText(joiner.toString());
        } else if (definition instanceof StringOrderedSetDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (String value : ((StringOrderedSetDefinition)definition).getValue()) {
                joiner.add(value);
            }
            cell.setText(joiner.toString());
        } else if (definition instanceof IntegerDefinition) {
            cell.setText(String.valueOf(((IntegerDefinition)definition).getValue()));
        } else if (definition instanceof IntegerSequenceDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (Integer value : ((IntegerSequenceDefinition)definition).getValue()) {
                joiner.add(String.valueOf(value));
            }
            cell.setText(joiner.toString());
        } else if (definition instanceof IntegerOrderedSetDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (Integer value : ((IntegerOrderedSetDefinition)definition).getValue()) {
                joiner.add(String.valueOf(value));
            }
            cell.setText(joiner.toString());
        } else if (definition instanceof RealDefinition) {
            cell.setText(String.valueOf(((RealDefinition)definition).getValue()));
        } else if (definition instanceof RealSequenceDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (Double value : ((RealSequenceDefinition)definition).getValue()) {
                joiner.add(String.valueOf(value));
            }
            cell.setText(joiner.toString());
        } else if (definition instanceof RealOrderedSetDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (Double value : ((RealOrderedSetDefinition)definition).getValue()) {
                joiner.add(String.valueOf(value));
            }
            cell.setText(joiner.toString());
        } else if (definition instanceof BooleanDefinition) {
            cell.setText(String.valueOf(((BooleanDefinition)definition).isValue()));
        } else if (definition instanceof BooleanSequenceDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (Boolean value : ((BooleanSequenceDefinition)definition).getValue()) {
                joiner.add(String.valueOf(value));
            }
            cell.setText(joiner.toString());
        } else if (definition instanceof BooleanOrderedSetDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (Boolean value : ((BooleanOrderedSetDefinition)definition).getValue()) {
                joiner.add(String.valueOf(value));
            }
            cell.setText(joiner.toString());
        } else if (definition instanceof ModelDefinition) {
            EObject eObj = ((ModelDefinition)definition).getValue();
            if (eObj != null) {
                String text = this.getLabel(eObj);
                cell.setText(text);
            } else {
                cell.setText("");
            }
        } else if (definition instanceof ModelSequenceDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (EObject value : ((ModelSequenceDefinition)definition).getValue()) {
                joiner.add(this.getLabel(value));
            }
            cell.setText(joiner.toString());
        } else if (definition instanceof ModelOrderedSetDefinition) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (EObject value : ((ModelOrderedSetDefinition)definition).getValue()) {
                joiner.add(this.getLabel(value));
            }
            cell.setText(joiner.toString());
        } else {
            cell.setText(DON_T_KNOW_WHAT_TO_DO_WITH + definition.getClass().getCanonicalName());
        }
    }

    private String getLabel(EObject eObj) {
        IItemLabelProvider itemProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)eObj, IItemLabelProvider.class);
        String text = itemProvider == null ? eObj.toString() : itemProvider.getText((Object)eObj);
        return text;
    }
}

