/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.presentation.M2docconfEditorPlugin;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.util.M2DocUtils;

public abstract class AbstractGenerationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object selected : (IStructuredSelection)selection) {
                Generation generation;
                if (selected instanceof IFile && "genconf".equals(((IFile)selected).getFileExtension())) {
                    URI genconfURI = URI.createPlatformResourceURI((String)((IFile)selected).getFullPath().toString(), (boolean)true);
                    generation = this.getGeneration(genconfURI);
                } else {
                    generation = selected instanceof Generation ? (Generation)selected : null;
                }
                if (generation != null) {
                    this.execute(event, generation);
                    continue;
                }
                MessageDialog.openError((Shell)shell, (String)"Bad selection", (String)"Document generation action can only be triggered on Generation object or a .genconf file.");
            }
        } else {
            MessageDialog.openError((Shell)shell, (String)"Bad selection", (String)"Document generation action can only be triggered on Generation object or a .genconf file.");
        }
        return null;
    }

    protected abstract void execute(ExecutionEvent var1, Generation var2);

    protected Generation getGeneration(URI uri) {
        return GenconfUtils.getGeneration((URI)uri);
    }

    protected static boolean checkM2DocVersion(Shell shell, String dialogTitle, Generation gen) throws DocumentGenerationException, IOException {
        boolean res = true;
        Map options = GenconfUtils.getOptions((Generation)gen);
        ResourceSet resourceSetForModel = M2DocUtils.createResourceSetForModels(new ArrayList(), (Object)gen, (ResourceSet)new ResourceSetImpl(), (Map)options);
        String templateFilePath = gen.getTemplateFileName();
        if (templateFilePath != null && !templateFilePath.isEmpty()) {
            URI templateURI = GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)templateFilePath, (boolean)false));
            TemplateCustomProperties properties = POIServices.getInstance().getTemplateCustomProperties(resourceSetForModel.getURIConverter(), templateURI);
            boolean ignoreVersionCheck = Boolean.valueOf((String)options.get("IgnoreVersionCheck"));
            if (!ignoreVersionCheck && !"4.0.1".equals(properties.getM2DocVersion())) {
                ConfirmRunnable runnable = new ConfirmRunnable(dialogTitle, properties, shell);
                Display.getDefault().syncExec((Runnable)runnable);
                try {
                    res = (Boolean)runnable.get();
                }
                catch (InterruptedException e) {
                    M2docconfEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, M2docconfEditorPlugin.getPlugin().getBundle().getSymbolicName(), "Couldn't generate", (Throwable)e));
                }
                catch (java.util.concurrent.ExecutionException e) {
                    M2docconfEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, M2docconfEditorPlugin.getPlugin().getBundle().getSymbolicName(), "Couldn't generate", (Throwable)e));
                }
            }
        }
        M2DocUtils.cleanResourceSetForModels((Object)gen, (ResourceSet)resourceSetForModel);
        return res;
    }

    private static final class ConfirmRunnable
    implements RunnableFuture<Boolean> {
        private final String dialogTitle;
        private final TemplateCustomProperties properties;
        private final Shell shell;
        private boolean done;
        private boolean result;

        private ConfirmRunnable(String dialogTitle, TemplateCustomProperties properties, Shell shell) {
            this.dialogTitle = dialogTitle;
            this.properties = properties;
            this.shell = shell;
        }

        @Override
        public void run() {
            this.result = MessageDialog.openConfirm((Shell)this.shell, (String)this.dialogTitle, (String)("M2Doc version mismatch: template version is " + this.properties.getM2DocVersion() + " and current M2Doc version is 4.0.1. Do you want to continue ?"));
            this.done = true;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Boolean get() throws InterruptedException, java.util.concurrent.ExecutionException {
            return this.result;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, java.util.concurrent.ExecutionException, TimeoutException {
            return this.result;
        }
    }
}

