/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.view.aql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.obeonetwork.m2doc.genconf.editor.view.aql.ColorManager;
import org.obeonetwork.m2doc.genconf.editor.view.aql.IAQLColorConstants;

public class AQLScanner
implements ITokenScanner {
    private static final String KEYWORD_REGEX = "if|then|else|endif|let|in|true|false|null|not";
    private static final String STRING_LITERAL_REGEX = "'([^'\\\\]|\\\\.)*'";
    private static final String ECLASSIFIER_TYPE_REGEX = "[a-zA-Z_][a-zA-Z_0-9]*::[a-zA-Z_][a-zA-Z_0-9]*";
    private static final String ECLASSIFIER_SET_TYPE_REGEX = "\\{\\s*[a-zA-Z_][a-zA-Z_0-9]*::[a-zA-Z_][a-zA-Z_0-9]*(\\s*\\|\\s*[a-zA-Z_][a-zA-Z_0-9]*::[a-zA-Z_][a-zA-Z_0-9]*)*\\s*\\}";
    private static final Pattern SCANNER = Pattern.compile("(\\s+)|((?<![a-zA-Z])(if|then|else|endif|let|in|true|false|null|not)(?![a-zA-Z]))|('([^'\\\\]|\\\\.)*')|((?<![a-zA-Z])((String|Integer|Real|Boolean)(?![a-zA-Z]))|Sequence(?=\\()|OrderedSet(?=\\()|\\{\\s*[a-zA-Z_][a-zA-Z_0-9]*::[a-zA-Z_][a-zA-Z_0-9]*(\\s*\\|\\s*[a-zA-Z_][a-zA-Z_0-9]*::[a-zA-Z_][a-zA-Z_0-9]*)*\\s*\\}|[a-zA-Z_][a-zA-Z_0-9]*::[a-zA-Z_][a-zA-Z_0-9]*)");
    private static final int WS_GROUP = 1;
    private static final int KEYWORD_GROUP = 2;
    private static final int STRING_GROUP = 4;
    private static final int TYPE_LITERAL_GROUP = 6;
    private final IToken keywordToken;
    private final IToken stringToken;
    private final IToken typeLiteralToken;
    private Matcher matcher;
    private int documentOffset;
    private int expressionLength;
    private int currentOffset;
    private int currentLength;
    private boolean matcherReady;

    public AQLScanner(ColorManager colorManager) {
        this.keywordToken = new Token((Object)new TextAttribute(colorManager.getColor(IAQLColorConstants.KEYWORD)));
        this.stringToken = new Token((Object)new TextAttribute(colorManager.getColor(IAQLColorConstants.STRING)));
        this.typeLiteralToken = new Token((Object)new TextAttribute(colorManager.getColor(IAQLColorConstants.TYPE_LITERAL)));
    }

    public void setRange(IDocument document, int offset, int length) {
        try {
            this.matcher = SCANNER.matcher(document.get(offset, length));
            this.expressionLength = length;
            this.documentOffset = offset;
            this.currentOffset = 0;
            this.currentLength = 0;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IToken nextToken() {
        IToken res;
        if (this.matcherReady || this.matcher.find()) {
            if (this.matcher.start() == this.currentOffset + this.currentLength) {
                this.matcherReady = false;
                this.currentOffset = this.matcher.start();
                this.currentLength = this.matcher.end() - this.matcher.start();
                if (this.matcher.group(1) != null) {
                    return Token.WHITESPACE;
                }
                if (this.matcher.group(2) != null) {
                    return this.keywordToken;
                }
                if (this.matcher.group(4) != null) {
                    return this.stringToken;
                }
                if (this.matcher.group(6) == null) throw new IllegalStateException("should not happen.");
                return this.typeLiteralToken;
            }
            this.matcherReady = true;
            res = Token.UNDEFINED;
            this.currentOffset += this.currentLength;
            this.currentLength = this.matcher.start() - this.currentOffset;
            return res;
        } else if (this.currentOffset + this.currentLength < this.expressionLength) {
            this.matcherReady = false;
            res = Token.UNDEFINED;
            this.currentOffset += this.currentLength;
            this.currentLength = this.expressionLength - this.currentOffset;
            return res;
        } else {
            this.matcherReady = false;
            res = Token.EOF;
            this.currentOffset = this.expressionLength;
            this.currentLength = 0;
        }
        return res;
    }

    public int getTokenOffset() {
        return this.documentOffset + this.currentOffset;
    }

    public int getTokenLength() {
        return this.currentLength;
    }
}

