/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.genconf.GenconfPackage;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.editor.GenerationListener;
import org.obeonetwork.m2doc.genconf.editor.ITemplateCustomPropertiesProvider;
import org.obeonetwork.m2doc.ide.ui.dialog.M2DocFileSelectionDialog;
import org.obeonetwork.m2doc.ide.ui.dialog.SelectRegistredTemplateDialog;
import org.obeonetwork.m2doc.ide.ui.dialog.SelectTemplateFromLibraryDialog;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class GenerationFileNamesPage
extends WizardPage
implements ITemplateCustomPropertiesProvider {
    private Generation generation;
    private final GenerationListener generationListener;
    private Text genConfURIText;
    private Text templateURIText;
    private Text validationURIText;
    private Text resultURIText;
    private TemplateCustomProperties templateCustomProperties;
    private boolean canChangeTemplateFile;

    protected GenerationFileNamesPage(Generation generation, GenerationListener generationListener, boolean canChangeTemplateFile) {
        super("Select files");
        this.setTitle("Select files");
        this.generation = generation;
        this.generationListener = generationListener;
        this.canChangeTemplateFile = canChangeTemplateFile;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        container.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)container);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.generation);
        this.genConfURIText = this.createGenconfURIComposite(this.generation, container);
        Group relativeToGenconfGroup = new Group(container, 2048);
        relativeToGenconfGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        relativeToGenconfGroup.setLayout((Layout)new GridLayout(1, false));
        relativeToGenconfGroup.setText("Relative to generation file");
        this.templateURIText = this.createTemplateURIComposite(this.generation, (Composite)relativeToGenconfGroup, this.canChangeTemplateFile);
        this.generationListener.setTemplateURIText(this.templateURIText);
        this.validationURIText = this.createURIComposite(this.generation, (Composite)relativeToGenconfGroup, "Validation file:", new Listener((EditingDomain)editingDomain){
            private final /* synthetic */ EditingDomain val$editingDomain;
            {
                this.val$editingDomain = editingDomain;
            }

            public void handleEvent(Event event) {
                M2DocFileSelectionDialog dialog = new M2DocFileSelectionDialog(GenerationFileNamesPage.this.getShell(), "Select validation file.", GenerationFileNamesPage.this.getFileName(GenconfUtils.getResolvedURI((Generation)GenerationFileNamesPage.this.generation, (URI)URI.createURI((String)GenerationFileNamesPage.this.generation.getValidationFileName()))), "docx", false);
                int dialogResult = dialog.open();
                if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
                    URI validationURI = URI.createPlatformResourceURI((String)dialog.getFileName(), (boolean)true);
                    URI genconfURI = GenerationFileNamesPage.this.generation.eResource().getURI();
                    String relativeDestinationPath = URI.decode((String)validationURI.deresolve(genconfURI).toString());
                    this.val$editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.val$editingDomain, (Object)GenerationFileNamesPage.this.generation, (Object)GenconfPackage.Literals.GENERATION__VALIDATION_FILE_NAME, (Object)relativeDestinationPath));
                }
            }
        });
        this.generationListener.setValidationURIText(this.validationURIText);
        if (this.generation.getValidationFileName() != null) {
            this.validationURIText.setText(this.generation.getValidationFileName());
        }
        this.validationURIText.addKeyListener(new KeyListener((EditingDomain)editingDomain){
            private final /* synthetic */ EditingDomain val$editingDomain;
            {
                this.val$editingDomain = editingDomain;
            }

            public void keyReleased(KeyEvent e) {
                if (!GenerationFileNamesPage.this.validationURIText.getText().equals(GenerationFileNamesPage.this.generation.getValidationFileName())) {
                    this.val$editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.val$editingDomain, (Object)GenerationFileNamesPage.this.generation, (Object)GenconfPackage.Literals.GENERATION__VALIDATION_FILE_NAME, (Object)GenerationFileNamesPage.this.validationURIText.getText()));
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.resultURIText = this.createURIComposite(this.generation, (Composite)relativeToGenconfGroup, "Result file:", new Listener((EditingDomain)editingDomain){
            private final /* synthetic */ EditingDomain val$editingDomain;
            {
                this.val$editingDomain = editingDomain;
            }

            public void handleEvent(Event event) {
                M2DocFileSelectionDialog dialog = new M2DocFileSelectionDialog(GenerationFileNamesPage.this.getShell(), "Select result file.", GenerationFileNamesPage.this.getFileName(GenconfUtils.getResolvedURI((Generation)GenerationFileNamesPage.this.generation, (URI)URI.createURI((String)GenerationFileNamesPage.this.generation.getResultFileName()))), "docx", false);
                int dialogResult = dialog.open();
                if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
                    URI validationURI = URI.createPlatformResourceURI((String)dialog.getFileName(), (boolean)true);
                    URI genconfURI = GenerationFileNamesPage.this.generation.eResource().getURI();
                    String relativeDestinationPath = URI.decode((String)validationURI.deresolve(genconfURI).toString());
                    this.val$editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.val$editingDomain, (Object)GenerationFileNamesPage.this.generation, (Object)GenconfPackage.Literals.GENERATION__RESULT_FILE_NAME, (Object)relativeDestinationPath));
                }
            }
        });
        this.generationListener.setDestinationURIText(this.resultURIText);
        if (this.generation.getResultFileName() != null) {
            this.resultURIText.setText(this.generation.getResultFileName());
        }
        this.resultURIText.addKeyListener(new KeyListener((EditingDomain)editingDomain){
            private final /* synthetic */ EditingDomain val$editingDomain;
            {
                this.val$editingDomain = editingDomain;
            }

            public void keyReleased(KeyEvent e) {
                if (!GenerationFileNamesPage.this.resultURIText.getText().equals(GenerationFileNamesPage.this.generation.getResultFileName())) {
                    this.val$editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.val$editingDomain, (Object)GenerationFileNamesPage.this.generation, (Object)GenconfPackage.Literals.GENERATION__RESULT_FILE_NAME, (Object)GenerationFileNamesPage.this.resultURIText.getText()));
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        URI templateURI = URI.createURI((String)this.getTemplateURIText().getText());
        if (templateURI != null) {
            this.validatePage(this.generation, templateURI);
        } else {
            this.validatePage(this.generation, URI.createURI((String)""));
        }
    }

    private Text createGenconfURIComposite(final Generation gen, Composite composite) {
        Composite uriComposite = new Composite(composite, composite.getStyle());
        uriComposite.setLayout((Layout)new GridLayout(3, false));
        uriComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label uriLabel = new Label(uriComposite, composite.getStyle());
        uriLabel.setText("Generation file:");
        final Text uriText = new Text(uriComposite, composite.getStyle());
        uriText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (gen.eResource().getURI() != null) {
            uriText.setText(URI.decode((String)gen.eResource().getURI().toString()));
        }
        uriText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                GenerationFileNamesPage.this.updateGenconfURI(gen, URI.createURI((String)uriText.getText(), (boolean)true));
                GenerationFileNamesPage.this.validatePage(gen, GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getTemplateFileName(), (boolean)false)));
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Button uriButton = new Button(uriComposite, 2048);
        uriButton.setText("Browse");
        uriButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                M2DocFileSelectionDialog dialog = new M2DocFileSelectionDialog(GenerationFileNamesPage.this.getShell(), "Select generation file.", GenerationFileNamesPage.this.getFileName(gen.eResource().getURI()), "genconf", false);
                int dialogResult = dialog.open();
                if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
                    URI newGenconfURI = URI.createPlatformResourceURI((String)dialog.getFileName(), (boolean)true);
                    GenerationFileNamesPage.this.updateGenconfURI(gen, newGenconfURI);
                    uriText.setText(newGenconfURI.toString());
                    GenerationFileNamesPage.this.validatePage(gen, GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getTemplateFileName(), (boolean)false)));
                }
            }
        });
        return uriText;
    }

    private void updateGenconfURI(final Generation gen, final URI newGenconfURI) {
        final URI templateAbsolutURI = gen.getTemplateFileName() != null ? GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getTemplateFileName(), (boolean)false)) : null;
        final URI validationAbsolutURI = gen.getValidationFileName() != null ? GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getValidationFileName(), (boolean)false)) : null;
        final URI resultAbsolutURI = gen.getResultFileName() != null ? GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getResultFileName())) : null;
        gen.eResource().setURI(newGenconfURI);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)gen);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                if (templateAbsolutURI != null) {
                    gen.setTemplateFileName(URI.decode((String)templateAbsolutURI.deresolve(newGenconfURI).toString()));
                }
                if (validationAbsolutURI != null) {
                    gen.setValidationFileName(URI.decode((String)validationAbsolutURI.deresolve(newGenconfURI).toString()));
                }
                if (resultAbsolutURI != null) {
                    gen.setResultFileName(URI.decode((String)resultAbsolutURI.deresolve(newGenconfURI).toString()));
                }
            }
        });
    }

    private Text createTemplateURIComposite(final Generation gen, Composite composite, boolean canChange) {
        Composite uriComposite = new Composite(composite, composite.getStyle());
        uriComposite.setLayout((Layout)new GridLayout(5, false));
        uriComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)gen);
        Label uriLabel = new Label(uriComposite, composite.getStyle());
        uriLabel.setText("Template File:");
        final Text uriText = new Text(uriComposite, composite.getStyle());
        uriText.setEnabled(canChange);
        uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationFileNamesPage.this.templateCustomProperties = GenerationFileNamesPage.this.validatePage(gen, GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getTemplateFileName(), (boolean)false)));
            }
        });
        if (gen.getTemplateFileName() != null) {
            uriText.setText(gen.getTemplateFileName());
            this.templateCustomProperties = this.validatePage(gen, GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getTemplateFileName(), (boolean)false)));
        }
        uriText.addKeyListener(new KeyListener((EditingDomain)editingDomain){
            private final /* synthetic */ EditingDomain val$editingDomain;
            {
                this.val$editingDomain = editingDomain;
            }

            public void keyReleased(KeyEvent e) {
                if (!uriText.getText().equals(gen.getTemplateFileName())) {
                    this.val$editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.val$editingDomain, (Object)gen, (Object)GenconfPackage.Literals.GENERATION__TEMPLATE_FILE_NAME, (Object)uriText.getText()));
                    GenerationFileNamesPage.this.templateCustomProperties = GenerationFileNamesPage.this.validatePage(gen, GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getTemplateFileName(), (boolean)false)));
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        uriText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        uriText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (!uriText.getText().equals(gen.eResource().getURI().toString())) {
                    GenerationFileNamesPage.this.updateTemplateURI(gen, URI.createURI((String)uriText.getText()));
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Button workspaceButton = new Button(uriComposite, 2048);
        workspaceButton.setEnabled(canChange);
        workspaceButton.setText("Browse workspace");
        workspaceButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                M2DocFileSelectionDialog dialog = new M2DocFileSelectionDialog(GenerationFileNamesPage.this.getShell(), "Select generation file.", GenerationFileNamesPage.this.getFileName(GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getTemplateFileName()))), "docx", true);
                int dialogResult = dialog.open();
                if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
                    URI templateURI = URI.createPlatformResourceURI((String)dialog.getFileName(), (boolean)true);
                    GenerationFileNamesPage.this.updateTemplateURI(gen, templateURI);
                }
            }
        });
        Button registeryButton = new Button(uriComposite, 2048);
        registeryButton.setEnabled(canChange);
        registeryButton.setText("Browse registery");
        registeryButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectRegistredTemplateDialog dialog = new SelectRegistredTemplateDialog(GenerationFileNamesPage.this.getShell());
                int dialogResult = dialog.open();
                if (dialogResult == 0 && dialog.getTemplateURI() != null) {
                    GenerationFileNamesPage.this.updateTemplateURI(gen, dialog.getTemplateURI());
                }
            }
        });
        Button librariesButton = new Button(uriComposite, 2048);
        librariesButton.setEnabled(canChange);
        librariesButton.setText("Browse libraries");
        librariesButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectTemplateFromLibraryDialog dialog = new SelectTemplateFromLibraryDialog(GenerationFileNamesPage.this.getShell());
                int dialogResult = dialog.open();
                if (dialogResult == 0 && dialog.getTemplateURI() != null) {
                    GenerationFileNamesPage.this.updateTemplateURI(gen, dialog.getTemplateURI());
                }
            }
        });
        return uriText;
    }

    private void updateTemplateURI(Generation gen, URI templateURI) {
        URI genconfURI = gen.eResource().getURI();
        String relativeTemplatePath = !templateURI.isPlatformPlugin() ? URI.decode((String)templateURI.deresolve(genconfURI).toString()) : URI.decode((String)templateURI.toString());
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)gen);
        this.templateCustomProperties = this.validatePage(gen, GenconfUtils.getResolvedURI((Generation)gen, (URI)URI.createURI((String)gen.getTemplateFileName(), (boolean)false)));
        editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)gen, (Object)GenconfPackage.Literals.GENERATION__TEMPLATE_FILE_NAME, (Object)relativeTemplatePath));
        if (gen.getResultFileName() == null || gen.getResultFileName().isEmpty()) {
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)gen, (Object)GenconfPackage.Literals.GENERATION__RESULT_FILE_NAME, (Object)relativeTemplatePath.replace(".docx", "-generated.docx")));
        }
        if (gen.getValidationFileName() == null || gen.getValidationFileName().isEmpty()) {
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)gen, (Object)GenconfPackage.Literals.GENERATION__VALIDATION_FILE_NAME, (Object)relativeTemplatePath.replace(".docx", "-validation.docx")));
        }
    }

    private Text createURIComposite(Generation gen, Composite composite, String label, Listener buttonListener) {
        Composite uriComposite = new Composite(composite, composite.getStyle());
        uriComposite.setLayout((Layout)new GridLayout(3, false));
        uriComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label uriLabel = new Label(uriComposite, composite.getStyle());
        uriLabel.setText(label);
        Text uriText = new Text(uriComposite, composite.getStyle());
        uriText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button uriButton = new Button(uriComposite, 2048);
        uriButton.setText("Browse");
        uriButton.addListener(13, buttonListener);
        return uriText;
    }

    private TemplateCustomProperties validatePage(final Generation gen, URI templateURI) {
        TemplateCustomProperties res;
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)gen);
        URI absoluteURI = templateURI.resolve(gen.eResource().getURI());
        if (URIConverter.INSTANCE.exists(absoluteURI, null)) {
            final IQueryEnvironment queryEnvironment = Query.newEnvironment();
            try {
                TemplateCustomProperties properties;
                res = properties = POIServices.getInstance().getTemplateCustomProperties(URIConverter.INSTANCE, absoluteURI);
                List oldDefinitions = GenconfUtils.getOldDefinitions((Generation)gen, (TemplateCustomProperties)properties);
                Command removeCommand = RemoveCommand.create((EditingDomain)editingDomain, (Object)gen, (Object)4, (Collection)oldDefinitions);
                editingDomain.getCommandStack().execute(removeCommand);
                queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
                queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
                properties.configureQueryEnvironmentWithResult(queryEnvironment);
                ResourceSetImpl defaultResourceSet = new ResourceSetImpl();
                defaultResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                defaultResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().putAll(Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap());
                final ResourceSet resourceSetForModel = M2DocUtils.createResourceSetForModels(new ArrayList(), (Object)queryEnvironment, (ResourceSet)defaultResourceSet, (Map)GenconfUtils.getOptions((Generation)gen));
                List newDefinitions = GenconfUtils.getNewDefinitions((Generation)gen, (TemplateCustomProperties)properties);
                Command addCommand = AddCommand.create((EditingDomain)editingDomain, (Object)gen, (Object)4, (Collection)newDefinitions);
                editingDomain.getCommandStack().execute(addCommand);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        GenconfUtils.initializeVariableDefinition((Generation)gen, (IReadOnlyQueryEnvironment)queryEnvironment, (TemplateCustomProperties)properties, (ResourceSet)resourceSetForModel);
                    }
                });
            }
            catch (Exception e) {
                this.setErrorMessage("Invalid template: " + e.getMessage());
                res = null;
            }
        } else {
            res = null;
            this.setErrorMessage("Template " + String.valueOf(absoluteURI) + " doesn't exist.");
        }
        if (res != null) {
            this.setPageComplete(true);
            Map options = GenconfUtils.getOptions((Generation)this.generation);
            boolean ignoreVersionCheck = Boolean.valueOf((String)options.get("IgnoreVersionCheck"));
            if (!ignoreVersionCheck && !"4.0.1".equals(res.getM2DocVersion())) {
                this.setMessage("M2Doc version mismatch: template version is " + res.getM2DocVersion() + " and current M2Doc version is 4.0.1", 2);
            } else {
                this.setErrorMessage(null);
            }
        } else {
            this.setPageComplete(false);
        }
        return res;
    }

    public Text getGenConfURIText() {
        return this.genConfURIText;
    }

    public Text getTemplateURIText() {
        return this.templateURIText;
    }

    public Text getValidationURIText() {
        return this.validationURIText;
    }

    public Text getResultURIText() {
        return this.resultURIText;
    }

    @Override
    public TemplateCustomProperties getTemplateCustomProperties() {
        return this.templateCustomProperties;
    }

    private String getFileName(URI uri) {
        String res = uri.isPlatformResource() ? uri.toPlatformString(true) : "";
        return res;
    }
}

